/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util.encoders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.net.util.encoders.CharacterDecoder;
import sun.misc.CEFormatException;
import sun.misc.CEStreamExhausted;

public class UUDecoder
extends CharacterDecoder {
    private static byte[] s_uutable = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public String bufferName;
    public int mode;
    private byte[] decoderBuffer = new byte[4];

    int bytesPerAtom() {
        return 3;
    }

    int bytesPerLine() {
        return 45;
    }

    void decodeAtom(InputStream inStream, OutputStream outStream, int l) throws IOException {
        block3: {
            StringBuffer x = new StringBuffer();
            for (int i = 0; i < 4; ++i) {
                int c1 = inStream.read();
                if (c1 == -1) {
                    throw new CEStreamExhausted();
                }
                x.append((char)c1);
                this.decoderBuffer[i] = (byte)(c1 - 32 & 0x3F);
            }
            int a = this.decoderBuffer[0] << 2 & 0xFC | this.decoderBuffer[1] >>> 4 & 3;
            int b = this.decoderBuffer[1] << 4 & 0xF0 | this.decoderBuffer[2] >>> 2 & 0xF;
            int c = this.decoderBuffer[2] << 6 & 0xC0 | this.decoderBuffer[3] & 0x3F;
            outStream.write((byte)(a & 0xFF));
            if (l > 1) {
                outStream.write((byte)(b & 0xFF));
            }
            if (l <= 2) break block3;
            outStream.write((byte)(c & 0xFF));
        }
    }

    void decodeBufferPrefix(InputStream inStream, OutputStream outStream) throws IOException {
        int c;
        StringBuffer q = new StringBuffer(32);
        boolean sawNewLine = true;
        while (true) {
            if ((c = inStream.read()) == -1) {
                throw new CEFormatException("UUDecoder: No begin line.");
            }
            if (c == 98 && sawNewLine && (c = inStream.read()) == 101) break;
            sawNewLine = c == 10;
        }
        while (c != 10 && c != 13) {
            c = inStream.read();
            if (c == -1) {
                throw new CEFormatException("UUDecoder: No begin line.");
            }
            if (c == 10 || c == 13) continue;
            q.append((char)c);
        }
        String r = q.toString();
        if (r.indexOf(32) != 3) {
            throw new CEFormatException("UUDecoder: Malformed begin line.");
        }
        this.mode = Integer.parseInt(r.substring(4, 7));
        this.bufferName = r.substring(r.indexOf(32, 6) + 1);
        this.decodeLineSuffix(inStream, outStream);
    }

    int decodeLinePrefix(InputStream inStream, OutputStream outStream) throws IOException {
        int c = inStream.read();
        if (c == 96) {
            this.decodeLineSuffix(inStream, outStream);
            throw new CEStreamExhausted();
        }
        if (c == -1) {
            throw new CEFormatException("UUDecoder: Short Buffer.");
        }
        if ((c = c - 32 & 0x3F) > this.bytesPerLine()) {
            throw new CEFormatException("UUDecoder: Bad Line Length.");
        }
        return c;
    }

    void decodeLineSuffix(InputStream inStream, OutputStream outStream) throws IOException {
        int c;
        do {
            if ((c = inStream.read()) != -1) continue;
            throw new CEStreamExhausted();
        } while (c != 10);
    }

    void decodeBufferSuffix(InputStream inStream, OutputStream outStream) throws IOException {
        int c = inStream.read(this.decoderBuffer);
        if (this.decoderBuffer[0] != 101 || this.decoderBuffer[1] != 110 || this.decoderBuffer[2] != 100) {
            throw new CEFormatException("UUDecoder: Missing 'end' line.");
        }
    }
}

