/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.async;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import oracle.xml.async.DOMBuilderConstants;
import oracle.xml.async.DOMBuilderErrorEvent;
import oracle.xml.async.DOMBuilderErrorListener;
import oracle.xml.async.DOMBuilderEvent;
import oracle.xml.async.DOMBuilderListener;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.NodeFactory;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMBuilder
implements Serializable,
DOMBuilderConstants,
Runnable {
    protected Reader reader;
    protected String rootName;
    protected String inString;
    protected InputStream inStream;
    protected URL url;
    protected InputSource inSource;
    protected int methodToCall = 0;
    protected URL inputXmlURLLocation;
    protected String inputXmlText;
    protected XMLDocument result;
    private int id;
    private Vector DOMEventListenerVect = new Vector();
    private Vector ErrorEventListenerVect = new Vector();
    private boolean workingFlag;
    DOMParser parser;
    Thread thrd;

    public DOMBuilder() {
        this.id = 0;
        this.parser = new DOMParser();
        this.thrd = new Thread(this);
        this.workingFlag = false;
    }

    public DOMBuilder(int id) {
        this.id = id;
        this.parser = new DOMParser();
        this.thrd = new Thread(this);
        this.workingFlag = false;
    }

    public int getId() {
        return this.id;
    }

    public void run() {
        this.workingFlag = true;
        this.fireDOMBuilderEvent(0);
        try {
            switch (this.methodToCall) {
                case 1: {
                    this.parser.parseDTD(this.reader, this.rootName);
                    break;
                }
                case 2: {
                    this.parser.parseDTD(this.inStream, this.rootName);
                    break;
                }
                case 3: {
                    this.parser.parseDTD(this.url, this.rootName);
                    break;
                }
                case 4: {
                    this.parser.parseDTD(this.inString, this.rootName);
                    break;
                }
                case 5: {
                    this.parser.parseDTD(this.inSource, this.rootName);
                    break;
                }
                case 6: {
                    this.parser.parse(this.reader);
                    break;
                }
                case 7: {
                    this.parser.parse(this.inStream);
                    break;
                }
                case 8: {
                    this.parser.parse(this.url);
                    break;
                }
                case 9: {
                    this.parser.parse(this.inString);
                    break;
                }
                case 10: {
                    this.parser.parse(this.inSource);
                }
            }
        }
        catch (Exception e) {
            this.fireDOMBuilderErrorEvent(new DOMBuilderErrorEvent(this, e));
            this.fireDOMBuilderEvent(2);
        }
        this.workingFlag = false;
        this.fireDOMBuilderEvent(1);
    }

    public void addDOMBuilderListener(DOMBuilderListener p0) {
        this.DOMEventListenerVect.addElement(p0);
    }

    public void addDOMBuilderErrorListener(DOMBuilderErrorListener p0) {
        this.ErrorEventListenerVect.addElement(p0);
    }

    public synchronized void removeDOMBuilderListener(DOMBuilderListener p0) {
        this.DOMEventListenerVect.removeElement(p0);
    }

    public synchronized void removeDOMBuilderErrorListener(DOMBuilderErrorListener p0) {
        this.ErrorEventListenerVect.removeElement(p0);
    }

    private synchronized void fireDOMBuilderEvent(int p1) {
        Vector targetVect;
        DOMBuilder dOMBuilder = this;
        synchronized (dOMBuilder) {
            try {
                targetVect = (Vector)this.DOMEventListenerVect.clone();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        DOMBuilderEvent Evt = new DOMBuilderEvent(this, p1);
        for (int i = 0; i < targetVect.size(); ++i) {
            DOMBuilderListener target = (DOMBuilderListener)targetVect.elementAt(i);
            if (p1 == 0) {
                target.domBuilderStarted(Evt);
                continue;
            }
            if (p1 == 1) {
                target.domBuilderOver(Evt);
                continue;
            }
            if (p1 != 2) continue;
            target.domBuilderError(Evt);
        }
    }

    private synchronized void fireDOMBuilderErrorEvent(DOMBuilderErrorEvent p1) {
        Vector targetVect;
        DOMBuilder dOMBuilder = this;
        synchronized (dOMBuilder) {
            try {
                targetVect = (Vector)this.ErrorEventListenerVect.clone();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        for (int i = 0; i < targetVect.size(); ++i) {
            DOMBuilderErrorListener target = (DOMBuilderErrorListener)targetVect.elementAt(i);
            target.domBuilderErrorCalled(p1);
        }
    }

    public synchronized Document getResult() {
        while (this.workingFlag) {
        }
        this.result = this.parser.getDocument();
        return this.result;
    }

    public synchronized DTD getDoctype() {
        while (this.workingFlag) {
        }
        return this.parser.getDoctype();
    }

    public synchronized void showWarnings(boolean yes) {
        while (this.workingFlag) {
        }
        this.parser.showWarnings(yes);
    }

    public final synchronized void setErrorStream(PrintWriter out) throws IOException {
        while (this.workingFlag) {
        }
        this.parser.setErrorStream(out);
    }

    public final synchronized void setErrorStream(OutputStream out) throws IOException {
        while (this.workingFlag) {
        }
        this.parser.setErrorStream(out);
    }

    public final synchronized void setErrorStream(OutputStream out, String enc) throws IOException {
        while (this.workingFlag) {
        }
        this.parser.setErrorStream(out, enc);
    }

    public synchronized XMLDocument getDocument() {
        while (this.workingFlag) {
        }
        return this.parser.getDocument();
    }

    public synchronized void setNodeFactory(NodeFactory factory) throws XMLParseException {
        while (this.workingFlag) {
        }
        this.parser.setNodeFactory(factory);
    }

    public synchronized void setDoctype(DTD dtd) {
        while (this.workingFlag) {
        }
        this.parser.setDoctype(dtd);
    }

    public synchronized void setValidationMode(boolean yes) {
        while (this.workingFlag) {
        }
        this.parser.setValidationMode(yes);
    }

    public synchronized void setBaseURL(URL url) {
        while (this.workingFlag) {
        }
        this.parser.setBaseURL(url);
    }

    public synchronized void setPreserveWhitespace(boolean flag) {
        while (this.workingFlag) {
        }
        this.parser.setPreserveWhitespace(flag);
    }

    public synchronized boolean getValidationMode() {
        while (this.workingFlag) {
        }
        return this.parser.getValidationMode();
    }

    public synchronized String getReleaseVersion() {
        while (this.workingFlag) {
        }
        String str = XMLParser.getReleaseVersion();
        return str;
    }

    public final synchronized void parse(InputSource in) throws IOException, SAXException, XMLParseException {
        while (this.workingFlag) {
        }
        this.inSource = in;
        this.methodToCall = 10;
        this.thrd.start();
    }

    public final synchronized void parse(String in) throws IOException, SAXException, XMLParseException {
        while (this.workingFlag) {
        }
        this.inString = in;
        this.methodToCall = 9;
        this.thrd.start();
    }

    public final synchronized void parse(URL url) throws IOException, SAXException, XMLParseException {
        while (this.workingFlag) {
        }
        this.url = url;
        this.methodToCall = 8;
        this.thrd.start();
    }

    public final synchronized void parse(InputStream in) throws IOException, SAXException, XMLParseException {
        while (this.workingFlag) {
        }
        this.inStream = in;
        this.methodToCall = 7;
        this.thrd.start();
    }

    public final synchronized void parse(Reader r) throws IOException, SAXException, XMLParseException {
        while (this.workingFlag) {
        }
        this.reader = r;
        this.methodToCall = 6;
        this.thrd.start();
    }

    public final synchronized void parseDTD(InputSource in, String rootName) throws IOException, SAXException, XMLParseException {
        while (this.workingFlag) {
        }
        this.inSource = in;
        this.rootName = rootName;
        this.methodToCall = 5;
        this.thrd.start();
    }

    public final synchronized void parseDTD(String in, String rootName) throws IOException, SAXException, XMLParseException {
        while (this.workingFlag) {
        }
        this.inString = in;
        this.rootName = rootName;
        this.methodToCall = 4;
        this.thrd.start();
    }

    public final synchronized void parseDTD(URL url, String rootName) throws IOException, SAXException, XMLParseException {
        while (this.workingFlag) {
        }
        this.url = url;
        this.rootName = rootName;
        this.methodToCall = 3;
        this.thrd.start();
    }

    public final synchronized void parseDTD(InputStream in, String rootName) throws IOException, SAXException, XMLParseException {
        while (this.workingFlag) {
        }
        this.inStream = in;
        this.rootName = rootName;
        this.methodToCall = 2;
        this.thrd.start();
    }

    public final synchronized void parseDTD(Reader r, String rootName) throws IOException, SAXException, XMLParseException {
        while (this.workingFlag) {
        }
        this.reader = r;
        this.rootName = rootName;
        this.methodToCall = 1;
        this.thrd.start();
    }
}

