/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.async;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import oracle.xml.async.XSLTransformerConstants;
import oracle.xml.async.XSLTransformerErrorEvent;
import oracle.xml.async.XSLTransformerErrorListener;
import oracle.xml.async.XSLTransformerEvent;
import oracle.xml.async.XSLTransformerListener;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.DocumentFragment;

public class XSLTransformer
implements Serializable,
XSLTransformerConstants,
Runnable {
    protected int methodToCall = 0;
    protected DocumentFragment result;
    private int id;
    XMLDocument xmlDocument;
    XSLStylesheet xslStylesheet;
    Reader xmlReader;
    InputStream xmlInputStream;
    URL xmlURL;
    URL refURL;
    OutputStream xslOutputStream;
    XSLProcessor processor;
    private Vector XSLEventListenerVect = new Vector();
    private Vector ErrorEventListenerVect = new Vector();
    private boolean workingFlag;
    Thread thrd;

    public XSLTransformer() {
        this.id = 0;
        this.processor = new XSLProcessor();
        this.thrd = new Thread(this);
        this.workingFlag = false;
    }

    public XSLTransformer(int id) {
        this.id = id;
        this.processor = new XSLProcessor();
        this.thrd = new Thread(this);
        this.workingFlag = false;
    }

    public int getId() {
        return this.id;
    }

    public void run() {
        this.workingFlag = true;
        this.fireXSLTransformerEvent(0);
        try {
            switch (this.methodToCall) {
                case 1: {
                    this.result = this.processor.processXSL(this.xslStylesheet, this.xmlDocument);
                    break;
                }
                case 2: {
                    this.result = this.processor.processXSL(this.xslStylesheet, this.xmlInputStream, this.refURL);
                    break;
                }
                case 3: {
                    this.result = this.processor.processXSL(this.xslStylesheet, this.xmlReader, this.refURL);
                    break;
                }
                case 4: {
                    this.result = this.processor.processXSL(this.xslStylesheet, this.xmlURL, this.refURL);
                    break;
                }
                case 5: {
                    this.processor.processXSL(this.xslStylesheet, this.xmlDocument, this.xslOutputStream);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            this.fireXSLTransformerErrorEvent(new XSLTransformerErrorEvent(this, e));
            this.fireXSLTransformerEvent(2);
        }
        this.workingFlag = false;
        this.fireXSLTransformerEvent(1);
    }

    public void addXSLTransformerListener(XSLTransformerListener p0) {
        this.XSLEventListenerVect.addElement(p0);
    }

    public void addXSLTransformerErrorListener(XSLTransformerErrorListener p0) {
        this.ErrorEventListenerVect.addElement(p0);
    }

    public synchronized void removeXSLTransformerListener(XSLTransformerListener p0) {
        this.XSLEventListenerVect.removeElement(p0);
    }

    public synchronized void removeDOMTransformerErrorListener(XSLTransformerErrorListener p0) {
        this.ErrorEventListenerVect.removeElement(p0);
    }

    synchronized void fireXSLTransformerEvent(int p1) {
        Vector targetVect;
        XSLTransformer xSLTransformer = this;
        synchronized (xSLTransformer) {
            try {
                targetVect = (Vector)this.XSLEventListenerVect.clone();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        XSLTransformerEvent Evt = new XSLTransformerEvent(this, p1);
        for (int i = 0; i < targetVect.size(); ++i) {
            XSLTransformerListener target = (XSLTransformerListener)targetVect.elementAt(i);
            if (p1 == 0) {
                target.xslTransformerStarted(Evt);
                continue;
            }
            if (p1 == 1) {
                target.xslTransformerOver(Evt);
                continue;
            }
            if (p1 != 2) continue;
            target.xslTransformerError(Evt);
        }
    }

    synchronized void fireXSLTransformerErrorEvent(XSLTransformerErrorEvent p1) {
        Vector targetVect;
        XSLTransformer xSLTransformer = this;
        synchronized (xSLTransformer) {
            try {
                targetVect = (Vector)this.ErrorEventListenerVect.clone();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        for (int i = 0; i < targetVect.size(); ++i) {
            XSLTransformerErrorListener target = (XSLTransformerErrorListener)targetVect.elementAt(i);
            target.xslTransformerErrorCalled(p1);
        }
    }

    public void processXSL(XSLStylesheet xsl, XMLDocument xml) throws XSLException {
        while (this.workingFlag) {
        }
        this.xslStylesheet = xsl;
        this.xmlDocument = xml;
        this.methodToCall = 1;
        this.thrd.start();
    }

    public void processXSL(XSLStylesheet xsl, InputStream xml, URL ref) throws XSLException {
        while (this.workingFlag) {
        }
        this.xslStylesheet = xsl;
        this.xmlInputStream = xml;
        this.refURL = ref;
        this.methodToCall = 2;
        this.thrd.start();
    }

    public void processXSL(XSLStylesheet xsl, Reader xml, URL ref) throws XSLException {
        while (this.workingFlag) {
        }
        this.xslStylesheet = xsl;
        this.xmlReader = xml;
        this.refURL = ref;
        this.methodToCall = 3;
        this.thrd.start();
    }

    public void processXSL(XSLStylesheet xsl, URL xml, URL ref) throws XSLException {
        while (this.workingFlag) {
        }
        this.xslStylesheet = xsl;
        this.xmlURL = xml;
        this.refURL = ref;
        this.methodToCall = 4;
        this.thrd.start();
    }

    public void processXSL(XSLStylesheet xsl, XMLDocument xml, OutputStream os) throws XSLException {
        while (this.workingFlag) {
        }
        this.xslStylesheet = xsl;
        this.xmlDocument = xml;
        this.xslOutputStream = os;
        this.methodToCall = 5;
        this.thrd.start();
    }

    public final void setErrorStream(OutputStream out) throws IOException {
        while (this.workingFlag) {
        }
        try {
            this.processor.setErrorStream(out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void showWarnings(boolean yes) {
        while (this.workingFlag) {
        }
        this.processor.showWarnings(yes);
    }

    public synchronized DocumentFragment getResult() {
        while (this.workingFlag) {
        }
        return this.result;
    }
}

