/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.srcviewer;

import java.util.Enumeration;
import java.util.Vector;
import oracle.xml.srcviewer.AbsOffset;
import oracle.xml.srcviewer.Offset;

final class BranchOffset
extends AbsOffset {
    private Vector suboffsets;
    private Object userObject;

    public BranchOffset() {
        this(null);
    }

    public BranchOffset(Object obj) {
        this.userObject = obj;
    }

    public void addSuboffset(AbsOffset absoffset) {
        if (this.suboffsets == null) {
            this.suboffsets = new Vector();
        }
        this.suboffsets.addElement(absoffset);
    }

    public int getEndOffset() {
        if (this.suboffsets == null) {
            return 0;
        }
        Offset offset = (Offset)this.suboffsets.lastElement();
        return offset.getEndOffset();
    }

    public int getStartOffset() {
        if (this.suboffsets == null) {
            return 0;
        }
        Offset offset = (Offset)this.suboffsets.firstElement();
        return offset.getStartOffset();
    }

    public BranchOffset getSubBranchOffsetAt(int i) {
        if (this.contains(i)) {
            if (this.suboffsets != null) {
                for (int j = 0; j < this.suboffsets.size(); ++j) {
                    Offset offset = (Offset)this.suboffsets.elementAt(j);
                    if (!offset.contains(i)) continue;
                    if (offset instanceof BranchOffset) {
                        return ((BranchOffset)offset).getSubBranchOffsetAt(i);
                    }
                    return this;
                }
            }
            return this;
        }
        return null;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public Enumeration suboffsets() {
        if (this.suboffsets != null) {
            return this.suboffsets.elements();
        }
        return null;
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf("BranchOffset[").concat(String.valueOf(this.getStartOffset()))).concat(String.valueOf(","))).concat(String.valueOf(this.getEndOffset()))).concat(String.valueOf("]"));
    }
}

