/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.transviewer;

import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.CLOB;

public class DBAccess {
    int nameSize = 16;

    public int getNameSize() {
        return this.nameSize;
    }

    public boolean isXMLTable(Connection con, String tablename) throws Exception {
        ResultSet rset = null;
        String s1 = "";
        String s2 = "";
        String s3 = "";
        String s4 = "";
        tablename = tablename.toUpperCase();
        Statement stmt = con.createStatement();
        rset = stmt.executeQuery(String.valueOf(String.valueOf("SELECT COLUMN_NAME,DATA_TYPE FROM USER_TAB_COLUMNS WHERE TABLE_NAME='").concat(String.valueOf(tablename))).concat(String.valueOf("'")));
        if (rset.next()) {
            s1 = rset.getString(1);
            s2 = rset.getString(2);
            if (rset.next()) {
                s3 = rset.getString(1);
                s4 = rset.getString(2);
            }
            rset.close();
            stmt.close();
            if (!s1.equals("FILENAME")) {
                boolean bl = false;
                return bl;
            }
            if (!s2.equals("CHAR")) {
                boolean bl = false;
                return bl;
            }
            if (!s3.equals("FILEDATA")) {
                boolean bl = false;
                return bl;
            }
            if (!s4.equals("CLOB")) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        rset.close();
        stmt.close();
        boolean bl = false;
        return bl;
    }

    public String[] getXMLTableNames(Connection con, String tablePrefix) throws Exception {
        ResultSet rset = null;
        Vector<String> vect = new Vector<String>(10);
        tablePrefix = tablePrefix.toUpperCase();
        Statement stmt = con.createStatement();
        rset = stmt.executeQuery("SELECT TABLE_NAME FROM USER_TABLES");
        while (rset.next()) {
            String tablename = rset.getString(1);
            if (tablename.indexOf(tablePrefix) != 0 || !this.isXMLTable(con, tablename)) continue;
            vect.addElement(tablename);
        }
        String[] filenames = new String[vect.size()];
        int i = 0;
        Enumeration e = vect.elements();
        while (e.hasMoreElements()) {
            filenames[i++] = (String)e.nextElement();
        }
        rset.close();
        stmt.close();
        String[] stringArray = filenames;
        return stringArray;
    }

    public boolean insertXMLData(Connection con, String tablename, String xmlname, String xmldata) throws Exception {
        OraclePreparedStatement pstmt = null;
        CLOB clob = null;
        tablename = tablename.toUpperCase();
        xmlname = xmlname.toUpperCase();
        if ((xmlname = xmlname.trim()).length() > this.nameSize) {
            xmlname = xmlname.substring(0, this.nameSize);
        }
        try {
            pstmt = (OraclePreparedStatement)con.prepareStatement(String.valueOf(String.valueOf("INSERT INTO ").concat(String.valueOf(tablename))).concat(String.valueOf(" VALUES (?,empty_clob())")));
            pstmt.setString(1, xmlname);
            pstmt.execute();
            pstmt.close();
            con.setAutoCommit(false);
            Statement stmt = con.createStatement();
            ResultSet rset = stmt.executeQuery(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("SELECT FILEDATA FROM ").concat(String.valueOf(tablename))).concat(String.valueOf(" WHERE FILENAME="))).concat(String.valueOf("'"))).concat(String.valueOf(xmlname))).concat(String.valueOf("'"))).concat(String.valueOf(" FOR UPDATE")));
            if (rset.next()) {
                clob = ((OracleResultSet)rset).getCLOB(1);
            }
            Writer wt = clob.getCharacterOutputStream();
            wt.write(xmldata);
            wt.flush();
            wt.close();
            rset.close();
            stmt.close();
            con.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException se) {
            int errcode = se.getErrorCode();
            if (errcode == 1) {
                boolean bl = false;
                return bl;
            }
            throw se;
        }
    }

    public boolean replaceXMLData(Connection con, String tablename, String xmlname, String xmldata) throws Exception {
        this.deleteXMLName(con, tablename, xmlname);
        return this.insertXMLData(con, tablename, xmlname, xmldata);
    }

    public boolean xmlTableExists(Connection con, String tablename) throws Exception {
        tablename = tablename.toUpperCase();
        try {
            Statement stmt = con.createStatement();
            ResultSet rset = stmt.executeQuery(String.valueOf("select 'hello' from ").concat(String.valueOf(tablename)));
            rset.close();
            stmt.close();
            boolean bl = true;
            return bl;
        }
        catch (SQLException se) {
            int errcode = se.getErrorCode();
            if (errcode == 942) {
                boolean bl = false;
                return bl;
            }
            throw se;
        }
    }

    public boolean dropXMLTable(Connection con, String tablename) throws Exception {
        Statement stmt = con.createStatement();
        tablename = tablename.toUpperCase();
        try {
            stmt.execute(String.valueOf("DROP TABLE ").concat(String.valueOf(tablename)));
            boolean bl = true;
            return bl;
        }
        catch (SQLException se) {
            int errcode = se.getErrorCode();
            if (errcode == 942) {
                boolean bl = true;
                return bl;
            }
            throw se;
        }
    }

    public boolean createXMLTable(Connection con, String tablename) throws Exception {
        tablename = tablename.toUpperCase();
        try {
            Statement stmt = con.createStatement();
            stmt.execute(String.valueOf(String.valueOf(String.valueOf(String.valueOf("CREATE TABLE ").concat(String.valueOf(tablename))).concat(String.valueOf(" (FILENAME CHAR( "))).concat(String.valueOf(this.nameSize))).concat(String.valueOf(" ) UNIQUE, FILEDATA CLOB) LOB(FILEDATA) STORE AS (DISABLE STORAGE IN ROW)")));
            stmt.close();
            boolean bl = true;
            return bl;
        }
        catch (SQLException se) {
            int errcode = se.getErrorCode();
            if (errcode == 955) {
                boolean bl = true;
                return bl;
            }
            throw se;
        }
    }

    private void printXMLTable(Connection con, String tablename) throws Exception {
        ResultSet rset = null;
        tablename = tablename.toUpperCase();
        Statement stmt = con.createStatement();
        rset = stmt.executeQuery(String.valueOf("SELECT * FROM ").concat(String.valueOf(tablename)));
        while (rset.next()) {
            String filename = rset.getString(1);
            CLOB clob = ((OracleResultSet)rset).getCLOB(2);
            int len = clob.length() < (long)30000 ? (int)clob.length() : 30000;
            String filedata = clob.getSubString(1L, len);
        }
        rset.close();
        stmt.close();
    }

    public String[] getXMLNames(Connection con, String tablename) throws Exception {
        ResultSet rset = null;
        Vector<String> vect = new Vector<String>(10);
        tablename = tablename.toUpperCase();
        Statement stmt = con.createStatement();
        rset = stmt.executeQuery(String.valueOf("SELECT FILENAME FROM ").concat(String.valueOf(tablename)));
        while (rset.next()) {
            String filename = rset.getString(1);
            vect.capacity();
            vect.addElement(filename);
        }
        String[] filenames = new String[vect.size()];
        int i = 0;
        Enumeration e = vect.elements();
        while (e.hasMoreElements()) {
            filenames[i++] = (String)e.nextElement();
        }
        rset.close();
        stmt.close();
        String[] stringArray = filenames;
        return stringArray;
    }

    public String getXMLData(Connection con, String tablename, String xmlname) throws Exception {
        ResultSet rset = null;
        StringBuffer sb = new StringBuffer(1000);
        tablename = tablename.toUpperCase();
        xmlname = xmlname.toUpperCase();
        Statement stmt = con.createStatement();
        rset = stmt.executeQuery(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("SELECT FILEDATA FROM ").concat(String.valueOf(tablename))).concat(String.valueOf(" WHERE FILENAME="))).concat(String.valueOf("'"))).concat(String.valueOf(xmlname))).concat(String.valueOf("'")));
        if (rset.next()) {
            CLOB clob = ((OracleResultSet)rset).getCLOB(1);
            long cloblen = clob.length();
            int datalen = 30000;
            int i = 0;
            while ((long)i < cloblen) {
                int k = cloblen - (long)i - (long)datalen >= (long)0 ? datalen : (int)(cloblen - (long)i);
                sb.append(clob.getSubString((long)(i + 1), k));
                i += datalen;
            }
            stmt.close();
            rset.close();
            return sb.toString();
        }
        stmt.close();
        rset.close();
        return null;
    }

    public boolean deleteXMLName(Connection con, String tablename, String xmlname) throws Exception {
        tablename = tablename.toUpperCase();
        xmlname = xmlname.toUpperCase();
        Statement stmt = con.createStatement();
        try {
            stmt.execute(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("DELETE FROM ").concat(String.valueOf(tablename))).concat(String.valueOf(" WHERE FILENAME="))).concat(String.valueOf("'"))).concat(String.valueOf(xmlname))).concat(String.valueOf("'")));
            stmt.close();
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            int errcode = ex.getErrorCode();
            boolean bl = false;
            return bl;
        }
    }

    private static void fillClob(Connection conn, CLOB clob, long length) throws Exception {
        Writer outstream = clob.getCharacterOutputStream();
        int i = 0;
        int chunk = 10;
        while ((long)i < length) {
            outstream.write(String.valueOf(i).concat(String.valueOf("hello world")), 0, chunk);
            if (length - (long)(i += chunk) >= (long)chunk) continue;
            chunk = (int)length - i;
        }
        outstream.close();
    }

    static void dumpClob(Connection con, CLOB clob) throws Exception {
        Reader instream = clob.getCharacterStream();
        char[] buffer = new char[1000];
        int length = 0;
        while ((length = instream.read(buffer)) != -1) {
            for (int i = 0; i < length; ++i) {
            }
        }
        instream.close();
    }
}

