/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.transviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.IllegalComponentStateException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;
import oracle.xml.sql.query.OracleXMLQuery;
import oracle.xml.transviewer.ConnectData;
import oracle.xml.transviewer.DBAccess;

class DBPanel
extends JPanel {
    private Vector actionListeners;
    JLabel HostName = new JLabel();
    XYLayout xYLayout1 = new XYLayout();
    JTextField HostNameTF = new JTextField();
    JLabel SID = new JLabel();
    JTextField SIDTF = new JTextField();
    JLabel UserId = new JLabel();
    JTextField UserIdTF = new JTextField();
    JLabel Password = new JLabel();
    JPanel queryPanel = new JPanel();
    JTextArea QueryTA = new JTextArea();
    XYLayout xYLayout3 = new XYLayout();
    JButton SubmitBT = new JButton();
    JPanel clobPanel = new JPanel();
    XYLayout xYLayout2 = new XYLayout();
    JLabel clobName = new JLabel();
    JTextField clobNameTF = new JTextField();
    JLabel xmlFileName = new JLabel();
    JTextField xmlDataNameTF = new JTextField();
    JSeparator jSeparator1 = new JSeparator();
    JButton loadBT = new JButton();
    JButton addBT = new JButton();
    JButton replaceBT = new JButton();
    JButton deleteBT = new JButton();
    JButton listBT = new JButton();
    JLabel errorTextLB = new JLabel();
    JSeparator jSeparator2 = new JSeparator();
    JSeparator jSeparator3 = new JSeparator();
    JLabel port = new JLabel();
    JTextField portTF = new JTextField();
    JButton clobNamesBT = new JButton();
    JButton addTableBT = new JButton();
    JButton deleteTableBT = new JButton();
    DefaultListModel lmTables = new DefaultListModel();
    JList listTableLST = new JList(this.lmTables);
    DefaultListModel lmNames = new DefaultListModel();
    JList listNamesLST = new JList(this.lmNames);
    String text = "";
    ConnectData conData = new ConnectData();
    JScrollPane jScrollPane1 = new JScrollPane();
    JScrollPane jScrollPane2 = new JScrollPane();
    JSeparator jSeparator4 = new JSeparator();
    JPasswordField PasswordTF = new JPasswordField();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel BufferNameLB = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel BufferStatusLB = new JLabel();
    JSeparator jSeparator5 = new JSeparator();
    JScrollPane jScrollPane3 = new JScrollPane();
    String DataNameText = "Data Name";
    String QueryLabelText = "Type a query to import database result set into XML:";
    String HostnameText = "Hostname";
    String UserIdText = "User Id";
    String PasswordText = "Password";
    String SIDText = "SID";
    String EmptyText = "Empty";
    String XMLBufferText = "XML Buffer:";
    String CLOBTableNameText = "CLOB Table Name";
    String AddText = "Add";
    String RewriteText = "Rewrite";
    String DeleteText = "Delete";
    String ListDataNamesText = "List Data Names";
    String PortText = "Port";
    String ListCLOBText = "List CLOB Tables";
    String AddTableText = "Add Table";
    String DeleteTableText = "Delete Table";
    String RetrieveResultSetText = "Retrieve result set";
    String RetrieveText = "Retrieve";
    String ImportLabelText = "Import data from CLOB table:";
    Locale eLocale;
    Locale defaultLocale = new Locale("en", "US");
    static String eFilename = "oracle.xml.transviewer.mesg.UserInterface";
    ResourceBundle resBundle;

    private void loadText() {
        try {
            this.eLocale = this.getLocale();
        }
        catch (IllegalComponentStateException cse) {
            this.eLocale = this.defaultLocale;
        }
        try {
            this.resBundle = ResourceBundle.getBundle(eFilename, this.eLocale);
            this.DataNameText = this.resBundle.getString("T300");
            this.QueryLabelText = this.resBundle.getString("T301");
            this.HostnameText = this.resBundle.getString("T302");
            this.UserIdText = this.resBundle.getString("T303");
            this.PasswordText = this.resBundle.getString("T304");
            this.SIDText = this.resBundle.getString("T305");
            this.EmptyText = this.resBundle.getString("T306");
            this.XMLBufferText = this.resBundle.getString("T307");
            this.CLOBTableNameText = this.resBundle.getString("T308");
            this.AddText = this.resBundle.getString("T309");
            this.RewriteText = this.resBundle.getString("T310");
            this.DeleteText = this.resBundle.getString("T311");
            this.ListDataNamesText = this.resBundle.getString("T312");
            this.PortText = this.resBundle.getString("T313");
            this.ListCLOBText = this.resBundle.getString("T314");
            this.AddTableText = this.resBundle.getString("T315");
            this.DeleteTableText = this.resBundle.getString("T316");
            this.RetrieveResultSetText = this.resBundle.getString("T317");
            this.RetrieveText = this.resBundle.getString("T318");
            this.ImportLabelText = this.resBundle.getString("T319");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    DBPanel(ConnectData conData) {
        this.conData = conData;
        this.loadText();
        try {
            this.jbInit();
            this.listTableLST.setSelectionMode(0);
            this.listNamesLST.setSelectionMode(0);
            this.listCLOBNames();
            this.listCLOBTables();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String getXMLText() {
        return this.text;
    }

    private void jbInit() throws Exception {
        this.HostName.setText(this.HostnameText);
        this.jLabel1.setText(this.QueryLabelText);
        this.BufferNameLB.setText(this.XMLBufferText);
        this.BufferStatusLB.setText(this.EmptyText);
        this.SID.setText(this.SIDText);
        this.Password.setText(this.PasswordText);
        this.UserId.setText(this.UserIdText);
        this.xmlFileName.setText(this.DataNameText);
        this.loadBT.setText(this.RetrieveText);
        this.clobNamesBT.setText(this.ListCLOBText);
        this.clobName.setText(this.CLOBTableNameText);
        this.addBT.setText(this.AddText);
        this.replaceBT.setText(this.RewriteText);
        this.deleteBT.setText(this.DeleteText);
        this.listBT.setText(this.ListDataNamesText);
        this.port.setText(this.PortText);
        this.addTableBT.setText(this.AddTableText);
        this.deleteTableBT.setText(this.DeleteTableText);
        this.SubmitBT.setText(this.RetrieveResultSetText);
        this.setLayout((LayoutManager)this.xYLayout1);
        this.HostName.setForeground(Color.black);
        this.HostName.setFont(new Font("Dialog", 0, 12));
        this.jLabel1.setForeground(Color.white);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        this.jLabel2.setText(this.ImportLabelText);
        this.jLabel2.setForeground(Color.white);
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        this.BufferNameLB.setForeground(Color.red);
        this.BufferNameLB.setBackground(new Color(46, 204, 204));
        this.BufferNameLB.setFont(new Font("Dialog", 0, 12));
        this.jLabel3.setForeground(Color.darkGray);
        this.BufferStatusLB.setForeground(Color.white);
        this.BufferStatusLB.setBackground(Color.black);
        this.BufferStatusLB.setFont(new Font("Dialog", 0, 12));
        this.xYLayout1.setHeight(487);
        this.xYLayout1.setWidth(498);
        this.SID.setForeground(Color.black);
        this.SID.setFont(new Font("Dialog", 0, 12));
        this.UserId.setForeground(Color.black);
        this.UserId.setFont(new Font("Dialog", 0, 12));
        this.Password.setForeground(Color.black);
        this.Password.setFont(new Font("Dialog", 0, 12));
        this.queryPanel.setBackground(new Color(204, 204, 204));
        this.clobPanel.setBackground(new Color(204, 204, 204));
        this.clobName.setForeground(Color.black);
        this.clobName.setFont(new Font("Dialog", 0, 12));
        this.clobNameTF.addActionListener(new 1());
        this.xmlFileName.setForeground(Color.black);
        this.xmlFileName.setFont(new Font("Dialog", 0, 12));
        this.xmlDataNameTF.addKeyListener(new 2());
        this.xmlDataNameTF.addActionListener(new 3());
        this.jSeparator1.setOrientation(1);
        this.loadBT.setFont(new Font("Dialog", 0, 10));
        this.loadBT.addActionListener(new 4());
        this.addBT.setFont(new Font("Dialog", 0, 10));
        this.addBT.addActionListener(new 5());
        this.replaceBT.setHorizontalAlignment(2);
        this.replaceBT.setFont(new Font("Dialog", 0, 10));
        this.replaceBT.setAlignmentY(0.1f);
        this.replaceBT.setHorizontalTextPosition(2);
        this.replaceBT.addActionListener(new 6());
        this.deleteBT.setActionCommand("Delete");
        this.deleteBT.setFont(new Font("Dialog", 0, 10));
        this.deleteBT.addActionListener(new 7());
        this.listBT.setFont(new Font("Dialog", 0, 10));
        this.listBT.addActionListener(new 8());
        this.errorTextLB.setForeground(Color.red);
        this.port.setForeground(Color.black);
        this.port.setFont(new Font("Dialog", 0, 12));
        this.clobNamesBT.setFont(new Font("Dialog", 0, 10));
        this.clobNamesBT.addActionListener(new 9());
        this.addTableBT.setFont(new Font("Dialog", 0, 10));
        this.addTableBT.addActionListener(new 10());
        this.deleteTableBT.setFont(new Font("Dialog", 0, 10));
        this.listNamesLST.addMouseListener(new 11());
        this.listTableLST.addMouseListener(new 12());
        this.deleteTableBT.addActionListener(new 13());
        this.clobPanel.setLayout((LayoutManager)this.xYLayout2);
        this.queryPanel.setLayout((LayoutManager)this.xYLayout3);
        this.SubmitBT.addActionListener(new 14());
        this.SubmitBT.setFont(new Font("Dialog", 0, 10));
        this.add((Component)this.HostName, new XYConstraints(9, 9, 63, 21));
        this.add((Component)this.HostNameTF, new XYConstraints(74, 8, 148, -1));
        this.add((Component)this.SID, new XYConstraints(232, 12, 32, -1));
        this.add((Component)this.SIDTF, new XYConstraints(264, 9, 82, -1));
        this.add((Component)this.UserId, new XYConstraints(9, 38, 45, -1));
        this.add((Component)this.UserIdTF, new XYConstraints(74, 35, 110, -1));
        this.add((Component)this.Password, new XYConstraints(196, 38, -1, -1));
        this.add((Component)this.queryPanel, new XYConstraints(9, 74, 466, 140));
        this.queryPanel.add((Component)this.jLabel1, new XYConstraints(4, 3, 361, -1));
        this.queryPanel.add((Component)this.SubmitBT, new XYConstraints(314, 3, 152, 19));
        this.queryPanel.add((Component)this.jScrollPane3, new XYConstraints(3, 28, 468, 110));
        this.jScrollPane3.getViewport().add((Component)this.QueryTA, null);
        this.add((Component)this.clobPanel, new XYConstraints(10, 230, 478, 218));
        this.clobPanel.add((Component)this.jSeparator1, new XYConstraints(239, 17, 7, 190));
        this.clobPanel.add((Component)this.loadBT, new XYConstraints(391, 45, 79, 19));
        this.clobPanel.add((Component)this.addBT, new XYConstraints(326, 45, 64, 19));
        this.clobPanel.add((Component)this.replaceBT, new XYConstraints(251, 45, -1, 19));
        this.clobPanel.add((Component)this.deleteBT, new XYConstraints(251, 190, 105, 20));
        this.clobPanel.add((Component)this.listBT, new XYConstraints(359, 190, 113, 20));
        this.clobPanel.add((Component)this.errorTextLB, new XYConstraints(10, 198, 450, -1));
        this.clobPanel.add((Component)this.clobNamesBT, new XYConstraints(113, 190, 116, 20));
        this.clobPanel.add((Component)this.addTableBT, new XYConstraints(117, 44, 112, 20));
        this.clobPanel.add((Component)this.deleteTableBT, new XYConstraints(4, 190, 106, 20));
        this.clobPanel.add((Component)this.jScrollPane1, new XYConstraints(4, 67, 225, 121));
        this.jScrollPane1.getViewport().add((Component)this.listTableLST, null);
        this.clobPanel.add((Component)this.jScrollPane2, new XYConstraints(251, 66, 221, 122));
        this.jScrollPane2.getViewport().add((Component)this.listNamesLST, null);
        this.clobPanel.add((Component)this.clobName, new XYConstraints(4, 22, 108, -1));
        this.clobPanel.add((Component)this.clobNameTF, new XYConstraints(110, 17, 118, -1));
        this.clobPanel.add((Component)this.xmlDataNameTF, new XYConstraints(322, 15, 146, -1));
        this.clobPanel.add((Component)this.xmlFileName, new XYConstraints(248, 17, 85, 21));
        this.clobPanel.add((Component)this.jLabel2, new XYConstraints(4, 1, 219, -1));
        this.add((Component)this.jSeparator2, new XYConstraints(5, 65, 479, 3));
        this.add((Component)this.jSeparator3, new XYConstraints(10, 219, 476, 0));
        this.add((Component)this.port, new XYConstraints(360, 14, 32, -1));
        this.add((Component)this.portTF, new XYConstraints(400, 10, 36, -1));
        this.add((Component)this.jSeparator4, new XYConstraints(11, 451, 476, -1));
        this.add((Component)this.PasswordTF, new XYConstraints(264, 35, 82, -1));
        this.add((Component)this.BufferNameLB, new XYConstraints(12, 455, 88, -1));
        this.add((Component)this.jLabel3, new XYConstraints(123, 454, 362, -1));
        this.add((Component)this.BufferStatusLB, new XYConstraints(102, 455, 382, -1));
        this.add((Component)this.jSeparator5, new XYConstraints(10, 473, 477, 4));
    }

    void SubmitBT_actionPerformed(ActionEvent e) {
        try {
            Connection cn = this.getConnection();
            OracleXMLQuery q = new OracleXMLQuery(cn, this.QueryTA.getText());
            q.useLowerCaseTagNames();
            this.conData.xmlText = q.getXMLString();
            this.conData.SQLText = this.QueryTA.getText();
            this.conData.dataSourceString = String.valueOf("Loaded, SQL=").concat(String.valueOf(this.conData.SQLText));
            this.fireActionPerformed(new ActionEvent(this, 1, "datareturned"));
            cn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Connection getConnection() throws SQLException {
        String username = this.UserIdTF.getText();
        String password = this.PasswordTF.getText();
        String thinConn = String.valueOf(String.valueOf(String.valueOf("jdbc:oracle:thin:@").concat(String.valueOf(this.HostNameTF.getText()))).concat(String.valueOf(":1521:"))).concat(String.valueOf(this.SIDTF.getText()));
        String default8iConn = "jdbc:oracle:kprb:";
        String driverClass = "oracle.jdbc.driver.OracleDriver";
        Object cn = null;
        try {
            Driver d = (Driver)Class.forName(driverClass).newInstance();
            Connection connection = DBPanel.insideOracle8i() ? DriverManager.getConnection(default8iConn) : DriverManager.getConnection(thinConn, username, password);
            return connection;
        }
        catch (Exception e) {
            throw new SQLException("Error Loading JDBC Driver");
        }
    }

    static boolean insideOracle8i() {
        String ver = System.getProperty("oracle.server.version");
        return ver != null && !ver.equals("");
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }

    void listBT_actionPerformed(ActionEvent e) {
        this.listCLOBNames();
    }

    void listCLOBNames() {
        String clobName = this.clobNameTF.getText();
        DBAccess db = new DBAccess();
        this.conData.username = this.UserIdTF.getText();
        this.conData.password = this.PasswordTF.getText();
        this.conData.instancename = this.SIDTF.getText();
        this.conData.port = this.portTF.getText();
        this.conData.hostname = this.HostNameTF.getText();
        this.xmlDataNameTF.setText("");
        try {
            this.lmNames.removeAllElements();
            this.conData.getConnection();
            String[] dataNames = db.getXMLNames(this.conData.con, clobName);
            for (int i = 0; i < dataNames.length; ++i) {
                this.lmNames.addElement(dataNames[i]);
            }
            this.conData.closeConnection();
            if (this.lmNames.getSize() > 0) {
                this.selectDataName(0);
            }
        }
        catch (Exception exception) {}
    }

    void loadBT_actionPerformed(ActionEvent e) {
        String clobName = this.clobNameTF.getText();
        DBAccess db = new DBAccess();
        this.conData.username = this.UserIdTF.getText();
        this.conData.password = this.PasswordTF.getText();
        this.conData.instancename = this.SIDTF.getText();
        this.conData.port = this.portTF.getText();
        this.conData.hostname = this.HostNameTF.getText();
        this.errorTextLB.setText("");
        try {
            this.conData.getConnection();
            this.conData.xmlText = db.getXMLData(this.conData.con, this.clobNameTF.getText(), this.xmlDataNameTF.getText());
            this.conData.closeConnection();
        }
        catch (Exception ex) {
            this.conData.xmlText = "";
        }
        this.conData.dataSourceString = String.valueOf(String.valueOf(String.valueOf("Loaded, table=").concat(String.valueOf(this.clobNameTF.getText()))).concat(String.valueOf(", name="))).concat(String.valueOf(this.xmlDataNameTF.getText()));
        this.fireActionPerformed(new ActionEvent(this, 1, "datareturned"));
    }

    void addBT_actionPerformed(ActionEvent e) {
        String clobName = this.clobNameTF.getText();
        if (this.xmlDataNameTF.getText().trim().compareTo("") == 0) {
            return;
        }
        if (this.clobNameTF.getText().trim().compareTo("") == 0) {
            return;
        }
        DBAccess db = new DBAccess();
        this.conData.username = this.UserIdTF.getText();
        this.conData.password = this.PasswordTF.getText();
        this.conData.instancename = this.SIDTF.getText();
        this.conData.port = this.portTF.getText();
        this.conData.hostname = this.HostNameTF.getText();
        try {
            this.conData.getConnection();
            if (this.conData.xmlText == null) {
                this.conData.xmlText = "";
            }
            db.insertXMLData(this.conData.con, this.clobNameTF.getText(), this.xmlDataNameTF.getText(), this.conData.xmlText);
            this.conData.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listCLOBNames();
    }

    void replaceBT_actionPerformed(ActionEvent e) {
        String clobName = this.clobNameTF.getText();
        DBAccess db = new DBAccess();
        this.conData.username = this.UserIdTF.getText();
        this.conData.password = this.PasswordTF.getText();
        this.conData.instancename = this.SIDTF.getText();
        this.conData.port = this.portTF.getText();
        this.conData.hostname = this.HostNameTF.getText();
        try {
            this.conData.getConnection();
            db.replaceXMLData(this.conData.con, this.clobNameTF.getText(), this.xmlDataNameTF.getText(), this.conData.xmlText);
            this.conData.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listBT_actionPerformed(new ActionEvent(this, 0, ""));
    }

    void addTableBT_actionPerformed(ActionEvent e) {
        if (this.clobNameTF.getText().trim().compareTo("") == 0) {
            return;
        }
        DBAccess db = new DBAccess();
        this.conData.username = this.UserIdTF.getText();
        this.conData.password = this.PasswordTF.getText();
        this.conData.instancename = this.SIDTF.getText();
        this.conData.port = this.portTF.getText();
        this.conData.hostname = this.HostNameTF.getText();
        try {
            this.conData.getConnection();
            db.createXMLTable(this.conData.con, this.clobNameTF.getText());
            this.conData.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listCLOBTables();
        this.listCLOBNames();
    }

    void deleteTableBT_actionPerformed(ActionEvent e) {
        DBAccess db = new DBAccess();
        this.conData.username = this.UserIdTF.getText();
        this.conData.password = this.PasswordTF.getText();
        this.conData.instancename = this.SIDTF.getText();
        this.conData.port = this.portTF.getText();
        this.conData.hostname = this.HostNameTF.getText();
        try {
            this.conData.getConnection();
            db.dropXMLTable(this.conData.con, this.clobNameTF.getText());
            this.conData.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listCLOBTables();
        this.listCLOBNames();
    }

    void clobNamesBT_actionPerformed(ActionEvent e) {
        this.listCLOBTables();
    }

    void listCLOBTables() {
        DBAccess db = new DBAccess();
        this.conData.username = this.UserIdTF.getText();
        this.conData.password = this.PasswordTF.getText();
        this.conData.instancename = this.SIDTF.getText();
        this.conData.port = this.portTF.getText();
        this.conData.hostname = this.HostNameTF.getText();
        try {
            this.conData.getConnection();
            String[] tableNames = db.getXMLTableNames(this.conData.con, "");
            this.lmTables.removeAllElements();
            for (int i = 0; i < tableNames.length; ++i) {
                this.lmTables.addElement(tableNames[i]);
            }
            if (this.lmTables.getSize() > 0) {
                this.selectTable(0);
            }
            this.conData.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listCLOBNames();
    }

    void deleteBT_actionPerformed(ActionEvent e) {
        String clobName = this.clobNameTF.getText();
        DBAccess db = new DBAccess();
        this.conData.username = this.UserIdTF.getText();
        this.conData.password = this.PasswordTF.getText();
        this.conData.instancename = this.SIDTF.getText();
        this.conData.port = this.portTF.getText();
        this.conData.hostname = this.HostNameTF.getText();
        try {
            this.conData.getConnection();
            db.deleteXMLName(this.conData.con, this.clobNameTF.getText(), this.xmlDataNameTF.getText());
            this.conData.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listBT_actionPerformed(new ActionEvent(this, 0, ""));
        this.listBT_actionPerformed(new ActionEvent(this, 0, ""));
        this.listCLOBNames();
    }

    void xmlDataNameTF_actionPerformed(ActionEvent e) {
        this.xmlDataNameTF.setText(this.xmlDataNameTF.getText().toUpperCase().trim());
    }

    void listTableLST_mouseReleased(MouseEvent e) {
        if (this.listTableLST.getSelectedIndex() != -1) {
            String text = (String)this.listTableLST.getSelectedValue();
            if (text != null) {
                this.clobNameTF.setText(text);
            }
            this.listCLOBNames();
        }
    }

    void selectTable(int i) {
        String text;
        this.listTableLST.setSelectedIndex(i);
        if (this.listTableLST.getSelectedIndex() != -1 && (text = (String)this.listTableLST.getSelectedValue()) != null) {
            this.clobNameTF.setText(text);
        }
    }

    void selectDataName(int i) {
        String text;
        this.listNamesLST.setSelectedIndex(i);
        if (this.listNamesLST.getSelectedIndex() != -1 && (text = (String)this.listNamesLST.getSelectedValue()) != null) {
            this.xmlDataNameTF.setText(text.trim());
        }
    }

    void listNamesLST_mouseReleased(MouseEvent e) {
        String text;
        if (this.listNamesLST.getSelectedIndex() != -1 && (text = (String)this.listNamesLST.getSelectedValue()) != null) {
            this.xmlDataNameTF.setText(text.trim());
        }
    }

    void xmlDataNameTF_keyReleased(KeyEvent e) {
        DBAccess db = new DBAccess();
        if (this.xmlDataNameTF.getText().length() >= db.getNameSize()) {
            this.xmlDataNameTF.setText(this.xmlDataNameTF.getText().substring(0, db.getNameSize()));
        }
    }

    void clobNameTF_actionPerformed(ActionEvent e) {
        this.clobNameTF.setText(this.clobNameTF.getText().toUpperCase().trim());
    }

    class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DBPanel.this.SubmitBT_actionPerformed(e);
        }

        14() {
        }
    }

    class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DBPanel.this.deleteTableBT_actionPerformed(e);
        }

        13() {
        }
    }

    class 12
    extends MouseAdapter {
        public void mouseReleased(MouseEvent e) {
            DBPanel.this.listTableLST_mouseReleased(e);
        }

        12() {
        }
    }

    class 11
    extends MouseAdapter {
        public void mouseReleased(MouseEvent e) {
            DBPanel.this.listNamesLST_mouseReleased(e);
        }

        11() {
        }
    }

    class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DBPanel.this.addTableBT_actionPerformed(e);
        }

        10() {
        }
    }

    class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DBPanel.this.clobNamesBT_actionPerformed(e);
        }

        9() {
        }
    }

    class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DBPanel.this.listBT_actionPerformed(e);
        }

        8() {
        }
    }

    class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DBPanel.this.deleteBT_actionPerformed(e);
        }

        7() {
        }
    }

    class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DBPanel.this.replaceBT_actionPerformed(e);
        }

        6() {
        }
    }

    class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DBPanel.this.addBT_actionPerformed(e);
        }

        5() {
        }
    }

    class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DBPanel.this.loadBT_actionPerformed(e);
        }

        4() {
        }
    }

    class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DBPanel.this.xmlDataNameTF_actionPerformed(e);
        }

        3() {
        }
    }

    class 2
    extends KeyAdapter {
        public void keyReleased(KeyEvent e) {
            DBPanel.this.xmlDataNameTF_keyReleased(e);
        }

        2() {
        }
    }

    class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DBPanel.this.clobNameTF_actionPerformed(e);
        }

        1() {
        }
    }
}

