/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.transviewer;

import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.transviewer.RESPanel;
import oracle.xml.transviewer.XMLPanel;
import oracle.xml.transviewer.XSLPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLTransformPanel
extends JPanel {
    JTabbedPane tabmain = new JTabbedPane(1);
    XMLPanel xmlPanel = new XMLPanel();
    XSLPanel xslPanel = new XSLPanel();
    RESPanel resPanel = new RESPanel();
    RESPanel htmlPanel = new RESPanel();
    JPanel filePanel = new JPanel();
    JPanel jPanel1 = new JPanel();
    XMLDocument xmlDoc;
    XMLDocument xslDoc;
    XMLDocument resDoc;
    URL xslUrl;
    XMLParser parser;
    Locale eLocale;
    Locale defaultLocale = new Locale("en", "US");
    static String eFilename = "oracle.xml.transviewer.mesg.UserInterface";
    ResourceBundle resBundle;
    String msg1 = "XSL buffer stylesheet applied to the XML buffer data";
    String msg2 = "Process XSL error: ";
    String xmlTabName = "XML";
    String xslTabName = "XSL";
    String transformTabName = "Transform";

    public XMLTransformPanel() {
        this.loadText();
        try {
            this.addElements();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadText() {
        try {
            this.eLocale = this.getLocale();
        }
        catch (IllegalComponentStateException cse) {
            this.eLocale = this.defaultLocale;
        }
        try {
            this.resBundle = ResourceBundle.getBundle(eFilename, this.eLocale);
            this.msg1 = this.resBundle.getString("T001");
            this.msg2 = this.resBundle.getString("T002");
            this.xmlTabName = this.resBundle.getString("T003");
            this.xslTabName = this.resBundle.getString("T004");
            this.transformTabName = this.resBundle.getString("T005");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addElements() throws Exception {
        this.tabmain.add(this.xmlTabName, this.xmlPanel);
        this.tabmain.add(this.xslTabName, this.xslPanel);
        this.tabmain.add(this.transformTabName, this.resPanel);
        this.resPanel.disableSave();
        this.resPanel.disableDBLoad();
        this.resPanel.disableDBSubmit();
        this.xslPanel.disableDBSubmit();
        this.tabmain.addChangeListener(new 1());
        this.addComponentListener(new 2());
        this.tabmain.setPreferredSize(new Dimension(520, 580));
        this.tabmain.setSelectedIndex(0);
        this.add(this.tabmain);
        this.doLayout();
        this.show();
    }

    void componentIsResized(ComponentEvent e) {
        Dimension dim = this.getSize();
        --dim.width;
        --dim.height;
        this.tabmain.setPreferredSize(dim);
        this.updateUI();
    }

    void tabmainChanged(ChangeEvent e) {
        block10: {
            JTabbedPane tp = (JTabbedPane)e.getSource();
            int ind = tp.getSelectedIndex();
            if (ind == 0) {
                tp.setSelectedIndex(ind);
                this.xmlPanel.dbPanel.listCLOBNames();
                this.xmlPanel.dbPanel.listCLOBTables();
            }
            if (ind == 1) {
                tp.setSelectedIndex(ind);
                this.xslPanel.dbPanel.listCLOBNames();
                this.xslPanel.dbPanel.listCLOBTables();
            }
            if (ind != 2) break block10;
            this.resPanel.dbPanel.listCLOBNames();
            this.resPanel.dbPanel.listCLOBTables();
            if (!this.xmlPanel.parseAndSet()) {
                tp.setSelectedIndex(0);
            } else if (!this.xslPanel.parseAndSet()) {
                tp.setSelectedIndex(1);
            } else {
                XSLStylesheet xslStl = null;
                XMLDocumentFragment result = null;
                XSLProcessor processor = new XSLProcessor();
                this.xmlDoc = this.xmlPanel.getDocument();
                if (this.xmlDoc == null) {
                    tp.setSelectedIndex(0);
                    return;
                }
                this.xslDoc = this.xslPanel.getDocument();
                if (this.xslDoc == null) {
                    tp.setSelectedIndex(1);
                    return;
                }
                this.xslUrl = this.xslPanel.getXSLURL();
                try {
                    xslStl = new XSLStylesheet(this.xslDoc, this.xslUrl);
                    result = processor.processXSL(xslStl, this.xmlDoc);
                    this.resDoc = new XMLDocument();
                    this.resDoc.appendChild((Node)result);
                    this.resPanel.conData.dataSourceString = this.msg1;
                    this.resPanel.setDocument((Document)this.resDoc);
                    this.resPanel.tabxml.setSelectedIndex(4);
                    tp.setSelectedIndex(ind);
                }
                catch (Exception ex) {
                    this.xslPanel.tabxml.setSelectedIndex(4);
                    this.xslPanel.doLayout();
                    this.xslPanel.errTextPane.setText(String.valueOf(this.msg2).concat(String.valueOf(ex.toString())));
                    tp.setSelectedIndex(1);
                }
            }
        }
    }

    class 2
    implements ComponentListener {
        public void componentResized(ComponentEvent e) {
            XMLTransformPanel.this.componentIsResized(e);
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        2() {
        }
    }

    class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            XMLTransformPanel.this.tabmainChanged(e);
        }

        1() {
        }
    }
}

