/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.treeviewer;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import oracle.xml.treeviewer.XMLTreeModel;
import org.w3c.dom.Document;

public class XMLTreeView
extends JPanel {
    protected transient JTree theTree;
    protected transient JScrollPane scrollPane;
    protected XMLTreeModel model;

    public XMLTreeView() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.getScrollPane());
    }

    public void setXMLDocument(Document document) {
        this.getXMLTreeModel().setNode(document);
        this.getTree().setModel(this.getXMLTreeModel());
        this.getTree().updateUI();
    }

    public void updateUI() {
        super.updateUI();
        this.getTree().updateUI();
        this.getScrollPane().updateUI();
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, this.getTree().getRowHeight() * 6);
    }

    protected XMLTreeModel getXMLTreeModel() {
        if (this.model == null) {
            this.model = new XMLTreeModel();
        }
        return this.model;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getTree());
        }
        return this.scrollPane;
    }

    protected JTree getTree() {
        if (this.theTree == null) {
            this.theTree = new JTree();
            this.theTree.setRootVisible(true);
            this.theTree.setEditable(false);
            this.theTree.setVisibleRowCount(6);
        }
        return this.theTree;
    }
}

