/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.docgen;

import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import org.xml.sax.SAXException;

public class OracleXMLDocGenString
extends OracleXMLDocGen {
    private StringBuffer xmlBody = null;
    private StringBuffer xmlHead = null;
    private StringBuffer xmlString = null;
    Hashtable namespaces = null;
    private static final String WSPACE = " ";
    private static final String WSPACE3 = "   ";
    private static final String LPAREN = "<";
    private static final String LPAREN_WQMARK = "<?";
    private static final String LPAREN_WSLASH = "</";
    private static final String WSPACE_INDENT1 = "   ";
    private static final String WSPACE_INDENT2 = "      ";
    private static final String WSPACE_INDENT3 = "         ";
    private static final String WSPACE_INDENT4 = "            ";
    private static final String RPAREN = ">\n";
    private static final String RPAREN_WQMARK = "?>\n";
    private static final String RPAREN_WSLASH = "/>\n";
    private static final String EQUAL_QUOTE = "=\"";
    private static final String QUOTE = "\"";
    private int level = 0;
    private int entryLevel = 0;
    static final int UNINITIALIZED_STATE = 0;
    static final int NEWELEMENT_STATE = 1;
    static final int ENDELEMENT_STATE = 2;
    static final int ADDTEXTVALUE_STATE = 3;
    static final int ADDATTRIBUTE_STATE = 4;
    private int docState = 0;
    private boolean isFragment = false;

    public void addAttribute(String string, String string2) {
        this.xmlString.append(WSPACE);
        this.xmlString.append(string);
        this.xmlString.append(EQUAL_QUOTE);
        this.xmlString.append(string2);
        this.xmlString.append(QUOTE);
        if (string == "xmlns") {
            this.xmlString = this.xmlBody;
        }
    }

    private void addIndentToString(int n) {
        switch (n) {
            case 0: {
                return;
            }
            case 1: {
                this.xmlString.append("   ");
                return;
            }
            case 2: {
                this.xmlString.append(WSPACE_INDENT2);
                return;
            }
            case 3: {
                this.xmlString.append(WSPACE_INDENT3);
                return;
            }
            case 4: {
                this.xmlString.append(WSPACE_INDENT4);
                return;
            }
        }
        int n2 = 0;
        while (n2 < n / 4) {
            this.addIndentToString(4);
            ++n2;
        }
        this.addIndentToString(n % 4);
    }

    public String addNamespace(String string, String string2) {
        if (this.namespaces == null) {
            this.namespaces = new Hashtable(4);
        }
        return this.namespaces.put(string, string2);
    }

    public void addTextValue(String string, boolean bl) {
        this.xmlString.append(">");
        if (string != null) {
            if (bl) {
                this.convertString(this.xmlString, string);
            } else {
                this.xmlString.append(string);
            }
        }
        this.docState = 3;
    }

    public void appendDTD(String string) {
        this.xmlString.append(string);
    }

    private void convertString(StringBuffer stringBuffer, String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c == '&' || c == '<' || c == '>' || c == '\"') {
                stringBuffer.append(string.substring(n, n3));
                n = n3 + 1;
                switch (c) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        break;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        break;
                    }
                }
            }
            ++n3;
        }
        if (n < n2) {
            stringBuffer.append(string.substring(n));
        }
    }

    public void createNewDocument(boolean bl) {
        if (this.xmlHead == null || bl) {
            this.xmlString = this.xmlHead = new StringBuffer(20000);
            this.xmlBody = new StringBuffer(20000);
        }
        if (bl) {
            this.level = 0;
            this.docState = 0;
        }
    }

    public void createProcessingInstruction(String string, String string2) {
        if (this.isFragment) {
            return;
        }
        this.xmlString.append(LPAREN_WQMARK);
        this.xmlString.append(string);
        this.xmlString.append(WSPACE);
        this.xmlString.append(string2);
        this.xmlString.append(RPAREN_WQMARK);
    }

    public void docAppend(OracleXMLDocGen oracleXMLDocGen) {
        if (this.isFragment) {
            return;
        }
        if (this.docState == 4 || this.docState == 1) {
            this.xmlString.append(RPAREN);
            this.docState = 2;
        }
        this.xmlString.append((String)oracleXMLDocGen.getDocFragment());
    }

    public void endElement(Object object) {
        String string = (String)object;
        --this.level;
        if (this.level - this.entryLevel == 0 && this.namespaces != null) {
            String string2 = null;
            Enumeration enumeration = this.namespaces.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                this.xmlHead.append(WSPACE);
                this.xmlHead.append("xmlns");
                this.xmlHead.append(":");
                this.xmlHead.append(string2);
                this.xmlHead.append(EQUAL_QUOTE);
                this.xmlHead.append(this.namespaces.get(string2));
                this.xmlHead.append(QUOTE);
            }
        }
        if (this.docState == 4 || this.docState == 1) {
            this.xmlString.append(RPAREN_WSLASH);
        } else {
            if (this.docState != 3) {
                this.addIndentToString(this.level);
            }
            this.xmlString.append(LPAREN_WSLASH);
            this.xmlString.append(string);
            this.xmlString.append(RPAREN);
        }
        this.docState = 2;
    }

    public Object getDocFragment() {
        if (!this.isFragment) {
            return null;
        }
        return String.valueOf(this.xmlHead.toString()) + this.xmlBody.toString();
    }

    public String getXMLDocumentString() {
        return this.xmlHead.append(this.xmlBody.toString()).toString();
    }

    public void insertXMLFragment(Reader reader) throws IOException, XMLParseException, SAXException {
        int n;
        this.xmlString.append(RPAREN);
        if (reader == null) {
            return;
        }
        char[] cArray = new char[100];
        while ((n = reader.read(cArray)) != -1) {
            this.xmlString.append(cArray, 0, n);
        }
        this.docState = 3;
    }

    public OracleXMLDocGen newDocGenDoc(boolean bl) {
        OracleXMLDocGenString oracleXMLDocGenString = new OracleXMLDocGenString();
        if (this.encoding != null) {
            oracleXMLDocGenString.setEncoding(this.encoding);
        }
        oracleXMLDocGenString.createNewDocument(false);
        oracleXMLDocGenString.isFragment = bl;
        if (bl) {
            oracleXMLDocGenString.entryLevel = oracleXMLDocGenString.level = this.level;
        }
        return oracleXMLDocGenString;
    }

    public void setVersion(String string) {
        if (this.isFragment) {
            return;
        }
        if (this.encoding == null) {
            this.createProcessingInstruction("xml", "version = '" + string + "'");
        } else {
            this.createProcessingInstruction("xml", "version = '" + string + "' " + "encoding = '" + this.encoding + "'");
        }
    }

    public Object startNewElement(String string) {
        if (this.docState == 4 || this.docState == 1) {
            this.xmlString.append(RPAREN);
        }
        this.addIndentToString(this.level);
        this.xmlString.append(LPAREN);
        this.xmlString.append(string);
        ++this.level;
        this.docState = 1;
        return string;
    }

    public boolean supportMetatype(int n) {
        return n == 1;
    }
}

