/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLErrorWriter;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLPageRequestImpl;
import oracle.xml.xsql.XSQLParserHelper;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class XSQLCommandLinePageRequest
extends XSQLPageRequestImpl {
    private String[] args;
    private int argsUsed = 0;
    private Dictionary parameters = null;
    private Dictionary extraParameters = null;

    private XSQLCommandLinePageRequest(URL uRL, Dictionary dictionary, Dictionary dictionary2) {
        this.pageurl = uRL.toString();
        this.parameters = dictionary;
        this.extraParameters = dictionary2;
    }

    public XSQLCommandLinePageRequest(String[] stringArray) {
        this.args = stringArray;
        this.setupErrorWriter();
        if (stringArray.length >= 2 && stringArray[1].indexOf("=") < 0) {
            this.argsUsed = 2;
            try {
                this.out = new PrintWriter(new FileWriter(stringArray[1]));
            }
            catch (IOException iOException) {
                XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.format(10, stringArray[1]), (XSQLPageRequest)this);
                xSQLErrorWriter.print();
            }
        } else {
            this.argsUsed = 1;
            super.setupWriter();
        }
        this.parseCommandLineAttributes();
        this.setupPageURL();
    }

    public String getParameter(String string) {
        String string2 = super.getParameter(string);
        if (string2 != null) {
            return string2;
        }
        if (this.extraParameters != null && (string2 = XSQLUtil.stringParamValue(this.extraParameters.get(string))) != null) {
            return string2;
        }
        return this.parameters != null ? (String)this.parameters.get(string) : null;
    }

    protected void setupPageURL() {
        if (this.requiredParametersOk()) {
            URL uRL = this.createURL(this.args[0]);
            this.pageurl = uRL != null ? uRL.toString() : null;
        }
    }

    private URL createURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = String.valueOf('/').concat(String.valueOf(string2));
                    }
                }
                string2 = String.valueOf("file://").concat(String.valueOf(string2));
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                System.out.println(String.valueOf("Cannot create url for: ").concat(String.valueOf(string)));
                System.exit(0);
            }
        }
        return uRL;
    }

    public boolean useConnectionPooling() {
        return false;
    }

    public String getUserAgent() {
        String string = this.getParameter("useragent");
        return string == null ? "commandline" : string;
    }

    public String translateURL(String string) {
        URL uRL = null;
        String string2 = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = this.getSourceDocumentURI();
            try {
                URL uRL2 = new URL(string3);
                string3 = uRL2.toString();
                if (string3.startsWith("file:/")) {
                    int n = string3.indexOf("/");
                    int n2 = string3.indexOf("/", n + 1);
                    int n3 = string3.lastIndexOf("/");
                    String string4 = string3.substring(0, n2);
                    String string5 = string3.substring(0, n3 + 1);
                    string2 = string.charAt(0) == '/' ? String.valueOf(string4).concat(String.valueOf(string)) : String.valueOf(string5).concat(String.valueOf(string));
                } else {
                    String string6 = uRL2.getProtocol();
                    String string7 = uRL2.getHost();
                    int n = uRL2.getPort();
                    String string8 = n != -1 ? String.valueOf(":").concat(String.valueOf(new Integer(n).toString())) : "";
                    String string9 = String.valueOf(String.valueOf(String.valueOf(string6).concat(String.valueOf("://"))).concat(String.valueOf(string7))).concat(String.valueOf(string8));
                    string2 = string.charAt(0) == '/' ? String.valueOf(string9).concat(String.valueOf(string)) : String.valueOf(string3.substring(0, string3.lastIndexOf(47) + 1)).concat(String.valueOf(string));
                }
                String string10 = string2;
                return string10;
            }
            catch (MalformedURLException malformedURLException2) {
                // empty catch block
            }
        }
        return uRL.toString();
    }

    public String getRequestType() {
        return "Command Line";
    }

    public boolean requiredParametersOk() {
        return this.args.length >= 1;
    }

    public String usageMessage() {
        return "xsql xsqlFileURI [outFileName] [param1=value1 ... paramN=valueN]";
    }

    private void parseCommandLineAttributes() {
        this.parameters = new Hashtable();
        int n = this.args.length;
        if (n > this.argsUsed) {
            int n2 = this.argsUsed;
            while (n2 < n) {
                String string = this.args[n2];
                int n3 = string.indexOf("=");
                if (n3 >= 0) {
                    char c;
                    String string2 = string.substring(0, n3);
                    String string3 = string.substring(n3 + 1);
                    if (string3 != null && !string3.equals("") && (c = string3.charAt(0)) == '\"') {
                        string3 = string3.substring(1, string3.length() - 1);
                    }
                    this.parameters.put(string2, string3);
                }
                ++n2;
            }
        }
    }

    protected void setupWriter() {
    }

    public Document getPostedDocument() {
        String string;
        Document document = super.getPostedDocument();
        if (document == null && (string = this.getParameter("posted-xml")) != null) {
            URL uRL = this.createURL(string);
            if (uRL != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                try {
                    Document document2 = XSQLParserHelper.parse(uRL, printWriter);
                    if (document2 != null) {
                        super.setPostedDocument(document2);
                    }
                }
                catch (IOException iOException) {
                    Document document3 = null;
                    return document3;
                }
                catch (SAXParseException sAXParseException) {
                    XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.getString(16), sAXParseException, (XSQLPageRequest)this);
                    xSQLErrorWriter.print();
                    Document document4 = null;
                    return document4;
                }
                catch (SAXException sAXException) {
                    Document document5 = null;
                    return document5;
                }
            }
            return this.getPostedDocument();
        }
        return document;
    }

    public XSQLPageRequest createNestedRequest(URL uRL, Dictionary dictionary) {
        return new XSQLCommandLinePageRequest(uRL, this.parameters, dictionary);
    }
}

