/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleConnection;

final class XSQLConnection {
    private Connection connection = null;
    private long lastUsed = 0L;
    private String connName = null;
    private boolean isOracleDriver = false;

    XSQLConnection(Connection connection, String string) {
        this.connection = connection;
        this.lastUsed = System.currentTimeMillis();
        this.connName = string;
        if (connection instanceof OracleConnection) {
            this.isOracleDriver = true;
        }
    }

    public boolean isOracleDriver() {
        return this.isOracleDriver;
    }

    public Connection getJDBCConnection() {
        return this.connection;
    }

    public String getConnectionName() {
        return this.connName;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void updateLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void finalize() {
        this.close();
    }
}

