/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLConnection;
import oracle.xml.xsql.XSQLConnectionPool;
import oracle.xml.xsql.XSQLErrorWriter;
import oracle.xml.xsql.XSQLNamedConnection;
import oracle.xml.xsql.XSQLPageRequest;

final class XSQLConnectionManager {
    private Hashtable connectionPools = new Hashtable();
    private static XSQLConnectionManager xcm = null;

    public static XSQLConnectionManager getManager() {
        if (xcm == null) {
            xcm = new XSQLConnectionManager();
        }
        return xcm;
    }

    private XSQLConnectionManager() {
    }

    public XSQLConnection getConnection(String string, XSQLPageRequest xSQLPageRequest) throws SQLException {
        XSQLConnectionPool xSQLConnectionPool = this.getPool(string, xSQLPageRequest);
        return xSQLConnectionPool.getConnection();
    }

    public void releaseConnection(XSQLConnection xSQLConnection, XSQLPageRequest xSQLPageRequest) {
        try {
            this.getPool(xSQLConnection.getConnectionName(), xSQLPageRequest).releaseConnection(xSQLConnection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void showStatus(XSQLPageRequest xSQLPageRequest) {
        Object object;
        xSQLPageRequest.setContentType("text/html");
        PrintWriter printWriter = xSQLPageRequest.getWriter();
        XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
        if (!xSQLConfigManager.dumpPoolAllowed()) {
            if (xSQLPageRequest.useHTMLErrors()) {
                if (!xSQLPageRequest.printedErrorHeader()) {
                    printWriter.println(String.valueOf(String.valueOf("<H1>XSQL ").concat(String.valueOf(xSQLPageRequest.getRequestType()))).concat(String.valueOf(" Status</H1>")));
                    xSQLPageRequest.setPrintedErrorHeader(true);
                }
            } else if (!xSQLPageRequest.printedErrorHeader()) {
                printWriter.println(String.valueOf(String.valueOf("XSQL ").concat(String.valueOf(xSQLPageRequest.getRequestType()))).concat(String.valueOf(" Status")));
                xSQLPageRequest.setPrintedErrorHeader(true);
            }
            printWriter.println("XSQL Connection Pool status dumping is disabled.");
            printWriter.flush();
            return;
        }
        if (xSQLPageRequest.useHTMLErrors()) {
            if (!xSQLPageRequest.printedErrorHeader()) {
                printWriter.println(String.valueOf(String.valueOf("<H1>XSQL ").concat(String.valueOf(xSQLPageRequest.getRequestType()))).concat(String.valueOf(" Status</H1>")));
                xSQLPageRequest.setPrintedErrorHeader(true);
            }
        } else if (!xSQLPageRequest.printedErrorHeader()) {
            printWriter.println(String.valueOf(String.valueOf("XSQL ").concat(String.valueOf(xSQLPageRequest.getRequestType()))).concat(String.valueOf(" Status")));
            xSQLPageRequest.setPrintedErrorHeader(true);
        }
        printWriter.println(String.valueOf("Named Connections").concat(String.valueOf(xSQLPageRequest.useHTMLErrors() ? "<br>" : "")));
        Enumeration enumeration = xSQLConfigManager.getNamedConnections().keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ++n;
            object = (String)enumeration.nextElement();
            printWriter.println(String.valueOf(object).concat(String.valueOf(xSQLPageRequest.useHTMLErrors() ? "<br>" : "")));
        }
        printWriter.println(String.valueOf(String.valueOf(String.valueOf("Total of ").concat(String.valueOf(n))).concat(String.valueOf(" named connections(s)."))).concat(String.valueOf(xSQLPageRequest.useHTMLErrors() ? "<br>" : "")));
        printWriter.println(String.valueOf("Connection Pools").concat(String.valueOf(xSQLPageRequest.useHTMLErrors() ? "<br>" : "")));
        object = this.connectionPools.keys();
        int n2 = 0;
        while (object.hasMoreElements()) {
            ++n2;
            String string = (String)object.nextElement();
            XSQLConnectionPool xSQLConnectionPool = (XSQLConnectionPool)this.connectionPools.get(string);
            xSQLConnectionPool.dumpPool(xSQLPageRequest);
        }
        printWriter.println(String.valueOf(String.valueOf("Total of ").concat(String.valueOf(n2))).concat(String.valueOf(" pools.")));
        printWriter.flush();
    }

    private XSQLConnectionPool getPool(String string, XSQLPageRequest xSQLPageRequest) throws SQLException {
        XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
        XSQLNamedConnection xSQLNamedConnection = xSQLConfigManager.getNamedConnection(xSQLPageRequest, string);
        if (xSQLNamedConnection == null) {
            XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.format(4, string), xSQLPageRequest);
            xSQLErrorWriter.print();
            throw new SQLException();
        }
        return this.getPool(string, xSQLNamedConnection.getDriver(), xSQLNamedConnection.getDburl(), xSQLNamedConnection.getUsername(), xSQLNamedConnection.getPassword(), xSQLPageRequest);
    }

    private XSQLConnectionPool getPool(String string, String string2, String string3, String string4, String string5, XSQLPageRequest xSQLPageRequest) throws SQLException {
        XSQLConnectionPool xSQLConnectionPool = null;
        String string6 = string;
        xSQLConnectionPool = (XSQLConnectionPool)this.connectionPools.get(string6);
        if (xSQLConnectionPool == null) {
            xSQLConnectionPool = new XSQLConnectionPool(xSQLPageRequest, string, string2, string3, string4, string5);
            if (xSQLConnectionPool != null) {
                if (xSQLPageRequest.useConnectionPooling()) {
                    this.connectionPools.put(string6, xSQLConnectionPool);
                }
                return xSQLConnectionPool;
            }
            return null;
        }
        return xSQLConnectionPool;
    }
}

