/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.xml.xsql.XSQLPageProcessor;
import oracle.xml.xsql.XSQLPageRequest;
import org.xml.sax.SAXParseException;

final class XSQLErrorWriter {
    String[] message = new String[4];
    int messages = -1;
    XSQLPageRequest env = null;

    public XSQLErrorWriter(String string, Exception exception, XSQLPageRequest xSQLPageRequest) {
        this.env = xSQLPageRequest;
        this.addMessage(string);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        this.addMessage(stringWriter.toString());
    }

    public XSQLErrorWriter(String string, XSQLPageRequest xSQLPageRequest) {
        this.env = xSQLPageRequest;
        this.addMessage(string);
    }

    public XSQLErrorWriter(String string, String string2, XSQLPageRequest xSQLPageRequest) {
        this.env = xSQLPageRequest;
        this.addMessage(string);
        this.addMessage(string2);
    }

    public XSQLErrorWriter(String string, String string2, SAXParseException sAXParseException, XSQLPageRequest xSQLPageRequest) {
        this.env = xSQLPageRequest;
        this.addMessage(string);
        this.addMessage(string2);
        this.xmlError(sAXParseException);
    }

    public XSQLErrorWriter(String string, SAXParseException sAXParseException, XSQLPageRequest xSQLPageRequest) {
        this.env = xSQLPageRequest;
        this.addMessage(string);
        this.xmlError(sAXParseException);
    }

    public XSQLErrorWriter(SAXParseException sAXParseException, XSQLPageRequest xSQLPageRequest) {
        this.env = xSQLPageRequest;
        this.xmlError(sAXParseException);
    }

    public void print() {
        if (this.env.useHTMLErrors()) {
            this.env.setContentType("text/html");
        } else {
            this.env.setContentType("text/plain");
        }
        PrintWriter printWriter = this.env.getErrorWriter();
        if (this.env.useHTMLErrors()) {
            if (!this.env.printedErrorHeader()) {
                printWriter.println(String.valueOf(String.valueOf("<H2>").concat(String.valueOf(this.versionMessage(this.env)))).concat(String.valueOf("</H2>")));
                this.env.setPrintedErrorHeader(true);
            }
            int n = 0;
            while (n <= this.messages) {
                if (this.message[n] != null && !this.message[n].equals("")) {
                    printWriter.println(String.valueOf(String.valueOf("<font size='-1' face='monospace'>").concat(String.valueOf(this.crlfToBr(this.message[n])))).concat(String.valueOf("</font><BR>")));
                }
                ++n;
            }
        } else {
            if (!this.env.printedErrorHeader()) {
                printWriter.println(this.versionMessage(this.env));
                this.env.setPrintedErrorHeader(true);
            }
            int n = 0;
            while (n <= this.messages) {
                if (this.message[n] != null && !this.message[n].equals("")) {
                    printWriter.println(this.message[n]);
                }
                ++n;
            }
        }
        printWriter.flush();
    }

    private String crlfToBr(String string) {
        int n = 0;
        boolean bl = false;
        while ((n = string.indexOf("\n")) >= 0) {
            string = String.valueOf(String.valueOf(string.substring(0, n)).concat(String.valueOf("<BR>"))).concat(String.valueOf(string.substring(n + 1)));
        }
        return string;
    }

    private String name(XSQLPageRequest xSQLPageRequest) {
        return String.valueOf(String.valueOf("Oracle XSQL ").concat(String.valueOf(xSQLPageRequest.getRequestType()))).concat(String.valueOf(" Error"));
    }

    private void xmlError(SAXParseException sAXParseException) {
        int n = sAXParseException.getLineNumber();
        int n2 = sAXParseException.getColumnNumber();
        String string = sAXParseException.getSystemId();
        String string2 = sAXParseException.getMessage();
        this.addMessage(String.valueOf(String.valueOf(String.valueOf("XML parse error at line ").concat(String.valueOf(n))).concat(String.valueOf(", char "))).concat(String.valueOf(n2)));
        this.addMessage(string2);
    }

    private String versionMessage(XSQLPageRequest xSQLPageRequest) {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Oracle XSQL ").concat(String.valueOf(xSQLPageRequest.getRequestType()))).concat(String.valueOf(" Page Processor "))).concat(String.valueOf(XSQLPageProcessor.VERSION))).concat(String.valueOf(" ("))).concat(String.valueOf(XSQLPageProcessor.STATUS))).concat(String.valueOf(")"));
    }

    private void addMessage(String string) {
        this.message[++this.messages] = string;
    }
}

