/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XSQLParserHelper {
    public static Document parseFromString(String string, PrintWriter printWriter) throws SAXException, SAXParseException, IOException, MalformedURLException {
        return XSQLParserHelper.parse(new BufferedInputStream(new ByteArrayInputStream(string.getBytes())), null, printWriter);
    }

    public static Document parseFromString(StringBuffer stringBuffer, PrintWriter printWriter) throws SAXException, SAXParseException, IOException, MalformedURLException {
        return XSQLParserHelper.parseFromString(stringBuffer.toString(), printWriter);
    }

    public static Document parse(URL uRL, PrintWriter printWriter) throws SAXException, SAXParseException, IOException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.showWarnings(false);
        dOMParser.setValidationMode(false);
        dOMParser.setPreserveWhitespace(true);
        dOMParser.setErrorStream(printWriter);
        dOMParser.parse(uRL);
        XMLDocument xMLDocument = dOMParser.getDocument();
        Element element = xMLDocument.getDocumentElement();
        if (element == null) {
            throw new RuntimeException("Error Parsing the XML Document.");
        }
        return dOMParser.getDocument();
    }

    public static Document parse(InputStream inputStream, URL uRL, PrintWriter printWriter) throws SAXException, SAXParseException, IOException {
        DOMParser dOMParser = new DOMParser();
        if (uRL != null) {
            dOMParser.setBaseURL(uRL);
        }
        dOMParser.showWarnings(false);
        dOMParser.setValidationMode(false);
        dOMParser.setPreserveWhitespace(true);
        dOMParser.setErrorStream(printWriter);
        dOMParser.parse(inputStream);
        XMLDocument xMLDocument = dOMParser.getDocument();
        Element element = xMLDocument.getDocumentElement();
        return dOMParser.getDocument();
    }

    public static Document parse(Reader reader, PrintWriter printWriter) throws SAXException, SAXParseException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.showWarnings(false);
        dOMParser.setValidationMode(false);
        dOMParser.setPreserveWhitespace(true);
        try {
            dOMParser.setErrorStream(printWriter);
            dOMParser.parse(reader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        Element element = xMLDocument.getDocumentElement();
        if (element == null) {
            throw new RuntimeException("Error Parsing the XML Document.");
        }
        return dOMParser.getDocument();
    }

    public static Document newDocument() {
        return new XMLDocument();
    }

    public static void print(Document document, PrintWriter printWriter) {
        try {
            ((XMLDocument)document).print(printWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getNamespaceOfElement(Element element) {
        boolean bl;
        String string = element.getNodeName();
        boolean bl2 = bl = string.indexOf(":") >= 0;
        if (bl) {
            return ((XMLElement)element).getNamespace();
        }
        return string;
    }

    private static String getExpandedNameOfElement(Element element) {
        boolean bl;
        String string = element.getNodeName();
        boolean bl2 = bl = string.indexOf(":") >= 0;
        if (bl) {
            return ((XMLElement)element).getExpandedName();
        }
        return string;
    }

    private static String getExpandedNameOfAttribute(Attr attr, Element element) {
        boolean bl;
        String string = attr.getNodeName();
        boolean bl2 = bl = string.indexOf(":") >= 0;
        if (bl) {
            return ((XMLAttr)attr).getExpandedName();
        }
        return String.valueOf(String.valueOf(XSQLParserHelper.getNamespaceOfElement(element)).concat(String.valueOf(":"))).concat(String.valueOf(string));
    }
}

