/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLHttpUtil;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLPageRequestImpl;
import oracle.xml.xsql.XSQLParserHelper;
import oracle.xml.xsql.XSQLServlet;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class XSQLServletPageRequest
extends XSQLPageRequestImpl {
    static final String INCLUDED_REQUEST_URI = "javax.servlet.include.request_uri";
    static final String INCLUDED_SERVLET_PATH = "javax.servlet.include.servlet_path";
    static final String GNUJSP_REQUEST = "javax.servlet.include.path";
    static final String POSTED_HTML_FORM = "application/x-www-form-urlencoded";
    static final String POSTED_XML_DOCUMENT = "text/xml";
    private Dictionary cookies = null;
    private HttpServletRequest req = null;
    private HttpServletResponse resp = null;
    private Dictionary extraParams = null;

    private XSQLServletPageRequest(URL uRL, Dictionary dictionary, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Dictionary dictionary2, Document document) {
        this.req = httpServletRequest;
        this.resp = httpServletResponse;
        this.extraParams = dictionary;
        this.cookies = dictionary2;
        this.pageurl = XSQLUtil.safeURLAsString(uRL);
        this.setPostedDocument(document);
        this.err = new PrintWriter(new StringWriter());
    }

    public XSQLServletPageRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.req = httpServletRequest;
        this.resp = httpServletResponse;
        this.collectCookies();
        this.setupPageURL();
    }

    public String getParameter(String string) {
        Object object;
        Object object2;
        String string2 = super.getParameter(string);
        if (string2 == null) {
            String string3 = string2 = this.cookies != null ? (String)this.cookies.get(string) : null;
        }
        if (string2 == null && (object2 = this.req.getSession(false)) != null && (object = object2.getValue(string)) != null) {
            string2 = object.toString();
        }
        if (string2 == null) {
            if (this.extraParams != null) {
                string2 = XSQLUtil.stringParamValue(this.extraParams.get(string));
            }
            if (string2 == null) {
                string2 = this.req.getParameter(string);
            }
        }
        object2 = this.getPageEncoding();
        if (string2 != null) {
            if (object2 != null) {
                return XSQLUtil.XL(string2, (String)object2);
            }
            return string2;
        }
        return null;
    }

    private void setupPageURL() {
        String string;
        String string2 = null;
        this.pageurl = XSQLServlet.inJServ() ? this.req.getPathTranslated() : ((string2 = (String)this.req.getAttribute(INCLUDED_SERVLET_PATH)) != null ? this.req.getRealPath(string2) : ((string = this.req.getServletPath()) != null ? this.req.getRealPath(string) : null));
        this.pageurl = this.pageurl != null ? this.pageurl.replace('\\', '/') : null;
    }

    protected void setupWriter() {
        try {
            XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
            int n = xSQLConfigManager.getOutputBufferSize();
            this.out = n == 0 ? this.resp.getWriter() : new PrintWriter(new BufferedWriter(this.resp.getWriter(), n));
        }
        catch (IOException iOException) {
            super.setupWriter();
        }
    }

    protected void setupErrorWriter() {
        try {
            if (this.err == null) {
                this.err = this.resp.getWriter();
            }
        }
        catch (IOException iOException) {
            super.setupErrorWriter();
        }
    }

    public String getUserAgent() {
        return this.req.getHeader("User-Agent");
    }

    public void setContentType(String string) {
        this.resp.setContentType(string);
        this.setupWriter();
        this.setupErrorWriter();
    }

    public boolean useHTMLErrors() {
        return true;
    }

    public String translateURL(String string) {
        if (string.startsWith("http:/") || string.startsWith("file:/")) {
            return string;
        }
        if (string.charAt(0) == '/') {
            String string2 = this.req.getServerName();
            String string3 = this.req.getScheme();
            int n = this.req.getServerPort();
            String string4 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(string3).concat(String.valueOf("://"))).concat(String.valueOf(string2))).concat(String.valueOf(n != -1 ? String.valueOf(":").concat(String.valueOf(n)) : ""))).concat(String.valueOf(string));
            return string4;
        }
        return XSQLUtil.translate(this.getSourceDocumentURI(), string);
    }

    public String getRequestType() {
        return "Servlet";
    }

    public Document getRequestParamsAsXMLDocument() {
        XMLDocument xMLDocument = XSQLHttpUtil.HttpRequestAsXMLDocument(this.req, this.getPageEncoding());
        return xMLDocument;
    }

    public Document getPostedDocument() {
        Document document = super.getPostedDocument();
        if (document != null) {
            return document;
        }
        String string = this.req.getContentType();
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase(POSTED_XML_DOCUMENT)) {
            try {
                this.setPostedDocument(this.XMLDocumentFromServletInputStream());
            }
            catch (SAXException sAXException) {
                Document document2 = null;
                return document2;
            }
        } else if (string.equalsIgnoreCase(POSTED_HTML_FORM)) {
            this.setPostedDocument((Document)XSQLHttpUtil.HttpRequestAsXMLDocument(this.req, this.getPageEncoding()));
        }
        return super.getPostedDocument();
    }

    /*
     * Loose catch block
     */
    private Document XMLDocumentFromServletInputStream() throws SAXException {
        Document document;
        block12: {
            ServletInputStream servletInputStream = null;
            document = null;
            servletInputStream = this.req.getInputStream();
            document = XSQLParserHelper.parse((InputStream)servletInputStream, null, this.getErrorWriter());
            Object var6_3 = null;
            try {
                if (servletInputStream != null) {
                    servletInputStream.close();
                }
                break block12;
            }
            catch (IOException iOException) {}
            break block12;
            {
                catch (IOException iOException) {
                    Document document2 = null;
                    Object var6_4 = null;
                    try {
                        if (servletInputStream != null) {
                            servletInputStream.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    return document2;
                }
                catch (SAXException sAXException) {
                    throw sAXException;
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    if (servletInputStream != null) {
                        servletInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return document;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.req;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.resp;
    }

    public void setPageEncoding(String string) {
        this.requestedPageEncoding = string;
    }

    public String getCookie(String string) {
        return this.cookies != null ? (String)this.cookies.get(string) : null;
    }

    private void collectCookies() {
        int n;
        Cookie[] cookieArray = this.req.getCookies();
        int n2 = n = cookieArray != null ? cookieArray.length : 0;
        if (n > 0) {
            this.cookies = new Hashtable(n);
            int n3 = 0;
            while (n3 < n) {
                Cookie cookie = cookieArray[n3];
                String string = cookie.getName();
                String string2 = cookie.getValue();
                this.cookies.put(string, string2);
                ++n3;
            }
        }
    }

    public XSQLPageRequest createNestedRequest(URL uRL, Dictionary dictionary) {
        return new XSQLServletPageRequest(uRL, dictionary, this.req, this.resp, this.cookies, this.postedDocument);
    }
}

