/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

final class XSQLStylesheetPI {
    private static String STYLE_PI = "xml-stylesheet";
    private static String TYPE = "type";
    private static String MEDIA = "media";
    private static String TITLE = "title";
    private static String HREF = "href";
    private static String CHARSET = "charset";
    private static String ALTERNATE = "alternate";
    private static String RESULTTYPE = "result-type";
    private static String CLIENT = "client";
    private String href;
    private String type;
    private String title;
    private String media;
    private String charset;
    private String alternate;
    private String originalValue;
    private String resultType;
    private boolean client = false;

    XSQLStylesheetPI(ProcessingInstruction processingInstruction) {
        this.originalValue = processingInstruction.getNodeValue();
        this.parsePseudoAttributes(processingInstruction);
    }

    XSQLStylesheetPI(String string, String string2) {
        this.setHref(string);
        if (string2 != null && !string2.equals("")) {
            if (string2.equalsIgnoreCase("s") || string2.equalsIgnoreCase("server")) {
                this.setClient(false);
            } else if (string2.equalsIgnoreCase("c") || string2.equalsIgnoreCase("client")) {
                this.setClient(true);
            }
        }
        this.setType("text/xsl");
        this.originalValue = String.valueOf(String.valueOf("type=\"text/xsl\" href=\"").concat(String.valueOf(string))).concat(String.valueOf("\""));
    }

    public boolean isClient() {
        return this.client;
    }

    public String getHref() {
        return this.href;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMedia() {
        return this.media;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setHref(String string) {
        this.href = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setMedia(String string) {
        this.media = string;
    }

    public void setClient(boolean bl) {
        this.client = bl;
    }

    public void setAlternate(String string) {
        this.alternate = string;
    }

    public String getAlternate() {
        return this.alternate;
    }

    private void parsePseudoAttributes(ProcessingInstruction processingInstruction) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(processingInstruction.getNodeValue(), " \n\r\t");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                while (string.charAt(string.length() - 1) != '\"' && string.charAt(string.length() - 1) != '\'') {
                    string = String.valueOf(string).concat(String.valueOf(String.valueOf(" ").concat(String.valueOf(stringTokenizer.nextToken()))));
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer(string, "=");
                String string2 = stringTokenizer2.nextToken();
                String string3 = stringTokenizer2.nextToken();
                string3 = string3.substring(1, string3.length() - 1);
                if (string2.equals(TYPE)) {
                    this.setType(string3);
                    continue;
                }
                if (string2.equals(HREF)) {
                    this.setHref(string3);
                    continue;
                }
                if (string2.equals(MEDIA)) {
                    this.setMedia(string3);
                    continue;
                }
                if (string2.equals(CLIENT)) {
                    if (!string3.equalsIgnoreCase("y") && !string3.equalsIgnoreCase("yes")) continue;
                    this.setClient(true);
                    continue;
                }
                if (string2.equals(TITLE)) {
                    this.setTitle(string3);
                    continue;
                }
                if (string2.equals(CHARSET)) {
                    this.setCharset(string3);
                    continue;
                }
                if (!string2.equals(ALTERNATE)) continue;
                this.setAlternate(string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public Document addToProlog(Document document) {
        ProcessingInstruction processingInstruction = document.createProcessingInstruction(STYLE_PI, this.originalValue);
        Element element = document.getDocumentElement();
        document.insertBefore(processingInstruction, element);
        return document;
    }
}

