/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLErrorWriter;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLParserHelper;
import oracle.xml.xsql.XSQLStylesheet;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class XSQLStylesheetPool {
    private XMLDocument parsedSheetSource = null;
    private long parsedSheetTimestamp = -1L;
    private Hashtable stylesheets;
    private String sheeturi;
    private String password;
    private static int total = 0;
    private long lastCleanup = -1L;
    private int POOL_TIMEOUT = 60000;
    private int POOL_INCREMENT = 1;
    private int POOL_INITIAL = 1;
    private URL xslURL = null;

    public XSQLStylesheetPool(String string, XSQLPageRequest xSQLPageRequest, boolean bl) throws MalformedURLException, XSLException, SAXParseException, FileNotFoundException {
        XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
        this.POOL_TIMEOUT = xSQLConfigManager.getStylesheetPoolTimeout();
        this.POOL_INCREMENT = xSQLConfigManager.getStylesheetPoolIncrement();
        this.POOL_INITIAL = xSQLConfigManager.getStylesheetPoolInitial();
        this.sheeturi = string;
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        this.xslURL = new URL(string);
    }

    public XSQLStylesheet getStylesheet(XSQLPageRequest xSQLPageRequest, boolean bl) throws FileNotFoundException, XSLException, SAXException, SAXParseException, Exception {
        long l = XSQLStylesheetPool.timestampOf(this.sheeturi);
        Object var5_4 = null;
        if (l == (long)0) {
            return new XSQLStylesheet(this.newSheet(this.parseStylesheetSourceDoc(this.xslURL, xSQLPageRequest, bl), xSQLPageRequest, bl), this.sheeturi, false);
        }
        if (this.parsedSheetSource == null || l > this.parsedSheetTimestamp) {
            try {
                this.rereadStylehseetSourceDoc(this.xslURL, l, xSQLPageRequest, bl);
            }
            catch (SAXParseException sAXParseException) {
                this.stylesheets = null;
                this.parsedSheetSource = null;
                this.parsedSheetTimestamp = -1L;
                throw sAXParseException;
            }
            catch (XSLException xSLException) {
                this.stylesheets = null;
                this.parsedSheetSource = null;
                this.parsedSheetTimestamp = -1L;
                throw xSLException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.stylesheets = null;
                this.parsedSheetSource = null;
                this.parsedSheetTimestamp = -1L;
                throw fileNotFoundException;
            }
            catch (Exception exception) {
                this.stylesheets = null;
                this.parsedSheetSource = null;
                this.parsedSheetTimestamp = -1L;
                throw exception;
            }
        }
        return this.getSheetFromPool(xSQLPageRequest, bl);
    }

    private XSQLStylesheet getSheetFromPool(XSQLPageRequest xSQLPageRequest, boolean bl) throws FileNotFoundException, XSLException, SAXParseException {
        XSQLStylesheet xSQLStylesheet = null;
        XSQLStylesheet xSQLStylesheet2 = null;
        Enumeration enumeration = this.stylesheets.keys();
        int n = 0;
        long l = System.currentTimeMillis();
        boolean bl2 = false;
        if (l - this.lastCleanup > (long)this.POOL_TIMEOUT) {
            bl2 = true;
            this.lastCleanup = l;
        }
        Hashtable hashtable = this.stylesheets;
        synchronized (hashtable) {
            try {
                while (enumeration.hasMoreElements()) {
                    xSQLStylesheet = (XSQLStylesheet)enumeration.nextElement();
                    ++n;
                    Boolean bl3 = (Boolean)this.stylesheets.get(xSQLStylesheet);
                    if (bl3 != Boolean.FALSE) continue;
                    if (xSQLStylesheet2 == null) {
                        this.stylesheets.put(xSQLStylesheet, Boolean.TRUE);
                        xSQLStylesheet2 = xSQLStylesheet;
                        continue;
                    }
                    if (!bl2 || l - xSQLStylesheet.getLastUsed() <= (long)this.POOL_TIMEOUT || n <= this.POOL_INITIAL) continue;
                    xSQLStylesheet.close();
                    this.stylesheets.remove(xSQLStylesheet);
                }
                Object var13_11 = null;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                throw throwable;
            }
        }
        if (xSQLStylesheet2 != null) {
            return xSQLStylesheet2;
        }
        int n2 = 0;
        while (n2 < this.POOL_INCREMENT) {
            xSQLStylesheet2 = new XSQLStylesheet(this.newSheet(this.parsedSheetSource, xSQLPageRequest, bl), this.sheeturi, true);
            this.stylesheets.put(xSQLStylesheet2, Boolean.FALSE);
            ++n2;
        }
        return this.getSheetFromPool(xSQLPageRequest, bl);
    }

    public void releaseSheet(XSQLStylesheet xSQLStylesheet) {
        if (xSQLStylesheet.isPooled()) {
            Enumeration enumeration = this.stylesheets.keys();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                ++n;
                XSQLStylesheet xSQLStylesheet2 = (XSQLStylesheet)enumeration.nextElement();
                if (xSQLStylesheet2 != xSQLStylesheet) continue;
                Hashtable hashtable = this.stylesheets;
                synchronized (hashtable) {
                    try {
                        long l = System.currentTimeMillis();
                        xSQLStylesheet2.updateLastUsed();
                        this.stylesheets.put(xSQLStylesheet2, Boolean.FALSE);
                        Object var9_7 = null;
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var9_8 = null;
                        throw throwable;
                    }
                }
            }
        }
    }

    private XSLStylesheet newSheet(XMLDocument xMLDocument, XSQLPageRequest xSQLPageRequest, boolean bl) throws XSLException, FileNotFoundException, SAXParseException {
        XSLStylesheet xSLStylesheet = null;
        try {
            PrintWriter printWriter = new PrintWriter(new StringWriter());
            xSLStylesheet = new XSLStylesheet(xMLDocument, this.xslURL);
        }
        catch (XSLException xSLException) {
            throw xSLException;
        }
        catch (Exception exception) {
            throw new RuntimeException(Res.getString(21));
        }
        return xSLStylesheet;
    }

    private static long timestampOf(String string) {
        File file = null;
        try {
            URL uRL = new URL(string);
            file = new File(uRL.getFile());
        }
        catch (Exception exception) {
            long l = 0L;
            return l;
        }
        return file.lastModified();
    }

    private XMLDocument parseStylesheetSourceDoc(URL uRL, XSQLPageRequest xSQLPageRequest, boolean bl) throws XSLException, FileNotFoundException, SAXException, SAXParseException, Exception {
        XMLDocument xMLDocument = null;
        try {
            PrintWriter printWriter = new PrintWriter(new StringWriter());
            xMLDocument = (XMLDocument)XSQLParserHelper.parse(uRL, printWriter);
        }
        catch (SAXParseException sAXParseException) {
            if (!bl) {
                XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.format(6, xSQLPageRequest.getStylesheetURI()), sAXParseException, xSQLPageRequest);
                xSQLErrorWriter.print();
            }
            throw sAXParseException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!bl) {
                XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.format(8, xSQLPageRequest.getStylesheetURI()), xSQLPageRequest);
                xSQLErrorWriter.print();
            }
            throw fileNotFoundException;
        }
        catch (Exception exception) {
            XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.format(19, xSQLPageRequest.getStylesheetURI()), exception, xSQLPageRequest);
            xSQLErrorWriter.print();
            throw exception;
        }
        return xMLDocument;
    }

    private synchronized void rereadStylehseetSourceDoc(URL uRL, long l, XSQLPageRequest xSQLPageRequest, boolean bl) throws XSLException, FileNotFoundException, SAXParseException, Exception {
        block7: {
            this.parsedSheetSource = this.parseStylesheetSourceDoc(uRL, xSQLPageRequest, bl);
            this.parsedSheetTimestamp = l;
            Hashtable<XSQLStylesheet, Boolean> hashtable = new Hashtable<XSQLStylesheet, Boolean>(this.POOL_INITIAL * 2);
            if (l != (long)0) {
                int n = 0;
                while (n < this.POOL_INITIAL) {
                    XSQLStylesheet xSQLStylesheet = new XSQLStylesheet(this.newSheet(this.parsedSheetSource, xSQLPageRequest, bl), this.sheeturi, true);
                    if (xSQLStylesheet != null) {
                        hashtable.put(xSQLStylesheet, Boolean.FALSE);
                    }
                    ++n;
                }
                if (this.stylesheets != null) {
                    Hashtable hashtable2 = this.stylesheets;
                    synchronized (hashtable2) {
                        try {
                            this.stylesheets = hashtable;
                            Object var10_9 = null;
                            break block7;
                        }
                        catch (Throwable throwable) {
                            Object var10_10 = null;
                            throw throwable;
                        }
                    }
                }
                this.stylesheets = hashtable;
            }
        }
    }
}

