/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Enumeration;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLErrorWriter;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLPeekaheadWriter;
import oracle.xml.xsql.XSQLStylesheet;
import oracle.xml.xsql.XSQLStylesheetManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public final class XSQLStylesheetProcessor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Document processToDocument(Document document, String string, XSQLPageRequest xSQLPageRequest) throws FileNotFoundException, XSLException, SAXParseException, Exception {
        XMLDocument xMLDocument = null;
        XSQLStylesheet xSQLStylesheet = null;
        XSQLStylesheetManager xSQLStylesheetManager = XSQLStylesheetManager.getManager();
        try {
            try {
                XSLProcessor xSLProcessor = new XSLProcessor();
                xSQLStylesheet = xSQLStylesheetManager.getStylesheet(string, xSQLPageRequest, true);
                XMLDocumentFragment xMLDocumentFragment = xSLProcessor.processXSL(xSQLStylesheet.getStylesheet(), (XMLDocument)document);
                xMLDocument = new XMLDocument();
                xMLDocument.appendChild((Node)xMLDocumentFragment);
            }
            catch (SAXParseException sAXParseException) {
                throw sAXParseException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (XSLException xSLException) {
                XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.format(11, string), xSLException.getMessage(), xSQLPageRequest);
                xSQLErrorWriter.print();
                throw xSLException;
            }
            catch (Exception exception) {
                if (xSQLPageRequest.printedErrorHeader()) throw exception;
                XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.format(18, xSQLPageRequest.getStylesheetURI()), exception, xSQLPageRequest);
                xSQLErrorWriter.print();
                throw exception;
            }
            Object var9_14 = null;
            if (xSQLStylesheet == null) return xMLDocument;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (xSQLStylesheet == null) throw throwable;
            xSQLStylesheetManager.releaseStylesheet(xSQLStylesheet, xSQLPageRequest, true);
            throw throwable;
        }
        xSQLStylesheetManager.releaseStylesheet(xSQLStylesheet, xSQLPageRequest, true);
        return xMLDocument;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void processToWriter(Document document, String string, XSQLPageRequest xSQLPageRequest) throws FileNotFoundException, XSLException, SAXParseException, Exception {
        XSQLStylesheet xSQLStylesheet = null;
        XSQLStylesheetManager xSQLStylesheetManager = XSQLStylesheetManager.getManager();
        try {
            try {
                Object var5_5 = null;
                String string2 = null;
                XSQLPeekaheadWriter xSQLPeekaheadWriter = null;
                XSLProcessor xSLProcessor = new XSLProcessor();
                xSQLStylesheet = xSQLStylesheetManager.getStylesheet(string, xSQLPageRequest, false);
                XSLStylesheet xSLStylesheet = xSQLStylesheet.getStylesheet();
                string2 = xSLStylesheet.getOutputEncoding();
                XSQLStylesheetProcessor.setStylesheetParametersFromPageRequest(xSLStylesheet, xSQLPageRequest);
                xSQLPeekaheadWriter = new XSQLPeekaheadWriter(xSLStylesheet, xSQLPageRequest, string2);
                xSLProcessor.processXSL(xSLStylesheet, (XMLDocument)document, (PrintWriter)xSQLPeekaheadWriter);
            }
            catch (SAXParseException sAXParseException) {
                throw sAXParseException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (XSLException xSLException) {
                XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.format(11, xSQLPageRequest.getStylesheetURI()), xSLException.getMessage(), xSQLPageRequest);
                xSQLErrorWriter.print();
                throw xSLException;
            }
            catch (Exception exception) {
                if (xSQLPageRequest.printedErrorHeader()) throw exception;
                XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.format(18, xSQLPageRequest.getStylesheetURI()), exception, xSQLPageRequest);
                xSQLErrorWriter.print();
                throw exception;
            }
            Object var11_16 = null;
            if (xSQLStylesheet == null) return;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            if (xSQLStylesheet == null) throw throwable;
            xSQLStylesheetManager.releaseStylesheet(xSQLStylesheet, xSQLPageRequest, true);
            throw throwable;
        }
        xSQLStylesheetManager.releaseStylesheet(xSQLStylesheet, xSQLPageRequest, true);
    }

    private static void setStylesheetParametersFromPageRequest(XSLStylesheet xSLStylesheet, XSQLPageRequest xSQLPageRequest) {
        try {
            xSLStylesheet.resetParams();
            Enumeration enumeration = xSQLPageRequest.getStylesheetParameters();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = xSQLPageRequest.getStylesheetParameter(string);
                    xSLStylesheet.setParam(string, String.valueOf(String.valueOf("'").concat(String.valueOf(string2))).concat(String.valueOf("'")));
                }
            }
        }
        catch (XSLException xSLException) {
            // empty catch block
        }
    }
}

