/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class XSQLUtil {
    public static NodeList select(Document document, String string) {
        return XSQLUtil.select((XMLDocument)document, string);
    }

    public static NodeList select(XMLDocument xMLDocument, String string) {
        try {
            NodeList nodeList = xMLDocument.selectNodes(string, (NSResolver)xMLDocument.getDocumentElement());
            return nodeList;
        }
        catch (XSLException xSLException) {
            NodeList nodeList = null;
            return nodeList;
        }
    }

    public static NodeList select(Element element, String string) {
        return XSQLUtil.select((XMLElement)element, string);
    }

    public static NodeList select(XMLElement xMLElement, String string) {
        try {
            NodeList nodeList = xMLElement.selectNodes(string, (NSResolver)xMLElement);
            return nodeList;
        }
        catch (XSLException xSLException) {
            NodeList nodeList = null;
            return nodeList;
        }
    }

    public static Node selectFirst(Document document, String string) {
        return XSQLUtil.selectFirst((XMLDocument)document, string);
    }

    public static Node selectFirst(XMLDocument xMLDocument, String string) {
        try {
            NodeList nodeList = xMLDocument.selectNodes(string, (NSResolver)xMLDocument.getDocumentElement());
            Node node = nodeList.getLength() > 0 ? nodeList.item(0) : null;
            return node;
        }
        catch (XSLException xSLException) {
            Node node = null;
            return node;
        }
    }

    public static Node selectFirst(Element element, String string) {
        return XSQLUtil.selectFirst((XMLElement)element, string);
    }

    public static Node selectFirst(XMLElement xMLElement, String string) {
        try {
            NodeList nodeList = xMLElement.selectNodes(string, (NSResolver)xMLElement);
            Node node = nodeList.getLength() > 0 ? nodeList.item(0) : null;
            return node;
        }
        catch (XSLException xSLException) {
            Node node = null;
            return node;
        }
    }

    public static String valueOf(Element element, String string) {
        return XSQLUtil.valueOf((XMLNode)element, string);
    }

    public static String valueOf(Node node, String string) {
        return XSQLUtil.valueOf((XMLNode)node, string);
    }

    public static String valueOf(XMLElement xMLElement, String string) {
        return XSQLUtil.valueOf((XMLNode)xMLElement, string);
    }

    public static String valueOf(XMLNode xMLNode, String string) {
        block7: {
            try {
                NodeList nodeList;
                NSResolver nSResolver = null;
                if (xMLNode instanceof XMLElement) {
                    nSResolver = (NSResolver)xMLNode;
                }
                if ((nodeList = xMLNode.selectNodes(string, nSResolver)) != null && nodeList.getLength() > 0) {
                    XMLNode xMLNode2 = (XMLNode)nodeList.item(0);
                    if (xMLNode2 instanceof XMLText) {
                        String string2 = xMLNode2.getNodeValue();
                        return string2;
                    }
                    if (xMLNode2 instanceof XMLAttr) {
                        String string3 = ((XMLAttr)xMLNode2).getNodeValue();
                        return string3;
                    }
                    if (xMLNode2 instanceof XMLElement) {
                        ((XMLElement)xMLNode2).normalize();
                        String string4 = XSQLUtil.content((XMLElement)xMLNode2);
                        return string4;
                    }
                    break block7;
                }
                String string5 = "";
                return string5;
            }
            catch (XSLException xSLException) {
                String string6 = "";
                return string6;
            }
        }
        return "";
    }

    private static String content(XMLElement xMLElement) {
        StringBuffer stringBuffer = new StringBuffer();
        Object var2_2 = null;
        NodeList nodeList = xMLElement.getChildNodes();
        if (nodeList != null && nodeList.getLength() > 0) {
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                XMLNode xMLNode = (XMLNode)nodeList.item(n2);
                short s = xMLNode.getNodeType();
                if (s == 3) {
                    stringBuffer.append(xMLNode.getNodeValue());
                } else if (s == 1) {
                    stringBuffer.append(XSQLUtil.content((XMLElement)xMLNode));
                }
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public static XMLDocument DictionaryOfParamsAsXMLDocument(Dictionary dictionary) {
        try {
            Object object;
            Enumeration enumeration = null;
            if (dictionary != null) {
                enumeration = dictionary.keys();
            }
            XMLDocument xMLDocument = new XMLDocument();
            Element element = xMLDocument.createElement("request");
            xMLDocument.appendChild((Node)element);
            Element element2 = xMLDocument.createElement("parameters");
            element.appendChild(element2);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    String string = (String)dictionary.get(object);
                    Element element3 = xMLDocument.createElement((String)object);
                    element2.appendChild(element3);
                    Text text = xMLDocument.createTextNode(string);
                    element3.appendChild(text);
                }
            }
            object = xMLDocument;
            return object;
        }
        catch (Exception exception) {
            XMLDocument xMLDocument = new XMLDocument();
            Element element = xMLDocument.createElement("request");
            String string = exception.getMessage();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string = string != null ? String.valueOf(string).concat(String.valueOf(stringWriter.toString())) : stringWriter.toString();
            Text text = xMLDocument.createTextNode(string != null ? string : "");
            element.appendChild(text);
            xMLDocument.appendChild((Node)element);
            XMLDocument xMLDocument2 = xMLDocument;
            return xMLDocument2;
        }
    }

    public static String XL(String string, String string2) {
        try {
            String string3 = new String(string.getBytes("8859_1"), string2);
            return string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string4 = "-?-";
            return string4;
        }
    }

    public static String safeURLAsString(URL uRL) {
        String string = uRL.toExternalForm();
        if (string.startsWith("file:/")) {
            return String.valueOf("file:///").concat(String.valueOf(string.substring(6)));
        }
        return string;
    }

    public static String translate(String string, String string2) {
        try {
            if (!string.startsWith("file:/") && !string.startsWith("http:/")) {
                string = String.valueOf("file:///").concat(String.valueOf(string));
            }
            String string3 = XSQLUtil.translate(new URL(string), string2);
            return string3;
        }
        catch (Exception exception) {
            String string4 = null;
            return string4;
        }
    }

    public static String translate(URL uRL, String string) throws Exception {
        try {
            String string2 = XSQLUtil.safeURLAsString(new URL(uRL, string));
            return string2;
        }
        catch (Exception exception) {
            String string3 = null;
            return string3;
        }
    }

    public static String stringParamValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            if (stringArray.length > 0) {
                return stringArray[0];
            }
            return null;
        }
        return null;
    }
}

