/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql.actions;

import java.sql.SQLException;
import oracle.xml.xsql.XSQLActionHandler;
import oracle.xml.xsql.XSQLActionHandlerImpl;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.actions.Res;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XSQLExtensionActionHandler
extends XSQLActionHandlerImpl {
    private static final String HANDLER = "handler";
    private String className = null;

    public void init(XSQLPageRequest xSQLPageRequest, Element element) {
        super.init(xSQLPageRequest, element);
        this.className = this.getAttribute(HANDLER, this.getActionElement());
    }

    public void setHandlerClass(String string) {
        this.className = string;
    }

    public void handleAction(Node node) throws SQLException {
        Class<?> clazz = null;
        XSQLActionHandler xSQLActionHandler = null;
        if (this.className == null) {
            this.reportMissingAttribute(node, HANDLER);
            return;
        }
        try {
            clazz = Class.forName(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.reportError(node, Res.format(2, this.className));
            return;
        }
        try {
            xSQLActionHandler = (XSQLActionHandler)clazz.newInstance();
        }
        catch (ClassCastException classCastException) {
            this.reportError(node, Res.format(3, this.className));
        }
        catch (Exception exception) {
            this.reportError(node, Res.format(1, this.className));
        }
        if (xSQLActionHandler != null) {
            xSQLActionHandler.init(this.getPageRequest(), this.getActionElement());
            xSQLActionHandler.handleAction(node);
        }
    }
}

