/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql.actions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.dml.OracleXMLSave;
import oracle.xml.xsql.XSQLActionHandlerImpl;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLStylesheetProcessor;
import oracle.xml.xsql.actions.Res;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class XSQLInsertParameterHandler
extends XSQLActionHandlerImpl {
    private static final String NAME = "name";
    private static final String TABLE = "table";
    private static final String TRANSFORM = "transform";
    private static final String DATEFORMAT = "date-format";
    private OracleXMLSave oxs = null;
    private String paramname = null;
    private String tablename = null;
    private String transform = null;
    private String dateformat = null;

    public void init(XSQLPageRequest xSQLPageRequest, Element element) {
        super.init(xSQLPageRequest, element);
        this.paramname = this.getAttributeAllowingParam(NAME, element);
        this.tablename = this.getAttributeAllowingParam(TABLE, element);
        this.transform = this.getAttributeAllowingParam(TRANSFORM, element);
        this.dateformat = this.getAttributeAllowingParam(DATEFORMAT, element);
        this.transform = this.transform != null && !this.transform.equals("") ? xSQLPageRequest.translateURL(this.transform) : null;
    }

    public void handleAction(Node node) throws SQLException {
        if (!this.requiredConnectionProvided(node)) {
            return;
        }
        if (this.tablename == null || this.tablename.equals("")) {
            this.reportMissingAttribute(node, TABLE);
            return;
        }
        if (this.paramname == null || this.paramname.equals("")) {
            this.reportMissingAttribute(node, NAME);
            return;
        }
        String string = this.variableValue(this.paramname, this.getActionElement());
        if (string != null && !string.equals("")) {
            StringReader stringReader = new StringReader(string);
            DOMParser dOMParser = new DOMParser();
            try {
                dOMParser.parse((Reader)stringReader);
            }
            catch (IOException iOException) {
                this.reportError(node, Res.getString(10));
            }
            catch (SAXException sAXException) {
                this.reportError(node, Res.format(8, this.paramname));
            }
            XMLDocument xMLDocument = dOMParser.getDocument();
            Object object = null;
            if (xMLDocument != null) {
                try {
                    object = this.transform != null && !this.transform.equals("") ? XSQLStylesheetProcessor.processToDocument((Document)xMLDocument, this.transform, this.getPageRequest()) : xMLDocument;
                    OracleXMLSave oracleXMLSave = new OracleXMLSave(this.getPageRequest().getJDBCConnection(), this.tablename);
                    oracleXMLSave.setIgnoreCase(true);
                    if (this.dateformat != null && !this.dateformat.equals("")) {
                        oracleXMLSave.setDateFormat(this.dateformat);
                    }
                    int n = oracleXMLSave.insertXML((Document)object);
                    this.getPageRequest().getJDBCConnection().commit();
                    this.reportStatus(node, "rows", String.valueOf("").concat(String.valueOf(n)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.reportError(node, Res.format(11, this.transform));
                }
                catch (IOException iOException) {
                }
                catch (SQLException sQLException) {
                    this.reportError(node, sQLException.getMessage());
                }
                catch (OracleXMLSQLException oracleXMLSQLException) {
                    this.reportError(node, oracleXMLSQLException.getMessage());
                }
                catch (Exception exception) {
                    this.reportError(node, exception.getMessage());
                }
            } else {
                this.reportStatus(node, "result", Res.getString(13));
            }
        } else {
            this.reportStatus(node, "result", Res.format(12, this.paramname));
        }
    }
}

