/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql.actions;

import java.sql.SQLException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import oracle.xml.xsql.XSQLActionHandlerImpl;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLServletPageRequest;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XSQLSetCookieHandler
extends XSQLActionHandlerImpl {
    String name = null;
    String value = null;
    String statement = null;
    String sequence = null;
    String maxage = null;
    String domain = null;
    String path = null;
    String ignoreEmpty = null;
    boolean onlyIfNull = false;
    boolean dontSetIfNull = false;
    boolean currentlyNull = false;

    public void init(XSQLPageRequest xSQLPageRequest, Element element) {
        super.init(xSQLPageRequest, element);
        this.name = this.getAttributeAllowingParam("name", element);
        this.value = this.getAttributeAllowingParam("value", element);
        this.maxage = this.getAttributeAllowingParam("max-age", element);
        this.domain = this.getAttributeAllowingParam("domain", element);
        this.path = this.getAttributeAllowingParam("path", element);
        String string = this.getAttributeAllowingParam("only-if-unset", element);
        String string2 = this.getAttributeAllowingParam("ignore-empty-value", element);
        if (string != null) {
            this.onlyIfNull = string.equalsIgnoreCase("yes");
        }
        if (string2 != null) {
            this.dontSetIfNull = string2.equalsIgnoreCase("yes");
        }
        this.statement = this.getActionElementContent();
    }

    public void handleAction(Node node) throws SQLException {
        if (this.getPageRequest().getRequestType().equals("Servlet")) {
            String string;
            XSQLServletPageRequest xSQLServletPageRequest = (XSQLServletPageRequest)this.getPageRequest();
            HttpServletResponse httpServletResponse = xSQLServletPageRequest.getHttpServletResponse();
            if (this.name == null || this.name.equals("")) {
                this.reportMissingAttribute(node, "name");
                return;
            }
            if (this.onlyIfNull && (string = xSQLServletPageRequest.getCookie(this.name)) == null) {
                this.currentlyNull = true;
            }
            if (!this.onlyIfNull || this.currentlyNull) {
                if (this.value == null) {
                    this.value = this.firstColumnOfFirstRow(node, this.statement);
                }
                if (!(this.value == null || this.dontSetIfNull && this.value.equals(""))) {
                    string = new Cookie(this.name, this.value);
                    if (this.maxage != null && !this.maxage.equals("")) {
                        try {
                            int n = Integer.parseInt(this.maxage);
                            string.setMaxAge(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (this.domain != null && !this.domain.equals("")) {
                        string.setDomain(this.domain);
                    }
                    if (this.path != null && !this.path.equals("")) {
                        string.setPath(this.path);
                    }
                    httpServletResponse.addCookie((Cookie)string);
                }
            }
        }
    }
}

