/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addr;

import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class IPCAddress
extends Address {
    public static String IPC_PROTOCOL = "IPC";

    protected IPCAddress(NVPair nVPair) throws CreateAddressException {
        super(nVPair);
        String string = Address._getParameter(nVPair, "PROTOCOL");
        if (string == null || !string.equalsIgnoreCase(IPC_PROTOCOL)) {
            throw new CreateAddressException("IPC: Invalid protocol (" + string + ") in Address.");
        }
        String string2 = IPC_PROTOCOL;
        this._setParameter("PROTOCOL", string2);
        string2 = Address._getParameter(nVPair, "KEY");
        if (string2 == null) {
            throw new CreateAddressException("IPC: The value for KEY is missing.");
        }
        this._setParameter("KEY", string2);
    }

    public String getKey() {
        return this._getParameter("KEY");
    }

    public void setKey(String string) {
        this._setParameter("KEY", string);
    }

    private static void _validateKey(String string) {
    }

    private static void _print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        String string;
        IPCAddress iPCAddress;
        NVPair nVPair;
        String string2;
        String string3;
        NVFactory nVFactory = new NVFactory();
        System.out.println("Verifying constructor IPCAddress(nvp)");
        System.out.println("  With VALID input");
        try {
            string3 = "(ADDRESS=(PROTOCOL=IPC)(KEY=winter_lsnr))";
            string2 = "    Case 1: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            iPCAddress = new IPCAddress(nVPair);
            string2 = "      Result: " + iPCAddress.toNVString();
            System.out.println(string2);
            string3 = "(Address = (key = summer_lsnr) (protocol = ipc))";
            string2 = "    Case 2: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            iPCAddress = new IPCAddress(nVPair);
            string2 = "      Result: " + iPCAddress.toNVString();
            System.out.println(string2);
            string3 = "(address = (Protocol = IPC) (Key = novell1))";
            string2 = "    Case 3: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            iPCAddress = new IPCAddress(nVPair);
            string2 = "      Result: " + iPCAddress.toNVString();
            System.out.println(string2);
        }
        catch (CreateAddressException createAddressException) {
            string = "      ERROR: Unexpected exception: " + createAddressException.getMessage();
            System.out.println(string);
        }
        System.out.println("\n  With INVALID input");
        try {
            string3 = "(address = (key=foobar))";
            string2 = "    Case 1: Missing protocol: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            iPCAddress = new IPCAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=tcp)(host=winter)(port=1521))";
            string2 = "    Case 2: Incorrect protocol: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            iPCAddress = new IPCAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=ipc))";
            string2 = "    Case 3: Missing service: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            iPCAddress = new IPCAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=ipc)(key=summer_lsnr)";
            string2 = "    Case 4: Parse error: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            iPCAddress = new IPCAddress(nVPair);
            System.out.println("      ERROR: expected NVParseException");
            return;
        }
        catch (CreateAddressException createAddressException) {
            string = "      ERROR: Unexpected exception: " + createAddressException.getMessage();
            System.out.println(string);
            return;
        }
    }
}

