/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addr;

import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class NMPAddress
extends Address {
    public static String NMP_PROTOCOL = "NMP";

    public NMPAddress(NVPair nVPair) throws CreateAddressException {
        super(nVPair);
        String string = Address._getParameter(nVPair, "PROTOCOL");
        if (string == null || !string.equalsIgnoreCase(NMP_PROTOCOL)) {
            throw new CreateAddressException("NMP: Invalid protocol (" + string + ") in Address.");
        }
        String string2 = NMP_PROTOCOL;
        this._setParameter("PROTOCOL", string2);
        string2 = Address._getParameter(nVPair, "SERVER");
        if (string2 == null) {
            throw new CreateAddressException("NMP: The value for SERVER is missing.");
        }
        this._setParameter("SERVER", string2);
        String string3 = Address._getParameter(nVPair, "PIPE");
        if (string3 == null) {
            throw new CreateAddressException("NMP: The value for PIPE is missing.");
        }
        this._setParameter("PIPE", string3);
    }

    public String getServer() {
        return this._getParameter("SERVER");
    }

    public String getPipe() {
        return this._getParameter("PIPE");
    }

    public void setServer(String string) {
        this._setParameter("SERVER", string);
    }

    public void setPipe(String string) {
        this._setParameter("PIPE", string);
    }

    private static void _validateServer(String string) {
    }

    private static void _validatePipe(String string) {
    }

    private static void _print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        String string;
        NMPAddress nMPAddress;
        NVPair nVPair;
        String string2;
        String string3;
        NVFactory nVFactory = new NVFactory();
        System.out.println("Verifying constructor NMPAddress(nvp)");
        System.out.println("  With VALID input");
        try {
            string3 = "(ADDRESS=(PROTOCOL=NMP)(SERVER=WINTER)(PIPE=ORAPIPE))";
            string2 = "    Case 1: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            nMPAddress = new NMPAddress(nVPair);
            string2 = "      Result: " + nMPAddress.toNVString();
            System.out.println(string2);
            string3 = "(Address = (Server = Summer) (PIPE = ORAPIPE) (Protocol = NMP))";
            string2 = "    Case 2: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            nMPAddress = new NMPAddress(nVPair);
            string2 = "      Result: " + nMPAddress.toNVString();
            System.out.println(string2);
            string3 = "(address = (protocol = nmp) (pipe = orapipe) (server = stacks))";
            string2 = "    Case 3: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            nMPAddress = new NMPAddress(nVPair);
            string2 = "      Result: " + nMPAddress.toNVString();
            System.out.println(string2);
        }
        catch (CreateAddressException createAddressException) {
            string = "      ERROR: Unexpected exception: " + createAddressException.getMessage();
            System.out.println(string);
        }
        System.out.println("\n  With INVALID input");
        try {
            string3 = "(address = (server=summer)(pipe=orapipe))";
            string2 = "    Case 1: Missing protocol: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            nMPAddress = new NMPAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=spx)(service = winter_lsnr))";
            string2 = "    Case 2: Incorrect protocol: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            nMPAddress = new NMPAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=nmp)(pipe=orapipe))";
            string2 = "    Case 3: Missing server: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            nMPAddress = new NMPAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=nmp)(server=summer))";
            string2 = "    Case 4: Missing pipe: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            nMPAddress = new NMPAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=nmp)(server=summer)(pipe=orapipe)";
            string2 = "    Case 5: Parse error: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            nMPAddress = new NMPAddress(nVPair);
            System.out.println("      ERROR: expected NVParseException");
            return;
        }
        catch (CreateAddressException createAddressException) {
            string = "      ERROR: Unexpected exception: " + createAddressException.getMessage();
            System.out.println(string);
            return;
        }
    }
}

