/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addr;

import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class SPXAddress
extends Address {
    public static String SPX_PROTOCOL = "SPX";

    protected SPXAddress(NVPair nVPair) throws CreateAddressException {
        super(nVPair);
        String string = Address._getParameter(nVPair, "PROTOCOL");
        if (string == null || !string.equalsIgnoreCase(SPX_PROTOCOL)) {
            throw new CreateAddressException("SPX: Invalid protocol (" + string + ") in Address.");
        }
        String string2 = SPX_PROTOCOL;
        this._setParameter("PROTOCOL", string2);
        string2 = Address._getParameter(nVPair, "SERVICE");
        if (string2 == null) {
            throw new CreateAddressException("SPX: The value for SERVICE is missing.");
        }
        this._setParameter("SERVICE", string2);
    }

    public String getService() {
        return this._getParameter("SERVICE");
    }

    public void setService(String string) {
        this._setParameter("SERVICE", string);
    }

    private static void _validateService(String string) {
    }

    private static void _print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        String string;
        SPXAddress sPXAddress;
        NVPair nVPair;
        String string2;
        String string3;
        NVFactory nVFactory = new NVFactory();
        System.out.println("Verifying constructor SPXAddress(nvp)");
        System.out.println("  With VALID input");
        try {
            string3 = "(ADDRESS=(PROTOCOL=SPX)(SERVICE=WINTER_LSNR))";
            string2 = "    Case 1: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            sPXAddress = new SPXAddress(nVPair);
            string2 = "      Result: " + sPXAddress.toNVString();
            System.out.println(string2);
            string3 = "(Address = (service = summer_lsnr) (protocol = spx))";
            string2 = "    Case 2: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            sPXAddress = new SPXAddress(nVPair);
            string2 = "      Result: " + sPXAddress.toNVString();
            System.out.println(string2);
            string3 = "(address = (Protocol = SPX) (Service = novell1))";
            string2 = "    Case 3: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            sPXAddress = new SPXAddress(nVPair);
            string2 = "      Result: " + sPXAddress.toNVString();
            System.out.println(string2);
        }
        catch (CreateAddressException createAddressException) {
            string = "      ERROR: Unexpected exception: " + createAddressException.getMessage();
            System.out.println(string);
        }
        System.out.println("\n  With INVALID input");
        try {
            string3 = "(address = (service=foobar))";
            string2 = "    Case 1: Missing protocol: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            sPXAddress = new SPXAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=tcp)(host=winter)(port=1521))";
            string2 = "    Case 2: Incorrect protocol: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            sPXAddress = new SPXAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=spx))";
            string2 = "    Case 3: Missing service: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            sPXAddress = new SPXAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=spx)(service=summer_lsnr)";
            string2 = "    Case 4: Parse error: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            sPXAddress = new SPXAddress(nVPair);
            System.out.println("      ERROR: expected NVParseException");
            return;
        }
        catch (CreateAddressException createAddressException) {
            string = "      ERROR: Unexpected exception: " + createAddressException.getMessage();
            System.out.println(string);
            return;
        }
    }
}

