/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addr;

import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class TCPSAddress
extends Address {
    public static String TCPS_PROTOCOL = "TCPS";

    protected TCPSAddress(NVPair nVPair) throws CreateAddressException {
        super(nVPair);
        String string = Address._getParameter(nVPair, "PROTOCOL");
        if (string == null || !string.equalsIgnoreCase(TCPS_PROTOCOL)) {
            throw new CreateAddressException("TCPS: Invalid protocol (" + string + ") in Address.");
        }
        String string2 = TCPS_PROTOCOL;
        this._setParameter("PROTOCOL", string2);
        string2 = Address._getParameter(nVPair, "HOST");
        if (string2 == null) {
            throw new CreateAddressException("TCPS: The value for the HOST is missing.");
        }
        this._setParameter("HOST", string2);
        String string3 = Address._getParameter(nVPair, "PORT");
        if (string3 == null) {
            throw new CreateAddressException("TCPS: The value for PORT is missing.");
        }
        try {
            int n = Integer.valueOf(string3);
            this._setParameter("PORT", String.valueOf(n));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new CreateAddressException("TCPS: The value for PORT (" + string3 + ") must be a number.");
        }
    }

    public String getHost() {
        return this._getParameter("HOST");
    }

    public int getPort() {
        String string = this._getParameter("PORT");
        return Integer.valueOf(string);
    }

    public void setHost(String string) {
        this._setParameter("HOST", string);
    }

    public void setPort(int n) {
        this._setParameter("PORT", String.valueOf(n));
    }

    private static void _validateHost(String string) {
    }

    private static void _validatePort(int n) {
    }

    private static void _print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        String string;
        TCPSAddress tCPSAddress;
        NVPair nVPair;
        String string2;
        String string3;
        NVFactory nVFactory = new NVFactory();
        System.out.println("Verifying constructor TCPSAddress(nvp)");
        System.out.println("  With VALID input");
        try {
            string3 = "(ADDRESS=(PROTOCOL=TCPS)(HOST=WINTER)(PORT=1521))";
            string2 = "    Case 1: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            tCPSAddress = new TCPSAddress(nVPair);
            string2 = "      Result: " + tCPSAddress.toNVString();
            System.out.println(string2);
            string3 = "(Address = (Host = summer) (Port = 1526) (Protocol = TCPS))";
            string2 = "    Case 2: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            tCPSAddress = new TCPSAddress(nVPair);
            string2 = "      Result: " + tCPSAddress.toNVString();
            System.out.println(string2);
            string3 = "(address = (protocol = TCPS) (port = 5000) (host = spring))";
            string2 = "    Case 3: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            tCPSAddress = new TCPSAddress(nVPair);
            string2 = "      Result: " + tCPSAddress.toNVString();
            System.out.println(string2);
        }
        catch (CreateAddressException createAddressException) {
            string = "      ERROR: Unexpected exception: " + createAddressException.getMessage();
            System.out.println(string);
        }
        System.out.println("\n  With INVALID input");
        try {
            string3 = "(address = (host=winter)(port=1521))";
            string2 = "    Case 1: Missing protocol: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            tCPSAddress = new TCPSAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=spx)(service = winter_lsnr))";
            string2 = "    Case 2: Incorrect protocol: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            tCPSAddress = new TCPSAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=TCPS)(port=1521))";
            string2 = "    Case 3: Missing host: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            tCPSAddress = new TCPSAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=TCPS)(host=summer))";
            string2 = "    Case 4: Missing port: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            tCPSAddress = new TCPSAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=TCPS)(host=summer)(port=1521)";
            string2 = "    Case 5: Parse error: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            tCPSAddress = new TCPSAddress(nVPair);
            System.out.println("      ERROR: expected NVParseException");
        }
        catch (CreateAddressException createAddressException) {
            string = "      ERROR: Unexpected exception: " + createAddressException.getMessage();
            System.out.println(string);
        }
        try {
            string3 = "(address = (protocol=TCPS)(host=summer)(port=foo))";
            string2 = "    Case 6: Invalid port: " + string3;
            System.out.println(string2);
            nVPair = nVFactory.createNVPair(string3);
            tCPSAddress = new TCPSAddress(nVPair);
            System.out.println("      ERROR: expected CreateAddressException");
            return;
        }
        catch (CreateAddressException createAddressException) {
            string = "      Exception Received: " + createAddressException.getMessage();
            System.out.println(string);
            return;
        }
    }
}

