/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.container;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.MissingResourceException;
import oracle.ewt.EwtContainer;
import oracle.ewt.alert.Alert;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.LDAPDataStore;

public class ContextSelectionPanel
extends EwtContainer
implements ItemListener {
    private NetStrings m_ns;
    private LDAPDataStore m_lds;
    private String m_oracleContext;
    private String m_directoryContext;
    private String m_previousContext;
    private String m_dirRootContext;
    ComboBox m_directoryChoice;
    LWChoice m_oracleChoice;

    public ContextSelectionPanel(LDAPDataStore lDAPDataStore, String string) throws DataStoreException {
        this.m_lds = lDAPDataStore;
        this.m_ns = new NetStrings();
        if (string == null) {
            string = "";
        }
        this.m_previousContext = string;
        String[] stringArray = this.m_lds.getNamingContexts(this.m_lds.getDirectoryServers()[0], this.m_lds.getDirectoryType());
        this.m_directoryChoice = new ComboBox();
        try {
            this.m_dirRootContext = this.m_ns.getString("CNTctxtSelDirRoot");
        }
        catch (MissingResourceException missingResourceException) {
            this.m_dirRootContext = "<ROOT>";
        }
        this.m_directoryChoice.addItem(this.m_dirRootContext);
        int n = -1;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.m_directoryChoice.addItem(stringArray[n2]);
                if (this.m_previousContext.toUpperCase().endsWith(stringArray[n2].toUpperCase())) {
                    n = n2 + 1;
                }
                ++n2;
            }
        }
        this.m_directoryChoice.select(n == -1 ? 0 : n);
        this.m_directoryContext = this.m_directoryChoice.getSelectedItem();
        this.m_oracleChoice = new LWChoice();
        if (!this.updateOracleContexts(this.m_directoryContext)) {
            this.m_directoryContext = this.m_dirRootContext;
            this.m_directoryChoice.select(this.m_directoryContext);
            if (!this.updateOracleContexts(this.m_directoryContext)) {
                String string2;
                try {
                    string2 = this.m_ns.getString("CNTctxtSelErrorNoOracleSvr");
                }
                catch (MissingResourceException missingResourceException) {
                    string2 = this.m_ns.getString("CNTctxtSelErrorNoOracle");
                }
                new Alert(NetUtils.getApplication().getFrame(), string2, 0, 1).runAlert();
                throw new DataStoreException("No oracle contexts available");
            }
        }
        this.m_directoryChoice.addItemListener((ItemListener)this);
        this.m_oracleChoice.addItemListener((ItemListener)this);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        MultiLineLabel multiLineLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), this.m_ns.getString("CNTctxtSelChooseNaming"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 16;
        ((Container)((Object)this)).add((Component)multiLineLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 3;
        ((Container)((Object)this)).add((Component)new LWLabel(this.m_ns.getString("CNTctxtSelNamingContext")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        ((Container)((Object)this)).add((Component)this.m_directoryChoice, gridBagConstraints);
        MultiLineLabel multiLineLabel2 = new MultiLineLabel(WordWrapper.getTextWrapper(), this.m_ns.getString("CNTctxtSelChooseOracle"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.anchor = 16;
        ((Container)((Object)this)).add((Component)multiLineLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 7;
        gridBagConstraints.weighty = 0.0;
        ((Container)((Object)this)).add((Component)new LWLabel(this.m_ns.getString("CNTctxtSelOracleContext")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        ((Container)((Object)this)).add((Component)this.m_oracleChoice, gridBagConstraints);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        block2: {
            block3: {
                block4: {
                    if (itemEvent.getStateChange() != 1) break block2;
                    if (itemEvent.getSource() != this.m_directoryChoice) break block3;
                    if (this.m_directoryContext != null && this.m_directoryContext.equals(this.m_directoryChoice.getSelectedItem())) break block4;
                    this.m_directoryContext = this.m_directoryChoice.getSelectedItem();
                    if (this.updateOracleContexts(this.m_directoryContext)) break block2;
                    Alert alert = new Alert(NetUtils.getApplication().getFrame(), this.m_ns.getString("CNTctxtSelErrorNoOracle"), 0, 1);
                    alert.runAlert();
                    this.m_directoryContext = this.m_dirRootContext;
                    this.updateOracleContexts(this.m_dirRootContext);
                }
                return;
            }
            this.m_oracleContext = this.m_oracleChoice.getSelectedItem();
        }
    }

    public void setContext(String string) {
        if (string == null) {
            throw new NullPointerException("Null context");
        }
        this.m_oracleContext = string;
        int n = this.m_directoryChoice.getItemCount() - 1;
        while (n >= 0) {
            if (this.m_oracleContext.startsWith(this.m_directoryChoice.getItem(n))) {
                this.m_directoryChoice.select(n);
            }
            --n;
        }
        this.m_directoryContext = this.m_directoryChoice.getSelectedItem();
        int n2 = this.m_oracleChoice.getItemCount() - 1;
        while (n2 >= 0) {
            if (this.m_oracleContext.equals(this.m_oracleChoice.getItem(n2))) {
                this.m_oracleChoice.select(n2);
            }
            --n2;
        }
    }

    private boolean updateOracleContexts(String string) {
        String[] stringArray;
        this.m_oracleChoice.removeAll();
        if (string.equals(this.m_dirRootContext)) {
            string = "";
        }
        if ((stringArray = this.m_lds.getOracleContexts(string, this.m_lds.getDirectoryServers()[0], this.m_lds.getDirectoryType())) == null || stringArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.m_oracleChoice.addItem(stringArray[n]);
            if (this.m_previousContext.equalsIgnoreCase(this.m_oracleChoice.getItem(n))) {
                this.m_oracleChoice.select(n);
            }
            ++n;
        }
        if (n == stringArray.length) {
            this.m_oracleChoice.select(0);
        }
        this.m_oracleContext = this.m_oracleChoice.getSelectedItem();
        return true;
    }

    public String getContext() {
        return this.m_oracleContext;
    }

    public Dimension getMaximumSize() {
        return ((Container)((Object)this)).getPreferredSize();
    }
}

