/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.container;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.ewt.alert.Alert;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeSelection;
import oracle.ewt.dTree.DTreeSelectionEvent;
import oracle.ewt.dialog.directory.DirectoryDialog;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWMenuSeparator;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarItem;
import oracle.ewt.toolBar.ToolBarSeparator;
import oracle.net.asst.component.NetComponent;
import oracle.net.asst.component.NetObjectMenu;
import oracle.net.asst.component.NetObjectToolbar;
import oracle.net.asst.component.NetVector;
import oracle.net.asst.container.ContextChooser;
import oracle.net.asst.container.ExceptionMessage;
import oracle.net.asst.container.NetAboutDialog;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetPanel;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.listener.ListenerComponent;
import oracle.net.asst.names.NamesComponent;
import oracle.net.asst.nsnMigrationWizard.NSNMigrationWizard;
import oracle.net.asst.profile.NetProfileComponent;
import oracle.net.asst.servicename.ServiceNameComponent;
import oracle.net.common.NetGetEnv;
import oracle.net.common.NetProperties;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.FileDataStore;
import oracle.net.common.dataStore.LDAPDataStore;
import oracle.net.config.Config;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appComponent.TreeDetailAppComponent;
import oracle.sysman.emSDK.client.appContainer.WebApplication;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.DataDrivenTree;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.StaticItemSource;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSource;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItem;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeNodeSelectionListener;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeParentNode;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeProxy;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandAdapter;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandEvent;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandListener;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.MenuCommandItem;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.ToolBarCommandButton;

public class NetContainer
extends TreeDetailAppComponent
implements CommandListener {
    private final NetStrings ns = new NetStrings();
    private final String openString = this.ns.getString("CNTFileOpen");
    private final String saveString = this.ns.getString("CNTFileSave");
    private final String saveAsString = this.ns.getString("CNTFileSaveAs");
    private final String discardString = this.ns.getString("CNTFileDiscard");
    private final String toolsString = this.ns.getString("CNTTools");
    private final String ldapString = this.ns.getString("CNTToolsLDAP");
    private final String changeContextString = this.ns.getString("CNTChangeContextMenu");
    private final String changeAuthString = this.ns.getString("CNTChangeAuthMenu");
    private final String migrateString = this.ns.getString("CNTMigrateMenu");
    private final String editString = this.ns.getString("CNTEdit");
    private final String createString = this.ns.getString("CNTCreate");
    private final String deleteString = this.ns.getString("CNTDelete");
    private final String yesString = this.ns.getString("CNTYes");
    private final String noString = this.ns.getString("CNTNo");
    private final String cancelString = this.ns.getString("CNTCancel");
    private final String appNameString = this.ns.getString("CNTApplication");
    private BufferedFrame myFrame;
    private DirectoryDialog dirDialog;
    private WebApplication m_app;
    private NetVector controllableToolItems;
    private ToolBarItem createTItem;
    private ToolBarItem deleteTItem;
    private NetVector controllableMenus;
    private LWMenuItem createMenuItem;
    private LWMenuItem deleteMenuItem;
    private LWMenuItem changeContextMenuItem;
    private LWMenuItem changeAuthMenuItem;
    private LWMenuItem migrateMenuItem;
    private CommandAdapter commandAdapter;
    private NetProperties netProps;
    private FileDataStore m_fileDataStore;
    private LDAPDataStore m_ldapDataStore;
    private boolean isMSWindows;
    private boolean ldapEnabled = false;
    private Toolkit tk;
    NetComponent namesComp;
    NetComponent profileComp;
    NetComponent lsnrComp;
    NetComponent serviceComp;
    NetComponent LDAPserviceComp;
    private Config m_config;
    private NetVector allComponents;
    private NetComponent activeComponent;

    public NetContainer(WebApplication webApplication) {
        super(webApplication);
        this.m_app = webApplication;
    }

    public void initClient() {
        String string;
        super.initClient();
        this.myFrame = (BufferedFrame)this.m_app.getFrame();
        this.tk = Toolkit.getDefaultToolkit();
        NetUtils.setContainer(this);
        NetUtils.setHelpContext(new NetHelp(this.myFrame));
        try {
            this.netProps = NetProperties.getInstance();
        }
        catch (IOException iOException) {
            System.err.println("Error initializing NetProperties file");
            this.netProps = null;
        }
        String string2 = System.getProperty("os.name", "NONE");
        this.isMSWindows = string2.startsWith("Windows");
        String string3 = NetUtils.formatDirectoryString(NetGetEnv.getNetworkDir());
        while (!new File(string3).isDirectory()) {
            string = this.pickDirectory(this.ns.getString("CNTOpenConfMsg"), this.ns.getString("CNTOpenConfTitle"), string3);
            string3 = NetUtils.formatDirectoryString(string);
        }
        this.m_fileDataStore = new FileDataStore(string3);
        NetUtils.setDefaultDomain(this.readDefaultDomain(this.m_fileDataStore));
        try {
            this.m_config = new Config(NetGetEnv.getOracleHome(), 1, null);
            this.ldapEnabled = this.m_config.getDirectoryType() != null;
        }
        catch (Exception exception) {
            this.ldapEnabled = false;
        }
        if (this.ldapEnabled) {
            try {
                this.m_ldapDataStore = new LDAPDataStore();
            }
            catch (DataStoreException dataStoreException) {
                ExceptionMessage.display((Component)((Object)this), "Unable to connect to directory", dataStoreException);
                dataStoreException.printStackTrace();
                this.ldapEnabled = false;
                this.m_ldapDataStore = null;
            }
        }
        this.loadComponents();
        this.getTreeMaster().setTreeRoot((TreeDataSource)new InvisibleDataSource(this.getTreeMaster().getTree()));
        this.commandAdapter = new CommandAdapter(this.m_app);
        this.commandAdapter.addCommandListener((CommandListener)this);
        this.generateMenus();
        this.generateToolBar();
        this.getSplitter().setSizeRatio(0.37);
        this.myFrame.setTitle(String.valueOf(this.appNameString) + " - " + this.m_fileDataStore.getAdminDir());
        string = this.getTree().getRoot().getItem(0);
        string.setExpanded(true);
        this.getTree().getSelection().selectItem((DTreeItem)string);
    }

    private void loadComponents() {
        this.allComponents = new NetVector();
        if (this.ldapEnabled) {
            this.LDAPserviceComp = new ServiceNameComponent(this.m_app, this.m_ldapDataStore);
            this.allComponents.addElement(this.LDAPserviceComp);
        }
        this.profileComp = new NetProfileComponent(this.m_app, this.m_fileDataStore);
        this.allComponents.addElement(this.profileComp);
        this.lsnrComp = new ListenerComponent(this.m_app, this.m_fileDataStore);
        this.allComponents.addElement(this.lsnrComp);
        this.serviceComp = new ServiceNameComponent(this.m_app, this.m_fileDataStore);
        this.allComponents.addElement(this.serviceComp);
        String string = null;
        if (this.netProps != null) {
            string = this.netProps.getProperty("Names");
        }
        if (string == null || string.equalsIgnoreCase("yes")) {
            this.namesComp = new NamesComponent(this.m_app, this.m_fileDataStore);
            this.allComponents.addElement(this.namesComp);
        }
    }

    private void generateMenus() {
        Object object;
        this.controllableMenus = new NetVector();
        LWPopupMenu lWPopupMenu = this.m_app.getFileMenu().getSubMenu();
        Vector vector = new Vector();
        Enumeration enumeration = lWPopupMenu.getEnumeration();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof LWMenuItem)) continue;
            vector.addElement(e);
        }
        lWPopupMenu.removeAll();
        lWPopupMenu.add((Component)new MenuCommandItem(this.openString, this.openString));
        lWPopupMenu.add((Component)new MenuCommandItem(this.saveString, this.saveString));
        lWPopupMenu.add((Component)new MenuCommandItem(this.saveAsString, this.saveAsString));
        lWPopupMenu.add((Component)new LWMenuSeparator());
        lWPopupMenu.add((Component)new MenuCommandItem(this.discardString, this.discardString));
        lWPopupMenu.add((Component)new LWMenuSeparator());
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            lWPopupMenu.add((Component)((LWMenuItem)vector.elementAt(n2)));
            ++n2;
        }
        LWPopupMenu lWPopupMenu2 = new LWPopupMenu();
        this.createMenuItem = new MenuCommandItem(this.createString, this.createString);
        this.createMenuItem.setEnabled(false);
        lWPopupMenu2.add((Component)this.createMenuItem);
        this.deleteMenuItem = new MenuCommandItem(this.deleteString, this.deleteString);
        this.deleteMenuItem.setEnabled(false);
        lWPopupMenu2.add((Component)this.deleteMenuItem);
        NetObjectMenu netObjectMenu = new NetObjectMenu(this.editString, this.createString, false);
        netObjectMenu.setMenuItem(this.createMenuItem);
        this.controllableMenus.addElement(netObjectMenu);
        netObjectMenu = new NetObjectMenu(this.editString, this.deleteString, false);
        netObjectMenu.setMenuItem(this.deleteMenuItem);
        this.controllableMenus.addElement(netObjectMenu);
        LWPopupMenu lWPopupMenu3 = new LWPopupMenu();
        if (this.ldapEnabled) {
            object = new LWPopupMenu();
            ((Container)object).add((Component)new MenuCommandItem(this.changeContextString, this.changeContextString));
            ((Container)object).add((Component)new MenuCommandItem(this.changeAuthString, this.changeAuthString));
            ((Container)object).add((Component)new LWMenuSeparator());
            ((Container)object).add((Component)new MenuCommandItem(this.migrateString, this.migrateString));
            lWPopupMenu3.add((Component)new LWMenu(this.ldapString, (LWPopupMenu)object));
        }
        Enumeration enumeration2 = this.allComponents.elements();
        while (enumeration2.hasMoreElements()) {
            object = (NetComponent)enumeration2.nextElement();
            NetVector netVector = ((NetComponent)object).getComponentMenus();
            if (netVector == null) continue;
            Enumeration enumeration3 = netVector.elements();
            while (enumeration3.hasMoreElements()) {
                boolean bl = false;
                NetObjectMenu netObjectMenu2 = (NetObjectMenu)enumeration3.nextElement();
                MenuCommandItem menuCommandItem = new MenuCommandItem(netObjectMenu2.toString(), netObjectMenu2.toString());
                Enumeration enumeration4 = this.controllableMenus.elements();
                while (enumeration4.hasMoreElements()) {
                    NetObjectMenu netObjectMenu3 = (NetObjectMenu)enumeration4.nextElement();
                    if (!netObjectMenu3.getMenuName().equals(netObjectMenu2.getMenuName()) || !netObjectMenu3.toString().equals(netObjectMenu2.toString())) continue;
                    netObjectMenu2.setMenuItem(netObjectMenu3.getMenuItem());
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.controllableMenus.addElement(netObjectMenu2);
                netObjectMenu2.setMenuItem((LWMenuItem)menuCommandItem);
                menuCommandItem.setEnabled(false);
                if (netObjectMenu2.getMenuName().equals(this.editString)) {
                    lWPopupMenu2.add((Component)menuCommandItem);
                    continue;
                }
                lWPopupMenu3.add((Component)menuCommandItem);
            }
        }
        this.commandAdapter.checkStandardMenus();
        this.commandAdapter.addMenu(new LWMenu(this.editString, lWPopupMenu2));
        this.commandAdapter.addMenu(new LWMenu(this.toolsString, lWPopupMenu3));
    }

    private void generateToolBar() {
        this.controllableToolItems = new NetVector();
        ToolBar toolBar = new ToolBar();
        this.createTItem = new ToolBarCommandButton(this.createString, this.tk.getImage(String.valueOf(NetUtils.getImageDirectory()) + "create.gif"));
        toolBar.addItem(this.createTItem);
        this.createTItem.setHelpText(this.createString);
        this.createTItem.setEnabled(false);
        this.deleteTItem = new ToolBarCommandButton(this.deleteString, this.tk.getImage(String.valueOf(NetUtils.getImageDirectory()) + "delete.gif"));
        toolBar.addItem(this.deleteTItem);
        this.deleteTItem.setHelpText(this.deleteString);
        this.deleteTItem.setEnabled(false);
        NetObjectToolbar netObjectToolbar = new NetObjectToolbar(this.createString, null, false);
        netObjectToolbar.setToolbarItem(this.createTItem);
        this.controllableToolItems.addElement(netObjectToolbar);
        netObjectToolbar = new NetObjectToolbar(this.deleteString, null, false);
        netObjectToolbar.setToolbarItem(this.deleteTItem);
        this.controllableToolItems.addElement(netObjectToolbar);
        toolBar.addItem((ToolBarItem)new ToolBarSeparator());
        Enumeration enumeration = this.allComponents.elements();
        while (enumeration.hasMoreElements()) {
            NetComponent netComponent = (NetComponent)enumeration.nextElement();
            NetVector netVector = netComponent.getComponentToolbar();
            if (netVector == null) continue;
            Enumeration enumeration2 = netVector.elements();
            while (enumeration2.hasMoreElements()) {
                boolean bl = false;
                NetObjectToolbar netObjectToolbar2 = (NetObjectToolbar)enumeration2.nextElement();
                Enumeration enumeration3 = this.controllableToolItems.elements();
                while (enumeration3.hasMoreElements()) {
                    NetObjectToolbar netObjectToolbar3 = (NetObjectToolbar)enumeration3.nextElement();
                    if (!netObjectToolbar3.toString().equals(netObjectToolbar2.toString())) continue;
                    netObjectToolbar2.setToolbarItem(netObjectToolbar3.getToolbarItem());
                    bl = true;
                    break;
                }
                if (bl) continue;
                ToolBarCommandButton toolBarCommandButton = new ToolBarCommandButton(netObjectToolbar2.toString(), netObjectToolbar2.getImage());
                toolBarCommandButton.setHelpText(netObjectToolbar2.toString());
                netObjectToolbar2.setToolbarItem((ToolBarItem)toolBarCommandButton);
                toolBar.addItem((ToolBarItem)toolBarCommandButton);
                this.controllableToolItems.addElement(netObjectToolbar2);
                toolBarCommandButton.setEnabled(false);
            }
        }
        toolBar.addItem((ToolBarItem)new ToolBarSeparator());
        this.commandAdapter.addToolBar(toolBar);
    }

    public void display(NetComponent netComponent, Component component) {
        this.activeComponent = netComponent;
        this.getTreeDetail().showComponent(component);
    }

    public void setToolBarStatus(NetVector netVector) {
        ToolBarItem toolBarItem;
        Enumeration enumeration = this.controllableToolItems.elements();
        while (enumeration.hasMoreElements()) {
            toolBarItem = ((NetObjectToolbar)enumeration.nextElement()).getToolbarItem();
            if (toolBarItem == null) continue;
            toolBarItem.setEnabled(false);
        }
        if (netVector != null) {
            Enumeration enumeration2 = netVector.elements();
            while (enumeration2.hasMoreElements()) {
                NetObjectToolbar netObjectToolbar = (NetObjectToolbar)enumeration2.nextElement();
                toolBarItem = netObjectToolbar.getToolbarItem();
                toolBarItem.setEnabled(netObjectToolbar.isEnabled());
            }
        }
    }

    public void setMenuStatus(NetVector netVector) {
        LWMenuItem lWMenuItem;
        Enumeration enumeration = this.controllableMenus.elements();
        while (enumeration.hasMoreElements()) {
            lWMenuItem = ((NetObjectMenu)enumeration.nextElement()).getMenuItem();
            if (lWMenuItem == null) continue;
            lWMenuItem.setEnabled(false);
        }
        if (netVector != null) {
            Enumeration enumeration2 = netVector.elements();
            while (enumeration2.hasMoreElements()) {
                NetObjectMenu netObjectMenu = (NetObjectMenu)enumeration2.nextElement();
                lWMenuItem = netObjectMenu.getMenuItem();
                lWMenuItem.setEnabled(netObjectMenu.isEnabled());
            }
        }
    }

    public boolean isExitAllowed() {
        if (this.doSaveOrDiscard(true)) {
            return super.isExitAllowed();
        }
        return false;
    }

    private boolean doSaveOrDiscard(boolean bl) {
        boolean bl2 = false;
        Enumeration enumeration = this.allComponents.elements();
        while (enumeration.hasMoreElements()) {
            NetComponent netComponent = (NetComponent)enumeration.nextElement();
            if (!netComponent.isChanged()) continue;
            bl2 = true;
        }
        if (!bl2) {
            return true;
        }
        Alert alert = new Alert((Frame)this.myFrame, this.ns.getString("CNTSavePromptMsg"), 1, 7);
        alert.setCenterOver((Component)this.myFrame);
        alert.setDefaultButton(1);
        alert.setTitle(this.ns.getString("CNTSavePromptTitle"));
        alert.setButtonLabel(1, this.ns.getString("CNTSave"));
        alert.setButtonLabel(2, this.ns.getString("CNTDiscard"));
        alert.setButtonLabel(4, this.ns.getString("CNTCancel"));
        int n = alert.runAlert();
        alert.dispose();
        if (this.isMSWindows) {
            this.myFrame.toFront();
        }
        if (n == 1) {
            return this.doSave(false);
        }
        if (n == 2) {
            if (!bl) {
                this.doDiscard();
            }
        } else if (n == 4) {
            return false;
        }
        return true;
    }

    private boolean doSave(boolean bl) {
        boolean bl2 = true;
        Enumeration enumeration = this.allComponents.elements();
        block2: while (enumeration.hasMoreElements()) {
            NetComponent netComponent = (NetComponent)enumeration.nextElement();
            if (!bl && !netComponent.isChanged()) continue;
            while (true) {
                try {
                    if (netComponent.save(this.m_fileDataStore)) continue block2;
                    return false;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Alert alert = new Alert((Frame)this.myFrame, this.ns.getString("CNTSaveErrorMsg", new Object[]{netComponent.toString()}), 0, 7);
                    alert.setButtonLabel(1, this.ns.getString("CNTSaveErrorTryAgain"));
                    alert.setButtonLabel(2, this.ns.getString("CNTSaveErrorContinue"));
                    alert.setButtonLabel(4, this.ns.getString("CNTCancel"));
                    int n = alert.runAlert();
                    alert.dispose();
                    if (this.isMSWindows) {
                        this.myFrame.toFront();
                    }
                    if (n != 2) continue;
                    bl2 = false;
                    continue block2;
                    if (n != 4) continue;
                    return false;
                }
                break;
            }
        }
        return bl2;
    }

    private boolean doSaveAs() {
        String string = this.pickDirectory(this.ns.getString("CNTSaveConfMsg"), this.ns.getString("CNTSaveConfTitle"), this.m_fileDataStore.getAdminDir());
        if (string == null) {
            return false;
        }
        this.m_fileDataStore = new FileDataStore(NetUtils.formatDirectoryString(string));
        this.myFrame.setTitle(String.valueOf(this.appNameString) + " - " + this.m_fileDataStore.getAdminDir());
        return this.doSave(true);
    }

    private void doDiscard() {
        Enumeration enumeration = this.allComponents.elements();
        while (enumeration.hasMoreElements()) {
            NetComponent netComponent = (NetComponent)enumeration.nextElement();
            if (!netComponent.isChanged()) continue;
            netComponent.refresh(this.m_fileDataStore);
        }
        this.activeComponent = null;
        this.getTree().getSelection().selectItem(this.getTree().getRoot().getItem(0));
    }

    private void checkDiscard() {
        boolean bl = false;
        Enumeration enumeration = this.allComponents.elements();
        while (enumeration.hasMoreElements()) {
            NetComponent netComponent = (NetComponent)enumeration.nextElement();
            if (!netComponent.isChanged()) continue;
            bl = true;
            break;
        }
        if (bl) {
            String string = this.ns.getString("CNTDiscardPromptMsg");
            Alert alert = new Alert((Frame)this.myFrame, string, 0, 3);
            alert.setCenterOver((Component)this.myFrame);
            alert.setDefaultButton(2);
            alert.setTitle(this.ns.getString("CNTDiscardPromptTitle"));
            if (alert.runAlert() == 1) {
                this.doDiscard();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commandIssued(CommandEvent commandEvent) {
        Object object;
        block26: {
            block25: {
                block24: {
                    block23: {
                        block22: {
                            String string = commandEvent.getCommand();
                            object = commandEvent.getSource();
                            DataDrivenTree dataDrivenTree = this.getTree();
                            DTreeSelection dTreeSelection = dataDrivenTree.getSelection();
                            TreeItem treeItem = null;
                            if (dTreeSelection.getHasSelection()) {
                                treeItem = (TreeItem)dTreeSelection.getSelectionRanges().getFirstItem();
                            }
                            try {
                                NetVector netVector;
                                Object object2;
                                block27: {
                                    block29: {
                                        block28: {
                                            if (object instanceof ToolBarCommandButton) {
                                                ((ToolBarCommandButton)object).setEnabled(false);
                                            }
                                            if (string.equals(this.deleteString)) {
                                                if (treeItem == null) break block22;
                                                Object[] objectArray = new Object[]{treeItem.getLabel()};
                                                Alert alert = new Alert((Frame)this.myFrame, this.ns.getString("CNTDeletePromptMsg", objectArray), 0, 3);
                                                alert.setCenterOver((Component)this.myFrame);
                                                alert.setDefaultButton(2);
                                                alert.setTitle(this.ns.getString("CNTDeletePromptTitle", objectArray));
                                                if (alert.runAlert() != 2) {
                                                    this.activeComponent.delete();
                                                }
                                                if (!this.isMSWindows) break block22;
                                                this.myFrame.toFront();
                                                break block22;
                                            }
                                            if (!string.equals(this.createString)) break block27;
                                            if (treeItem == null) break block28;
                                            if (this.activeComponent != null) break block29;
                                        }
                                        Object var8_13 = null;
                                        break block23;
                                    }
                                    this.activeComponent.create(null);
                                    break block22;
                                }
                                if (string.equals(this.discardString)) {
                                    this.checkDiscard();
                                    break block22;
                                }
                                if (string.equals(this.openString)) {
                                    if (!this.doSaveOrDiscard(true)) {
                                        break block24;
                                    }
                                    String string2 = this.pickDirectory(this.ns.getString("CNTOpenConfMsg"), this.ns.getString("CNTOpenConfTitle"), this.m_fileDataStore.getAdminDir());
                                    if (string2 == null) break block22;
                                    this.m_fileDataStore = new FileDataStore(NetUtils.formatDirectoryString(string2));
                                    this.myFrame.setTitle(String.valueOf(this.appNameString) + " - " + this.m_fileDataStore.getAdminDir());
                                    this.allComponents.elements();
                                    int n = this.allComponents.size() - 1;
                                    while (true) {
                                        if (n < 0) {
                                            DTreeItem dTreeItem = this.getTree().getRoot().getItem(0);
                                            this.getTree().refreshTree(dTreeItem);
                                            dTreeItem.setExpanded(true);
                                            this.getTree().getSelection().selectItem(dTreeItem);
                                            break block22;
                                        }
                                        if (((NetComponent)this.allComponents.elementAt(n)).getDataStore() instanceof FileDataStore) {
                                            ((NetComponent)this.allComponents.elementAt(n)).refresh(this.m_fileDataStore);
                                        }
                                        --n;
                                    }
                                }
                                if (string.equals(this.saveString)) {
                                    this.doSave(false);
                                    break block22;
                                }
                                if (string.equals(this.saveAsString)) {
                                    this.doSaveAs();
                                    break block22;
                                }
                                if (string.equals(this.changeContextString)) {
                                    this.changeLDAPContext();
                                    break block22;
                                }
                                if (string.equals(this.changeAuthString)) {
                                    NetUtils.authenticateLDAP(this.m_ldapDataStore, this.ns.getString("CNTAuthTitle"), this.ns.getString("CNTAuthChangeMessage"));
                                    break block22;
                                }
                                if (string.equals(this.migrateString)) {
                                    this.launchMigrationWizard();
                                    break block22;
                                }
                                if (this.activeComponent == null) break block22;
                                NetVector netVector2 = this.activeComponent.getComponentMenus();
                                if (netVector2 != null) {
                                    object2 = netVector2.elements();
                                    while (object2.hasMoreElements()) {
                                        NetObjectMenu netObjectMenu = (NetObjectMenu)object2.nextElement();
                                        if (!string.equals(netObjectMenu.toString())) continue;
                                        this.activeComponent.executeComponentMenu(netObjectMenu.toString());
                                        break block25;
                                    }
                                }
                                if ((netVector = this.activeComponent.getComponentToolbar()) == null) break block22;
                                Enumeration enumeration = netVector.elements();
                                while (enumeration.hasMoreElements()) {
                                    object2 = (NetObjectToolbar)enumeration.nextElement();
                                    if (!string.equals(((NetObjectToolbar)object2).toString())) continue;
                                    this.activeComponent.executeComponentToolbar(((NetObjectToolbar)object2).toString());
                                    break block26;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var8_18 = null;
                                if (!(object instanceof ToolBarCommandButton)) throw throwable;
                                ((ToolBarCommandButton)object).setEnabled(true);
                                throw throwable;
                            }
                        }
                        Object var8_17 = null;
                        if (!(object instanceof ToolBarCommandButton)) return;
                        ((ToolBarCommandButton)object).setEnabled(true);
                        return;
                    }
                    if (!(object instanceof ToolBarCommandButton)) return;
                    ((ToolBarCommandButton)object).setEnabled(true);
                    return;
                }
                Object var8_14 = null;
                if (!(object instanceof ToolBarCommandButton)) return;
                ((ToolBarCommandButton)object).setEnabled(true);
                return;
            }
            Object var8_15 = null;
            if (!(object instanceof ToolBarCommandButton)) return;
            ((ToolBarCommandButton)object).setEnabled(true);
            return;
        }
        Object var8_16 = null;
        if (!(object instanceof ToolBarCommandButton)) return;
        ((ToolBarCommandButton)object).setEnabled(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void changeLDAPContext() {
        ContextChooser contextChooser;
        block11: {
            block10: {
                block9: {
                    if (!this.validateCurrentSelection()) {
                        return;
                    }
                    contextChooser = null;
                    try {
                        LDAPDataStore lDAPDataStore;
                        contextChooser = new ContextChooser(this.m_app.getFrame(), this.ns.getString("CNTChooseContextTitle"), this.ns.getString("CNTChooseContextMessage"), this.m_ldapDataStore.getAuthType(), this.m_ldapDataStore.getCredentials());
                        NetUtils.centerDialog((Dialog)((Object)contextChooser), this.m_app.getFrame());
                        String string = this.m_ldapDataStore.getOracleContext();
                        string = contextChooser.choose(string);
                        if (string == null) {
                            Object var4_3 = null;
                            if (contextChooser == null) return;
                            break block9;
                        }
                        if (string.equals(this.m_ldapDataStore.getOracleContext())) {
                            break block10;
                        }
                        try {
                            lDAPDataStore = new LDAPDataStore(string);
                        }
                        catch (DataStoreException dataStoreException) {
                            ExceptionMessage.display((Component)((Object)this), "Unable to connect to directory", dataStoreException);
                            dataStoreException.printStackTrace();
                            Object var4_5 = null;
                            if (contextChooser == null) return;
                            contextChooser.dispose();
                            return;
                        }
                        this.m_ldapDataStore = lDAPDataStore;
                        int n = this.allComponents.size() - 1;
                        while (n >= 0) {
                            if (((NetComponent)this.allComponents.elementAt(n)).getDataStore() instanceof LDAPDataStore) {
                                ((NetComponent)this.allComponents.elementAt(n)).refresh(this.m_ldapDataStore);
                            }
                            --n;
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        if (contextChooser == null) throw throwable;
                        contextChooser.dispose();
                        throw throwable;
                    }
                }
                contextChooser.dispose();
                return;
            }
            Object var4_4 = null;
            if (contextChooser == null) return;
            contextChooser.dispose();
            return;
        }
        Object var4_6 = null;
        if (contextChooser == null) return;
        contextChooser.dispose();
    }

    private void launchMigrationWizard() {
        if (!this.validateCurrentSelection()) {
            return;
        }
        if (!this.m_ldapDataStore.isAuthenticated() && !NetUtils.authenticateLDAP(this.m_ldapDataStore, this.ns.getString("CNTAuthTitle"), this.ns.getString("CNTAuthMessage"))) {
            Alert alert = new Alert(this.m_app.getFrame(), this.ns.getString("CNTAuthError"), 0, 1);
            alert.runAlert();
            return;
        }
        NSNMigrationWizard nSNMigrationWizard = new NSNMigrationWizard((BufferedFrame)this.m_app.getFrame(), this.m_fileDataStore, this.m_ldapDataStore.getAuthType(), this.m_ldapDataStore.getCredentials());
        if (nSNMigrationWizard.go() && nSNMigrationWizard.getLastDestinationContext().equalsIgnoreCase(this.m_ldapDataStore.getOracleContext())) {
            int n = this.allComponents.size() - 1;
            while (n >= 0) {
                if (((NetComponent)this.allComponents.elementAt(n)).getDataStore() instanceof LDAPDataStore) {
                    ((NetComponent)this.allComponents.elementAt(n)).refresh(this.m_ldapDataStore);
                }
                --n;
            }
        }
    }

    private String pickDirectory(String string, String string2, String string3) {
        BufferedFrame bufferedFrame = this.myFrame == null ? new BufferedFrame() : this.myFrame;
        this.dirDialog = new DirectoryDialog((Frame)bufferedFrame);
        this.dirDialog.setCenterOver((Component)bufferedFrame);
        this.dirDialog.setCreateAllowed(true);
        this.dirDialog.setTitle(string2);
        this.dirDialog.setMessage(string);
        File file = new File(string3);
        if (!file.isDirectory()) {
            file = new File(File.separator);
        }
        file = this.dirDialog.runDialog(file);
        if (this.isMSWindows && this.myFrame != null) {
            this.myFrame.toFront();
        }
        if (file != null) {
            return file.toString();
        }
        return null;
    }

    private void centerDialog(BufferedFrame bufferedFrame, BufferedDialog bufferedDialog) {
        Rectangle rectangle = bufferedFrame.getBounds();
        Dimension dimension = bufferedDialog.getSize();
        bufferedDialog.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
    }

    private void maybeShowCommentWarning(String string) {
        String string2 = null;
        if (this.netProps != null) {
            string2 = this.netProps.getProperty("CommentWarning");
        }
        if (string2 != null && !string2.equalsIgnoreCase("YES")) {
            return;
        }
        if (string == null) {
            string = "";
        }
        Object[] objectArray = new Object[]{string};
        Alert alert = new Alert((Frame)this.myFrame, this.ns.getString("CNTCommentWarningMsg", objectArray), 1, 1);
        alert.setCenterOver((Component)this.myFrame);
        alert.setTitle(this.ns.getString("CNTCommentWarningTitle"));
        alert.setDefaultButton(1);
        LWCheckbox lWCheckbox = new LWCheckbox(this.ns.getString("CNTCommentWarningShow"), false);
        alert.setExtraComponent((Component)lWCheckbox);
        alert.runAlert();
        if (this.netProps != null) {
            try {
                if (lWCheckbox.getState()) {
                    this.netProps.putProperty("CommentWarning", "NO");
                    this.netProps.save();
                }
            }
            catch (IOException iOException) {
                System.err.println("Error saving CommentWarning to NetProperties");
            }
        }
        alert.dispose();
    }

    private boolean validateCurrentSelection() {
        TreeItem treeItem = null;
        DTreeSelection dTreeSelection = this.getTree().getSelection();
        if (dTreeSelection.getHasSelection()) {
            treeItem = (TreeItem)dTreeSelection.getSelectionRanges().getFirstItem();
            if (dTreeSelection.toggleItem((DTreeItem)treeItem)) {
                dTreeSelection.toggleItem((DTreeItem)treeItem);
                return true;
            }
            return false;
        }
        return true;
    }

    private String readDefaultDomain(FileDataStore fileDataStore) {
        try {
            NLParamParser nLParamParser = new NLParamParser(String.valueOf(fileDataStore.getAdminDir()) + "sqlnet.ora");
            NVPair nVPair = nLParamParser.getNLPListElement("NAMES.DEFAULT_DOMAIN");
            return nVPair.getAtom();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public NetComponent getListenerComponent() {
        return this.lsnrComp;
    }

    public NetComponent getProfileComponent() {
        return this.profileComp;
    }

    public NetComponent getNamesComponent() {
        return this.namesComp;
    }

    public NetComponent getNetServiceNamesComponent() {
        return this.serviceComp;
    }

    public void showHelpContents() {
        NetUtils.getHelpContext().showContents();
    }

    public void showHelpSearch() {
        NetUtils.getHelpContext().showSearch();
    }

    public void showHelpWindows(boolean bl) {
    }

    public void showHelpTopic(String string, String string2) {
        NetUtils.getHelpContext().showTopic(string2);
    }

    public String getAboutMenuText() {
        return this.ns.getString("CNTHelpAbout");
    }

    public void showAboutBox() {
        NetAboutDialog netAboutDialog = new NetAboutDialog(this.myFrame, null, this.tk.getImage(String.valueOf(NetUtils.getImageDirectory()) + "naicon.gif"));
        this.centerDialog(this.myFrame, netAboutDialog);
        ((Dialog)((Object)netAboutDialog)).setModal(true);
        ((Component)((Object)netAboutDialog)).setVisible(true);
        if (this.isMSWindows) {
            this.myFrame.toFront();
        }
    }

    static /* synthetic */ NetStrings access$0(NetContainer netContainer) {
        return netContainer.ns;
    }

    static /* synthetic */ boolean access$1(NetContainer netContainer) {
        return netContainer.ldapEnabled;
    }

    static /* synthetic */ WebApplication access$2(NetContainer netContainer) {
        return netContainer.m_app;
    }

    public class InvisibleDataSource
    extends StaticItemSource {
        private final String treeRoot;

        public InvisibleDataSource(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            NetContainer netContainer2 = NetContainer.this = NetContainer.this;
            this.treeRoot = netContainer2.ns.getString("CNTNetwork");
            this.setSorted(false);
            this.setImageList(new Image[]{Toolkit.getDefaultToolkit().getImage(String.valueOf(NetUtils.getImageDirectory()) + "network.gif")});
        }

        protected DTreeItem internal_createStaticItem(String string, String string2) {
            return new TreeParentNode((TreeDataSource)new RootDataSource(this.getTree()), (TreeProxy)new RootProxy(this.getTree()), "oracle_sysman_netasst_root");
        }

        protected void populateItemList() {
            this.addItem(this.treeRoot, "oracle_sysman_netasst_root");
        }
    }

    class RootDataSource
    extends StaticItemSource {
        private final String localLabel;
        private final String ldapLabel;
        private Image ldapImage;
        private Image localImage;
        private Image namesImage;

        public RootDataSource(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            NetContainer.this = NetContainer.this;
            Object object = NetContainer.this;
            this.localLabel = ((NetContainer)((Object)object)).ns.getString("CNTLocalTree");
            object = NetContainer.this;
            this.ldapLabel = ((NetContainer)((Object)object)).ns.getString("CNTDirectoryTree");
            this.setSorted(false);
            object = Toolkit.getDefaultToolkit();
            this.ldapImage = ((Toolkit)object).getImage(String.valueOf(NetUtils.getImageDirectory()) + "LDAPFolder.gif");
            this.localImage = ((Toolkit)object).getImage(String.valueOf(NetUtils.getImageDirectory()) + "LocalFolder.gif");
            this.namesImage = ((Toolkit)object).getImage(String.valueOf(NetUtils.getImageDirectory()) + "ONamesParent.gif");
        }

        protected DTreeItem internal_createStaticItem(String string, String string2) {
            if (string2 == "oracle_sysman_netasst_ldap_tree") {
                return new TreeParentNode((TreeDataSource)new LDAPTreeDataSource(this.getTree()), (TreeProxy)new LDAPTreeProxy(this.getTree()), string2);
            }
            if (string2 == "oracle_sysman_netasst_local_tree") {
                return new TreeParentNode((TreeDataSource)new LocalTreeDataSource(this.getTree()), (TreeProxy)new LocalTreeProxy(this.getTree()), string2);
            }
            if (string2 == "oracle_sysman_netasst_names_comp") {
                return NetContainer.this.namesComp.getTreeNode(this.getTree());
            }
            return null;
        }

        protected void populateItemList() {
            NetContainer netContainer = NetContainer.this;
            if (netContainer.ldapEnabled) {
                this.addItem(this.ldapLabel, "oracle_sysman_netasst_ldap_tree");
            }
            this.addItem(this.localLabel, "oracle_sysman_netasst_local_tree");
            if (NetContainer.this.namesComp != null) {
                this.addItem(NetContainer.this.namesComp.toString(), "oracle_sysman_netasst_names_comp");
            }
        }

        protected Image getImage(int n) {
            String string = this.getType(n);
            if (string == "oracle_sysman_netasst_ldap_tree") {
                return this.ldapImage;
            }
            if (string == "oracle_sysman_netasst_local_tree") {
                return this.localImage;
            }
            if (string == "oracle_sysman_netasst_names_comp") {
                return this.namesImage;
            }
            return null;
        }
    }

    class RootProxy
    extends TreeProxy
    implements TreeNodeSelectionListener {
        private NetPanel rootPanel;

        public RootProxy(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            NetContainer.this = NetContainer.this;
            String string = NetContainer.this.ns.getString("CNTIntroMessage");
            this.rootPanel = new NetPanel(NetContainer.this.m_app, "NA_placebo.gif", string);
        }

        public void treeSelectionChanging(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
        }

        public void treeSelectionChanged(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            NetContainer.this.getTreeDetail().showComponent((Component)((Object)this.rootPanel));
        }
    }

    class LocalTreeDataSource
    extends StaticItemSource {
        private Image profImage;
        private Image snImage;
        private Image lsnrImage;

        public LocalTreeDataSource(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            NetContainer.this = NetContainer.this;
            this.setSorted(false);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.profImage = toolkit.getImage(String.valueOf(NetUtils.getImageDirectory()) + "profile.gif");
            this.snImage = toolkit.getImage(String.valueOf(NetUtils.getImageDirectory()) + "ServiceParent.gif");
            this.lsnrImage = toolkit.getImage(String.valueOf(NetUtils.getImageDirectory()) + "ListenerParent.gif");
        }

        protected Image getImage(int n) {
            String string = this.getType(n);
            if (string == "oracle_sysman_netasst_profile_comp") {
                return this.profImage;
            }
            if (string == "oracle_sysman_netasst_sn_comp") {
                return this.snImage;
            }
            if (string == "oracle_sysman_netasst_lsnr_comp") {
                return this.lsnrImage;
            }
            return null;
        }

        protected DTreeItem internal_createStaticItem(String string, String string2) {
            if (string2 == "oracle_sysman_netasst_profile_comp") {
                return NetContainer.this.profileComp.getTreeNode(this.getTree());
            }
            if (string2 == "oracle_sysman_netasst_sn_comp") {
                return NetContainer.this.serviceComp.getTreeNode(this.getTree());
            }
            if (string2 == "oracle_sysman_netasst_lsnr_comp") {
                return NetContainer.this.lsnrComp.getTreeNode(this.getTree());
            }
            return null;
        }

        protected void populateItemList() {
            this.addItem(NetContainer.this.profileComp.toString(), "oracle_sysman_netasst_profile_comp");
            this.addItem(NetContainer.this.serviceComp.toString(), "oracle_sysman_netasst_sn_comp");
            this.addItem(NetContainer.this.lsnrComp.toString(), "oracle_sysman_netasst_lsnr_comp");
        }
    }

    class LocalTreeProxy
    extends TreeProxy
    implements TreeNodeSelectionListener {
        private NetPanel localPanel;

        public LocalTreeProxy(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            NetContainer.this = NetContainer.this;
            this.localPanel = new NetPanel(NetContainer.this.m_app, "Local_placebo.gif", NetContainer.this.ns.getString("CNTLocalIntroMessage"));
        }

        public void treeSelectionChanging(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
        }

        public void treeSelectionChanged(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            NetContainer.this.getTreeDetail().showComponent((Component)((Object)this.localPanel));
        }
    }

    class LDAPTreeDataSource
    extends StaticItemSource {
        Image image;

        public LDAPTreeDataSource(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            NetContainer.this = NetContainer.this;
            this.setSorted(false);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.image = toolkit.getImage(String.valueOf(NetUtils.getImageDirectory()) + "ServiceParent.gif");
        }

        protected Image getImage(int n) {
            return this.image;
        }

        protected DTreeItem internal_createStaticItem(String string, String string2) {
            if (string2 == "oracle_sysman_netasst_sn_comp") {
                return NetContainer.this.LDAPserviceComp.getTreeNode(this.getTree());
            }
            return null;
        }

        protected void populateItemList() {
            this.addItem(NetContainer.this.LDAPserviceComp.toString(), "oracle_sysman_netasst_sn_comp");
        }
    }

    class LDAPTreeProxy
    extends TreeProxy
    implements TreeNodeSelectionListener {
        private NetPanel ldapPanel;

        public LDAPTreeProxy(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            NetContainer.this = NetContainer.this;
            this.ldapPanel = new NetPanel(NetContainer.this.m_app, "LDAP_placebo.gif", NetContainer.this.ns.getString("CNTLDAPIntroMessage"));
        }

        public void treeSelectionChanging(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
        }

        public void treeSelectionChanged(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            NetContainer.this.getTreeDetail().showComponent((Component)((Object)this.ldapPanel));
        }
    }
}

