/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.container;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.ewt.alert.Alert;
import oracle.net.asst.container.CredentialDialog;
import oracle.net.asst.container.ExceptionMessage;
import oracle.net.asst.container.NetApplication;
import oracle.net.asst.container.NetContainer;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.common.NetGetEnv;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.LDAPDataStore;

public class NetUtils {
    public static final char SEP = File.separatorChar;
    private static String imageDirString = null;
    private static NetHelp helpContext;
    private static NetApplication application;
    private static NetContainer container;
    private static String defaultDomain;

    public static final String getDefaultDomain() {
        if (defaultDomain == null) {
            return "";
        }
        return defaultDomain;
    }

    public static final void setDefaultDomain(String string) {
        defaultDomain = string;
    }

    public static final void setHelpContext(NetHelp netHelp) {
        helpContext = netHelp;
    }

    public static final NetHelp getHelpContext() {
        return helpContext;
    }

    public static final void setApplication(NetApplication netApplication) {
        application = netApplication;
    }

    public static final NetApplication getApplication() {
        return application;
    }

    public static final void setContainer(NetContainer netContainer) {
        container = netContainer;
    }

    public static final NetContainer getContainer() {
        return container;
    }

    public static boolean authenticateLDAP(LDAPDataStore lDAPDataStore, String string, String string2) {
        if (System.getProperty("os.name").startsWith("Windows") && lDAPDataStore.getDirectoryType().toUpperCase().startsWith("AD")) {
            try {
                lDAPDataStore.setAuthInfo(8, null);
                return true;
            }
            catch (DataStoreException dataStoreException) {}
        }
        try {
            lDAPDataStore.setAuthInfo(7, null);
            return true;
        }
        catch (DataStoreException dataStoreException) {
            NetStrings netStrings = new NetStrings();
            CredentialDialog credentialDialog = new CredentialDialog(application.getFrame(), string, string2);
            NetUtils.centerDialog((Dialog)((Object)credentialDialog), application.getFrame());
            while (credentialDialog.run()) {
                String[] stringArray = credentialDialog.getCredentials();
                if (stringArray[0] == null || stringArray[0].equals("")) {
                    Alert alert = new Alert(application.getFrame(), netStrings.getString("nnaUserNull"), 0, 1);
                    alert.setTitle(netStrings.getString("nnaError"));
                    alert.runAlert();
                    alert.dispose();
                    continue;
                }
                try {
                    lDAPDataStore.setAuthInfo(credentialDialog.getType(), stringArray);
                    return true;
                }
                catch (DataStoreException dataStoreException2) {
                    ExceptionMessage.display((Component)((Object)credentialDialog), netStrings.getString("CNTAuthError"), dataStoreException2);
                }
            }
            return false;
        }
    }

    public static String getImageDirectory() {
        if (imageDirString == null) {
            String string = NetGetEnv.getOracleHome();
            imageDirString = String.valueOf(NetUtils.formatDirectoryString(string)) + "network" + SEP + "tools" + SEP + "images" + SEP;
        }
        return imageDirString;
    }

    public static boolean isSameHost(String string, String string2) throws UnknownHostException {
        try {
            String string3;
            String string4;
            InetAddress inetAddress;
            if (string == null) {
                inetAddress = InetAddress.getLocalHost();
                string4 = inetAddress.getHostName();
            } else {
                string4 = string;
            }
            String string5 = InetAddress.getByName(string4).getHostAddress();
            if (string2 == null) {
                inetAddress = InetAddress.getLocalHost();
                string3 = inetAddress.getHostName();
            } else {
                string3 = string2;
            }
            String string6 = InetAddress.getByName(string3).getHostAddress();
            return string5.equals(string6);
        }
        catch (Exception exception) {
            if (exception instanceof UnknownHostException) {
                throw (UnknownHostException)exception;
            }
            System.err.println(exception);
            return false;
        }
    }

    public static String formatDirectoryString(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) != SEP) break;
            --n;
        }
        return String.valueOf(string.substring(0, n + 1)) + SEP;
    }

    public static void centerDialog(Dialog dialog, Component component) {
        Rectangle rectangle = application.getFrame().getBounds();
        Dimension dimension = dialog.getSize();
        ((Component)dialog).setLocation(rectangle.x + rectangle.width / 2 - dimension.width / 2, rectangle.y + rectangle.height / 2 - dimension.height / 2);
    }

    public static void centerDialogOnScreen(Dialog dialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = dialog.getSize();
        ((Component)dialog).setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
    }

    static {
        defaultDomain = null;
    }
}

