/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import oracle.ewt.EwtContainer;
import oracle.ewt.alert.Alert;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.spinBox.SpinBoxEvent;
import oracle.ewt.spinBox.SpinBoxListener;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.container.NetValidate;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.asst.listener.ListenerPrespawnDesc;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class ListenerDBServicePage
extends EwtContainer
implements ItemListener,
ActionListener,
SpinBoxListener,
KeyListener {
    private int initialMax;
    private int totalPrespawns;
    private int totalPrespawnsBak;
    private int tcpPs;
    private int tcpTo;
    private int spxPs;
    private int spxTo;
    private int nmpPs;
    private int nmpTo;
    private int ipcPs;
    private int ipcTo;
    private boolean changed = false;
    private LWCheckbox usePrespawnsBox;
    private LWCheckbox dontUsePrespawnsBox;
    private LWCheckboxGroup usePrespawnsGroup;
    private LWButton configPrespawnsButton;
    private EwtContainer configPrespawnPanel;
    private EwtContainer prespawnPanel;
    private BufferedDialog configPrespawnDialog;
    private EwtContainer psButtonPanel;
    private LWButton psOkButton;
    private LWButton psCancelButton;
    private LWButton psHelpButton;
    private ListenerPrespawnDesc tcpDesc;
    private ListenerPrespawnDesc spxDesc;
    private ListenerPrespawnDesc nmpDesc;
    private ListenerPrespawnDesc ipcDesc;
    private LWLabel prespawnHintA;
    private LWLabel prespawnHintB;
    private LWLabel prespawnHintC;
    private LWTextField globalNameField;
    private LWTextField oraHomeField;
    private LWTextField sidField;
    private LWTextField prespawnMaxField;
    private LWLabel globalDBNameLabel;
    private LWLabel oraHomeLabel;
    private LWLabel sidLabel;
    private LWLabel maxPrespawnLabel;
    private NetValidate netValidate;
    private LWTextField invalidField;
    private NetStrings ns = ListenerGeneric.getNS();
    private String name;
    private String usePrespawnsString;
    private String dontUsePrespawnsString;
    private String configPrespawnsString;
    private String prespawnMaxBak;
    private String psOkString;
    private String psCancelString;
    private String psHelpString;
    private String invalidString;
    private String prespawnHelpTopic = "TOPIClsnrPrespawnServers";
    private boolean dialogCancelled = false;
    private boolean warnedUnsupportedPlatform = false;

    public ListenerDBServicePage(NVPair nVPair) {
        this.buildUI();
        this.buildPrespawnDialog();
        this.netValidate = new NetValidate((BufferedFrame)ListenerGeneric.getApp().getFrame());
        boolean bl = false;
        if (nVPair == null) {
            String string = NetUtils.getDefaultDomain();
            if (string != "") {
                string = "." + string;
            }
            this.globalNameField.setText("Oracle8" + string);
            this.sidField.setText("ORCL");
            String string2 = System.getProperty("os.name");
            if (string2.startsWith("Windows")) {
                this.oraHomeField.setText("");
            } else {
                this.oraHomeField.setText(ListenerGeneric.getOraHome());
            }
        } else {
            NVNavigator nVNavigator = new NVNavigator();
            NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "GLOBAL_DBNAME");
            this.globalNameField.setText(nVPair2 == null ? "" : nVPair2.getAtom());
            nVPair2 = nVNavigator.findNVPair(nVPair, "SID_NAME");
            this.sidField.setText(nVPair2 == null ? "" : nVPair2.getAtom());
            nVPair2 = nVNavigator.findNVPair(nVPair, "ORACLE_HOME");
            this.oraHomeField.setText(nVPair2 == null ? "" : nVPair2.getAtom());
            nVPair2 = nVNavigator.findNVPair(nVPair, "PRESPAWN_MAX");
            if (nVPair2 != null) {
                String string = nVPair2.getAtom();
                nVPair2 = nVNavigator.findNVPair(nVPair, "PRESPAWN_LIST");
                if (nVPair2 == null) {
                    NVPair nVPair3 = nVNavigator.findNVPair(nVPair, "PRESPAWN_DESC");
                    NVPair nVPair4 = nVNavigator.findNVPair(nVPair3, "PROTOCOL");
                    if (nVPair4 != null) {
                        NVPair nVPair5 = nVNavigator.findNVPair(nVPair3, "POOL_SIZE");
                        NVPair nVPair6 = nVNavigator.findNVPair(nVPair3, "TIMEOUT");
                        try {
                            this.setPrespawnFields(nVPair4.getAtom(), nVPair5 == null ? "0" : nVPair5.getAtom(), nVPair6 == null ? "0" : nVPair6.getAtom());
                            bl = true;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            System.err.println(illegalArgumentException);
                        }
                    }
                } else {
                    int n = 0;
                    while (n < nVPair2.getListSize()) {
                        NVPair nVPair7 = nVPair2.getListElement(n);
                        NVPair nVPair8 = nVNavigator.findNVPair(nVPair7, "PROTOCOL");
                        if (nVPair8 != null) {
                            NVPair nVPair9 = nVNavigator.findNVPair(nVPair7, "POOL_SIZE");
                            NVPair nVPair10 = nVNavigator.findNVPair(nVPair7, "TIMEOUT");
                            try {
                                this.setPrespawnFields(nVPair8.getAtom(), nVPair9 == null ? "0" : nVPair9.getAtom(), nVPair10 == null ? "0" : nVPair10.getAtom());
                                bl = true;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                System.err.println(illegalArgumentException);
                            }
                        }
                        ++n;
                    }
                }
                if (bl) {
                    this.prespawnMaxField.setText(string);
                }
            }
        }
        this.usePrespawnsBox.setState(bl);
        this.configPrespawnsButton.setEnabled(bl);
        this.totalPrespawns = this.getPrespawnTotal();
        this.backupPrespawnConfig();
    }

    private void buildUI() {
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.globalDBNameLabel = new LWLabel(this.ns.getString("LCCGlobalDBName"));
        this.globalNameField = new LWTextField(25);
        this.oraHomeField = new LWTextField(25);
        this.sidField = new LWTextField(25);
        this.globalNameField.addKeyListener(this);
        this.oraHomeField.addKeyListener(this);
        this.sidField.addKeyListener(this);
        this.oraHomeLabel = new LWLabel(this.ns.getString("LCCOracleHomeDir"));
        this.sidLabel = new LWLabel(this.ns.getString("LCCSID"));
        this.usePrespawnsString = new String(this.ns.getString("LCCUsePrespawns"));
        this.dontUsePrespawnsString = new String(this.ns.getString("LCCDontUsePrespawns"));
        this.configPrespawnsString = new String(this.ns.getString("LCCConfigurePrespawns"));
        this.usePrespawnsGroup = new LWCheckboxGroup();
        this.usePrespawnsBox = new LWCheckbox(this.usePrespawnsString, this.usePrespawnsGroup, false);
        this.usePrespawnsBox.addItemListener((ItemListener)this);
        this.dontUsePrespawnsBox = new LWCheckbox(this.dontUsePrespawnsString, this.usePrespawnsGroup, true);
        this.dontUsePrespawnsBox.addItemListener((ItemListener)this);
        this.configPrespawnPanel = new EwtContainer();
        this.configPrespawnPanel.setBorder((Border)new GroupBoxBorder("", InsetFramePainter.getFramePainter(), 2));
        this.configPrespawnPanel.setLayout(new GridBagLayout());
        this.configPrespawnsButton = new LWButton(this.configPrespawnsString);
        this.configPrespawnsButton.addActionListener((ActionListener)this);
        EwtContainer ewtContainer = this.configPrespawnPanel;
        LWButton lWButton = this.configPrespawnsButton;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)lWButton, 0, 0, 1, 1, 1, 18, 0.0, 0.0, 15, 10, 15, 10);
        ewtContainer = this;
        lWButton = this.globalDBNameLabel;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)lWButton, 0, 0, 1, 1, 0, 18, 0.0, 0.0, 10, 10, 0, 0);
        ewtContainer = this;
        lWButton = this.globalNameField;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)lWButton, 1, 0, 1, 1, 0, 18, 0.0, 0.0, 10, 0, 0, 10);
        ewtContainer = this;
        lWButton = this.oraHomeLabel;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)lWButton, 0, 1, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 0, 0);
        ewtContainer = this;
        lWButton = this.oraHomeField;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)lWButton, 1, 1, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 10);
        ewtContainer = this;
        lWButton = this.sidLabel;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)lWButton, 0, 2, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 0, 0);
        ewtContainer = this;
        lWButton = this.sidField;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)lWButton, 1, 2, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 10);
        ewtContainer = this;
        lWButton = this.dontUsePrespawnsBox;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)lWButton, 0, 3, 0, 1, 0, 18, 0.0, 0.0, 10, 15, 0, 10);
        ewtContainer = this;
        lWButton = this.usePrespawnsBox;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)lWButton, 0, 4, 0, 1, 0, 18, 0.0, 0.0, 0, 15, 0, 10);
        ewtContainer = this;
        lWButton = this.configPrespawnPanel;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)lWButton, 0, 4, 2, 1, 1, 18, 0.0, 0.0, 0, 10, 0, 10);
        ListenerGeneric.constrain((Container)((Object)this), (Component)new LWLabel(" "), 0, 5, 1, 1, 1, 18, 100.0, 100.0, 0, 0, 0, 0);
    }

    private void buildPrespawnDialog() {
        this.configPrespawnDialog = new BufferedDialog(ListenerGeneric.getApp().getFrame(), this.configPrespawnsString, false);
        this.maxPrespawnLabel = new LWLabel(this.ns.getString("LCCMaxPrespawns"));
        this.prespawnMaxField = new LWTextField(4);
        this.prespawnMaxField.addKeyListener(this);
        this.prespawnPanel = new EwtContainer();
        this.prespawnPanel.setLayout(new GridBagLayout());
        this.prespawnHintA = new LWLabel(this.ns.getString("LCCPrespawnHintA"));
        this.prespawnHintB = new LWLabel(this.ns.getString("LCCPrespawnHintB"));
        this.prespawnHintC = new LWLabel(this.ns.getString("LCCPrespawnHintC"));
        ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)this.prespawnHintA, 0, 0, 2, 1, 0, 10, 1.0, 0.0, 20, 10, 0, 0);
        ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)this.prespawnHintB, 0, 1, 2, 1, 0, 10, 1.0, 0.0, 0, 10, 0, 0);
        ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)this.prespawnHintC, 0, 2, 2, 1, 0, 10, 1.0, 0.0, 0, 10, 20, 0);
        if (ListenerGeneric.isTCPAllowed()) {
            this.tcpDesc = new ListenerPrespawnDesc("TCP", 0, 0);
            this.tcpDesc.setListener(this);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)new LWLabel(this.ns.getString("SNCTCP")), 0, 3, 1, 1, 0, 13, 1.0, 0.0, 0, 10, 5, 0);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)((Object)this.tcpDesc), 1, 3, 1, 1, 0, 17, 1.0, 0.0, 0, 10, 5, 0);
        }
        if (ListenerGeneric.isSPXAllowed()) {
            this.spxDesc = new ListenerPrespawnDesc("SPX", 0, 0);
            this.spxDesc.setListener(this);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)new LWLabel(this.ns.getString("SNCSPX")), 0, 4, 1, 1, 0, 13, 1.0, 0.0, 0, 10, 5, 0);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)((Object)this.spxDesc), 1, 4, 1, 1, 0, 17, 1.0, 0.0, 0, 10, 5, 0);
        }
        if (ListenerGeneric.isNMPAllowed()) {
            this.nmpDesc = new ListenerPrespawnDesc("NMP", 0, 0);
            this.nmpDesc.setListener(this);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)new LWLabel(this.ns.getString("SNCNMP")), 0, 5, 1, 1, 0, 13, 1.0, 0.0, 0, 10, 5, 0);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)((Object)this.nmpDesc), 1, 5, 1, 1, 0, 17, 1.0, 0.0, 0, 10, 5, 0);
        }
        if (ListenerGeneric.isIPCAllowed()) {
            this.ipcDesc = new ListenerPrespawnDesc("IPC", 0, 0);
            this.ipcDesc.setListener(this);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)new LWLabel(this.ns.getString("SNCIPC")), 0, 6, 1, 1, 0, 13, 1.0, 0.0, 0, 10, 10, 0);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)((Object)this.ipcDesc), 1, 6, 1, 1, 0, 17, 1.0, 0.0, 0, 10, 10, 0);
        }
        EwtContainer ewtContainer = new EwtContainer();
        ewtContainer.setLayout(new GridBagLayout());
        ListenerGeneric.constrain((Container)ewtContainer, (Component)this.maxPrespawnLabel, 0, 0, 1, 1, 0, 13, 1.0, 0.0, 0, 0, 0, 0);
        ListenerGeneric.constrain((Container)ewtContainer, (Component)this.prespawnMaxField, 1, 0, 1, 1, 0, 17, 1.0, 0.0, 0, 5, 0, 0);
        ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)ewtContainer, 0, 7, 2, 1, 0, 11, 1.0, 0.0, 10, 10, 10, 0);
        this.psOkString = new String(" " + this.ns.getString("LCCOK") + " ");
        this.psCancelString = new String(this.ns.getString("LCCCancel"));
        this.psHelpString = new String(this.ns.getString("LCCHelp"));
        this.psOkButton = new LWButton(this.psOkString);
        this.psCancelButton = new LWButton(this.psCancelString);
        this.psHelpButton = new LWButton(this.psHelpString);
        this.psOkButton.addActionListener((ActionListener)this);
        this.psCancelButton.addActionListener((ActionListener)this);
        this.psHelpButton.addActionListener((ActionListener)this);
        this.psButtonPanel = new EwtContainer();
        this.psButtonPanel.add((Component)this.psOkButton);
        this.psButtonPanel.add((Component)this.psCancelButton);
        this.psButtonPanel.add((Component)this.psHelpButton);
        ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)this.psButtonPanel, 0, 8, 2, 1, 0, 15, 1.0, 1.0, 0, 0, 15, 0);
        this.configPrespawnDialog.add((Component)this.prespawnPanel, "Center");
        this.configPrespawnDialog.setSize(420, 360);
        Dimension dimension = ListenerGeneric.getApp().getFrame().getToolkit().getScreenSize();
        Dimension dimension2 = this.configPrespawnDialog.getSize();
        this.configPrespawnDialog.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public void addNotify() {
        super.addNotify();
        this.usePrespawnsBox.setBackground(this.usePrespawnsBox.getBackground());
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        char c = keyEvent.getKeyChar();
        this.changed = true;
        if (object == this.prespawnMaxField) {
            if (Character.isDigit(c) || c == '\b') {
                return;
            }
        } else if (object == this.sidField) {
            if (Character.isLetterOrDigit(c) || c == '\b' || c == '_') {
                return;
            }
        } else {
            return;
        }
        keyEvent.setKeyChar('\u0000');
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.configPrespawnsString)) {
            this.backupPrespawnConfig();
            this.configPrespawnDialog.setModal(true);
            this.configPrespawnDialog.show();
        }
        if (string.equals(this.psOkString) && this.validatePrespawnDialog()) {
            this.dialogCancelled = false;
            this.configPrespawnDialog.dispose();
        }
        if (string.equals(this.psCancelString)) {
            this.dialogCancelled = true;
            this.configPrespawnDialog.dispose();
            this.restorePrespawnConfig();
        }
        if (string.equals(this.psHelpString)) {
            ListenerGeneric.getHelp().showTopic(this.prespawnHelpTopic);
        }
    }

    private boolean validatePrespawnDialog() {
        int n = 0;
        int n2 = this.getPrespawnTotal();
        try {
            n = Integer.parseInt(this.prespawnMaxField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.prespawnMaxField.setText("");
        }
        if (n > 0 && n2 == 0 && !this.prespawnMaxField.getText().equals("")) {
            this.invalidField = this.prespawnMaxField;
            this.invalidString = this.maxPrespawnLabel.getText();
            this.setFocus();
            return false;
        }
        if (n2 > 0 && !this.netValidate.validateNumber(this.prespawnMaxField, n2, 999)) {
            this.invalidField = this.prespawnMaxField;
            this.invalidString = this.maxPrespawnLabel.getText();
            this.setFocus();
            return false;
        }
        return true;
    }

    private void backupPrespawnConfig() {
        if (this.tcpDesc != null) {
            this.tcpPs = this.tcpDesc.getPoolSize();
            this.tcpTo = this.tcpDesc.getTimeout();
        }
        if (this.spxDesc != null) {
            this.spxPs = this.spxDesc.getPoolSize();
            this.spxTo = this.spxDesc.getTimeout();
        }
        if (this.nmpDesc != null) {
            this.nmpPs = this.nmpDesc.getPoolSize();
            this.nmpTo = this.nmpDesc.getTimeout();
        }
        if (this.ipcDesc != null) {
            this.ipcPs = this.ipcDesc.getPoolSize();
            this.ipcTo = this.ipcDesc.getTimeout();
        }
        this.prespawnMaxBak = this.prespawnMaxField.getText();
        this.totalPrespawnsBak = this.totalPrespawns;
    }

    private void restorePrespawnConfig() {
        if (this.tcpDesc != null) {
            this.tcpDesc.setFields(this.tcpPs, this.tcpTo);
        }
        if (this.spxDesc != null) {
            this.spxDesc.setFields(this.spxPs, this.spxTo);
        }
        if (this.nmpDesc != null) {
            this.nmpDesc.setFields(this.nmpPs, this.nmpTo);
        }
        if (this.ipcDesc != null) {
            this.ipcDesc.setFields(this.ipcPs, this.ipcTo);
        }
        this.prespawnMaxField.setText(this.prespawnMaxBak);
        this.totalPrespawns = this.totalPrespawnsBak;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        this.changed = true;
        if (itemEvent.getSource() == this.usePrespawnsBox) {
            if (!this.warnedUnsupportedPlatform && System.getProperty("os.name").startsWith("Windows")) {
                this.warnedUnsupportedPlatform = true;
                Alert alert = new Alert(ListenerGeneric.getApp().getFrame(), this.ns.getString("LCCPrespawnsNotAvailable"), 1, 3);
                alert.setTitle(this.ns.getString("nnaWarning"));
                if (alert.runAlert() == 2) {
                    return;
                }
            }
            this.configPrespawnsButton.setEnabled(true);
            this.backupPrespawnConfig();
            this.configPrespawnDialog.setModal(true);
            this.configPrespawnDialog.show();
            return;
        }
        this.configPrespawnsButton.setEnabled(false);
    }

    public void spinBoxValueChanged(SpinBoxEvent spinBoxEvent) {
        boolean bl;
        int n = 0;
        int n2 = 0;
        int n3 = this.totalPrespawns;
        this.changed = true;
        this.totalPrespawns = this.getPrespawnTotal();
        boolean bl2 = this.totalPrespawns > n3;
        try {
            n = Integer.parseInt(this.prespawnMaxField.getText());
            bl = false;
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (bl) {
            n2 = this.totalPrespawns * 2;
        } else {
            if (n3 <= n && bl2) {
                n2 = n + 2;
            }
            if (n3 > n && bl2) {
                n2 = this.totalPrespawns;
            }
            if (n3 >= n && !bl2) {
                n2 = this.totalPrespawns;
            }
            if (n3 < n && !bl2) {
                n2 = n - 2;
            }
        }
        this.prespawnMaxField.setText(String.valueOf(n2));
    }

    private void setPrespawnFields(String string, String string2, String string3) throws IllegalArgumentException {
        block10: {
            try {
                if (string.equalsIgnoreCase("TCP")) {
                    if (this.tcpDesc != null) {
                        this.tcpDesc.setFields(string2, string3);
                        return;
                    }
                    break block10;
                }
                if (string.equalsIgnoreCase("SPX")) {
                    if (this.spxDesc != null) {
                        this.spxDesc.setFields(string2, string3);
                        return;
                    }
                    break block10;
                }
                if (string.equalsIgnoreCase("NMP")) {
                    if (this.nmpDesc != null) {
                        this.nmpDesc.setFields(string2, string3);
                        return;
                    }
                    break block10;
                }
                if (string.equalsIgnoreCase("IPC")) {
                    if (this.ipcDesc != null) {
                        this.ipcDesc.setFields(string2, string3);
                        return;
                    }
                    break block10;
                }
                throw new IllegalArgumentException("Invalid protocol");
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error setting prespawn description fields: " + exception);
            }
        }
    }

    private int getPrespawnTotal() {
        int n = 0;
        if (this.tcpDesc != null) {
            n += this.tcpDesc.getPoolSize();
        }
        if (this.spxDesc != null) {
            n += this.spxDesc.getPoolSize();
        }
        if (this.nmpDesc != null) {
            n += this.nmpDesc.getPoolSize();
        }
        if (this.ipcDesc != null) {
            n += this.ipcDesc.getPoolSize();
        }
        return n;
    }

    public String toString() {
        String string = this.oraHomeField.getText();
        if (string.length() > 0 && string.charAt(string.length() - 1) == File.separatorChar) {
            string = string.substring(0, string.length() - 1);
        }
        String string2 = new String();
        string2 = String.valueOf(string2) + "(SID_DESC=(GLOBAL_DBNAME=" + this.globalNameField.getText() + ")" + "(ORACLE_HOME=" + string + ")" + "(SID_NAME=" + this.sidField.getText() + ")";
        if (this.usePrespawnsBox.getState()) {
            string2 = String.valueOf(string2) + "(PRESPAWN_MAX=" + this.prespawnMaxField.getText() + ")";
            string2 = String.valueOf(string2) + "(PRESPAWN_LIST=";
            if (this.tcpDesc != null && this.tcpDesc.getPoolSize() > 0) {
                string2 = String.valueOf(string2) + this.tcpDesc.toString();
            }
            if (this.spxDesc != null && this.spxDesc.getPoolSize() > 0) {
                string2 = String.valueOf(string2) + this.spxDesc.toString();
            }
            if (this.nmpDesc != null && this.nmpDesc.getPoolSize() > 0) {
                string2 = String.valueOf(string2) + this.nmpDesc.toString();
            }
            if (this.ipcDesc != null && this.ipcDesc.getPoolSize() > 0) {
                string2 = String.valueOf(string2) + this.ipcDesc.toString();
            }
            string2 = String.valueOf(string2) + ")";
        }
        string2 = String.valueOf(string2) + ")";
        return string2;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public void setFocus() {
        if (this.invalidField == this.prespawnMaxField) {
            BufferedFrame bufferedFrame = (BufferedFrame)ListenerGeneric.getApp().getFrame();
            Object[] objectArray = new String[]{"Prespawn Max", "", ""};
            Alert alert = new Alert((Frame)bufferedFrame, this.ns.getString("LCCMaxPrespawnsHint", objectArray), 0, 1);
            alert.setTitle(this.ns.getString("CNTRangeErrorMsg"));
            alert.setCenterOver((Component)bufferedFrame);
            alert.runAlert();
            alert.dispose();
            return;
        }
        this.netValidate.showDialog(this.invalidString);
        this.invalidField.requestFocus();
        this.invalidField.selectAll();
    }

    public boolean areDataValid() {
        if (this.globalNameField.getText().length() != 0 && !this.netValidate.validateHostName(this.globalNameField)) {
            this.invalidField = this.globalNameField;
            this.invalidString = this.globalDBNameLabel.getText();
            this.setFocus();
            return false;
        }
        if (!NetValidate.validateSID(this.sidField.getText())) {
            this.invalidField = this.sidField;
            this.invalidString = this.sidLabel.getText();
            this.setFocus();
            return false;
        }
        if (this.usePrespawnsBox.getState() && !this.validatePrespawnDialog()) {
            this.invalidField = this.prespawnMaxField;
            this.invalidString = this.maxPrespawnLabel.getText();
            this.setFocus();
            return false;
        }
        return true;
    }

    private void showPrespawnDialog() {
        this.backupPrespawnConfig();
        this.configPrespawnDialog.setModal(true);
        this.configPrespawnDialog.show();
    }

    public void setListenerName(String string) {
        this.name = string;
    }
}

