/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.common.NetGetEnv;
import oracle.net.common.NetProperties;
import oracle.net.nl.NLParamParser;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class ListenerGeneric {
    private static NetProperties netProperty = null;
    private static boolean trace;
    private static boolean tcpOk;
    private static boolean spxOk;
    private static boolean nmpOk;
    private static boolean ipcOk;
    private static String oraHome;
    private static WebApplication app;
    private static NLParamParser nlpa;
    private static NetStrings ns;
    private static NetHelp help;
    private static boolean allowInvalid;

    public static void setTrace() {
        if (trace) {
            System.out.println("setTrace():");
        }
        try {
            netProperty = NetProperties.getInstance();
            String string = netProperty.getProperty("ListenerTrace");
            if (string != null && string.equalsIgnoreCase("on")) {
                trace = true;
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("ListenerGeneric:setTrace(): " + fileNotFoundException);
            return;
        }
        catch (IOException iOException) {
            System.err.println("ListenerGeneric:setTrace(): " + iOException);
        }
    }

    public static void devTrc(String string) {
        if (trace) {
            System.out.println(string);
        }
    }

    public static void setNLP(NLParamParser nLParamParser) {
        nlpa = nLParamParser;
    }

    public static NLParamParser getNLP() {
        return nlpa;
    }

    public static void setApp(WebApplication webApplication) {
        app = webApplication;
    }

    public static WebApplication getApp() {
        return app;
    }

    public static void setHelp(NetHelp netHelp) {
        help = netHelp;
    }

    public static NetHelp getHelp() {
        return help;
    }

    public static NetStrings getNS() {
        return ns;
    }

    public static void setAllowInvalid(boolean bl) {
        allowInvalid = bl;
    }

    public static boolean allowInvalid() {
        return allowInvalid;
    }

    public static boolean isTCPAllowed() {
        try {
            String string;
            if (netProperty == null) {
                netProperty = NetProperties.getInstance();
            }
            if ((string = netProperty.getProperty("TCP")) != null && string.equalsIgnoreCase("yes")) {
                tcpOk = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("ListenerGeneric:isTCPAllowed(): " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.err.println("ListenerGeneric:isTCPAllowed(): " + iOException);
        }
        return tcpOk;
    }

    public static boolean isSPXAllowed() {
        try {
            String string;
            if (netProperty == null) {
                netProperty = NetProperties.getInstance();
            }
            if ((string = netProperty.getProperty("SPX")) != null && string.equalsIgnoreCase("yes")) {
                spxOk = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("ListenerGeneric:isSPXAllowed(): " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.err.println("ListenerGeneric:isSPXAllowed(): " + iOException);
        }
        return tcpOk;
    }

    public static boolean isNMPAllowed() {
        try {
            String string;
            if (netProperty == null) {
                netProperty = NetProperties.getInstance();
            }
            if ((string = netProperty.getProperty("NMP")) != null && string.equalsIgnoreCase("yes")) {
                nmpOk = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("ListenerGeneric:isNMPAllowed(): " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.err.println("ListenerGeneric:isNMPAllowed(): " + iOException);
        }
        return nmpOk;
    }

    public static boolean isIPCAllowed() {
        try {
            String string;
            if (netProperty == null) {
                netProperty = NetProperties.getInstance();
            }
            if ((string = netProperty.getProperty("IPC")) != null && string.equalsIgnoreCase("yes")) {
                ipcOk = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("ListenerGeneric:isIPCAllowed(): " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.err.println("ListenerGeneric:isIPCAllowed(): " + iOException);
        }
        return ipcOk;
    }

    public static String getOraHome() {
        char c = File.separatorChar;
        if (oraHome == null) {
            oraHome = NetGetEnv.getOracleHome();
            int n = oraHome.length() - 1;
            while (n >= 0) {
                if (oraHome.charAt(n) != c) break;
                --n;
            }
            oraHome = String.valueOf(oraHome.substring(0, n + 1)) + c;
        }
        return oraHome;
    }

    public static String getHostName() {
        String string;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("ListenerGeneric::getHostName: InetAddress exception");
            string = "localhost";
        }
        return string;
    }

    public static char getSeparator() {
        return File.separatorChar;
    }

    public static void setFillBoth(Container container) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        ((GridBagLayout)container.getLayout()).setConstraints(container, gridBagConstraints);
    }

    public static void constrain(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, int n7, int n8, int n9, int n10) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = n5;
        gridBagConstraints.anchor = n6;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        if (n7 + n8 + n9 + n10 > 0) {
            gridBagConstraints.insets = new Insets(n7, n8, n9, n10);
        }
        ((GridBagLayout)container.getLayout()).setConstraints(component, gridBagConstraints);
        container.add(component);
        if (container.getPeer() != null) {
            container.getLayout().layoutContainer(container);
        }
        container.validate();
    }

    public static void constrainMainPanel(Container container, Component component, int n, int n2) {
        ListenerGeneric.constrain(container, component, n, n2, 1, 1, 1, 18, 100.0, 100.0, 0, 0, 0, 0);
    }

    public static void constrain(Container container, Component component, int n, int n2, int n3, int n4) {
        ListenerGeneric.constrain(container, component, n, n2, n3, n4, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
    }

    public static void constrain(Container container, Component component, int n, int n2, int n3, int n4, int n5) {
        ListenerGeneric.constrain(container, component, n, n2, n3, n4, n5, 18, 0.0, 0.0, 0, 0, 0, 0);
    }

    public static void constrain(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        ListenerGeneric.constrain(container, component, n, n2, n3, n4, 0, 18, 0.0, 0.0, n5, n6, n7, n8);
    }

    public static void constrain(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        ListenerGeneric.constrain(container, component, n, n2, n3, n4, n9, 18, 0.0, 0.0, n5, n6, n7, n8);
    }

    static {
        ns = new NetStrings();
        help = null;
    }
}

