/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.alert.Alert;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.listener.ListenerCache;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.asst.listener.ListenerListeningLocations;
import oracle.net.asst.profile.NetAddr;
import oracle.net.asst.profile.NetLayout;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class ListenerListeningLocations
extends EwtContainer
implements ListenerCache,
TabPanelListener,
ActionListener {
    private static Vector listenerList = new Vector();
    private static String dupListener;
    private static Hashtable protocolErrors;
    private static final NetStrings ns;
    private static final String addString;
    private static final String removeString;
    private static final String helpString;
    private static final String addressString;
    private static final String addLocationString;
    private static final String addrTitleString;
    private static final String locationHelpTopic = "TOPIClsnrLsnrLocations";
    private static final NVNavigator nav;
    private static final NVFactory factory;
    private final WebApplication app = ListenerGeneric.getApp();
    private TabPanel tp;
    private EwtContainer addrPanel;
    private MultiLineLabel addLocMessage;
    private LWButton addButton;
    private LWButton removeButton;
    private LWButton helpButton;
    private GridBagConstraints buttonGBC;
    private GridBagConstraints messageGBC;
    private GridBagConstraints tpGBC;
    private NLParamParser nlpa = ListenerGeneric.getNLP();
    private String name;
    private int addrCount;
    private boolean changed = false;
    private EndpointPanel currEndpoint;
    private EndpointPanel invalid;

    public ListenerListeningLocations() {
        this.addButton = new LWButton(addString);
        this.addButton.addActionListener((ActionListener)this);
        this.removeButton = new LWButton(removeString);
        this.removeButton.addActionListener((ActionListener)this);
        this.removeButton.setEnabled(false);
        this.helpButton = new LWButton(helpString);
        this.helpButton.addActionListener((ActionListener)this);
        EwtContainer ewtContainer = new EwtContainer();
        ewtContainer.add((Component)this.addButton);
        ewtContainer.add((Component)this.removeButton);
        ewtContainer.add((Component)this.helpButton);
        this.addLocMessage = new MultiLineLabel(addLocationString);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.messageGBC = new GridBagConstraints();
        this.messageGBC.gridx = 0;
        this.messageGBC.gridy = 1;
        this.messageGBC.gridwidth = 1;
        this.messageGBC.gridheight = 1;
        this.messageGBC.weightx = 1.0;
        this.messageGBC.weighty = 10.0;
        this.messageGBC.fill = 0;
        this.messageGBC.anchor = 10;
        ((Container)((Object)this)).add((Component)this.addLocMessage, this.messageGBC);
        this.tpGBC = (GridBagConstraints)this.messageGBC.clone();
        this.tpGBC.insets.bottom = 10;
        this.tpGBC.insets.top = 10;
        this.tpGBC.insets.right = 0;
        this.tpGBC.insets.left = 0;
        this.tpGBC.fill = 1;
        this.buttonGBC = (GridBagConstraints)this.messageGBC.clone();
        this.buttonGBC.gridy = 2;
        this.buttonGBC.weighty = 0.0;
        this.buttonGBC.anchor = 16;
        ((Container)((Object)this)).add((Component)ewtContainer, this.buttonGBC);
    }

    public void setListenerName(String string) {
        this.name = string;
    }

    public void set() {
        EndpointPanel endpointPanel = null;
        this.nlpa.removeNLPListElement(this.name);
        if (this.tp == null) {
            return;
        }
        try {
            if (this.tp.getPageCount() == 1) {
                endpointPanel = (EndpointPanel)((Object)this.tp.getPage(0).getContent());
                this.nlpa.addNLPListElement(String.valueOf(this.name) + "=" + endpointPanel.getDescriptionString());
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("(DESCRIPTION_LIST=");
                int n = 0;
                while (n < this.tp.getPageCount()) {
                    endpointPanel = (EndpointPanel)((Object)this.tp.getPage(n).getContent());
                    stringBuffer.append(endpointPanel.getDescriptionString());
                    ++n;
                }
                stringBuffer.append(")");
                this.nlpa.addNLPListElement(String.valueOf(this.name) + "=" + stringBuffer.toString());
            }
        }
        catch (NLException nLException) {
            System.err.println(nLException);
        }
        endpointPanel.clearChangedFlag();
        this.changed = false;
    }

    public void get() {
        NVPair nVPair = this.nlpa.getNLPListElement(this.name);
        if (nVPair == null || nVPair.getListSize() == 0) {
            this.changed = true;
            return;
        }
        NVPair nVPair2 = nVPair.getListElement(0);
        String string = nVPair2.getName().toUpperCase();
        if (string.equals("DESCRIPTION_LIST")) {
            this.parseDList(nVPair2, null);
            return;
        }
        if (string.equals("DESCRIPTION")) {
            this.parseDList(nVPair, null);
            return;
        }
        if (string.equals("ADDRESS_LIST")) {
            this.parseAList(nVPair2, null);
            return;
        }
        if (string.equals("ADDRESS")) {
            this.parseAList(nVPair, null);
        }
    }

    public boolean isChanged() {
        if (this.changed || this.tp == null) {
            return true;
        }
        int n = 0;
        while (n < this.tp.getPageCount()) {
            if (((EndpointPanel)((Object)this.tp.getPage(n).getContent())).hasChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean areDataValid() {
        if (this.tp == null) {
            return false;
        }
        int n = 0;
        while (n < this.tp.getPageCount()) {
            EndpointPanel endpointPanel = (EndpointPanel)((Object)this.tp.getPage(n).getContent());
            if (!endpointPanel.areDataValid() || (dupListener = ListenerListeningLocations.findDuplicate(endpointPanel)) != null) {
                this.invalid = endpointPanel;
                return false;
            }
            ++n;
        }
        dupListener = null;
        this.invalid = null;
        return true;
    }

    public void setFocus() {
        if (this.tp == null) {
            BufferedFrame bufferedFrame = (BufferedFrame)ListenerGeneric.getApp().getFrame();
            Alert alert = new Alert((Frame)bufferedFrame, ns.getString("LCCPleaseAddListeningLocation"), 0, 1);
            alert.setTitle(ns.getString("nnaError"));
            alert.setCenterOver((Component)bufferedFrame);
            alert.setDefaultButton(1);
            alert.runAlert();
            alert.dispose();
            this.addButton.requestFocus();
            return;
        }
        if (this.invalid != null) {
            this.tp.getSelectedPage().setVisible(true);
            this.invalid.setFocus();
        }
    }

    public void tabPanelSelectionChanged(TabPanelEvent tabPanelEvent) {
        TabPanelPage tabPanelPage = tabPanelEvent.getPage();
        if (tabPanelPage != null) {
            this.currEndpoint = (EndpointPanel)((Object)tabPanelPage.getContent());
        }
    }

    public void tabPanelSelectionChanging(TabPanelEvent tabPanelEvent) {
        if (ListenerGeneric.allowInvalid()) {
            return;
        }
        if (!(this.currEndpoint == null || this.currEndpoint.areDataValid() && (dupListener = ListenerListeningLocations.findDuplicate(this.currEndpoint)) == null)) {
            ((Cancelable)tabPanelEvent).cancel();
            this.currEndpoint.setFocus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(addString)) {
            this.changed = true;
            this.newAddr(factory.createNVPair("(ADDRESS=(PROTOCOL=tcp)(HOST=" + ListenerGeneric.getHostName() + ")(PORT=" + (this.tp == null ? "1521" : "") + "))"), null);
            return;
        }
        if (string.equals(removeString)) {
            this.changed = true;
            this.removeAddr();
            return;
        }
        if (string.equals(helpString)) {
            ListenerGeneric.getHelp().showTopic(locationHelpTopic);
            return;
        }
    }

    private void newAddr(NVPair nVPair, NVPair nVPair2) {
        this.changed = true;
        if (this.tp == null) {
            this.tp = new TabPanel();
            this.tp.addTabPanelListener((TabPanelListener)this);
            ((Container)((Object)this)).remove((Component)this.addLocMessage);
            ((Container)((Object)this)).add((Component)this.tp, this.tpGBC);
        }
        if (!(ListenerGeneric.allowInvalid() || this.currEndpoint == null || this.currEndpoint.areDataValid() && (dupListener = ListenerListeningLocations.findDuplicate(this.currEndpoint)) == null)) {
            this.currEndpoint.setFocus();
            return;
        }
        EndpointPanel endpointPanel = new EndpointPanel(nVPair, nVPair2);
        endpointPanel.setAppEnv(this.app);
        TabPanelPage tabPanelPage = this.tp.addPage(String.valueOf(addressString) + ++this.addrCount, (Component)((Object)endpointPanel));
        if (ListenerGeneric.allowInvalid()) {
            tabPanelPage.setSelected(true);
        } else {
            ListenerGeneric.setAllowInvalid(true);
            tabPanelPage.setSelected(true);
            ListenerGeneric.setAllowInvalid(false);
        }
        this.validate();
        if (this.tp.getPageCount() >= 1) {
            this.removeButton.setEnabled(true);
        }
        this.currEndpoint = (EndpointPanel)((Object)this.tp.getSelectedPage().getContent());
    }

    private void removeAddr() {
        TabPanelPage tabPanelPage = this.tp.getSelectedPage();
        this.changed = true;
        ListenerGeneric.setAllowInvalid(true);
        this.tp.removePage(tabPanelPage);
        ListenerGeneric.setAllowInvalid(false);
        tabPanelPage = null;
        --this.addrCount;
        if (this.tp.getPageCount() == 0) {
            this.removeButton.setEnabled(false);
            this.tp.removeTabPanelListener((TabPanelListener)this);
            ((Container)((Object)this)).remove((Component)this.tp);
            this.tp = null;
            this.currEndpoint = null;
            ((Container)((Object)this)).add((Component)this.addLocMessage, this.messageGBC);
            this.validate();
            return;
        }
        this.currEndpoint = (EndpointPanel)((Object)this.tp.getSelectedPage().getContent());
        int n = 0;
        while (n < this.tp.getPageCount()) {
            this.tp.getPage(n).setLabel(String.valueOf(addressString) + (n + 1));
            ++n;
        }
    }

    private void parseDList(NVPair nVPair, NVPair nVPair2) {
        if (nVPair == null) {
            return;
        }
        NVPair nVPair3 = this.findPStack(nVPair);
        if (nVPair3 == null) {
            nVPair3 = nVPair2;
        }
        int n = nVPair.getListSize();
        int n2 = 0;
        while (n2 < n) {
            NVPair nVPair4 = nVPair.getListElement(n2);
            String string = nVPair4.getName().toUpperCase();
            if (string.equals("DESCRIPTION_LIST")) {
                this.parseDList(nVPair4, nVPair3 != null ? nVPair3 : nVPair2);
            }
            if (string.equals("DESCRIPTION") && nav.findNVPairRecurse(nVPair4, "ADDRESS") != null) {
                this.parseAList(nVPair4, nVPair3 != null ? nVPair3 : nVPair2);
            }
            ++n2;
        }
    }

    private void parseAList(NVPair nVPair, NVPair nVPair2) {
        if (nVPair == null) {
            return;
        }
        NVPair nVPair3 = this.findPStack(nVPair);
        if (nVPair3 == null) {
            nVPair3 = nVPair2;
        }
        int n = nVPair.getListSize();
        NVPair nVPair4 = null;
        int n2 = 0;
        while (n2 < n) {
            nVPair4 = nVPair.getListElement(n2);
            if (nVPair4.getName().toUpperCase().equals("ADDRESS_LIST")) {
                this.parseAList(nVPair4, nVPair3 != null ? nVPair3 : nVPair2);
            } else if (nVPair4.getName().toUpperCase().equals("ADDRESS")) {
                this.newAddr(nVPair4, nVPair3 != null ? nVPair3 : nVPair2);
            }
            ++n2;
        }
    }

    private NVPair findPStack(NVPair nVPair) {
        NVPair nVPair2 = null;
        NVPair nVPair3 = null;
        nVPair2 = nav.findNVPair(nVPair, "PROTOCOL_STACK");
        if (nVPair2 != null && nav.findNVPair(nVPair2, "SESSION") == null) {
            nVPair = nVPair2;
            nVPair2 = null;
        }
        if (nVPair2 == null && (nVPair3 = nav.findNVPair(nVPair, "PRESENTATION")) != null) {
            String string = nVPair3.getAtom().toUpperCase();
            String string2 = "(PROTOCOL_STACK=(PRESENTATION=" + string + ")(SESSION=";
            if (nVPair3.equals("TTC")) {
                nVPair2 = factory.createNVPair(String.valueOf(string2) + "NS))");
            } else if (nVPair3.equals("GIOP")) {
                nVPair2 = factory.createNVPair(String.valueOf(string2) + "RAW))");
            }
        }
        return nVPair2;
    }

    public static void registerListener(ListenerListeningLocations listenerListeningLocations) {
        listenerList.addElement(listenerListeningLocations);
    }

    public static void unregisterListener(ListenerListeningLocations listenerListeningLocations) {
        try {
            listenerList.removeElement(listenerListeningLocations);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static String findDuplicate(EndpointPanel endpointPanel) {
        Enumeration enumeration = listenerList.elements();
        while (enumeration.hasMoreElements()) {
            ListenerListeningLocations listenerListeningLocations = (ListenerListeningLocations)enumeration.nextElement();
            if (listenerListeningLocations.tp == null) continue;
            int n = listenerListeningLocations.tp.getPageCount();
            int n2 = 0;
            while (n2 < n) {
                EndpointPanel endpointPanel2 = (EndpointPanel)((Object)listenerListeningLocations.tp.getPage(n2).getContent());
                if (endpointPanel2 != endpointPanel && endpointPanel.addr.sameEndpoint(endpointPanel2.addr)) {
                    return listenerListeningLocations.name;
                }
                ++n2;
            }
        }
        return null;
    }

    private static void showDuplicateError(EndpointPanel endpointPanel) {
        String string = endpointPanel.addr.getProtocol().toUpperCase();
        Object[] objectArray = new Object[]{dupListener != null ? dupListener : ""};
        String string2 = ns.getString((String)protocolErrors.get(string), objectArray);
        Alert alert = new Alert(ListenerGeneric.getApp().getFrame(), string2, 0, 1);
        alert.setCenterOver((Component)ListenerGeneric.getApp().getFrame());
        alert.setDefaultButton(1);
        alert.setTitle(ns.getString("nnaError"));
        alert.runAlert();
        alert.dispose();
        dupListener = null;
    }

    static /* synthetic */ String access$0() {
        return addrTitleString;
    }

    static /* synthetic */ boolean access$1(ListenerListeningLocations listenerListeningLocations) {
        return listenerListeningLocations.changed;
    }

    static /* synthetic */ void access$2(ListenerListeningLocations listenerListeningLocations, boolean bl) {
        listenerListeningLocations.changed = bl;
    }

    static /* synthetic */ NetStrings access$3() {
        return ns;
    }

    static /* synthetic */ NVNavigator access$4() {
        return nav;
    }

    static /* synthetic */ String access$5() {
        return dupListener;
    }

    static /* synthetic */ void access$6(EndpointPanel endpointPanel) {
        ListenerListeningLocations.showDuplicateError(endpointPanel);
    }

    static {
        protocolErrors = new Hashtable(5);
        protocolErrors.put("TCP", "LCCDupErrorTCP");
        protocolErrors.put("TCPS", "LCCDupErrorTCPS");
        protocolErrors.put("IPC", "LCCDupErrorIPC");
        protocolErrors.put("SPX", "LCCDupErrorSPX");
        protocolErrors.put("NMP", "LCCDupErrorNMP");
        ns = new NetStrings();
        addString = ns.getString("LCCAddAddress");
        removeString = ns.getString("LCCRemoveAddress");
        helpString = ns.getString("LCCHelp");
        addressString = ns.getString("LCCAddress");
        addLocationString = ns.getString("LCCaddLocationMessage");
        addrTitleString = ns.getString("LCCaddrTitle");
        nav = new NVNavigator();
        factory = new NVFactory();
    }

    public class EndpointPanel
    extends NetLayout {
        NetAddr addr;
        private GridBagConstraints gbc;
        private LWCheckbox stackBox;
        private LWLabel stackMessage1;
        private MultiLineLabel stackMessage2;
        private NVPair unsupportedPStack;
        private final String IIOPStack = "(PROTOCOL_STACK=(PRESENTATION=GIOP)(SESSION=RAW))";

        public EndpointPanel(NVPair nVPair, NVPair nVPair2) {
            ListenerListeningLocations.this = ListenerListeningLocations.this;
            this.setBorderPainter((BorderPainter)new FixedBorderPainter(40, 40, 40, 40));
            this.addr = new NetAddr(nVPair);
            this.addr.setBorderPainter(UIManager.createGroupBoxPainter((Painter)new FixedBorderPainter(15, 10, 10, 10), (String)addrTitleString));
            this.stackBox = new LWCheckbox("");
            this.stackBox.addItemListener((ItemListener)new 1(this));
            this.stackMessage1 = new LWLabel(ns.getString("LCCiiopPStack1"));
            this.stackMessage2 = new MultiLineLabel(WordWrapper.getTextWrapper(), ns.getString("LCCiiopPStack2"));
            this.stackMessage2.setPreferredAspectRatio(10.0f);
            if (nVPair2 == null) {
                this.stackBox.setState(false);
            } else {
                NVPair nVPair3 = nav.findNVPair(nVPair2, "PRESENTATION");
                NVPair nVPair4 = nav.findNVPair(nVPair2, "SESSION");
                if (nVPair3 == null || nVPair4 == null) {
                    this.unsupportedPStack = nVPair2;
                    this.stackBox.setState(false);
                    this.stackBox.setEnabled(false);
                    this.stackMessage1.setEnabled(false);
                    this.stackMessage2.setEnabled(false);
                } else if (nVPair3.getAtom().equalsIgnoreCase("TTC") && nVPair4.getAtom().equalsIgnoreCase("NS")) {
                    this.stackBox.setState(false);
                } else if (nVPair3.getAtom().equalsIgnoreCase("GIOP") && nVPair4.getAtom().equalsIgnoreCase("RAW")) {
                    this.stackBox.setState(true);
                } else {
                    this.unsupportedPStack = nVPair2;
                    this.stackBox.setState(false);
                    this.stackBox.setEnabled(false);
                    this.stackMessage1.setEnabled(false);
                    this.stackMessage2.setEnabled(false);
                }
            }
            ((Container)((Object)this)).setLayout(new GridBagLayout());
            this.gbc = new GridBagConstraints();
            this.gbc.gridx = 0;
            this.gbc.gridy = 0;
            this.gbc.weighty = 1.0;
            this.gbc.weightx = 1.0;
            this.gbc.anchor = 10;
            this.gbc.gridheight = 1;
            this.gbc.gridwidth = 2;
            ((Container)((Object)this)).add((Component)((Object)this.addr), this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = 1;
            this.gbc.weighty = 0.0;
            this.gbc.weightx = 0.0;
            this.gbc.fill = 0;
            this.gbc.anchor = 17;
            this.gbc.insets.left = 5;
            ((Container)((Object)this)).add((Component)this.stackBox, this.gbc);
            ++this.gbc.gridx;
            this.gbc.weightx = 1.0;
            ((Container)((Object)this)).add((Component)this.stackMessage1, this.gbc);
            ++this.gbc.gridy;
            this.gbc.weighty = 1.0;
            this.gbc.anchor = 18;
            this.gbc.insets.top = 1;
            ((Container)((Object)this)).add((Component)this.stackMessage2, this.gbc);
        }

        public String getDescriptionString() {
            String string = "";
            if (this.unsupportedPStack != null) {
                string = this.unsupportedPStack.toString();
            }
            if (this.stackBox.getState()) {
                string = "(PROTOCOL_STACK=(PRESENTATION=GIOP)(SESSION=RAW))";
            }
            return "(DESCRIPTION=" + this.addr.getAddr().toString() + string + ")";
        }

        public void setAppEnv(WebApplication webApplication) {
            this.addr.setAppEnv(webApplication);
        }

        public void setFocus() {
            if (dupListener != null) {
                ListenerListeningLocations.showDuplicateError(this);
                return;
            }
            this.addr.setFocus();
        }

        public boolean hasChanged() {
            ListenerListeningLocations listenerListeningLocations = ListenerListeningLocations.this;
            return listenerListeningLocations.changed || this.addr.hasChanged();
        }

        public void clearChangedFlag() {
            ListenerListeningLocations listenerListeningLocations = ListenerListeningLocations.this;
            listenerListeningLocations.changed = false;
        }

        public boolean areDataValid() {
            return this.addr.areDataValid();
        }

        static /* synthetic */ ListenerListeningLocations access$0(EndpointPanel endpointPanel) {
            return endpointPanel.ListenerListeningLocations.this;
        }
    }
}

