/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.listener.ListenerCache;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class ListenerLoggingTracing
extends EwtContainer
implements ListenerCache,
ItemListener,
ActionListener {
    private String name;
    private WebApplication app = ListenerGeneric.getApp();
    private NetStrings ns = ListenerGeneric.getNS();
    private NLParamParser nlpa = ListenerGeneric.getNLP();
    private LWCheckboxGroup logGroup = new LWCheckboxGroup();
    private LWCheckboxGroup traceGroup = new LWCheckboxGroup();
    private LWCheckbox logEnBox;
    private LWCheckbox logDisBox;
    private LWCheckbox traceEnBox;
    private LWCheckbox traceDisBox;
    private boolean changed;
    private LWTextField logFileField;
    private LWTextField traceFileField;
    private String logEnString;
    private String logDisString;
    private String traceEnString;
    private String traceDisString;
    private String browseString;
    private String userString;
    private String adminString;
    private String supportString;
    private String chooseLogString;
    private String chooseTraceString;
    private String[] hintArrayA;
    private String[] hintArrayB;
    private LWLabel logFileLabel;
    private LWLabel traceLevelLabel;
    private LWLabel traceLevelHintA;
    private LWLabel traceLevelHintB;
    private LWLabel traceFileLabel;
    private LWChoice traceLevelChoice;
    private LWButton logButton;
    private LWButton traceButton;
    private char sep;
    private String oraHome;
    private File logFileDef;
    private File traceFileDef;
    private String savedLogFileField;
    private String savedTraceFileField;
    private EwtContainer logPanel;
    private EwtContainer tracePanel;

    public ListenerLoggingTracing() {
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.sep = File.separatorChar;
        this.oraHome = ListenerGeneric.getOraHome();
        this.logDisString = new String(this.ns.getString("LCCLoggingDisabled"));
        this.logEnString = new String(this.ns.getString("LCCLoggingEnabled"));
        this.traceEnString = new String(this.ns.getString("LCCTracingEnabled"));
        this.traceDisString = new String(this.ns.getString("LCCTracingDisabled"));
        this.browseString = new String(this.ns.getString("LCCBrowse"));
        this.hintArrayA = new String[3];
        this.hintArrayB = new String[3];
        this.hintArrayA[0] = new String(this.ns.getString("LCCUserHintA"));
        this.hintArrayB[0] = new String(this.ns.getString("LCCUserHintB"));
        this.hintArrayA[1] = new String(this.ns.getString("LCCAdminHintA"));
        this.hintArrayB[1] = new String(this.ns.getString("LCCAdminHintB"));
        this.hintArrayA[2] = new String(this.ns.getString("LCCSupportHintA"));
        this.hintArrayB[2] = new String(this.ns.getString("LCCSupportHintB"));
        this.userString = new String(this.ns.getString("LCCUser"));
        this.adminString = new String(this.ns.getString("LCCAdmin"));
        this.supportString = new String(this.ns.getString("LCCSupport"));
        this.logDisBox = new LWCheckbox(this.logDisString, this.logGroup, false);
        this.logDisBox.addItemListener((ItemListener)this);
        this.logEnBox = new LWCheckbox(this.logEnString, this.logGroup, true);
        this.logEnBox.addItemListener((ItemListener)this);
        ListenerLoggingTracing listenerLoggingTracing = this;
        LWCheckbox lWCheckbox = this.logDisBox;
        ListenerGeneric.constrain((Container)((Object)listenerLoggingTracing), (Component)lWCheckbox, 0, 0, 1, 1, 0, 18, 0.0, 0.0, 5, 15, 0, 0);
        listenerLoggingTracing = this;
        lWCheckbox = this.logEnBox;
        ListenerGeneric.constrain((Container)((Object)listenerLoggingTracing), (Component)lWCheckbox, 0, 1, 1, 1, 0, 18, 0.0, 0.0, 0, 15, 0, 0);
        this.logFileLabel = new LWLabel(this.ns.getString("LCCLogFile"));
        this.logFileField = new LWTextField("", 30);
        this.savedLogFileField = new String();
        this.logButton = new LWButton(this.browseString);
        this.logButton.addActionListener((ActionListener)this);
        this.chooseLogString = new String(this.ns.getString("LCCChooseLog"));
        this.logPanel = new EwtContainer();
        this.logPanel.setBorder((Border)new GroupBoxBorder("", InsetFramePainter.getFramePainter(), 2));
        this.logPanel.setLayout(new GridBagLayout());
        listenerLoggingTracing = this.logPanel;
        lWCheckbox = this.logFileLabel;
        ListenerGeneric.constrain((Container)((Object)listenerLoggingTracing), (Component)lWCheckbox, 0, 0, 1, 1, 0, 18, 0.0, 0.0, 10, 10, 0, 0);
        listenerLoggingTracing = this.logPanel;
        lWCheckbox = this.logFileField;
        ListenerGeneric.constrain((Container)((Object)listenerLoggingTracing), (Component)lWCheckbox, 1, 0, 1, 1, 1, 18, 0.0, 0.0, 10, 0, 0, 5);
        ListenerGeneric.constrain((Container)this.logPanel, (Component)this.logButton, 0, 1, 2, 1, 0, 13, 1.0, 1.0, 5, 0, 10, 5);
        listenerLoggingTracing = this;
        lWCheckbox = this.logPanel;
        ListenerGeneric.constrain((Container)((Object)listenerLoggingTracing), (Component)lWCheckbox, 0, 1, 1, 1, 1, 18, 0.0, 0.0, 0, 10, 10, 10);
        this.traceDisBox = new LWCheckbox(this.traceDisString, this.traceGroup, true);
        this.traceDisBox.addItemListener((ItemListener)this);
        this.traceEnBox = new LWCheckbox(this.traceEnString, this.traceGroup, false);
        this.traceEnBox.addItemListener((ItemListener)this);
        listenerLoggingTracing = this;
        lWCheckbox = this.traceDisBox;
        ListenerGeneric.constrain((Container)((Object)listenerLoggingTracing), (Component)lWCheckbox, 0, 2, 1, 1, 0, 18, 0.0, 0.0, 15, 15, 0, 0);
        listenerLoggingTracing = this;
        lWCheckbox = this.traceEnBox;
        ListenerGeneric.constrain((Container)((Object)listenerLoggingTracing), (Component)lWCheckbox, 0, 3, 1, 1, 0, 18, 0.0, 0.0, 0, 15, 0, 0);
        this.traceFileLabel = new LWLabel(this.ns.getString("LCCTraceFile"));
        this.traceLevelChoice = new LWChoice();
        this.traceLevelChoice.add(this.userString);
        this.traceLevelChoice.add(this.adminString);
        this.traceLevelChoice.add(this.supportString);
        this.traceLevelChoice.addItemListener((ItemListener)this);
        this.traceLevelLabel = new LWLabel(this.ns.getString("LCCTraceLevel"));
        this.traceLevelHintA = new LWLabel(this.hintArrayA[0]);
        this.traceLevelHintB = new LWLabel(this.hintArrayB[0]);
        this.traceButton = new LWButton(this.browseString);
        this.traceButton.addActionListener((ActionListener)this);
        this.chooseTraceString = new String(this.ns.getString("LCCChooseTrace"));
        this.traceFileField = new LWTextField("", 30);
        this.savedTraceFileField = new String();
        this.tracePanel = new EwtContainer();
        this.tracePanel.setBorder((Border)new GroupBoxBorder("", InsetFramePainter.getFramePainter(), 2));
        this.tracePanel.setLayout(new GridBagLayout());
        listenerLoggingTracing = this.tracePanel;
        lWCheckbox = this.traceLevelLabel;
        ListenerGeneric.constrain((Container)((Object)listenerLoggingTracing), (Component)lWCheckbox, 0, 0, 1, 1, 0, 18, 0.0, 0.0, 10, 10, 0, 0);
        listenerLoggingTracing = this.tracePanel;
        lWCheckbox = this.traceLevelChoice;
        ListenerGeneric.constrain((Container)((Object)listenerLoggingTracing), (Component)lWCheckbox, 1, 0, 1, 1, 0, 18, 0.0, 0.0, 10, 0, 0, 0);
        listenerLoggingTracing = this.tracePanel;
        lWCheckbox = this.traceLevelHintA;
        ListenerGeneric.constrain((Container)((Object)listenerLoggingTracing), (Component)lWCheckbox, 1, 1, 2, 1, 1, 18, 0.0, 0.0, 0, 0, 0, 0);
        listenerLoggingTracing = this.tracePanel;
        lWCheckbox = this.traceLevelHintB;
        ListenerGeneric.constrain((Container)((Object)listenerLoggingTracing), (Component)lWCheckbox, 1, 2, 2, 1, 1, 18, 0.0, 0.0, 0, 0, 10, 0);
        listenerLoggingTracing = this.tracePanel;
        lWCheckbox = this.traceFileLabel;
        ListenerGeneric.constrain((Container)((Object)listenerLoggingTracing), (Component)lWCheckbox, 0, 3, 1, 1, 0, 18, 0.0, 0.0, 10, 10, 0, 0);
        listenerLoggingTracing = this.tracePanel;
        lWCheckbox = this.traceFileField;
        ListenerGeneric.constrain((Container)((Object)listenerLoggingTracing), (Component)lWCheckbox, 1, 3, 1, 1, 1, 18, 0.0, 0.0, 10, 0, 0, 5);
        ListenerGeneric.constrain((Container)this.tracePanel, (Component)this.traceButton, 0, 4, 2, 1, 0, 13, 1.0, 1.0, 5, 0, 10, 5);
        listenerLoggingTracing = this;
        lWCheckbox = this.tracePanel;
        ListenerGeneric.constrain((Container)((Object)listenerLoggingTracing), (Component)lWCheckbox, 0, 3, 1, 1, 1, 18, 0.0, 0.0, 0, 10, 10, 10);
    }

    public void addNotify() {
        super.addNotify();
        this.traceEnBox.setBackground(this.traceEnBox.getBackground());
        this.logEnBox.setBackground(this.logEnBox.getBackground());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block7: {
            block4: {
                block6: {
                    block5: {
                        Object object = actionEvent.getSource();
                        if (!(object instanceof LWButton)) break block4;
                        if (!((LWButton)object).equals(this.logButton)) break block5;
                        ListenerGeneric.devTrc("ListenerLoggingTracing:actionPerformed log dir button pushed");
                        FileDialog fileDialog = new FileDialog(this.app.getFrame(), this.chooseLogString, 1);
                        File file = new File(this.logFileField.getText());
                        fileDialog.setFile(file.getName());
                        fileDialog.setDirectory(file.getParent());
                        fileDialog.show();
                        if (fileDialog.getFile() != null) {
                            File file2 = new File(fileDialog.getDirectory(), fileDialog.getFile());
                            this.logFileField.setText(file2.toString());
                            return;
                        }
                        break block6;
                    }
                    ListenerGeneric.devTrc("ListenerLoggingTracing:actionPerformed trace dir button pushed");
                    FileDialog fileDialog = new FileDialog(this.app.getFrame(), this.chooseTraceString, 1);
                    File file = new File(this.traceFileField.getText());
                    fileDialog.setFile(file.getName());
                    fileDialog.setDirectory(file.getParent());
                    fileDialog.show();
                    if (fileDialog.getFile() == null) break block7;
                    File file3 = new File(fileDialog.getDirectory(), fileDialog.getFile());
                    this.traceFileField.setText(file3.toString());
                }
                return;
            }
            ListenerGeneric.devTrc("ListenerLoggingTracing:actionPerformed unknown action");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof LWChoice) {
            ListenerGeneric.devTrc("ListenerLoggingTracing:itemStateChanged trace level state change");
            this.traceLevelHintA.setText(this.hintArrayA[((LWChoice)object).getSelectedIndex()]);
            this.traceLevelHintB.setText(this.hintArrayB[((LWChoice)object).getSelectedIndex()]);
            this.validate();
            this.changed = true;
            return;
        }
        if (object instanceof LWCheckbox) {
            if (((LWCheckbox)object).equals(this.logEnBox)) {
                ListenerGeneric.devTrc("ListenerLoggingTracing:itemStateChanged enable logging state change");
                this.enableLogPanel(true);
                return;
            }
            if (((LWCheckbox)object).equals(this.logDisBox)) {
                ListenerGeneric.devTrc("ListenerLoggingTracing:itemStateChanged disable logging state change");
                this.enableLogPanel(false);
                return;
            }
            if (((LWCheckbox)object).equals(this.traceEnBox)) {
                ListenerGeneric.devTrc("ListenerLoggingTracing:itemStateChanged enable tracing state change");
                this.enableTracePanel(true);
                return;
            }
            if (((LWCheckbox)object).equals(this.traceDisBox)) {
                ListenerGeneric.devTrc("ListenerLoggingTracing:itemStateChanged disable tracing state change");
                this.enableTracePanel(false);
                return;
            }
        } else {
            ListenerGeneric.devTrc("ListenerLoggingTracing:itemStateChanged unknown state change");
        }
    }

    private void enableLogPanel(boolean bl) {
        this.logFileField.setEnabled(bl);
        this.logFileField.setEditable(bl);
        this.logButton.setEnabled(bl);
        this.logFileField.repaint(0L);
        this.changed = true;
    }

    private void enableTracePanel(boolean bl) {
        this.traceFileField.setEnabled(bl);
        this.traceFileField.setEditable(bl);
        this.traceButton.setEnabled(bl);
        this.traceLevelChoice.setEnabled(bl);
        this.traceFileField.repaint(0L);
        this.changed = true;
    }

    public void setListenerName(String string) {
        this.name = string;
        this.logFileDef = new File(String.valueOf(this.oraHome) + "network" + this.sep + "log" + this.sep + this.name + ".log");
        this.traceFileDef = new File(String.valueOf(this.oraHome) + "network" + this.sep + "trace" + this.sep + this.name + ".trc");
    }

    public void set() {
        try {
            File file;
            String string;
            this.nlpa.removeNLPListElement("LOGGING_" + this.name);
            if (this.logGroup.getSelectedCheckbox().getLabel().equals(this.logDisString)) {
                this.nlpa.addNLPListElement("LOGGING_" + this.name + "=OFF");
            }
            this.nlpa.removeNLPListElement("LOG_DIRECTORY_" + this.name);
            this.nlpa.removeNLPListElement("LOG_FILE_" + this.name);
            this.savedLogFileField = string = this.logFileField.getText();
            if (!string.equals(this.logFileDef.toString())) {
                ListenerGeneric.devTrc("adding non-default log dir/file");
                file = new File(string);
                this.nlpa.addNLPListElement("LOG_DIRECTORY_" + this.name + "=" + file.getParent());
                this.nlpa.addNLPListElement("LOG_FILE_" + this.name + "=" + file.getName());
            }
            this.nlpa.removeNLPListElement("TRACE_LEVEL_" + this.name);
            if (this.traceGroup.getSelectedCheckbox().getLabel().equals(this.traceEnString)) {
                String string2 = this.traceLevelChoice.getSelectedItem();
                if (string2.equals(this.adminString)) {
                    this.nlpa.addNLPListElement("TRACE_LEVEL_" + this.name + "=ADMIN");
                } else if (string2.equals(this.userString)) {
                    this.nlpa.addNLPListElement("TRACE_LEVEL_" + this.name + "=USER");
                } else {
                    this.nlpa.addNLPListElement("TRACE_LEVEL_" + this.name + "=SUPPORT");
                }
            }
            this.nlpa.removeNLPListElement("TRACE_DIRECTORY_" + this.name);
            this.nlpa.removeNLPListElement("TRACE_FILE_" + this.name);
            this.savedTraceFileField = string = this.traceFileField.getText();
            if (!string.equals(this.traceFileDef.toString())) {
                ListenerGeneric.devTrc("adding non-default trace dir/file");
                file = new File(string);
                this.nlpa.addNLPListElement("TRACE_DIRECTORY_" + this.name + "=" + file.getParent());
                this.nlpa.addNLPListElement("TRACE_FILE_" + this.name + "=" + file.getName());
            }
        }
        catch (NLException nLException) {
            System.err.println(nLException);
        }
        this.changed = false;
    }

    public void get() {
        NVPair nVPair = this.nlpa.getNLPListElement("LOGGING_" + this.name);
        if (nVPair != null && nVPair.getAtom() != null && nVPair.getAtom().equalsIgnoreCase("OFF")) {
            this.logDisBox.setState(true);
            this.enableLogPanel(false);
        } else {
            this.logEnBox.setState(true);
            this.enableLogPanel(true);
        }
        nVPair = this.nlpa.getNLPListElement("LOG_FILE_" + this.name);
        String string = nVPair != null && nVPair.getAtom() != null ? nVPair.getAtom() : this.logFileDef.getName();
        nVPair = this.nlpa.getNLPListElement("LOG_DIRECTORY_" + this.name);
        String string2 = nVPair != null && nVPair.getAtom() != null ? nVPair.getAtom() : this.logFileDef.getParent();
        File file = new File(string2, string);
        this.logFileField.setText(file.toString());
        this.savedLogFileField = string;
        nVPair = this.nlpa.getNLPListElement("TRACE_LEVEL_" + this.name);
        if (nVPair != null && nVPair.getAtom() != null) {
            String string3 = nVPair.getAtom();
            this.traceEnBox.setState(true);
            this.enableTracePanel(true);
            if (string3.equalsIgnoreCase("USER")) {
                this.traceLevelChoice.select(this.userString);
                this.traceLevelHintA.setText(this.hintArrayA[0]);
                this.traceLevelHintB.setText(this.hintArrayB[0]);
            } else if (string3.equalsIgnoreCase("ADMIN")) {
                this.traceLevelChoice.select(this.adminString);
                this.traceLevelHintA.setText(this.hintArrayA[1]);
                this.traceLevelHintB.setText(this.hintArrayB[1]);
            } else if (string3.equalsIgnoreCase("SUPPORT")) {
                this.traceLevelChoice.select(this.supportString);
                this.traceLevelHintA.setText(this.hintArrayA[2]);
                this.traceLevelHintB.setText(this.hintArrayB[2]);
            } else {
                this.traceDisBox.setState(true);
                this.enableTracePanel(false);
            }
        } else {
            this.traceDisBox.setState(true);
            this.enableTracePanel(false);
        }
        nVPair = this.nlpa.getNLPListElement("TRACE_FILE_" + this.name);
        string = nVPair != null && nVPair.getAtom() != null ? nVPair.getAtom() : this.traceFileDef.getName();
        nVPair = this.nlpa.getNLPListElement("TRACE_DIRECTORY_" + this.name);
        string2 = nVPair != null && nVPair.getAtom() != null ? nVPair.getAtom() : this.traceFileDef.getParent();
        file = new File(string2, string);
        this.traceFileField.setText(file.toString());
        this.savedTraceFileField = string;
    }

    public boolean isChanged() {
        if (!this.logFileField.getText().equals(this.savedLogFileField)) {
            this.changed = true;
        }
        if (!this.traceFileField.getText().equals(this.savedTraceFileField)) {
            this.changed = true;
        }
        ListenerGeneric.devTrc("ListenerLoggingTracing:isChanged " + this.changed);
        return this.changed;
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }
}

