/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetValidate;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class ListenerOtherServicePage
extends EwtContainer
implements KeyListener {
    private LWTextField serviceNameField;
    private LWTextField programField;
    private LWTextField argsField;
    private LWTextField argv0Field;
    private LWTextField envField;
    private LWTextField sidField;
    private LWTextField oHomeField;
    private LWLabel serviceNameLabel;
    private LWLabel programLabel;
    private LWLabel argsLabel;
    private LWLabel argv0Label;
    private LWLabel envLabel;
    private LWLabel sidLabel;
    private LWLabel oHomeLabel;
    private NetStrings ns = ListenerGeneric.getNS();
    private NetValidate netValidate;
    private LWTextField invalidField;
    private String invalidString;
    private boolean changed = false;

    public ListenerOtherServicePage(NVPair nVPair) {
        this.buildUI();
        this.netValidate = new NetValidate((BufferedFrame)ListenerGeneric.getApp().getFrame());
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "GLOBAL_DBNAME");
        if (nVPair2 != null) {
            this.serviceNameField.setText(nVPair2.getAtom());
        }
        if ((nVPair2 = nVNavigator.findNVPair(nVPair, "PROGRAM")) != null) {
            this.programField.setText(nVPair2.getAtom());
        }
        if ((nVPair2 = nVNavigator.findNVPair(nVPair, "ARGV0")) != null) {
            this.argv0Field.setText(nVPair2.getAtom());
        }
        if ((nVPair2 = nVNavigator.findNVPair(nVPair, "ARGS")) != null) {
            this.argsField.setText(nVPair2.getAtom());
        }
        if ((nVPair2 = nVNavigator.findNVPair(nVPair, "ENV")) != null) {
            this.envField.setText(nVPair2.getAtom());
        }
        if ((nVPair2 = nVNavigator.findNVPair(nVPair, "SID_NAME")) != null) {
            this.sidField.setText(nVPair2.getAtom());
        }
        if ((nVPair2 = nVNavigator.findNVPair(nVPair, "ORACLE_HOME")) != null) {
            this.oHomeField.setText(nVPair2.getAtom());
        }
    }

    private void buildUI() {
        this.serviceNameLabel = new LWLabel(this.ns.getString("LCCGlobalServiceName"));
        this.programLabel = new LWLabel(this.ns.getString("LCCProgram"));
        this.argsLabel = new LWLabel(this.ns.getString("LCCProgramArguments"));
        this.argv0Label = new LWLabel(this.ns.getString("LCCProgramArgument0"));
        this.envLabel = new LWLabel(this.ns.getString("LCCEnvironment"));
        this.sidLabel = new LWLabel(this.ns.getString("LCCSID"));
        this.oHomeLabel = new LWLabel(this.ns.getString("LCCOracleHomeDir"));
        this.serviceNameField = new LWTextField(25);
        this.programField = new LWTextField(25);
        this.argsField = new LWTextField(25);
        this.argv0Field = new LWTextField(25);
        this.envField = new LWTextField(25);
        this.sidField = new LWTextField(25);
        this.oHomeField = new LWTextField(25);
        this.serviceNameField.addKeyListener(this);
        this.programField.addKeyListener(this);
        this.argsField.addKeyListener(this);
        this.argv0Field.addKeyListener(this);
        this.envField.addKeyListener(this);
        this.sidField.addKeyListener(this);
        this.oHomeField.addKeyListener(this);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.serviceNameLabel, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 20, 20, 10, 0);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.serviceNameField, 1, 0, 1, 1, 2, 13, 1.0, 0.0, 20, 0, 10, 20);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.programLabel, 0, 1, 1, 1, 2, 17, 1.0, 0.0, 0, 20, 10, 0);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.programField, 1, 1, 1, 1, 2, 13, 1.0, 0.0, 0, 0, 10, 20);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.argv0Label, 0, 2, 1, 1, 2, 17, 1.0, 0.0, 0, 20, 10, 0);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.argv0Field, 1, 2, 1, 1, 2, 13, 1.0, 0.0, 0, 0, 10, 20);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.argsLabel, 0, 3, 1, 1, 2, 17, 1.0, 0.0, 0, 20, 10, 0);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.argsField, 1, 3, 1, 1, 2, 13, 1.0, 0.0, 0, 0, 10, 20);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.envLabel, 0, 4, 1, 1, 2, 17, 1.0, 0.0, 0, 20, 10, 0);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.envField, 1, 4, 1, 1, 2, 13, 1.0, 0.0, 0, 0, 10, 20);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.sidLabel, 0, 5, 1, 1, 2, 17, 1.0, 0.0, 0, 20, 10, 0);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.sidField, 1, 5, 1, 1, 2, 13, 1.0, 0.0, 0, 0, 10, 20);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.oHomeLabel, 0, 6, 1, 1, 2, 17, 1.0, 0.0, 0, 20, 0, 0);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.oHomeField, 1, 6, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 20);
        ListenerGeneric.constrain((Container)((Object)this), (Component)new LWLabel(""), 0, 7, 2, 1, 0, 13, 1.0, 1.0, 0, 0, 0, 0);
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        char c = keyEvent.getKeyChar();
        if (object == this.sidField && !Character.isLetterOrDigit(c) && c != '_' && c != '\b') {
            keyEvent.consume();
            return;
        }
        this.changed = true;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setFocus() {
        this.netValidate.showDialog(this.invalidString);
        this.invalidField.requestFocus();
        this.invalidField.selectAll();
    }

    public boolean areDataValid() {
        if (this.serviceNameField.getText().length() > 0 && !this.netValidate.validateHostName(this.serviceNameField)) {
            this.invalidField = this.serviceNameField;
            this.invalidString = this.serviceNameLabel.getText();
            this.setFocus();
            return false;
        }
        if (this.programField.getText().length() == 0) {
            this.invalidField = this.programField;
            this.invalidString = this.programLabel.getText();
            this.setFocus();
            return false;
        }
        if (!NetValidate.validateSID(this.sidField.getText())) {
            this.invalidField = this.sidField;
            this.invalidString = this.sidLabel.getText();
            this.setFocus();
            return false;
        }
        return true;
    }

    public String toString() {
        String string = new String();
        string = String.valueOf(string) + "(SID_DESC=(GLOBAL_DBNAME=" + this.serviceNameField.getText() + ")" + "(PROGRAM=" + this.programField.getText() + ")" + "(ARGV0=" + this.argv0Field.getText() + ")" + "(ARGS=" + this.argsField.getText() + ")" + "(ENV=" + this.envField.getText() + ")" + "(SID_NAME=" + this.sidField.getText() + ")" + "(ORACLE_HOME=" + this.oHomeField.getText() + "))";
        return string;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }
}

