/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.listener.ListenerCache;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.asst.listener.ListenerOtherServicePage;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class ListenerOtherServices
extends EwtContainer
implements ListenerCache,
TabPanelListener,
ActionListener {
    private String name;
    private WebApplication app = ListenerGeneric.getApp();
    private boolean changed = false;
    private LWButton addButton;
    private LWButton removeButton;
    private LWButton helpButton;
    private String addString;
    private String removeString;
    private String helpString;
    private String serviceString;
    private TabPanel tp;
    private int serviceCount;
    private NetStrings ns = ListenerGeneric.getNS();
    private EwtContainer buttonPanel;
    private EwtContainer noServicesPanel;
    private LWLabel noServicesLabel;
    private LWLabel noServicesHintLabel;
    private NLParamParser nlpa = ListenerGeneric.getNLP();
    private final NVNavigator nav = new NVNavigator();
    private String otherHelpTopic = "TOPIClsnrOtherServices";
    private ListenerOtherServicePage currService;

    public ListenerOtherServices() {
        ListenerGeneric.devTrc("entered ListenerOtherServices");
        this.serviceString = new String(this.ns.getString("LCCService"));
        this.addString = new String(this.ns.getString("LCCAddService"));
        this.removeString = new String(this.ns.getString("LCCRemoveService"));
        this.helpString = new String(this.ns.getString("LCCHelp"));
        this.addButton = new LWButton(this.addString);
        this.addButton.addActionListener((ActionListener)this);
        this.removeButton = new LWButton(this.removeString);
        this.removeButton.addActionListener((ActionListener)this);
        this.removeButton.setEnabled(false);
        this.helpButton = new LWButton(this.helpString);
        this.helpButton.addActionListener((ActionListener)this);
        this.buttonPanel = new EwtContainer();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.noServicesPanel = new EwtContainer();
        this.noServicesPanel.setLayout(new GridBagLayout());
        this.noServicesLabel = new LWLabel(this.ns.getString("LCCNoServices"));
        this.noServicesHintLabel = new LWLabel(this.ns.getString("LCCNoServicesHint"));
        EwtContainer ewtContainer = this.noServicesPanel;
        LWLabel lWLabel = this.noServicesLabel;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)lWLabel, 0, 0, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        ewtContainer = this.noServicesPanel;
        lWLabel = this.noServicesHintLabel;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)lWLabel, 0, 1, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        ewtContainer = this;
        lWLabel = this.noServicesPanel;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)lWLabel, 0, 0, 1, 1, 1, 18, 100.0, 100.0, 0, 0, 0, 0);
        this.buttonPanel.add((Component)this.addButton);
        this.buttonPanel.add((Component)this.removeButton);
        this.buttonPanel.add((Component)this.helpButton);
        ewtContainer = this;
        lWLabel = this.buttonPanel;
        ListenerGeneric.constrain((Container)ewtContainer, (Component)lWLabel, 0, 1, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
    }

    public void addService(NVPair nVPair) {
        TabPanel tabPanel;
        if (this.tp == null) {
            tabPanel = new TabPanel();
            tabPanel.addTabPanelListener((TabPanelListener)this);
            ((Container)((Object)this)).remove((Component)this.noServicesPanel);
        } else {
            tabPanel = this.tp;
        }
        ListenerOtherServicePage listenerOtherServicePage = new ListenerOtherServicePage(nVPair);
        tabPanel.addPage(String.valueOf(this.serviceString) + ++this.serviceCount, (Component)((Object)listenerOtherServicePage));
        tabPanel.getPage(tabPanel.getPageCount() - 1).setSelected(true);
        listenerOtherServicePage.invalidate();
        this.validate();
        this.currService = listenerOtherServicePage;
        if (tabPanel.getPageCount() == 1) {
            this.removeButton.setEnabled(true);
        }
        if (this.tp == null) {
            this.tp = tabPanel;
        }
        ListenerOtherServices listenerOtherServices = this;
        TabPanel tabPanel2 = this.tp;
        ListenerGeneric.constrain((Container)((Object)listenerOtherServices), (Component)tabPanel2, 0, 0, 1, 1, 1, 18, 100.0, 100.0, 0, 0, 0, 0);
    }

    public void removeService() {
        TabPanelPage tabPanelPage = this.tp.getSelectedPage();
        this.tp.removeTabPanelListener((TabPanelListener)this);
        this.tp.removePage(tabPanelPage);
        this.tp.addTabPanelListener((TabPanelListener)this);
        --this.serviceCount;
        if (this.tp.getPageCount() == 0) {
            this.removeButton.setEnabled(false);
            this.tp.removeTabPanelListener((TabPanelListener)this);
            ((Container)((Object)this)).remove((Component)this.tp);
            this.tp = null;
            this.currService = null;
            ListenerOtherServices listenerOtherServices = this;
            EwtContainer ewtContainer = this.noServicesPanel;
            ListenerGeneric.constrain((Container)((Object)listenerOtherServices), (Component)ewtContainer, 0, 0, 1, 1, 1, 18, 100.0, 100.0, 0, 0, 0, 0);
            return;
        }
        this.currService = (ListenerOtherServicePage)((Object)this.tp.getSelectedPage().getContent());
        int n = 0;
        while (n < this.tp.getPageCount()) {
            this.tp.getPage(n).setLabel(String.valueOf(this.serviceString) + (n + 1));
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.addString)) {
            this.changed = true;
            if (this.currService != null && !this.currService.areDataValid()) {
                return;
            }
            this.addService(null);
            return;
        }
        if (string.equals(this.removeString)) {
            this.changed = true;
            this.removeService();
            return;
        }
        if (string.equals(this.helpString)) {
            ListenerGeneric.getHelp().show(this.otherHelpTopic);
            return;
        }
    }

    public void tabPanelSelectionChanged(TabPanelEvent tabPanelEvent) {
        this.currService = (ListenerOtherServicePage)((Object)tabPanelEvent.getPage().getContent());
    }

    public void tabPanelSelectionChanging(TabPanelEvent tabPanelEvent) {
        if (ListenerGeneric.allowInvalid()) {
            return;
        }
        if (this.currService != null && !this.currService.areDataValid()) {
            ((Cancelable)tabPanelEvent).cancel();
        }
    }

    public void setListenerName(String string) {
        this.name = string;
    }

    public void set() {
        Object object;
        NVPair nVPair = this.nlpa.getNLPListElement("SID_LIST_" + this.name);
        if (this.tp == null) {
            if (!this.changed) {
                return;
            }
            nVPair = this.stripOtherFromNVP(nVPair);
        } else {
            String[] stringArray = new String[this.tp.getPageCount()];
            int n = 0;
            while (n < this.tp.getPageCount()) {
                object = (ListenerOtherServicePage)((Object)this.tp.getPage(n).getContent());
                stringArray[n] = ((ListenerOtherServicePage)object).toString();
                if (((ListenerOtherServicePage)object).isChanged()) {
                    ((ListenerOtherServicePage)object).setChanged(false);
                    this.changed = true;
                }
                ++n;
            }
            if (this.changed) {
                NVPair nVPair2 = this.stripOtherFromNVP(nVPair);
                nVPair = this.addOtherToNVP(nVPair2, stringArray);
            } else {
                return;
            }
        }
        try {
            if (nVPair != null) {
                object = this.nav.findNVPair(nVPair, "SID_LIST");
                if (object == null || ((NVPair)object).getListSize() == 0) {
                    this.nlpa.removeNLPListElement("SID_LIST_" + this.name);
                } else {
                    this.nlpa.addNLPListElement(nVPair.toString());
                }
            }
        }
        catch (NLException nLException) {
            ListenerGeneric.devTrc("LOtherSvcs set failed");
        }
        this.changed = false;
    }

    public void get() {
        int n;
        NVPair nVPair;
        NVPair nVPair2;
        NVPair nVPair3 = this.nlpa.getNLPListElement("SID_LIST_" + this.name);
        if (nVPair3 != null) {
            nVPair2 = this.nav.findNVPair(nVPair3, "SID_DESC");
            if (nVPair2 != null) {
                nVPair = this.nav.findNVPair(nVPair2, "PROGRAM");
                if (nVPair != null) {
                    this.addService(nVPair2);
                }
            } else {
                nVPair2 = this.nav.findNVPair(nVPair3, "SID_LIST");
                if (nVPair2 != null) {
                    n = 0;
                    while (n < nVPair2.getListSize()) {
                        nVPair = this.nav.findNVPair(nVPair2.getListElement(n), "PROGRAM");
                        if (nVPair != null) {
                            this.addService(nVPair2.getListElement(n));
                        }
                        ++n;
                    }
                }
            }
        }
        if ((nVPair3 = this.nlpa.getNLPListElement("SERVICE_LIST_" + this.name)) != null) {
            this.changed = true;
            nVPair2 = this.nav.findNVPair(nVPair3, "SERVICE_DESC");
            if (nVPair2 != null) {
                nVPair = this.nav.findNVPair(nVPair2, "PROGRAM");
                if (nVPair != null) {
                    this.addService(nVPair2);
                }
            } else {
                nVPair2 = this.nav.findNVPair(nVPair3, "SERVICE_LIST");
                if (nVPair2 != null) {
                    n = 0;
                    while (n < nVPair2.getListSize()) {
                        nVPair = this.nav.findNVPair(nVPair2.getListElement(n), "PROGRAM");
                        if (nVPair != null) {
                            this.addService(nVPair2.getListElement(n));
                        }
                        ++n;
                    }
                }
            }
            this.nlpa.removeNLPListElement("SERVICE_LIST_" + this.name);
        }
    }

    private NVPair addOtherToNVP(NVPair nVPair, String[] stringArray) {
        if (stringArray.length == 0) {
            return nVPair;
        }
        NVFactory nVFactory = new NVFactory();
        NVPair nVPair2 = this.nav.findNVPair(nVPair, "SID_DESC");
        if (nVPair2 != null) {
            nVPair = nVFactory.createNVPair("(SID_LIST_" + this.name + "=(SID_LIST=" + nVPair2.toString() + "))");
        }
        if ((nVPair2 = this.nav.findNVPair(nVPair, "SID_LIST")) == null) {
            nVPair = nVFactory.createNVPair("(SID_LIST_" + this.name + "=(SID_LIST=))");
        }
        nVPair2 = this.nav.findNVPair(nVPair, "SID_LIST");
        int n = 0;
        while (n < stringArray.length) {
            nVPair2.addListElement(nVFactory.createNVPair(stringArray[n]));
            ++n;
        }
        return nVPair;
    }

    private NVPair stripOtherFromNVP(NVPair nVPair) {
        if (nVPair != null) {
            NVPair nVPair2 = this.nav.findNVPair(nVPair, "SID_DESC");
            if (nVPair2 != null) {
                if (this.nav.findNVPair(nVPair2, "PROGRAM") != null) {
                    return null;
                }
                return nVPair;
            }
            nVPair2 = this.nav.findNVPair(nVPair, "SID_LIST");
            if (nVPair2 == null) {
                return null;
            }
            int n = 0;
            while (n < nVPair2.getListSize()) {
                NVPair nVPair3 = nVPair2.getListElement(n);
                if (this.nav.findNVPair(nVPair3, "PROGRAM") != null) {
                    nVPair2.removeListElement(n);
                    --n;
                }
                ++n;
            }
            if (nVPair.getListSize() > 0) {
                return nVPair;
            }
            return null;
        }
        return null;
    }

    public boolean isChanged() {
        if (this.changed) {
            return true;
        }
        if (this.tp == null) {
            return false;
        }
        int n = 0;
        while (n < this.tp.getPageCount()) {
            ListenerOtherServicePage listenerOtherServicePage = (ListenerOtherServicePage)((Object)this.tp.getPage(n).getContent());
            if (listenerOtherServicePage.isChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean areDataValid() {
        if (this.tp == null) {
            return true;
        }
        int n = 0;
        while (n < this.tp.getPageCount()) {
            if (!((ListenerOtherServicePage)((Object)this.tp.getPage(n).getContent())).areDataValid()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setFocus() {
    }
}

