/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.alert.Alert;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesCache;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.profile.NetAddr;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NamesAddress
extends EwtContainer
implements NamesCache,
ActionListener,
ItemListener {
    NetStrings ns = new NetStrings();
    private String[][] itemNames = new String[][]{{this.ns.getString("nnaAddress"), "NS1", "names.addresses"}};
    private String addString = this.ns.getString("nnaAdd");
    private String removeString = this.ns.getString("nnaRemove");
    private String changeString = this.ns.getString("nnaChange");
    private LWTextField[] itemText;
    private LWList curList;
    private LWLabel l;
    private LWCheckbox cb;
    private LWButton addButton;
    private LWButton removeButton;
    private LWButton changeButton;
    private EwtContainer buttonPanel;
    private EwtContainer outPanel;
    private GridBagConstraints gbc;
    private NetAddr addrPanel;
    private Vector addrVector = new Vector(3);
    private NLParamParser nlpa;
    private NVFactory nvfactory = new NVFactory();
    private int curaddrIndex;
    private boolean changed;
    private boolean addressRemoved;

    public NamesAddress() {
        this.buttonPanel = new EwtContainer();
        this.buttonPanel.setLayout(new FlowLayout());
        this.addButton = new LWButton(this.addString);
        this.buttonPanel.add((Component)this.addButton);
        this.addButton.addActionListener((ActionListener)this);
        this.removeButton = new LWButton(this.removeString);
        this.buttonPanel.add((Component)this.removeButton);
        this.removeButton.addActionListener((ActionListener)this);
        this.changeButton = new LWButton(this.changeString);
        this.buttonPanel.add((Component)this.changeButton);
        this.changeButton.addActionListener((ActionListener)this);
        this.removeButton.setEnabled(false);
        this.changeButton.setEnabled(false);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.outPanel = new EwtContainer();
        this.outPanel.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.fill = 2;
        NVPair nVPair = this.nvfactory.createNVPair("(Address=(protocol=tcp))");
        this.addrPanel = new NetAddr(nVPair);
        this.addrPanel.setAppEnv(NetUtils.getApplication());
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 10;
        this.gbc.insets.top = 10;
        this.outPanel.add((Component)((Object)this.addrPanel), this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.insets.top = 0;
        this.outPanel.add((Component)this.buttonPanel, this.gbc);
        this.curList = new LWList(5, false);
        this.curList.addItemListener((ItemListener)this);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 1;
        this.outPanel.add((Component)this.curList, this.gbc);
        ((Container)((Object)this)).add((Component)this.outPanel, "Center");
    }

    public void setNLP(NLParamParser nLParamParser) {
        this.nlpa = nLParamParser;
    }

    public void get() {
        this.curaddrIndex = 0;
        this.changed = false;
        if (this.nlpa == null) {
            return;
        }
        int n = 0;
        while (n < this.itemNames.length) {
            this.curList.removeAll();
            this.addrVector.removeAllElements();
            NVPair nVPair = this.nlpa.getNLPListElement(new String(this.itemNames[n][2]));
            if (nVPair != null) {
                String string = (nVPair = nVPair.getListElement(0)).getName();
                if (string.equalsIgnoreCase("Address_list")) {
                    this.doAddrList(nVPair);
                } else {
                    this.addAddrPanel(nVPair);
                }
            } else if (this.nlpa.getNLPListElement("names.server_name") != null) {
                nVPair = this.nvfactory.createNVPair("(Address=(protocol=tcp)(port=1575)(host=" + NamesGeneric.getLocalHost() + "))");
                this.addAddrPanel(nVPair);
            }
            ++n;
        }
    }

    public void set() {
        NVPair nVPair;
        new NVNavigator();
        if (this.nlpa == null) {
            return;
        }
        int n = this.addrVector.size();
        if (n == 0) {
            return;
        }
        if (n == 1) {
            nVPair = this.nvfactory.createNVPair(this.addrVector.elementAt(0).toString());
        } else {
            nVPair = this.nvfactory.createNVPair("(Address_List=)");
            int n2 = 0;
            while (n2 < this.addrVector.size()) {
                nVPair.addListElement((NVPair)this.addrVector.elementAt(n2));
                ++n2;
            }
        }
        try {
            this.nlpa.addNLPListElement(String.valueOf(this.itemNames[0][2]) + "=" + nVPair.toString());
        }
        catch (NLException nLException) {}
        this.changed = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof LWButton) {
            int n;
            if (actionEvent.getActionCommand().compareTo(this.addString) == 0) {
                if (!this.addrPanel.areDataValid()) {
                    this.addrPanel.setFocus();
                    return;
                }
                NVPair nVPair = this.addrPanel.getAddr();
                if (nVPair == null) {
                    String string = this.ns.getString("nnaError");
                    String string2 = this.ns.getString("nnaAddressNull");
                    NamesDialog.popUp(string, string2, 2);
                    this.addrPanel.setFocus();
                    return;
                }
                NVPair nVPair2 = this.nvfactory.createNVPair(nVPair.toString());
                if (this.checkDups(nVPair2)) {
                    String string = this.ns.getString("nnaError");
                    String string3 = this.ns.getString("nnaSameAddr");
                    NamesDialog.popUp(string, string3, 2);
                    return;
                }
                this.addrVector.addElement(nVPair2);
                this.curList.addItem(nVPair.toString().toLowerCase());
                this.changed = true;
                return;
            }
            if (actionEvent.getActionCommand().compareTo(this.removeString) == 0) {
                int n2 = this.curList.getSelectedIndex();
                if (n2 >= 0) {
                    this.addressRemoved = true;
                    NVPair nVPair = this.nvfactory.createNVPair(this.curList.getSelectedItem());
                    this.curList.remove(n2);
                    this.addrVector.removeElementAt(n2);
                    int n3 = this.curList.getSelectedIndex();
                    if (n3 > 0) {
                        this.curList.deselect(n3);
                    }
                    this.removeButton.setEnabled(false);
                    this.changeButton.setEnabled(false);
                    this.changed = true;
                    return;
                }
            } else if (actionEvent.getActionCommand().compareTo(this.changeString) == 0 && (n = this.curList.getSelectedIndex()) >= 0) {
                if (!this.addrPanel.areDataValid()) {
                    this.addrPanel.setFocus();
                    return;
                }
                NVPair nVPair = this.addrPanel.getAddr();
                if (nVPair == null) {
                    String string = this.ns.getString("nnaError");
                    String string4 = this.ns.getString("nnaAddressNull");
                    NamesDialog.popUp(string, string4, 2);
                    this.addrPanel.setFocus();
                    return;
                }
                NVPair nVPair3 = this.nvfactory.createNVPair(nVPair.toString());
                if (this.checkDups(nVPair3)) {
                    String string = this.ns.getString("nnaError");
                    String string5 = this.ns.getString("nnaSameAddr");
                    NamesDialog.popUp(string, string5, 2);
                    return;
                }
                this.addrVector.removeElementAt(n);
                this.addrVector.insertElementAt(nVPair3, n);
                this.curList.remove(n);
                this.curList.addItem(this.addrPanel.getAddr().toString().toLowerCase(), n);
                int n4 = this.curList.getSelectedIndex();
                if (n4 > 0) {
                    this.curList.deselect(n4);
                }
                this.changeButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                this.changed = true;
            }
        }
    }

    private void doAddrList(NVPair nVPair) {
        int n = 0;
        while (n < nVPair.getListSize()) {
            this.addAddrPanel(nVPair.getListElement(n));
            ++n;
        }
    }

    private void addAddrPanel(NVPair nVPair) {
        this.addrVector.addElement(this.nvfactory.createNVPair(nVPair.toString()));
        this.curList.addItem(nVPair.toString().toLowerCase());
    }

    private void displayAddrPanel(NVPair nVPair) {
        this.curList.addItem(nVPair.toString());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = itemEvent.getStateChange();
        if (n == 1) {
            this.removeButton.setEnabled(true);
            this.changeButton.setEnabled(true);
            NVPair nVPair = this.nvfactory.createNVPair(this.curList.getSelectedItem());
            this.addrPanel.display(nVPair);
        }
    }

    public boolean isDataValid() {
        if (this.addressRemoved && this.addrVector.size() == 0) {
            Frame frame = NetUtils.getApplication().getFrame();
            Alert alert = new Alert(frame, this.ns.getString("nnaZeroAddressesError"), 0, 1);
            alert.runAlert();
            return false;
        }
        return true;
    }

    public void setFocus() {
    }

    public boolean isChanged() {
        return this.changed;
    }

    private boolean checkDups(NVPair nVPair) {
        String string = nVPair.toString();
        int n = 0;
        while (n < this.addrVector.size()) {
            if (string.equalsIgnoreCase(this.addrVector.elementAt(n).toString())) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

