/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesValidate;
import oracle.net.asst.names.TimePanel;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NamesAdvMisc
extends BufferedDialog {
    NetStrings ns = new NetStrings();
    private String[][] miscNames = new String[][]{{this.ns.getString("nnaMaxOpenConn"), "10", "names.max_open_connections"}, {this.ns.getString("nnaMsgPoolSize"), "10", "names.message_pool_start_size"}, {this.ns.getString("nnaAutoRefreshExp"), "259200", "names.auto_refresh_expire"}, {this.ns.getString("nnaAutoRefreshRetry"), "180", "names.auto_refresh_retry"}};
    private static final short timeItemsBegin = 2;
    private String[] newValues = new String[this.miscNames.length];
    private MarginBorder sharedBorderPixel;
    private int i;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel l;
    private EwtContainer timePanel;
    private EwtContainer miscPanel;
    private EwtContainer buttonPanel;
    private EwtContainer namePanel;
    private EwtContainer[] tpPanel;
    private TimePanel[] tp;
    private LWTextField[] itemText;
    private LWButton ok;
    private LWButton cancel;
    private LWContainer topPanel;

    public NamesAdvMisc(BufferedFrame bufferedFrame, String string, ActionListener actionListener, String[] stringArray) {
        super((Frame)bufferedFrame, string, true);
        NamesGeneric.debugTracing("Entering NamesAdvMisc");
        if (stringArray.length != this.miscNames.length) {
            NamesGeneric.debugTracing("wrong misc data");
            return;
        }
        this.topPanel = new LWContainer();
        this.setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.topPanel, "Center");
        this.topPanel.setLayout(new BorderLayout());
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.fill = 0;
        this.sharedBorderPixel = new MarginBorder(5, 5, 5, 5);
        this.miscPanel = new EwtContainer();
        this.miscPanel.setLayout(this.gb);
        this.miscPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaAdvTuning"), InsetFramePainter.getFramePainter(), 2));
        this.itemText = new LWTextField[this.miscNames.length - 2];
        this.namePanel = new EwtContainer();
        this.namePanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.namePanel, this.gbc);
        this.miscPanel.add((Component)this.namePanel);
        this.i = 0;
        while (this.i < 2) {
            this.gbc.gridx = 0;
            this.gbc.gridy = this.i;
            this.l = new LWLabel(new String(this.miscNames[this.i][0]), 1);
            this.gb.setConstraints((Component)this.l, this.gbc);
            this.namePanel.add((Component)this.l);
            ++this.gbc.gridx;
            this.itemText[this.i] = new LWTextField(20);
            this.gb.setConstraints((Component)this.itemText[this.i], this.gbc);
            this.namePanel.add((Component)this.itemText[this.i]);
            if (stringArray[this.i] != null) {
                this.itemText[this.i].setText(stringArray[this.i]);
            } else {
                this.itemText[this.i].setText(this.miscNames[this.i][1]);
            }
            ++this.i;
        }
        this.tp = new TimePanel[2];
        this.tpPanel = new EwtContainer[2];
        this.i = 2;
        while (this.i < this.miscNames.length) {
            int n = this.i - 2;
            this.gbc.gridx = 0;
            this.gbc.gridy = this.i + 1;
            this.tpPanel[n] = new EwtContainer();
            this.tpPanel[n].setLayout(this.gb);
            this.gb.setConstraints((Component)this.tpPanel[n], this.gbc);
            this.tpPanel[n].setBorder((Border)new GroupBoxBorder(this.miscNames[this.i][0], InsetFramePainter.getFramePainter(), 2));
            this.miscPanel.add((Component)this.tpPanel[n]);
            ++this.gbc.gridx;
            this.tp[n] = new TimePanel(true, true, true);
            this.gb.setConstraints((Component)((Object)this.tp[n]), this.gbc);
            this.tpPanel[n].add((Component)((Object)this.tp[n]));
            if (stringArray[this.i] != null) {
                this.tp[n].setTime(Integer.parseInt(stringArray[this.i], 10));
            } else {
                this.tp[n].setTime(Integer.parseInt(this.miscNames[this.i][1], 10));
            }
            ++this.i;
        }
        this.buttonPanel = new EwtContainer();
        this.buttonPanel.setLayout(new FlowLayout(0));
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.buttonPanel, this.gbc);
        this.miscPanel.add((Component)this.buttonPanel);
        this.ok = new LWButton(this.ns.getString("nnaOk"));
        this.ok.addActionListener(actionListener);
        this.buttonPanel.add((Component)this.ok);
        this.cancel = new LWButton(this.ns.getString("nnaCancel"));
        this.cancel.addActionListener(actionListener);
        this.buttonPanel.add((Component)this.cancel);
        this.topPanel.add((Component)this.miscPanel, "Center");
        ((Window)((Object)this)).pack();
        NamesGeneric.debugTracing("Exitting NamesAdvMisc");
    }

    public boolean checkMiscValues() {
        NamesGeneric.debugTracing("Entering NamesAdvMisc:checkMiscValues");
        int n = 0;
        while (n < 2) {
            if (!NamesValidate.validateNumerical(this.itemText[n], this.miscNames[n][0])) {
                this.itemText[n].requestFocus();
                return false;
            }
            this.newValues[n] = this.itemText[n].getText();
            ++n;
        }
        n = 2;
        while (n < this.miscNames.length) {
            int n2 = n - 2;
            if (!NamesValidate.validateTimeField(this.tp[n2], this.miscNames[n][0])) {
                return false;
            }
            this.newValues[n] = String.valueOf(this.tp[n2].getTimeInSec());
            ++n;
        }
        return true;
    }

    public void getMiscValues(String[] stringArray) {
        NamesGeneric.debugTracing("Entering NamesAdvMisc:getMiscValues");
        if (stringArray.length != this.miscNames.length) {
            NamesGeneric.debugTracing("wrong misc data");
            return;
        }
        int n = 0;
        while (n < this.miscNames.length) {
            stringArray[n] = this.newValues[n];
            ++n;
        }
        NamesGeneric.debugTracing("Exiting NamesAdvMisc:getMiscValues");
    }

    public boolean isDialogChanged(NLParamParser nLParamParser) {
        NamesGeneric.debugTracing("Entering NamesAdvMisc:isDialogChanged");
        int n = 0;
        while (n < this.miscNames.length) {
            NVPair nVPair = nLParamParser.getNLPListElement(new String(this.miscNames[n][2]));
            if (nVPair != null ? !this.newValues[n].equalsIgnoreCase(nVPair.getAtom()) : !this.newValues[n].equalsIgnoreCase(this.miscNames[n][1])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void dlgShow() {
        Dimension dimension = ((Component)((Object)this)).getParent().getSize();
        Dimension dimension2 = ((Component)((Object)this)).getSize();
        Point point = ((Component)((Object)this)).getParent().getLocation();
        int n = point.x + (dimension.width - dimension2.width) / 2;
        int n2 = point.y + (dimension.height - dimension2.height) / 2;
        ((Component)((Object)this)).setBounds(n, n2, dimension2.width, dimension2.height);
        ((Dialog)((Object)this)).show();
        if (NamesGeneric.OS.equals("Windows NT") || NamesGeneric.OS.equals("Windows 95")) {
            NamesGeneric.appFrame.toFront();
        }
    }
}

