/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesValidate;
import oracle.net.asst.names.TimePanel;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NamesAdvRegion
extends BufferedDialog {
    NetStrings ns = new NetStrings();
    private String[][] optNames = new String[][]{{this.ns.getString("nnaRegionName"), "LOCAL_REGION", "NAME"}, {this.ns.getString("nnaRefresh"), "86400", "REFRESH"}, {this.ns.getString("nnaRetry"), "60", "RETRY"}, {this.ns.getString("nnaExpire"), "600", "EXPIRE"}};
    private String[] newValues = new String[this.optNames.length];
    private int i;
    private int j;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel l;
    private EwtContainer timePanel;
    private EwtContainer advPanel;
    private EwtContainer buttonPanel;
    private EwtContainer namePanel;
    private EwtContainer[] tpPanel;
    private TimePanel[] tp;
    private LWButton ok;
    private LWButton cancel;
    private LWTextField itemText;
    private LWContainer topPanel;

    public NamesAdvRegion(BufferedFrame bufferedFrame, String string, ActionListener actionListener, String[] stringArray) {
        super((Frame)bufferedFrame, string, true);
        NamesGeneric.debugTracing("Entering NamesAdvRegion");
        if (stringArray.length != this.optNames.length) {
            NamesGeneric.debugTracing("wrong time data");
            return;
        }
        this.topPanel = new LWContainer();
        this.setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.topPanel, "Center");
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.fill = 2;
        this.advPanel = new EwtContainer();
        this.advPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.advPanel, this.gbc);
        this.advPanel.setBorderPainter(UIManager.createGroupBoxPainter((String)this.ns.getString("nnaOptionalParam")));
        this.namePanel = new EwtContainer();
        this.namePanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gb.setConstraints((Component)this.namePanel, this.gbc);
        this.advPanel.add((Component)this.namePanel);
        this.timePanel = new EwtContainer();
        this.timePanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.timePanel, this.gbc);
        this.advPanel.add((Component)this.timePanel);
        this.buttonPanel = new EwtContainer();
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.buttonPanel, this.gbc);
        this.advPanel.add((Component)this.buttonPanel);
        this.tp = new TimePanel[this.optNames.length];
        this.tpPanel = new EwtContainer[this.optNames.length];
        this.i = 1;
        while (this.i < this.optNames.length) {
            this.j = this.i - 1;
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
            this.tpPanel[this.j] = new EwtContainer();
            this.tpPanel[this.j].setLayout(this.gb);
            this.gb.setConstraints((Component)this.tpPanel[this.j], this.gbc);
            this.tpPanel[this.j].setBorderPainter(UIManager.createGroupBoxPainter((String)this.optNames[this.i][0]));
            this.timePanel.add((Component)this.tpPanel[this.j]);
            this.tp[this.j] = new TimePanel(true, true, true);
            this.gb.setConstraints((Component)((Object)this.tp[this.j]), this.gbc);
            this.tpPanel[this.j].add((Component)((Object)this.tp[this.j]));
            if (stringArray[this.i] != null) {
                this.tp[this.j].setTime(Integer.parseInt(stringArray[this.i], 10));
            } else {
                this.tp[this.j].setTime(Integer.parseInt(this.optNames[this.i][1], 10));
            }
            ++this.i;
        }
        this.gbc.gridx = 0;
        this.l = new LWLabel(new String(this.optNames[0][0]), 1);
        this.gb.setConstraints((Component)this.l, this.gbc);
        this.namePanel.add((Component)this.l);
        ++this.gbc.gridx;
        this.itemText = new LWTextField(15);
        this.gb.setConstraints((Component)this.itemText, this.gbc);
        this.namePanel.add((Component)this.itemText);
        if (stringArray[0] != null) {
            this.itemText.setText(stringArray[0]);
        } else {
            this.itemText.setText(this.optNames[0][1]);
        }
        this.ok = new LWButton(this.ns.getString("nnaOk"));
        this.ok.addActionListener(actionListener);
        this.ok.setLeftmost(true);
        this.buttonPanel.add((Component)this.ok);
        this.cancel = new LWButton(this.ns.getString("nnaCancel"));
        this.cancel.addActionListener(actionListener);
        this.cancel.setRightmost(true);
        this.buttonPanel.add((Component)this.cancel);
        this.topPanel.add((Component)this.advPanel, "Center");
        this.itemText.requestFocus();
        ((Window)((Object)this)).pack();
        NamesGeneric.debugTracing("Exitting NamesAdvRegion");
    }

    public boolean checkOptValues() {
        NamesGeneric.debugTracing("Entering NamesAdvRegion:checkOptValues");
        if (!NamesValidate.validateText(this.itemText, this.optNames[0][0])) {
            this.itemText.requestFocus();
            return false;
        }
        this.newValues[0] = this.itemText.getText();
        int n = 1;
        while (n < this.optNames.length) {
            if (!NamesValidate.validateTimeField(this.tp[n - 1], this.optNames[n][0])) {
                return false;
            }
            this.newValues[n] = String.valueOf(this.tp[n - 1].getTimeInSec());
            ++n;
        }
        return true;
    }

    public void getOptValues(String[] stringArray) {
        NamesGeneric.debugTracing("Entering NamesAdvRegion:getOptValues");
        if (stringArray.length != this.optNames.length) {
            NamesGeneric.debugTracing("wrong opt data");
            return;
        }
        int n = 0;
        while (n < this.optNames.length) {
            stringArray[n] = this.newValues[n];
            ++n;
        }
        NamesGeneric.debugTracing("Exitting NamesAdvRegion:getOptValues");
    }

    public boolean isDialogChanged(NLParamParser nLParamParser) {
        NamesGeneric.debugTracing("Entering NamesAdvRegion:isDialogChanged");
        int n = 0;
        while (n < this.optNames.length) {
            NVPair nVPair = nLParamParser.getNLPListElement(new String(this.optNames[n][2]));
            if (nVPair != null ? !this.newValues[n].equalsIgnoreCase(nVPair.getAtom()) : !this.newValues[n].equalsIgnoreCase(this.optNames[n][1])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void dlgShow() {
        Dimension dimension = ((Component)((Object)this)).getParent().getSize();
        Dimension dimension2 = ((Component)((Object)this)).getSize();
        BufferedFrame bufferedFrame = NamesGeneric.appFrame;
        Point point = ((Component)((Object)this)).getParent().getLocation();
        int n = point.x + (dimension.width - dimension2.width) / 2;
        int n2 = point.y + (dimension.height - dimension2.height) / 2;
        ((Component)((Object)this)).setBounds(n, n2, dimension2.width, dimension2.height);
        ((Dialog)((Object)this)).show();
        if (NamesGeneric.OS.equals("Windows NT") || NamesGeneric.OS.equals("Windows 95")) {
            bufferedFrame.toFront();
        }
    }
}

