/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.alert.Alert;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeExpansionListener;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemEvent;
import oracle.ewt.dTree.DTreeSelectionEvent;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.net.asst.component.NetComponent;
import oracle.net.asst.component.NetObjectMenu;
import oracle.net.asst.component.NetObjectToolbar;
import oracle.net.asst.component.NetVector;
import oracle.net.asst.container.NetContainer;
import oracle.net.asst.container.NetNameDialog;
import oracle.net.asst.container.NetPanel;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.container.NetValidate;
import oracle.net.asst.names.NamesAdmin;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.SdnsDialog;
import oracle.net.asst.names.control;
import oracle.net.asst.names.nnccj;
import oracle.net.asst.nameswizard.NamesWizardMain;
import oracle.net.common.NetProperties;
import oracle.net.common.dataStore.DataStore;
import oracle.net.common.dataStore.FileDataStore;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.DataDrivenTree;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeChildNode;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSource;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItem;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItemData;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeNodeSelectionListener;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeParentNode;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeProxy;

public class NamesComponent
extends NetComponent
implements ActionListener {
    NetStrings ns = new NetStrings();
    private NetVector objectVector;
    private Vector addrVector;
    private NetVector toolbarVect;
    private NetVector menuVect;
    private NetObjectMenu renameMenuItem;
    private control control;
    private nnccj nnccj;
    private NamesAdmin namesAdmin;
    private String oraNames;
    private String sdns_filename;
    private String names_filename;
    private final String FILENAME = "names.ora";
    private EwtContainer nsPanel;
    private String title;
    private String default_name = "onames_" + NamesGeneric.getLocalHost();
    private String default_addr = "(address=(host=" + NamesGeneric.getLocalHost() + ")(protocol=tcp)(port=1575))";
    private final NVNavigator nvnav = new NVNavigator();
    private final NVFactory nvfact = new NVFactory();
    private WebApplication theApp;
    private NetContainer theContainer;
    private BufferedFrame theAppFrame;
    private FileDataStore fds;
    private String selectedServer;
    private TreeParentNode myTreeNode;
    private SdnsDialog sdnsDialog;
    private boolean changed;
    private boolean loaded;
    private boolean commentsFound;

    private NamesComponent() {
    }

    public NamesComponent(WebApplication webApplication, DataStore dataStore) {
        NetProperties netProperties;
        this.theApp = webApplication;
        this.theAppFrame = (BufferedFrame)this.theApp.getFrame();
        this.theContainer = NetUtils.getContainer();
        if (dataStore instanceof FileDataStore) {
            this.fds = (FileDataStore)dataStore;
        }
        this.oraNames = NamesGeneric.getOraNames();
        this.nsPanel = new NetPanel(webApplication, "NS_placebo.gif", this.ns.getString("nnaIntroMessage"));
        try {
            netProperties = NetProperties.getInstance();
            NamesGeneric.setDebug(netProperties.getProperty("NamesTrace"));
        }
        catch (Exception exception) {
            NamesGeneric.debugTracing("io exception " + exception.getMessage());
        }
        NamesGeneric.debugTracing("Entering class:NamesComponent");
        netProperties = (BufferedFrame)NetUtils.getApplication().getFrame();
        NamesGeneric.appFrame = netProperties;
        this.toolbarVect = new NetVector();
        this.toolbarVect.addElement(new NetObjectToolbar(this.ns.getString("CNTCreate"), null, true));
        this.menuVect = new NetVector();
        this.menuVect.addElement(new NetObjectMenu(this.ns.getString("CNTTools"), this.ns.getString("nnaDiscNS"), true));
        this.menuVect.addElement(new NetObjectMenu(this.ns.getString("CNTTools"), this.ns.getString("nnaReloadNS"), true));
        this.renameMenuItem = new NetObjectMenu(this.ns.getString("CNTEdit"), this.ns.getString("CNTRename"), true);
        this.menuVect.addElement(this.renameMenuItem);
        this.menuVect.addElement(new NetObjectMenu(this.ns.getString("CNTEdit"), this.ns.getString("CNTCreate"), true));
        NamesGeneric.debugTracing("Exiting NamesComponent.<init>");
    }

    public DataStore getDataStore() {
        return this.fds;
    }

    public TreeItem getTreeNode(DataDrivenTree dataDrivenTree) {
        if (this.myTreeNode == null) {
            NamesProxy namesProxy = new NamesProxy(dataDrivenTree);
            this.myTreeNode = new TreeParentNode((TreeDataSource)new NamesDataSource(dataDrivenTree), (TreeProxy)namesProxy, "oracle_sysman_netasst_names_comp");
        }
        this.myTreeNode.setExpanded(false);
        return this.myTreeNode;
    }

    private void loadData() {
        File file;
        String string;
        String string2;
        Object object;
        NamesGeneric.debugTracing("Entering NamesComponent:loadObjects");
        this.changed = false;
        this.objectVector = new NetVector();
        this.addrVector = new Vector();
        this.names_filename = String.valueOf(this.fds.getAdminDir()) + "names.ora";
        NamesGeneric.debugTracing("names file is " + this.names_filename);
        NamesGeneric.debugTracing("dir is " + this.oraNames);
        this.sdns_filename = NamesGeneric.OS.startsWith("Windows") ? String.valueOf(this.oraNames) + "sdns.ora" : String.valueOf(this.oraNames) + ".sdns.ora";
        NamesGeneric.debugTracing("sdns file is " + this.sdns_filename);
        Vector vector = null;
        try {
            vector = this.readSDNSFile(this.sdns_filename);
        }
        catch (IOException iOException) {}
        if (vector != null && vector.size() > 0) {
            this.addrVector = new Vector(vector.size());
            int n = 1;
            while (n < vector.size()) {
                object = (String)vector.elementAt(n);
                int n2 = ((String)object).indexOf(61);
                if (n2 == -1) {
                    NamesGeneric.debugTracing(".sdns.ora is corrupted");
                    string2 = this.ns.getString("nnaSdnsCorrupt");
                    string = this.ns.getString("nnaError");
                    NamesDialog.popUp(string, string2, 2);
                } else {
                    string2 = ((String)object).substring(0, n2).trim();
                    string = ((String)object).substring(n2 + 1).trim();
                    this.objectVector.addElement(string2);
                    this.addrVector.addElement(string);
                }
                ++n;
            }
        }
        if ((file = new File(this.names_filename)).exists()) {
            try {
                object = null;
                NVPair nVPair = null;
                try {
                    object = new NLParamParser(this.names_filename);
                    if (!this.commentsFound) {
                        this.commentsFound = ((NLParamParser)object).fileHasComments();
                    }
                }
                catch (Throwable throwable) {
                    NamesGeneric.debugTracing(throwable.toString());
                }
                string2 = (nVPair = ((NLParamParser)object).getNLPListElement("names.server_name")) != null ? nVPair.getAtom() : this.default_name;
                nVPair = ((NLParamParser)object).getNLPListElement("names.addresses");
                if (nVPair != null) {
                    NVPair nVPair2 = this.nvnav.findNVPairRecurse(nVPair, "address");
                    string = nVPair2.toString();
                } else {
                    string = this.default_addr;
                }
                if (!this.addrPresent(string)) {
                    this.addrVector.addElement(string);
                    this.objectVector.addElement(string2);
                }
            }
            catch (Exception exception) {
                NamesGeneric.debugTracing(String.valueOf(exception) + ": names.ora");
            }
        }
        try {
            if (this.nnccj == null) {
                this.nnccj = new nnccj(0);
            }
            if (this.control == null) {
                this.control = new control();
            }
            if (this.namesAdmin == null) {
                this.namesAdmin = new NamesAdmin();
            }
            this.namesAdmin.activate(this.names_filename);
        }
        catch (Throwable throwable) {
            NamesGeneric.debugTracing("error while activating namesAdmin: " + throwable);
        }
        this.loaded = true;
        NamesGeneric.debugTracing("Exiting NamesComponent::loadObjects");
    }

    public boolean save(DataStore dataStore) {
        NamesGeneric.debugTracing("Entering/Exiting NamesComponent:saveObjects");
        if (!this.loaded) {
            this.loadData();
        }
        if (!this.namesAdmin.validateConfig()) {
            return true;
        }
        if (!(dataStore instanceof FileDataStore)) {
            return true;
        }
        this.fds = (FileDataStore)dataStore;
        this.changed = false;
        return this.namesAdmin.save(String.valueOf(this.fds.getAdminDir()) + "names.ora");
    }

    public NetVector getComponentMenus() {
        NamesGeneric.debugTracing("Entering/Exiting NamesComponent:getComponentMenus");
        return this.menuVect;
    }

    public NetVector getComponentToolbar() {
        NamesGeneric.debugTracing("Entering/Exiting NamesComponent:getComponentToolbars");
        return this.toolbarVect;
    }

    public void create(Object object) {
        NamesGeneric.debugTracing("Entering NamesComponent:createObject");
        try {
            File file = new File(String.valueOf(this.fds.getAdminDir()) + "names.ora");
            if (file.exists()) {
                String string = this.ns.getString("nnaNSExists");
                String string2 = this.ns.getString("nnaNSExists");
                NamesDialog.popUp(string, string2, 2);
                return;
            }
            Cursor cursor = Cursor.getDefaultCursor();
            NamesGeneric.appFrame.setCursor(new Cursor(3));
            if (!this.loaded) {
                this.loadData();
            }
            NamesWizardMain namesWizardMain = new NamesWizardMain(NamesGeneric.appFrame, this.fds.getAdminDir());
            namesWizardMain.go();
            NamesGeneric.appFrame.setCursor(cursor);
            if (NamesGeneric.OS.startsWith("Windows")) {
                NamesGeneric.appFrame.toFront();
            }
            if (!namesWizardMain.getWizardFinishState()) {
                return;
            }
            this.default_name = namesWizardMain.getServerName();
            this.default_addr = namesWizardMain.getServerAddress();
            this.objectVector.addElement(this.default_name);
            this.addrVector.addElement(this.default_addr);
            this.namesAdmin.activate(this.names_filename);
            Object[] objectArray = new Object[]{this.default_name, this.ns.getString("nnaConfigure")};
            String string = this.ns.getString("nnaNSCreated");
            String string3 = this.ns.getString("nnaNSCreatedText", objectArray);
            NamesDialog.popUp(string, string3, 2);
            NamesGeneric.newServerConfig = true;
            NamesGeneric.debugTracing("Exiting NamesComponent:createObject");
            ((DataDrivenTree)this.myTreeNode.getTree()).refreshTree((DTreeItem)this.myTreeNode);
            this.myTreeNode.setExpanded(true);
            this.selectChildNode(this.default_name);
            return;
        }
        catch (Exception exception) {
            NamesGeneric.debugTracing(exception.toString());
            return;
        }
    }

    public void refresh(DataStore dataStore) {
        NamesGeneric.debugTracing("Entering NamesComponent.refresh");
        if (dataStore instanceof FileDataStore) {
            this.fds = (FileDataStore)dataStore;
        }
        if (this.loaded) {
            this.loadData();
        }
        ((DataDrivenTree)this.myTreeNode.getTree()).refreshTree((DTreeItem)this.myTreeNode);
        this.myTreeNode.setExpanded(false);
        NamesGeneric.debugTracing("Exiting NamesComponent.refresh");
    }

    public void delete() {
        NamesGeneric.debugTracing("Entering/Exiting NamesComponent:deleteObject");
    }

    public String toString() {
        if (this.title == null) {
            this.title = this.ns.getString("nnaNS");
        }
        return this.title;
    }

    public boolean isChanged() {
        NamesGeneric.debugTracing("Entering/Exiting NamesComponent:isChanged");
        if (this.changed) {
            return true;
        }
        return this.loaded && this.namesAdmin.isChanged();
    }

    public boolean executeComponentMenu(String string) {
        if (!this.loaded) {
            this.loadData();
        }
        if (string.equals(this.ns.getString("CNTRename"))) {
            if (this.selectedServer == null) {
                return true;
            }
            int n = this.getObjectIndex(this.selectedServer);
            if (n == -1) {
                return true;
            }
            String string2 = (String)this.addrVector.elementAt(n);
            NVPair nVPair = this.nvnav.findNVPairRecurse(this.nvfact.createNVPair(string2), "host");
            string2 = nVPair != null ? nVPair.getAtom() : "_INVALID_HOST_NAME_";
            if (!NamesGeneric.isSameHost(string2, null)) {
                return true;
            }
            String string3 = null;
            BufferedFrame bufferedFrame = (BufferedFrame)NetUtils.getApplication().getFrame();
            NetValidate netValidate = new NetValidate(bufferedFrame);
            NetNameDialog netNameDialog = new NetNameDialog(bufferedFrame, null, this.ns.getString("nnaRenameInstructions"), null, null, null);
            while (true) {
                ((Component)((Object)netNameDialog)).setVisible(true);
                string3 = netNameDialog.getName();
                if (string3 == null) {
                    return true;
                }
                boolean bl = false;
                Enumeration enumeration = this.objectVector.elements();
                while (enumeration.hasMoreElements()) {
                    if (!enumeration.nextElement().toString().equalsIgnoreCase(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    Alert alert = new Alert((Frame)bufferedFrame, this.ns.getString("nnaDuplicate", new Object[]{string3}), 0, 1);
                    alert.runAlert();
                    continue;
                }
                if (string3.equalsIgnoreCase(this.selectedServer)) {
                    return true;
                }
                if (!string3.equals("") && netValidate.validateName(string3)) break;
                netValidate.showDialog(this.ns.getString("CNTNetNameFieldLabel"));
            }
            this.changed = true;
            this.namesAdmin.rename(this.selectedServer, string3);
            this.objectVector.removeElementAt(n);
            Object e = this.addrVector.elementAt(n);
            this.addrVector.removeElementAt(n);
            this.objectVector.addElement(string3);
            this.addrVector.addElement(e);
            ((DataDrivenTree)this.myTreeNode.getTree()).refreshTree((DTreeItem)this.myTreeNode);
            this.myTreeNode.setExpanded(true);
            this.selectedServer = string3;
            this.selectChildNode(string3);
            return true;
        }
        BufferedFrame bufferedFrame = NamesGeneric.appFrame;
        boolean bl = false;
        Vector vector = null;
        NamesGeneric.debugTracing("Entering NamesComponent:executeComponentMenu");
        NamesGeneric.debugTracing("menu " + string + "selected");
        if (this.nnccj == null) {
            this.nnccj = new nnccj(0);
        }
        if (this.control == null) {
            this.control = new control();
        }
        if (string.compareTo(this.ns.getString("nnaDiscNS")) == 0) {
            this.control.reorderNS(null, 0, (short)1);
            try {
                vector = this.readSDNSFile(this.sdns_filename);
            }
            catch (FileNotFoundException fileNotFoundException) {
                NamesGeneric.debugTracing("no well known nameserver running");
                this.sdnsDialog = new SdnsDialog(bufferedFrame, this.ns.getString("nnaNSDisc"), this);
                this.sdnsDialog.dlgShow();
            }
            catch (IOException iOException) {
                NamesGeneric.debugTracing("io exception");
            }
            if (vector != null) {
                int n = 1;
                while (n < vector.size()) {
                    String string4 = (String)vector.elementAt(n);
                    int n2 = string4.indexOf(61);
                    if (n2 == -1) {
                        NamesGeneric.debugTracing(".sdns.ora is corrupted");
                    }
                    String string5 = string4.substring(0, n2).trim();
                    String string6 = string4.substring(n2 + 1).trim();
                    NamesGeneric.debugTracing("NAME:" + string5);
                    NamesGeneric.debugTracing("ADDRESS:" + string6);
                    if (!this.addrPresent(string6)) {
                        this.objectVector.addElement(string5);
                        this.addrVector.addElement(string6);
                        bl = true;
                    }
                    ++n;
                }
            }
            if (bl) {
                String string7 = this.ns.getString("nnaMessage");
                String string8 = this.ns.getString("nnaServerDiscovered");
                NamesDialog.popUp(string7, string8, 2);
                this.myTreeNode.setExpanded(true);
            } else {
                String string9 = this.ns.getString("nnaMessage");
                String string10 = this.ns.getString("nnaCreateServer");
                NamesDialog.popUp(string9, string10, 2);
            }
        } else {
            NamesGeneric.debugTracing("reloading nameservers...");
            String[] stringArray = new String[this.addrVector.size()];
            int n = 0;
            while (n < this.addrVector.size()) {
                stringArray[n] = new String((String)this.addrVector.elementAt(n));
                stringArray[n] = stringArray[n].trim();
                ++n;
            }
            this.control.reloadNS(stringArray, stringArray.length);
        }
        NamesGeneric.debugTracing("Exiting NamesComponent:executeComponentMenu");
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Vector vector = null;
        String string = this.ns.getString("nnaOk");
        String string2 = this.ns.getString("nnaCancel");
        NamesGeneric.debugTracing("Entering NamesComponent:actionPerformed");
        if (object instanceof LWButton) {
            Object object2;
            Object object3;
            Object[] objectArray;
            if (actionEvent.getActionCommand().compareTo(string) == 0) {
                String string3;
                String string4;
                if (!this.sdnsDialog.isAddressValid()) {
                    return;
                }
                objectArray = this.sdnsDialog.getAddress();
                object3 = new String[]{objectArray};
                this.control.reorderNS((String[])object3, 1, (short)1);
                object2 = new File(this.sdns_filename);
                if (!((File)object2).exists() && ((File)(object2 = new File(String.valueOf(this.oraNames) + "sdns.ora"))).exists()) {
                    this.sdns_filename = String.valueOf(this.oraNames) + "sdns.ora";
                }
                try {
                    vector = this.readSDNSFile(this.sdns_filename);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Object[] objectArray2 = new Object[]{this.ns.getString("CNTEdit"), this.ns.getString("CNTCreate")};
                    NamesGeneric.debugTracing("Wrong nameserver address");
                    string4 = this.ns.getString("nnaMessage");
                    string3 = this.ns.getString("nnaCreateServer", objectArray2);
                    NamesDialog.popUp(string4, string3, 2);
                }
                catch (IOException iOException) {
                    NamesGeneric.debugTracing("io exception");
                }
                this.sdnsDialog.dispose();
                if (vector != null) {
                    int n = 1;
                    while (n < vector.size()) {
                        String string5 = (String)vector.elementAt(n);
                        int n2 = string5.indexOf(61);
                        if (n2 == -1) {
                            NamesGeneric.debugTracing(".sdns.ora is corrupted");
                        }
                        String string6 = string5.substring(0, n2).trim();
                        String string7 = string5.substring(n2 + 1).trim();
                        NamesGeneric.debugTracing("NAME:" + string6);
                        NamesGeneric.debugTracing("ADDRESS:" + string7);
                        if (!this.addrPresent(string7)) {
                            this.objectVector.addElement(string6);
                            this.addrVector.addElement(string7);
                        }
                        ++n;
                    }
                    if (vector.size() > 1) {
                        string4 = this.ns.getString("nnaMessage");
                        string3 = this.ns.getString("nnaServerDiscovered");
                        NamesDialog.popUp(string4, string3, 2);
                        this.myTreeNode.setExpanded(true);
                    }
                }
            }
            if (actionEvent.getActionCommand().compareTo(string2) == 0) {
                objectArray = new Object[]{this.ns.getString("CNTEdit"), this.ns.getString("CNTCreate")};
                NamesGeneric.debugTracing("You may have to create NS objects");
                this.sdnsDialog.dispose();
                object3 = this.ns.getString("nnaMessage");
                object2 = this.ns.getString("nnaCreateServer", objectArray);
                NamesDialog.popUp((String)object3, (String)object2, 2);
            }
        }
        NamesGeneric.debugTracing("Exiting NamesComponent:actionPerformed");
    }

    public boolean Comp_file_has_Comments() {
        return this.commentsFound;
    }

    public boolean addrSame(String string, String string2) {
        NVPair nVPair = this.nvfact.createNVPair(string);
        NVPair nVPair2 = this.nvfact.createNVPair(string2);
        if (nVPair.getName().equalsIgnoreCase("ADDRESS_LIST")) {
            nVPair = this.nvnav.findNVPairRecurse(nVPair, "ADDRESS");
        }
        if (nVPair2.getName().equalsIgnoreCase("ADDRESS_LIST")) {
            nVPair2 = this.nvnav.findNVPairRecurse(nVPair2, "ADDRESS");
        }
        try {
            NVPair nVPair3 = this.nvnav.findNVPair(nVPair, "protocol");
            NVPair nVPair4 = this.nvnav.findNVPair(nVPair2, "protocol");
            if (!nVPair3.getAtom().equalsIgnoreCase(nVPair4.getAtom())) {
                return false;
            }
            if (nVPair3.getAtom().equalsIgnoreCase("tcp")) {
                NVPair nVPair5 = this.nvnav.findNVPair(nVPair, "port");
                NVPair nVPair6 = this.nvnav.findNVPair(nVPair, "host");
                NVPair nVPair7 = this.nvnav.findNVPair(nVPair2, "port");
                NVPair nVPair8 = this.nvnav.findNVPair(nVPair2, "host");
                if (nVPair5.getAtom().equalsIgnoreCase(nVPair7.getAtom()) && NamesGeneric.isSameHost(nVPair6.getAtom(), nVPair8.getAtom())) {
                    return true;
                }
            } else if (nVPair3.getAtom().equalsIgnoreCase("ipc")) {
                NVPair nVPair9 = this.nvnav.findNVPair(nVPair, "key");
                NVPair nVPair10 = this.nvnav.findNVPair(nVPair2, "key");
                if (nVPair9.getAtom().equalsIgnoreCase(nVPair10.getAtom())) {
                    return true;
                }
            } else if (nVPair3.getAtom().equalsIgnoreCase("spx")) {
                NVPair nVPair11 = this.nvnav.findNVPair(nVPair, "service");
                NVPair nVPair12 = this.nvnav.findNVPair(nVPair2, "service");
                if (nVPair11.getAtom().equalsIgnoreCase(nVPair12.getAtom())) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            NamesGeneric.debugTracing(throwable.toString());
        }
        return false;
    }

    public boolean addrPresent(String string) {
        int n = 0;
        while (n < this.addrVector.size()) {
            NVPair nVPair = this.nvfact.createNVPair((String)this.addrVector.elementAt(n));
            nVPair = this.nvnav.findNVPairRecurse(nVPair, "address");
            NamesGeneric.debugTracing("sdnsAddr is " + nVPair.toString());
            if (this.addrSame(string, nVPair.toString())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void selectChildNode(String string) {
        NamesDataSource namesDataSource = (NamesDataSource)this.myTreeNode.getDataSource();
        int n = this.myTreeNode.getItemCount() - 1;
        while (n >= 0) {
            if (((TreeItemData)namesDataSource.getData(n)).getLabel().equalsIgnoreCase(string)) {
                this.myTreeNode.getTree().getSelection().selectItem(this.myTreeNode.getItem(n));
                return;
            }
            --n;
        }
    }

    private Vector readSDNSFile(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        Vector<String> vector = new Vector<String>();
        NamesGeneric.debugTracing("Entering NamesComponent:readSDNSFile");
        try {
            String string2;
            fileInputStream = new FileInputStream(string);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string.compareTo(this.sdns_filename) == 0) {
                    vector.addElement(string2);
                    continue;
                }
                NamesGeneric.debugTracing("Error in filename");
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (Exception exception) {}
        return vector;
    }

    private int getObjectIndex(String string) {
        NamesGeneric.debugTracing("Entering NamesComponent:getObjectIndex");
        NamesGeneric.debugTracing("size " + this.objectVector.size() + "str " + string);
        int n = 0;
        while (n < this.objectVector.size()) {
            NamesGeneric.debugTracing("objvec " + n + (String)this.objectVector.elementAt(n));
            if (((String)this.objectVector.elementAt(n)).compareTo(string) == 0) {
                return n;
            }
            ++n;
        }
        NamesGeneric.debugTracing("getobjindex failed");
        NamesGeneric.debugTracing("Exiting NamesComponent:getObjectIndex");
        return -1;
    }

    static /* synthetic */ NetContainer access$0(NamesComponent namesComponent) {
        return namesComponent.theContainer;
    }

    static /* synthetic */ WebApplication access$1(NamesComponent namesComponent) {
        return namesComponent.theApp;
    }

    static /* synthetic */ EwtContainer access$2(NamesComponent namesComponent) {
        return namesComponent.nsPanel;
    }

    static /* synthetic */ NetObjectMenu access$3(NamesComponent namesComponent) {
        return namesComponent.renameMenuItem;
    }

    static /* synthetic */ NetVector access$4(NamesComponent namesComponent) {
        return namesComponent.menuVect;
    }

    static /* synthetic */ NetVector access$5(NamesComponent namesComponent) {
        return namesComponent.toolbarVect;
    }

    static /* synthetic */ boolean access$6(NamesComponent namesComponent) {
        return namesComponent.loaded;
    }

    static /* synthetic */ NamesAdmin access$7(NamesComponent namesComponent) {
        return namesComponent.namesAdmin;
    }

    static /* synthetic */ String access$8(NamesComponent namesComponent) {
        return namesComponent.selectedServer;
    }

    static /* synthetic */ void access$9(NamesComponent namesComponent, String string) {
        namesComponent.selectedServer = string;
    }

    static /* synthetic */ BufferedFrame access$10(NamesComponent namesComponent) {
        return namesComponent.theAppFrame;
    }

    static /* synthetic */ int access$11(NamesComponent namesComponent, String string) {
        return namesComponent.getObjectIndex(string);
    }

    static /* synthetic */ Vector access$12(NamesComponent namesComponent) {
        return namesComponent.addrVector;
    }

    static /* synthetic */ NVNavigator access$13(NamesComponent namesComponent) {
        return namesComponent.nvnav;
    }

    static /* synthetic */ NVFactory access$14(NamesComponent namesComponent) {
        return namesComponent.nvfact;
    }

    static /* synthetic */ nnccj access$15(NamesComponent namesComponent) {
        return namesComponent.nnccj;
    }

    static /* synthetic */ control access$16(NamesComponent namesComponent) {
        return namesComponent.control;
    }

    static /* synthetic */ void access$17(NamesComponent namesComponent) {
        namesComponent.loadData();
    }

    static /* synthetic */ NetVector access$18(NamesComponent namesComponent) {
        return namesComponent.objectVector;
    }

    private class NamesDataSource
    extends TreeDataSource {
        private String[] treeItems;
        private Image nmSvrIcon;
        private TreeProxy sharedProxy;

        public NamesDataSource(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            NamesComponent.this = NamesComponent.this;
            NamesComponent namesComponent2 = NamesComponent.this;
            namesComponent2.getClass();
            this.sharedProxy = namesComponent2.new NamesServerProxy(dataDrivenTree);
            this.nmSvrIcon = Toolkit.getDefaultToolkit().getImage(String.valueOf(NetUtils.getImageDirectory()) + "nameserv.gif");
        }

        protected void internal_refreshData() {
            NamesComponent namesComponent;
            this.internal_clearData();
            NamesComponent namesComponent2 = NamesComponent.this;
            if (!namesComponent2.loaded) {
                namesComponent2 = NamesComponent.this;
                namesComponent2.loadData();
            }
            namesComponent2 = NamesComponent.this;
            this.treeItems = new String[namesComponent2.objectVector.size()];
            int n = 0;
            while (n < this.treeItems.length) {
                namesComponent = NamesComponent.this;
                this.treeItems[n] = namesComponent.objectVector.elementAt(n).toString();
                ++n;
            }
            if (this.treeItems != null && this.treeItems.length > 0) {
                namesComponent = new OneDDataSourceEvent((Object)this, 2001, 0, this.treeItems.length);
                this.processEvent((OneDDataSourceEvent)namesComponent);
            }
        }

        protected DTreeItem internal_createItem(DTreeDeferringParent dTreeDeferringParent, int n) {
            return new TreeChildNode(this.sharedProxy, "oracle_sysman_netasst_names_item");
        }

        protected void internal_setData(int n, Object object) {
        }

        protected Object internal_getData(int n) {
            return new TreeItemData(this.treeItems[n], this.nmSvrIcon);
        }

        protected int internal_getItemCount() {
            if (this.treeItems == null) {
                return 0;
            }
            return this.treeItems.length;
        }

        protected void internal_clearData() {
            if (this.treeItems != null) {
                OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent((Object)this, 2002, 0, this.treeItems.length);
                this.processEvent(oneDDataSourceEvent);
                this.treeItems = null;
            }
        }
    }

    private class NamesProxy
    extends TreeProxy
    implements TreeNodeSelectionListener,
    DTreeExpansionListener {
        private boolean instructionsShown = false;

        public NamesProxy(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            NamesComponent.this = NamesComponent.this;
        }

        public void dTreeItemExpanded(DTreeItemEvent dTreeItemEvent) {
            if (((TreeParentNode)dTreeItemEvent.getItem()).getType() == "oracle_sysman_netasst_names_comp" && !this.instructionsShown && dTreeItemEvent.getItem().getItemCount() == 0) {
                this.instructionsShown = true;
                Object[] objectArray = new Object[]{NamesComponent.this.ns.getString("CNTTools"), NamesComponent.this.ns.getString("nnaDiscNS")};
                String string = NamesComponent.this.ns.getString("nnaMessage");
                String string2 = NamesComponent.this.ns.getString("nnaNoNSMessage", objectArray);
                NamesDialog.popUp(string, string2, 2);
            }
        }

        public void dTreeItemExpanding(DTreeItemEvent dTreeItemEvent) {
        }

        public void dTreeItemCollapsed(DTreeItemEvent dTreeItemEvent) {
        }

        public void dTreeItemCollapsing(DTreeItemEvent dTreeItemEvent) {
        }

        public void treeSelectionChanging(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            NamesComponent namesComponent = NamesComponent.this;
            namesComponent.theContainer.setMenuStatus(null);
            namesComponent = NamesComponent.this;
            namesComponent.theContainer.setToolBarStatus(null);
            namesComponent = NamesComponent.this;
            namesComponent.theApp.showStatus("");
        }

        public void treeSelectionChanged(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            NamesComponent namesComponent = NamesComponent.this;
            namesComponent = NamesComponent.this;
            namesComponent.theContainer.display(NamesComponent.this, (Component)namesComponent.nsPanel);
            namesComponent = NamesComponent.this;
            namesComponent.renameMenuItem.setEnabled(false);
            namesComponent = NamesComponent.this;
            namesComponent = NamesComponent.this;
            namesComponent.theContainer.setMenuStatus(namesComponent.menuVect);
            namesComponent = NamesComponent.this;
            namesComponent = NamesComponent.this;
            namesComponent.theContainer.setToolBarStatus(namesComponent.toolbarVect);
            namesComponent = NamesComponent.this;
            namesComponent.theApp.showStatus("");
        }
    }

    private class NamesServerProxy
    extends TreeProxy
    implements TreeNodeSelectionListener {
        public NamesServerProxy(DataDrivenTree dataDrivenTree) {
            super(dataDrivenTree);
            NamesComponent.this = NamesComponent.this;
        }

        public void treeSelectionChanging(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            NamesComponent namesComponent = NamesComponent.this;
            if (namesComponent.loaded) {
                namesComponent = NamesComponent.this;
                if (!namesComponent.namesAdmin.validateConfig()) {
                    ((Cancelable)dTreeSelectionEvent).cancel();
                    return;
                }
            }
            namesComponent = NamesComponent.this;
            namesComponent.selectedServer = null;
            namesComponent = NamesComponent.this;
            namesComponent.theContainer.setMenuStatus(null);
            namesComponent = NamesComponent.this;
            namesComponent.theContainer.setToolBarStatus(null);
            namesComponent = NamesComponent.this;
            namesComponent.theApp.showStatus("");
        }

        public void treeSelectionChanged(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
            Object object;
            Object object2;
            NamesComponent namesComponent = NamesComponent.this;
            namesComponent.theAppFrame.setCursor(new Cursor(3));
            namesComponent = NamesComponent.this;
            namesComponent.theApp.showStatus(NamesComponent.this.ns.getString("nnaHoldOn"));
            namesComponent = NamesComponent.this;
            Object object3 = treeItem.getLabel();
            int n = namesComponent.getObjectIndex((String)object3);
            object3 = NamesComponent.this;
            object3 = (String)((NamesComponent)object3).addrVector.elementAt(n);
            Object object4 = NamesComponent.this;
            object4 = NamesComponent.this;
            object4 = ((NamesComponent)object4).nvnav.findNVPairRecurse(((NamesComponent)object4).nvfact.createNVPair((String)object3), "host");
            object3 = object4 != null ? ((NVPair)object4).getAtom() : "_INVALID_HOST_NAME_";
            try {
                object2 = NamesComponent.this;
                object = treeItem.getLabel();
                n = object2.getObjectIndex((String)object);
                String[] stringArray = new String[1];
                object2 = NamesComponent.this;
                stringArray[0] = (String)object2.addrVector.elementAt(n);
                object2 = stringArray;
                object = object2[0];
                oracle.net.asst.names.nnccj.serverAddress = object;
                object = NamesComponent.this;
                ((NamesComponent)object).control.setServer((String[])object2, 1, (short)3);
                object = NamesComponent.this;
                ((NamesComponent)object).namesAdmin.enableConfigure(NamesGeneric.isSameHost((String)object3, null));
                object = NamesComponent.this;
                if (((NamesComponent)object).control.pingServer((String[])object2, 1, (short)3) == 0) {
                    object = NamesComponent.this;
                    ((NamesComponent)object).namesAdmin.refreshAllScreens();
                } else {
                    object = NamesComponent.this;
                    ((NamesComponent)object).namesAdmin.clearScreens();
                }
            }
            catch (Throwable throwable) {
                NamesGeneric.debugTracing("error activating names server: " + throwable);
            }
            if (NamesGeneric.newServerConfig) {
                object2 = NamesComponent.this;
                object2.namesAdmin.showConfigPanel();
                NamesGeneric.newServerConfig = false;
            } else {
                object2 = NamesComponent.this;
                object2.namesAdmin.setPreviousPanel();
            }
            object2 = NamesComponent.this;
            object = treeItem.getLabel();
            object2.selectedServer = object;
            object2 = NamesComponent.this;
            object2 = NamesComponent.this;
            object2.theContainer.display(NamesComponent.this, (Component)((Object)object2.namesAdmin));
            object2 = NamesComponent.this;
            object2.renameMenuItem.setEnabled(true);
            object2 = NamesComponent.this;
            object2 = NamesComponent.this;
            object2.theContainer.setMenuStatus(object2.menuVect);
            object2 = NamesComponent.this;
            object2 = NamesComponent.this;
            object2.theContainer.setToolBarStatus(object2.toolbarVect);
            object2 = NamesComponent.this;
            object2.theAppFrame.setCursor(Cursor.getDefaultCursor());
            object2 = NamesComponent.this;
            object2.theApp.showStatus("");
        }
    }
}

