/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.control;
import oracle.net.asst.names.nnccj;

public class NamesControl
extends EwtContainer
implements ItemListener {
    NetStrings ns = new NetStrings();
    private String[] topItems = new String[]{this.ns.getString("nnaServerOps"), this.ns.getString("nnaStatsOps")};
    private String[] serverOps = new String[]{this.ns.getString("nnaStart"), this.ns.getString("nnaShutdown"), this.ns.getString("nnaRestart")};
    private String[] statsOps = new String[]{this.ns.getString("nnaLogStats"), this.ns.getString("nnaResetStats")};
    private MarginBorder sharedBorderPixel;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel secondsLabel;
    private LWLabel noteLabel;
    private LWTextField textField;
    private LWCheckbox[] topCb;
    private LWCheckbox[] serverCb;
    private LWCheckbox[] statsCb;
    private LWCheckbox[] timeCb;
    private LWCheckboxGroup topGroup;
    private LWCheckboxGroup serverGroup;
    private LWCheckboxGroup statsGroup;
    private LWCheckboxGroup timeGroup;
    private EwtContainer controlPanel;
    private EwtContainer opsPanel;
    private EwtContainer timePanel;
    private Insets panelInsets;
    private Insets indentedInsets;
    private control m_control;
    public static boolean serverUp;
    private boolean initialized;
    private boolean componentShownOnce;
    private short errorVerbosity = 1;

    public NamesControl() {
        NamesGeneric.debugTracing("Entering class:NamesControl");
        serverUp = nnccj.serverSet;
        this.m_control = new control();
        this.panelInsets = new Insets(2, 4, 2, 4);
        this.indentedInsets = new Insets(2, 30, 2, 4);
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gbc.insets = this.panelInsets;
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.sharedBorderPixel = new MarginBorder(4, 4, 4, 4);
        this.setBorder((Border)this.sharedBorderPixel);
        this.controlPanel = new EwtContainer();
        this.controlPanel.setLayout(this.gb);
        this.noteLabel = new LWLabel(this.ns.getString("nnaZeroWaitLabel"));
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gb.setConstraints((Component)this.noteLabel, this.gbc);
        this.controlPanel.add((Component)this.noteLabel);
        this.opsPanel = new EwtContainer();
        this.opsPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.opsPanel, this.gbc);
        this.opsPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaOperation"), InsetFramePainter.getFramePainter(), 2));
        this.controlPanel.add((Component)this.opsPanel);
        this.timePanel = new EwtContainer();
        this.timePanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.timePanel, this.gbc);
        this.timePanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaPerformOp"), InsetFramePainter.getFramePainter(), 2));
        this.controlPanel.add((Component)this.timePanel);
        this.gbc.ipadx = 10;
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.topCb = new LWCheckbox[this.topItems.length];
        this.topGroup = new LWCheckboxGroup();
        this.topCb[0] = new LWCheckbox(new String(this.topItems[0]), this.topGroup, false);
        this.topCb[0].addItemListener((ItemListener)this);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.topCb[0], this.gbc);
        this.opsPanel.add((Component)this.topCb[0]);
        this.serverGroup = new LWCheckboxGroup();
        this.serverCb = new LWCheckbox[this.serverOps.length];
        this.gbc.insets = this.indentedInsets;
        int n = 0;
        while (n < this.serverOps.length) {
            this.gbc.gridx = -1;
            ++this.gbc.gridy;
            this.serverCb[n] = new LWCheckbox(new String(this.serverOps[n]), this.serverGroup, false);
            this.serverCb[n].addItemListener((ItemListener)this);
            this.gb.setConstraints((Component)this.serverCb[n], this.gbc);
            this.opsPanel.add((Component)this.serverCb[n]);
            ++n;
        }
        this.gbc.insets = this.panelInsets;
        this.topCb[1] = new LWCheckbox(new String(this.topItems[1]), this.topGroup, false);
        this.topCb[1].addItemListener((ItemListener)this);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.topCb[1], this.gbc);
        this.opsPanel.add((Component)this.topCb[1]);
        this.statsGroup = new LWCheckboxGroup();
        this.statsCb = new LWCheckbox[this.statsOps.length];
        this.gbc.insets = this.indentedInsets;
        int n2 = 0;
        while (n2 < this.statsOps.length) {
            this.gbc.gridx = 0;
            this.gbc.insets = this.indentedInsets;
            ++this.gbc.gridy;
            this.statsCb[n2] = new LWCheckbox(new String(this.statsOps[n2]), this.statsGroup, false);
            this.statsCb[n2].addItemListener((ItemListener)this);
            this.gb.setConstraints((Component)this.statsCb[n2], this.gbc);
            this.opsPanel.add((Component)this.statsCb[n2]);
            ++n2;
        }
        this.gbc.insets = this.panelInsets;
        this.gbc.ipadx = 10;
        this.timeGroup = new LWCheckboxGroup();
        this.timeCb = new LWCheckbox[2];
        this.timeCb[0] = new LWCheckbox(this.ns.getString("nnaImmediately"), this.timeGroup, false);
        this.timeCb[0].addItemListener((ItemListener)this);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 0.0;
        this.gb.setConstraints((Component)this.timeCb[0], this.gbc);
        this.timePanel.add((Component)this.timeCb[0]);
        this.timeCb[0].setEnabled(false);
        this.timeCb[1] = new LWCheckbox(this.ns.getString("nnaWait"), this.timeGroup, false);
        this.timeCb[1].addItemListener((ItemListener)this);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gb.setConstraints((Component)this.timeCb[1], this.gbc);
        this.timePanel.add((Component)this.timeCb[1]);
        this.timeCb[1].setEnabled(false);
        this.textField = new LWTextField(12);
        this.gbc.ipadx = 0;
        this.gbc.fill = 2;
        this.gbc.weightx = 5.0;
        ++this.gbc.gridx;
        this.gbc.gridwidth = -1;
        this.gb.setConstraints((Component)this.textField, this.gbc);
        this.timePanel.add((Component)this.textField);
        this.textField.setEditable(false);
        this.gbc.gridx = -1;
        this.gbc.gridwidth = 0;
        this.secondsLabel = new LWLabel(this.ns.getString("nnaSeconds"));
        this.gb.setConstraints((Component)this.secondsLabel, this.gbc);
        this.timePanel.add((Component)this.secondsLabel);
        this.secondsLabel.setEnabled(false);
        if (serverUp) {
            this.setServerUp();
        } else {
            this.setServerDown();
        }
        ((Container)((Object)this)).add((Component)this.controlPanel, "North");
        NamesGeneric.debugTracing("Exiting class:NamesControl");
        ((Component)((Object)this)).addComponentListener(new 1());
    }

    public void LoadFirstTime() {
        NamesGeneric.debugTracing("Entering LoadFirstTime:NamesControl");
        if (this.initialized) {
            return;
        }
        this.LoadIntoScreen();
        this.initialized = true;
        NamesGeneric.debugTracing("Exiting LoadFirstTime:NamesControl");
    }

    public void PerformOp() {
        String string;
        int n = -1;
        String[] stringArray = new String[1];
        int n2 = 0;
        NamesGeneric.debugTracing("Entering PerformOp:NamesControl");
        LWCheckbox lWCheckbox = this.topGroup.getSelectedCheckbox();
        if (lWCheckbox == null) {
            String string2 = this.ns.getString("nnaError");
            String string3 = this.ns.getString("nnaNullSelection");
            NamesDialog.popUp(string2, string3, 2);
            return;
        }
        String string4 = lWCheckbox.getLabel();
        if ((lWCheckbox = string4.compareTo(this.topItems[0]) == 0 ? this.serverGroup.getSelectedCheckbox() : this.statsGroup.getSelectedCheckbox()) == null) {
            String string5 = this.ns.getString("nnaError");
            String string6 = this.ns.getString("nnaNullSelection");
            NamesDialog.popUp(string5, string6, 2);
            return;
        }
        string4 = lWCheckbox.getLabel();
        if (this.timeGroup.getSelectedCheckbox().getLabel().compareTo(this.ns.getString("nnaWait")) == 0) {
            string = this.textField.getText();
            try {
                Integer.parseInt(string, 10);
            }
            catch (NumberFormatException numberFormatException) {
                string = null;
                String string7 = this.ns.getString("nnaError");
                String string8 = this.ns.getString("nnaWaitMustBeNumber");
                NamesDialog.popUp(string7, string8, 2);
                return;
            }
            stringArray[0] = string;
            n2 = 1;
        } else {
            string = null;
        }
        if (string4.compareTo(this.serverOps[0]) == 0) {
            n = this.m_control.startServer(null, 0);
            if (n == 0) {
                serverUp = true;
                String string9 = this.ns.getString("nnaMessage");
                String string10 = this.ns.getString("nnaServerStartSucc");
                NamesDialog.popUp(string9, string10, 2);
                this.setServerUp();
                nnccj.serverSet = true;
            }
        } else if (string4.compareTo(this.serverOps[1]) == 0) {
            if (string == null) {
                n = this.m_control.stopServer();
                if (n == 0) {
                    serverUp = false;
                    String string11 = this.ns.getString("nnaMessage");
                    String string12 = this.ns.getString("nnaServerStop");
                    NamesDialog.popUp(string11, string12, 2);
                    this.setServerDown();
                    nnccj.serverSet = false;
                }
            } else {
                n = this.m_control.stopServer(stringArray, n2);
                if (n == 0) {
                    String string13 = String.valueOf(this.ns.getString("nnaServerStopping")) + this.m_control.returnResp();
                    String string14 = this.ns.getString("nnaMessage");
                    NamesDialog.popUp(string14, string13, 2);
                }
            }
        } else if (string4.compareTo(this.serverOps[2]) == 0) {
            if (string == null) {
                n = this.m_control.setRestart();
                if (n == 0) {
                    serverUp = true;
                    String string15 = this.ns.getString("nnaMessage");
                    String string16 = this.ns.getString("nnaServerRestartSucc");
                    NamesDialog.popUp(string15, string16, 2);
                }
            } else {
                n = this.m_control.setRestart(stringArray, n2);
                if (n == 0) {
                    String string17 = String.valueOf(this.ns.getString("nnaServerRestarting")) + this.m_control.returnResp();
                    serverUp = true;
                    String string18 = this.ns.getString("nnaMessage");
                    NamesDialog.popUp(string18, string17, 2);
                }
            }
        } else if (string4.compareTo(this.statsOps[0]) == 0) {
            if (string == null) {
                n = this.m_control.logStats();
                if (n == 0) {
                    String string19 = this.ns.getString("nnaMessage");
                    String string20 = this.ns.getString("nnaServerStatsLogged");
                    NamesDialog.popUp(string19, string20, 2);
                }
            } else {
                n = this.m_control.setLogStats(stringArray, n2);
                if (n == 0) {
                    String string21 = String.valueOf(this.ns.getString("nnaLoggingStats")) + this.m_control.returnResp();
                    String string22 = this.ns.getString("nnaMessage");
                    NamesDialog.popUp(string22, string21, 2);
                }
            }
        } else if (string4.compareTo(this.statsOps[1]) == 0) {
            if (string == null) {
                n = this.m_control.resetStats();
                if (n == 0) {
                    String string23 = this.ns.getString("nnaMessage");
                    String string24 = this.ns.getString("nnaStatsReset");
                    NamesDialog.popUp(string23, string24, 2);
                }
            } else {
                n = this.m_control.setResetStats(stringArray, n2);
                if (n == 0) {
                    String string25 = String.valueOf(this.ns.getString("nnaResetingStats")) + this.m_control.returnResp();
                    String string26 = this.ns.getString("nnaMessage");
                    NamesDialog.popUp(string26, string25, 2);
                }
            }
        }
        NamesGeneric.debugTracing("Exiting PerformOp:NamesControl");
    }

    public void LoadIntoScreen() {
        NamesGeneric.debugTracing("Entering LoadIntoScreen:NamesControl");
        if (this.initialized) {
            String[] stringArray = new String[]{nnccj.serverAddress};
            int n = stringArray[0] == null ? 0 : 1;
            int n2 = this.m_control.pingServer(stringArray, n, this.errorVerbosity);
            if (n2 == 0) {
                serverUp = true;
                nnccj.serverSet = true;
                this.m_control.setServer(stringArray, n);
            } else {
                serverUp = false;
                nnccj.serverSet = false;
            }
        }
        if (serverUp) {
            this.setServerUp();
        } else {
            this.setServerDown();
        }
        NamesGeneric.debugTracing("Exiting LoadIntoScreen:NamesControl");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        NamesGeneric.debugTracing("Entering itemStateChanged:NamesControl");
        if (object instanceof LWCheckbox) {
            int n;
            String string = itemEvent.getItem().toString();
            if (string.compareTo(this.ns.getString("nnaServerOps")) == 0) {
                this.serverCb[0].setEnabled(!serverUp);
                n = 1;
                while (n < this.serverOps.length) {
                    this.serverCb[n].setEnabled(serverUp);
                    ++n;
                }
                this.statsGroup.setSelectedCheckbox(null);
                n = 0;
                while (n < this.statsOps.length) {
                    this.statsCb[n].setEnabled(false);
                    ++n;
                }
                if (this.serverGroup.getSelectedCheckbox() == null) {
                    this.timeGroup.setSelectedCheckbox(null);
                    this.timeCb[0].setEnabled(false);
                    this.timeCb[1].setEnabled(false);
                    this.textField.setEditable(false);
                    this.secondsLabel.setEnabled(false);
                }
            }
            if (string.compareTo(this.ns.getString("nnaStatsOps")) == 0) {
                n = 0;
                while (n < this.statsOps.length) {
                    this.statsCb[n].setEnabled(true);
                    ++n;
                }
                this.serverGroup.setSelectedCheckbox(null);
                n = 0;
                while (n < this.serverOps.length) {
                    this.serverCb[n].setEnabled(false);
                    ++n;
                }
                if (this.statsGroup.getSelectedCheckbox() == null) {
                    this.timeGroup.setSelectedCheckbox(null);
                    this.timeCb[0].setEnabled(false);
                    this.timeCb[1].setEnabled(false);
                    this.textField.setEditable(false);
                    this.secondsLabel.setEnabled(false);
                }
            } else if (string.compareTo(this.ns.getString("nnaStart")) == 0) {
                if (string.compareTo(this.ns.getString("nnaStart")) == 0) {
                    this.timeCb[1].setEnabled(false);
                } else {
                    this.timeCb[1].setEnabled(true);
                }
                this.textField.setEditable(false);
                this.secondsLabel.setEnabled(false);
            } else if (string.compareTo(this.ns.getString("nnaImmediately")) == 0) {
                this.textField.setEditable(false);
                this.secondsLabel.setEnabled(false);
            } else if (string.compareTo(this.ns.getString("nnaWait")) == 0) {
                this.textField.setEditable(true);
                this.secondsLabel.setEnabled(true);
            } else if (string.compareTo(this.ns.getString("nnaShutdown")) == 0 || string.compareTo(this.ns.getString("nnaRestart")) == 0 || string.compareTo(this.ns.getString("nnaLogStats")) == 0 || string.compareTo(this.ns.getString("nnaResetStats")) == 0) {
                this.timeCb[0].setEnabled(true);
                this.timeCb[1].setEnabled(true);
                this.timeCb[0].setState(true);
                this.textField.setEditable(false);
                this.secondsLabel.setEnabled(false);
            }
        }
        NamesGeneric.debugTracing("Exiting itemStateChanged:NamesControl");
    }

    public void setServerUp() {
        NamesGeneric.debugTracing("Entering setServerUp:NamesControl");
        this.topCb[0].setState(true);
        this.topCb[1].setEnabled(true);
        this.serverGroup.setSelectedCheckbox(null);
        this.statsGroup.setSelectedCheckbox(null);
        this.serverCb[0].setEnabled(false);
        int n = 1;
        while (n < this.serverOps.length) {
            this.serverCb[n].setEnabled(true);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.statsOps.length) {
            this.statsCb[n2].setEnabled(false);
            ++n2;
        }
        this.timeGroup.setSelectedCheckbox(null);
        this.timeCb[0].setEnabled(false);
        this.timeCb[1].setEnabled(false);
        this.textField.setEditable(false);
        this.secondsLabel.setEnabled(false);
        NamesGeneric.debugTracing("Exiting setServerUp:NamesControl");
    }

    public void setServerDown() {
        NamesGeneric.debugTracing("Entering setServerDown:NamesControl");
        this.topCb[0].setEnabled(true);
        this.topCb[0].setState(true);
        this.topCb[1].setEnabled(false);
        this.serverCb[0].setEnabled(true);
        this.serverCb[0].setState(true);
        int n = 1;
        while (n < this.serverOps.length) {
            this.serverCb[n].setEnabled(false);
            ++n;
        }
        this.statsGroup.setSelectedCheckbox(null);
        int n2 = 0;
        while (n2 < this.statsOps.length) {
            this.statsCb[n2].setEnabled(false);
            ++n2;
        }
        this.timeCb[0].setEnabled(true);
        this.timeCb[0].setState(true);
        this.timeCb[1].setEnabled(false);
        this.textField.setEditable(false);
        this.secondsLabel.setEnabled(false);
        NamesGeneric.debugTracing("Exiting setServerDown:NamesControl");
    }

    public void clearPanel() {
        NamesGeneric.debugTracing("Entering clearPanel:NamesControl");
        serverUp = false;
        nnccj.serverSet = false;
        this.setServerDown();
        NamesGeneric.debugTracing("Exiting clearPanel:NamesControl");
    }

    static /* synthetic */ boolean access$0(NamesControl namesControl) {
        return namesControl.componentShownOnce;
    }

    static /* synthetic */ short access$1(NamesControl namesControl) {
        return namesControl.errorVerbosity;
    }

    static /* synthetic */ control access$2(NamesControl namesControl) {
        return namesControl.m_control;
    }

    static /* synthetic */ void access$3(NamesControl namesControl, short s) {
        namesControl.errorVerbosity = s;
    }

    static /* synthetic */ boolean access$4(NamesControl namesControl) {
        return namesControl.initialized;
    }

    static /* synthetic */ void access$5(NamesControl namesControl, boolean bl) {
        namesControl.componentShownOnce = bl;
    }

    private final class 1
    extends ComponentAdapter {
        public void componentShown(ComponentEvent componentEvent) {
            NamesControl namesControl = NamesControl.this;
            if (!namesControl.componentShownOnce && nnccj.serverAddress != null) {
                namesControl = NamesControl.this;
                short s = namesControl.errorVerbosity;
                NamesControl namesControl2 = NamesControl.this;
                namesControl2.errorVerbosity = (short)3;
                namesControl2 = NamesControl.this;
                if (!namesControl2.initialized) {
                    NamesControl.this.LoadFirstTime();
                } else {
                    NamesControl.this.LoadIntoScreen();
                }
                namesControl2 = NamesControl.this;
                namesControl2.componentShownOnce = true;
                namesControl2 = NamesControl.this;
                namesControl2.errorVerbosity = s;
            }
        }

        /* synthetic */ 1() {
        }
    }
}

