/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.io.File;
import java.net.InetAddress;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.net.common.NetGetEnv;

public class NamesGeneric {
    public static final String FileSeparator = File.separator;
    public static final char FileSeparatorChar = File.separatorChar;
    public static final String LineSeparator = "\n";
    public static final String OS = System.getProperty("os.name");
    public static boolean newServerConfig;
    public static BufferedFrame appFrame;
    private static boolean DEBUG_ON;
    private static String OraHome;
    private static String OraNames;

    public static void setDebug(String string) {
        if (string == null) {
            DEBUG_ON = false;
            return;
        }
        if ((string = string.toLowerCase()).compareTo("on") == 0 || string.compareTo("true") == 0 || string.compareTo("yes") == 0) {
            DEBUG_ON = true;
            return;
        }
        DEBUG_ON = false;
    }

    public static void debugTracing(String string) {
        if (DEBUG_ON) {
            System.out.println(string);
        }
    }

    public static String getOraHome() {
        if (OraHome == null) {
            OraHome = String.valueOf(NamesGeneric.formatDirectoryString(NetGetEnv.getOracleHome())) + "network" + FileSeparator;
        }
        return OraHome;
    }

    public static String getOraNames() {
        if (OraNames == null) {
            String string = NamesGeneric.getOraHome();
            OraNames = String.valueOf(string) + "names" + FileSeparator;
            return OraNames;
        }
        return OraNames;
    }

    public static String getLocalHost() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
            return string;
        }
        catch (Throwable throwable) {
            String string2 = "getLocalHost error: " + throwable.getMessage();
            if (DEBUG_ON) {
                System.out.println(string2);
            }
            return "onames";
        }
    }

    public static boolean isSameHost(String string, String string2) {
        if (DEBUG_ON) {
            System.out.println("Entering NamesComponent:sameHost");
        }
        try {
            String string3;
            String string4;
            InetAddress inetAddress;
            if (string == null) {
                inetAddress = InetAddress.getLocalHost();
                string4 = inetAddress.getHostName();
            } else {
                string4 = string;
            }
            String string5 = InetAddress.getByName(string4).getHostAddress();
            if (string2 == null) {
                inetAddress = InetAddress.getLocalHost();
                string3 = inetAddress.getHostName();
            } else {
                string3 = string2;
            }
            String string6 = "sameHost() comparing using hosts: " + string4 + " and " + string3;
            if (DEBUG_ON) {
                System.out.println(string6);
            }
            string6 = InetAddress.getByName(string3).getHostAddress();
            return string5.equals(string6);
        }
        catch (Exception exception) {
            String string7 = "samehost excep " + exception.getMessage();
            if (DEBUG_ON) {
                System.out.println(string7);
            }
            return false;
        }
    }

    public static boolean isWKNS() {
        int n = 0;
        while (n < 4) {
            if (NamesGeneric.isSameHost("oranamesrvr" + n, null)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void setAppFrame(BufferedFrame bufferedFrame) {
        appFrame = bufferedFrame;
    }

    public static void setNewServerConfig(boolean bl) {
        newServerConfig = bl;
    }

    public static String formatDirectoryString(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) != FileSeparatorChar) break;
            --n;
        }
        return String.valueOf(string.substring(0, n + 1)) + FileSeparator;
    }

    static {
        DEBUG_ON = true;
    }
}

