/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.monitor;
import oracle.net.asst.names.nnccj;

public class NamesMonitor
extends EwtContainer
implements ItemListener {
    NetStrings ns = new NetStrings();
    private String[] topItems = new String[]{this.ns.getString("nnaServer"), this.ns.getString("nnaStats"), this.ns.getString("nnaSchedOps")};
    private String[] scheduleItems = new String[]{this.ns.getString("nnaServer"), this.ns.getString("nnaStats"), this.ns.getString("nnaCache")};
    private String[] itemNames = new String[]{this.ns.getString("nnaServerName"), this.ns.getString("nnaVersion"), this.ns.getString("nnaRunningTime"), this.ns.getString("nnaRequestrecv"), this.ns.getString("nnaRequestforw"), this.ns.getString("nnaForeigncache"), this.ns.getString("nnaRegionFail"), this.ns.getString("nnaNextShutTime"), this.ns.getString("nnaNextRestartTime"), this.ns.getString("nnaNextStatsLogTime"), this.ns.getString("nnaNextStatsResetTime"), this.ns.getString("nnaNextFlush"), this.ns.getString("nnaNextReload"), this.ns.getString("nnaNextCkp"), this.ns.getString("nnaNextDump")};
    private final short statsItems = (short)3;
    private final short serverSchedItems = (short)7;
    private final short statsSchedItems = (short)9;
    private final short cacheItems = (short)11;
    private LWTextField[] itemText;
    private MarginBorder sharedBorderPixel;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel l;
    private EwtContainer runPanel;
    private EwtContainer textPanel;
    private EwtContainer cbPanel;
    private EwtContainer srvrSchedPanel;
    private EwtContainer statsSchedPanel;
    private EwtContainer cacheSchedulePanel;
    private EwtContainer cardPanel;
    private EwtContainer serverPanel;
    private EwtContainer statsPanel;
    private LWCheckboxGroup topGroup;
    private LWCheckboxGroup scheduleGroup;
    private LWCheckbox[] topCb;
    private LWCheckbox[] scheduleCb;
    private Insets zeroInsets;
    private CardLayout cardLayout;
    private boolean initialized;
    private monitor m_monitor;

    public NamesMonitor() {
        NamesGeneric.debugTracing("Entering class:NamesMontior");
        this.m_monitor = new monitor();
        this.zeroInsets = new Insets(0, 4, 0, 4);
        this.cardLayout = new CardLayout();
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gbc.insets = this.zeroInsets;
        this.gbc.fill = 2;
        this.sharedBorderPixel = new MarginBorder(2, 2, 2, 2);
        this.setBorder((Border)this.sharedBorderPixel);
        this.cbPanel = new EwtContainer();
        this.cbPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.insets = this.zeroInsets;
        this.gb.setConstraints((Component)this.cbPanel, this.gbc);
        this.cbPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaInfoAbout"), InsetFramePainter.getFramePainter(), 2));
        this.cardPanel = new EwtContainer();
        this.cardPanel.setLayout(this.cardLayout);
        ++this.gbc.gridy;
        this.gbc.insets = this.zeroInsets;
        this.gb.setConstraints((Component)this.cardPanel, this.gbc);
        this.cardPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaInfo"), InsetFramePainter.getFramePainter(), 2));
        this.gbc.ipadx = 10;
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(2, 4, 2, 4);
        this.topCb = new LWCheckbox[this.topItems.length];
        this.topGroup = new LWCheckboxGroup();
        int n = 0;
        while (n < this.topItems.length) {
            this.topCb[n] = new LWCheckbox(this.topItems[n], this.topGroup, false);
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
            this.gb.setConstraints((Component)this.topCb[n], this.gbc);
            this.topCb[n].addItemListener((ItemListener)this);
            this.cbPanel.add((Component)this.topCb[n]);
            ++n;
        }
        this.gbc.insets = new Insets(1, 30, 1, 1);
        this.scheduleCb = new LWCheckbox[this.scheduleItems.length];
        this.scheduleGroup = new LWCheckboxGroup();
        int n2 = 0;
        while (n2 < this.scheduleItems.length) {
            this.scheduleCb[n2] = new LWCheckbox(this.scheduleItems[n2], this.scheduleGroup, false);
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
            this.gb.setConstraints((Component)this.scheduleCb[n2], this.gbc);
            this.scheduleCb[n2].addItemListener((ItemListener)this);
            this.cbPanel.add((Component)this.scheduleCb[n2]);
            this.scheduleCb[n2].setEnabled(false);
            ++n2;
        }
        this.gbc.ipadx = 0;
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.gbc.insets = this.zeroInsets;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.serverPanel = new EwtContainer();
        this.serverPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.serverPanel, this.gbc);
        this.cardPanel.add((Component)this.serverPanel, "serverPanel");
        this.statsPanel = new EwtContainer();
        this.statsPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.statsPanel, this.gbc);
        this.cardPanel.add((Component)this.statsPanel, "statsPanel");
        this.srvrSchedPanel = new EwtContainer();
        this.srvrSchedPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.srvrSchedPanel, this.gbc);
        this.cardPanel.add((Component)this.srvrSchedPanel, "srvrSchedPanel");
        this.statsSchedPanel = new EwtContainer();
        this.statsSchedPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.statsSchedPanel, this.gbc);
        this.cardPanel.add((Component)this.statsSchedPanel, "statsSchedPanel");
        this.cacheSchedulePanel = new EwtContainer();
        this.cacheSchedulePanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.cacheSchedulePanel, this.gbc);
        this.cardPanel.add((Component)this.cacheSchedulePanel, "cachePanel");
        this.textPanel = new EwtContainer();
        this.textPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(4, 4, 0, 4);
        this.gb.setConstraints((Component)this.textPanel, this.gbc);
        this.serverPanel.add((Component)this.textPanel);
        this.runPanel = new EwtContainer();
        this.runPanel.setLayout(new FlowLayout(0));
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = new Insets(0, 4, 4, 4);
        this.gb.setConstraints((Component)this.runPanel, this.gbc);
        this.serverPanel.add((Component)this.runPanel);
        this.gbc.insets = new Insets(4, 4, 4, 4);
        this.itemText = new LWTextField[this.itemNames.length];
        int n3 = 0;
        while (n3 < this.itemNames.length) {
            if (this.itemNames[n3].compareTo(this.ns.getString("nnaRunningTime")) == 0) {
                this.l = new LWLabel(new String(this.itemNames[n3]), 1);
                this.gbc.gridx = 0;
                ++this.gbc.gridy;
                this.gb.setConstraints((Component)this.l, this.gbc);
                this.textPanel.add((Component)this.l);
                this.itemText[n3] = new LWTextField(50);
                this.gbc.gridx = 0;
                this.gbc.gridy = 0;
                this.gb.setConstraints((Component)this.itemText[n3], this.gbc);
                this.runPanel.add((Component)this.itemText[n3]);
                this.itemText[n3].setEditable(false);
            } else {
                this.gbc.gridx = 0;
                ++this.gbc.gridy;
                this.gbc.gridwidth = -1;
                this.gbc.weightx = 0.0;
                this.gbc.weighty = n3 == 9 || n3 == 7 ? 0.0 : 10.0;
                this.l = new LWLabel(new String(this.itemNames[n3]), 1);
                this.gb.setConstraints((Component)this.l, this.gbc);
                this.gbc.gridx = -1;
                this.gbc.gridwidth = 0;
                this.gbc.weightx = 10.0;
                this.itemText[n3] = new LWTextField();
                this.gb.setConstraints((Component)this.itemText[n3], this.gbc);
                if (n3 < 3) {
                    this.textPanel.add((Component)this.l);
                    this.textPanel.add((Component)this.itemText[n3]);
                } else if (n3 < 7) {
                    this.statsPanel.add((Component)this.l);
                    this.statsPanel.add((Component)this.itemText[n3]);
                } else if (n3 < 9) {
                    this.srvrSchedPanel.add((Component)this.l);
                    this.srvrSchedPanel.add((Component)this.itemText[n3]);
                } else if (n3 < 11) {
                    this.statsSchedPanel.add((Component)this.l);
                    this.statsSchedPanel.add((Component)this.itemText[n3]);
                } else {
                    this.cacheSchedulePanel.add((Component)this.l);
                    this.cacheSchedulePanel.add((Component)this.itemText[n3]);
                }
                this.itemText[n3].setEditable(false);
            }
            ++n3;
        }
        ((Container)((Object)this)).add((Component)this.cbPanel, "North");
        ((Container)((Object)this)).add((Component)this.cardPanel, "Center");
        this.topGroup.setSelectedCheckbox(this.topCb[0]);
        this.cardLayout.show((Container)this.cardPanel, "serverPanel");
        NamesGeneric.debugTracing("Exiting class:NamesMonitor");
    }

    public void LoadFirstTime() {
        NamesGeneric.debugTracing("Entering LoadFirstTime:NamesMonitor");
        if (this.initialized) {
            return;
        }
        if (!nnccj.serverSet) {
            NetUtils.getApplication().showStatus(this.ns.getString("nnaNameServerUnreachable"));
        } else {
            this.LoadIntoScreen();
            this.initialized = true;
        }
        NamesGeneric.debugTracing("Exiting LoadFirstTime:NamesMonitor");
    }

    public void LoadIntoScreen() {
        NamesGeneric.debugTracing("Entering LoadIntoScreen:NamesMonitor");
        short s = this.initialized ? (short)1 : 3;
        int n = this.m_monitor.getMonitorInfo(s);
        if (n == 0) {
            String string = this.m_monitor.returnMonitorInfo();
            int n2 = 0;
            while (n2 < this.itemNames.length) {
                int n3 = string.indexOf("\n");
                if (this.itemNames[n2].compareTo(this.ns.getString("nnaVersion")) == 0) {
                    String string2 = string.substring(0, n3);
                    int n4 = string2.length();
                    int n5 = string2.indexOf(58) + 2;
                    while (n5 < n4 - 1 && !Character.isDigit(string2.charAt(n5))) {
                        ++n5;
                    }
                    this.itemText[n2].setText(string2.substring(n5, n4));
                } else {
                    this.itemText[n2].setText(string.substring(0, n3));
                }
                string = string.substring(n3 + 1);
                ++n2;
            }
        } else {
            this.clearPanel();
        }
        NamesGeneric.debugTracing("Exiting LoadIntoScreen:NamesMonitor");
    }

    public void clearPanel() {
        NamesGeneric.debugTracing("Entering clearPanel:NamesMonitor");
        int n = 0;
        while (n < this.itemNames.length) {
            this.itemText[n].setText("");
            ++n;
        }
        NamesGeneric.debugTracing("Exiting clearPanel:NamesMonitor");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        NamesGeneric.debugTracing("Entering itemStateChanged:NamesMonitor");
        if (object instanceof LWCheckbox) {
            String string = this.topGroup.getSelectedCheckbox().getLabel();
            String string2 = itemEvent.getItem().toString();
            if (string.compareTo(this.ns.getString("nnaServer")) == 0) {
                this.scheduleGroup.setSelectedCheckbox(null);
                int n = 0;
                while (n < this.scheduleItems.length) {
                    this.scheduleCb[n].setEnabled(false);
                    ++n;
                }
                this.cardLayout.show((Container)this.cardPanel, "serverPanel");
            } else if (string.compareTo(this.ns.getString("nnaStats")) == 0) {
                this.scheduleGroup.setSelectedCheckbox(null);
                int n = 0;
                while (n < this.scheduleItems.length) {
                    this.scheduleCb[n].setEnabled(false);
                    ++n;
                }
                this.cardLayout.show((Container)this.cardPanel, "statsPanel");
            } else {
                int n = 0;
                while (n < this.scheduleItems.length) {
                    this.scheduleCb[n].setEnabled(true);
                    ++n;
                }
                if (string2.compareTo(this.ns.getString("nnaServer")) == 0) {
                    this.cardLayout.show((Container)this.cardPanel, "srvrSchedPanel");
                } else if (string2.compareTo(this.ns.getString("nnaStats")) == 0) {
                    this.cardLayout.show((Container)this.cardPanel, "statsSchedPanel");
                } else if (string2.compareTo(this.ns.getString("nnaCache")) == 0) {
                    this.cardLayout.show((Container)this.cardPanel, "cachePanel");
                }
            }
        }
        NamesGeneric.debugTracing("Exiting itemStateChanged:NamesMonitor");
    }
}

