/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.nameswizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.wizard.BaseWizard;
import oracle.ewt.wizard.Wizard;
import oracle.ewt.wizard.WizardDialog;
import oracle.ewt.wizard.WizardEvent;
import oracle.ewt.wizard.WizardListener;
import oracle.ewt.wizard.WizardPage;
import oracle.ewt.wizard.WizardValidateListener;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.nnccj;
import oracle.net.asst.nameswizard.DBAddress;
import oracle.net.asst.nameswizard.DBPasswordPanel;
import oracle.net.asst.nameswizard.DiscoverNS;
import oracle.net.asst.nameswizard.DomainHint;
import oracle.net.asst.nameswizard.DomainList;
import oracle.net.asst.nameswizard.DomainName;
import oracle.net.asst.nameswizard.FinalPanel;
import oracle.net.asst.nameswizard.FirstNSDecision;
import oracle.net.asst.nameswizard.FirstPanel;
import oracle.net.asst.nameswizard.MinTTL;
import oracle.net.asst.nameswizard.NamesWizardInterface;
import oracle.net.asst.nameswizard.RegionDBDecision;
import oracle.net.asst.nameswizard.RegionDBInfo;
import oracle.net.asst.nameswizard.RegionInfo;
import oracle.net.asst.nameswizard.RootRegionDecision;
import oracle.net.asst.nameswizard.SIDPanel;
import oracle.net.asst.nameswizard.ServerAddress;
import oracle.net.asst.nameswizard.ServerName;
import oracle.net.asst.nameswizard.UserPanel;
import oracle.net.asst.nameswizard.WKNSAddress;
import oracle.net.asst.nameswizard.WizardInfo;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NamesWizardMain
implements ActionListener,
WizardListener,
WizardValidateListener {
    private static final int WIZARD_WIDTH = 520;
    private static final int WIZARD_HEIGHT = 364;
    private NetStrings ns = new NetStrings();
    private BufferedFrame namesWizardFrame;
    private static Vector domainVector = new Vector();
    private boolean regionDBUsed = false;
    private boolean serverInRootRegion = false;
    private boolean discoveredNS = false;
    private nnccj m_nnccj = new nnccj(0);
    private Wizard m_namesWizard;
    private WizardDialog m_namesDialog;
    public boolean wizardFinishState = false;
    public String serverName;
    public String serverAddress;
    private FirstPanel m_firstPanel;
    private ServerName m_serverNamePanel;
    private WizardInfo m_wizardInfoPanel;
    private ServerAddress m_serverAddress;
    private RegionInfo m_regionInfoPanel;
    private RegionDBDecision m_regionDBDecision;
    private RegionDBInfo m_regionDBInfo;
    private DBAddress m_dbAddressPanel;
    private SIDPanel m_SIDPanel;
    private UserPanel m_userPanel;
    private DBPasswordPanel m_dbPassword;
    private RootRegionDecision m_rootDecision;
    private FirstNSDecision m_firstNSDecision;
    private DomainName m_domainName;
    private MinTTL m_minttlPanel;
    private FinalPanel m_finalPanel;
    private DomainList m_domainList;
    private DomainHint m_domainHint;
    private WKNSAddress m_wknsAddress;
    private DiscoverNS m_discoverNS;
    private WizardPage m_serverNamePage;
    private WizardPage m_regionDBDecisionPage;
    private WizardPage m_SIDPage;
    private WizardPage m_userPage;
    private WizardPage m_dbPasswordPage;
    private WizardPage m_regionInfoPage;
    private WizardPage m_rootDecisionPage;
    private WizardPage m_firstNSDecisionPage;
    private WizardPage m_firstPage;
    private WizardPage m_finalPanelPage;
    private WizardPage m_domainListPage;
    private WizardPage m_domainNamePage;
    private WizardPage m_minttlPage;
    private WizardPage m_serverAddressPage;
    private WizardPage m_domainHintPage;
    private WizardPage m_dbAddressPage;
    private WizardPage m_wknsAddressPage;
    private WizardPage m_discoverNSPage;
    private WizardPage m_regionDBInfoPage;
    private WizardPage m_wizardInfoPage;
    private String filename;

    public NamesWizardMain(BufferedFrame bufferedFrame, String string) {
        BufferedFrame bufferedFrame2;
        NamesGeneric.debugTracing("Entering init:NamesWizardMain");
        this.namesWizardFrame = bufferedFrame;
        this.filename = String.valueOf(string) + "names.ora";
        this.m_namesWizard = new Wizard();
        NamesGeneric.appFrame = bufferedFrame2 = this.namesWizardFrame;
        this.createWizardPanels();
        this.initialPanelSetup();
        this.m_namesWizard.addWizardListener((WizardListener)this);
        this.m_namesWizard.setMustFinish(true);
        this.m_namesWizard.setHelpAvailable(false);
        this.m_namesWizard.setCanApply(false);
        NamesGeneric.debugTracing("Exiting init:NamesWizardMain");
    }

    public void go() {
        this.m_namesDialog = new WizardDialog((BaseWizard)this.m_namesWizard, (Frame)this.namesWizardFrame, true);
        this.m_namesDialog.setTitle(this.ns.getString("nnaNamesWizard"));
        this.m_namesDialog.setResizable(false);
        Dimension dimension = this.namesWizardFrame.getToolkit().getScreenSize();
        this.m_namesDialog.setBounds((dimension.width - 520) / 2, (dimension.height - 364) / 2, 520, 364);
        this.m_namesDialog.setPreferredSize(520, 364);
        try {
            NamesGeneric.debugTracing("Running the wizard");
            this.m_namesDialog.runDialog();
            return;
        }
        catch (IllegalStateException illegalStateException) {
            System.err.println("NamesWizardMain.go(): " + illegalStateException);
            return;
        }
    }

    public void wizardValidatePage(WizardEvent wizardEvent) {
        WizardPage wizardPage = wizardEvent.getPage();
        NamesWizardInterface namesWizardInterface = this.getWizardPage(wizardPage);
        NamesGeneric.debugTracing("Current page: " + wizardPage.toString());
        if (!namesWizardInterface.isPageValid()) {
            NamesGeneric.debugTracing("Cancelling page " + wizardPage.toString());
            ((Cancelable)wizardEvent).cancel();
        }
        if (wizardPage == this.m_regionDBDecisionPage) {
            String string = this.m_regionDBDecision.getPageData();
            this.regionDBUsed = Boolean.valueOf(string);
            this.useRegionDBPages(this.regionDBUsed);
            return;
        }
        if (wizardPage == this.m_rootDecisionPage) {
            String string = this.m_rootDecision.getPageData();
            this.serverInRootRegion = Boolean.valueOf(string);
            this.nsInRootRegion(this.serverInRootRegion);
            return;
        }
        if (wizardPage == this.m_firstNSDecisionPage) {
            String string = this.m_firstNSDecision.getPageData();
            this.firstNSInRegion(Boolean.valueOf(string));
            return;
        }
        if (wizardPage == this.m_discoverNSPage) {
            if (!this.discoveredNS) {
                String string = this.m_discoverNS.getPageData();
                this.discoveredNS = Boolean.valueOf(string);
            }
            this.m_wknsAddressPage.setEnabled(!this.discoveredNS);
            this.m_wknsAddressPage.setVisible(!this.discoveredNS);
            return;
        }
        if (wizardPage == this.m_wknsAddressPage) {
            NamesGeneric.debugTracing("Discovery on the address page.");
            this.discoveredNS = this.m_wknsAddress.discoveredNS;
            if (this.discoveredNS) {
                this.m_discoverNSPage.setEnabled(false);
                this.m_discoverNSPage.setVisible(false);
            }
        }
    }

    public void wizardApplyState(WizardEvent wizardEvent) {
    }

    public void wizardCanceled(WizardEvent wizardEvent) {
        this.m_namesDialog.setVisible(false);
        this.m_namesDialog.dispose();
    }

    public void wizardFinished(WizardEvent wizardEvent) {
        NLParamParser nLParamParser = null;
        NVFactory nVFactory = new NVFactory();
        NamesGeneric.debugTracing("Will start saving now.");
        try {
            nLParamParser = new NLParamParser(this.filename);
            this.serverName = this.m_serverNamePanel.getPageData();
            nLParamParser.addNLPListElement("names.server_name=" + this.serverName);
            this.serverAddress = this.m_serverAddress.getPageData();
            nLParamParser.addNLPListElement("names.addresses=" + this.serverAddress);
            if (this.regionDBUsed) {
                NamesGeneric.debugTracing("Region DB used.");
                NVPair nVPair = nVFactory.createNVPair("(REGION=)");
                NVPair nVPair2 = nVFactory.createNVPair("(DESCRIPTION=)");
                NVPair nVPair3 = nVFactory.createNVPair("(CONNECT_DATA=)");
                NVPair nVPair4 = nVFactory.createNVPair(this.m_dbAddressPanel.getPageData());
                NVPair nVPair5 = nVFactory.createNVPair("(SID=" + this.m_SIDPanel.getPageData() + ")");
                NVPair nVPair6 = nVFactory.createNVPair("(Server=Dedicated)");
                nVPair3.addListElement(nVPair5);
                nVPair3.addListElement(nVPair6);
                nVPair2.addListElement(nVPair4);
                nVPair2.addListElement(nVPair3);
                NVPair nVPair7 = nVFactory.createNVPair("(USERID=" + this.m_userPanel.getPageData() + ")");
                NVPair nVPair8 = nVFactory.createNVPair("(PASSWORD=" + this.m_dbPassword.getPageData() + ")");
                nVPair.addListElement(nVPair2);
                nVPair.addListElement(nVPair7);
                nVPair.addListElement(nVPair8);
                nVPair.addListElement(nVFactory.createNVPair("(NAME=LOCAL_REGION)"));
                nVPair.addListElement(nVFactory.createNVPair("(REFRESH=86400)"));
                nVPair.addListElement(nVFactory.createNVPair("(RETRY=60)"));
                nVPair.addListElement(nVFactory.createNVPair("(EXPIRE=600)"));
                nVPair.addListElement(nVFactory.createNVPair("(VERSION=134230016)"));
                nLParamParser.addNLPListElement("names.admin_region=" + nVPair.toString());
            }
            if (!this.serverInRootRegion) {
                NamesGeneric.debugTracing("Server in root region.");
                nLParamParser.addNLPListElement("names.domains=" + this.m_domainList.getPageData());
                nLParamParser.addNLPListElement("names.domain_hints=" + this.m_domainHint.getPageData());
            }
            nLParamParser.saveNLParams(this.filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            NamesGeneric.debugTracing("IO exception: " + iOException.toString());
        }
        catch (NLException nLException) {
            NamesGeneric.debugTracing("NL exception:" + nLException.toString());
        }
        catch (Exception exception) {
            NamesGeneric.debugTracing("general exception:" + exception.toString());
        }
        NamesGeneric.debugTracing("Wizard save end");
        this.wizardFinishState = true;
        this.m_namesDialog.setVisible(false);
        this.m_namesDialog.dispose();
    }

    public void wizardSelectionChanged(WizardEvent wizardEvent) {
        WizardPage wizardPage = wizardEvent.getPage();
        if (wizardPage == this.m_domainNamePage) {
            this.m_domainName.setDomainName(this.getFirstDomainName());
            return;
        }
        if (wizardPage == this.m_minttlPage) {
            this.m_minttlPanel.setMinTTL(this.getFirstDomainTTL());
            return;
        }
        if (wizardPage == this.m_domainListPage) {
            NVFactory nVFactory = new NVFactory();
            NVPair nVPair = nVFactory.createNVPair("(DOMAIN=)");
            NVPair nVPair2 = nVFactory.createNVPair("(Name=" + this.m_domainName.getPageData() + ")");
            NVPair nVPair3 = nVFactory.createNVPair("(MIN_TTL=" + this.m_minttlPanel.getPageData() + ")");
            nVPair.addListElement(nVPair2);
            nVPair.addListElement(nVPair3);
            if (domainVector != null && domainVector.size() > 0) {
                domainVector.removeElementAt(0);
            }
            domainVector.insertElementAt(nVPair, 0);
            this.m_domainList.setDomains(domainVector);
            return;
        }
        if (wizardPage == this.m_rootDecisionPage && this.discoveredNS) {
            this.m_discoverNSPage.setEnabled(false);
            this.m_discoverNSPage.setVisible(false);
            this.m_wknsAddressPage.setEnabled(false);
            this.m_wknsAddressPage.setVisible(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        actionEvent.getActionCommand();
    }

    private void createWizardPanels() {
        NamesGeneric.debugTracing("Creating wizard pages");
        this.m_firstPanel = new FirstPanel();
        this.m_firstPage = new WizardPage((Component)((Object)this.m_firstPanel), this.ns.getString("nnaFirstPanel"));
        this.m_namesWizard.addPage(this.m_firstPage);
        this.m_firstPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_wizardInfoPanel = new WizardInfo();
        this.m_wizardInfoPage = new WizardPage((Component)((Object)this.m_wizardInfoPanel), this.ns.getString("nnaWizardInfo"));
        this.m_namesWizard.addPage(this.m_wizardInfoPage);
        this.m_wizardInfoPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_serverNamePanel = new ServerName();
        this.m_serverNamePage = new WizardPage((Component)((Object)this.m_serverNamePanel), this.ns.getString("nnaServerNamePage"));
        this.m_namesWizard.addPage(this.m_serverNamePage);
        this.m_serverNamePage.addWizardValidateListener((WizardValidateListener)this);
        this.m_serverAddress = new ServerAddress();
        this.m_serverAddressPage = new WizardPage((Component)((Object)this.m_serverAddress), this.ns.getString("nnaServerAddr"));
        this.m_namesWizard.addPage(this.m_serverAddressPage);
        this.m_serverAddressPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_regionInfoPanel = new RegionInfo();
        this.m_regionInfoPage = new WizardPage((Component)((Object)this.m_regionInfoPanel), this.ns.getString("nnaRegionInfo"));
        this.m_namesWizard.addPage(this.m_regionInfoPage);
        this.m_regionInfoPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_regionDBDecision = new RegionDBDecision();
        this.m_regionDBDecisionPage = new WizardPage((Component)((Object)this.m_regionDBDecision), this.ns.getString("nnaUseRDB"));
        this.m_namesWizard.addPage(this.m_regionDBDecisionPage);
        this.m_regionDBDecisionPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_regionDBInfo = new RegionDBInfo();
        this.m_regionDBInfoPage = new WizardPage((Component)((Object)this.m_regionDBInfo), this.ns.getString("nnaRegionDBInfo"));
        this.m_namesWizard.addPage(this.m_regionDBInfoPage);
        this.m_regionDBInfoPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_dbAddressPanel = new DBAddress();
        this.m_dbAddressPage = new WizardPage((Component)((Object)this.m_dbAddressPanel), this.ns.getString("nnaDBAddress"));
        this.m_namesWizard.addPage(this.m_dbAddressPage);
        this.m_dbAddressPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_SIDPanel = new SIDPanel();
        this.m_SIDPage = new WizardPage((Component)((Object)this.m_SIDPanel), this.ns.getString("nnaDBSID"));
        this.m_namesWizard.addPage(this.m_SIDPage);
        this.m_SIDPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_userPanel = new UserPanel();
        this.m_userPage = new WizardPage((Component)((Object)this.m_userPanel), this.ns.getString("nnaDBUser"));
        this.m_namesWizard.addPage(this.m_userPage);
        this.m_userPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_dbPassword = new DBPasswordPanel();
        this.m_dbPasswordPage = new WizardPage((Component)((Object)this.m_dbPassword), this.ns.getString("nnaDBPassword"));
        this.m_namesWizard.addPage(this.m_dbPasswordPage);
        this.m_dbPasswordPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_firstNSDecision = new FirstNSDecision();
        this.m_firstNSDecisionPage = new WizardPage((Component)((Object)this.m_firstNSDecision), this.ns.getString("nnaFirstNS"));
        this.m_namesWizard.addPage(this.m_firstNSDecisionPage);
        this.m_firstNSDecisionPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_discoverNS = new DiscoverNS();
        this.m_discoverNSPage = new WizardPage((Component)((Object)this.m_discoverNS), this.ns.getString("nnaDiscoverNS"));
        this.m_namesWizard.addPage(this.m_discoverNSPage);
        this.m_discoverNSPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_wknsAddress = new WKNSAddress();
        this.m_wknsAddressPage = new WizardPage((Component)((Object)this.m_wknsAddress), this.ns.getString("nnaWKNSAddress"));
        this.m_namesWizard.addPage(this.m_wknsAddressPage);
        this.m_wknsAddressPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_rootDecision = new RootRegionDecision();
        this.m_rootDecisionPage = new WizardPage((Component)((Object)this.m_rootDecision), this.ns.getString("nnaRootRegion"));
        this.m_namesWizard.addPage(this.m_rootDecisionPage);
        this.m_rootDecisionPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_domainName = new DomainName();
        this.m_domainNamePage = new WizardPage((Component)((Object)this.m_domainName), this.ns.getString("nnaDomName"));
        this.m_namesWizard.addPage(this.m_domainNamePage);
        this.m_domainNamePage.addWizardValidateListener((WizardValidateListener)this);
        this.m_minttlPanel = new MinTTL();
        this.m_minttlPage = new WizardPage((Component)((Object)this.m_minttlPanel), this.ns.getString("nnaMinTTl"));
        this.m_namesWizard.addPage(this.m_minttlPage);
        this.m_minttlPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_domainList = new DomainList();
        this.m_domainListPage = new WizardPage((Component)((Object)this.m_domainList), this.ns.getString("nnaDomainList"));
        this.m_namesWizard.addPage(this.m_domainListPage);
        this.m_domainListPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_domainHint = new DomainHint();
        this.m_domainHintPage = new WizardPage((Component)((Object)this.m_domainHint), this.ns.getString("nnaDomainHint"));
        this.m_namesWizard.addPage(this.m_domainHintPage);
        this.m_domainHintPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_finalPanel = new FinalPanel();
        this.m_finalPanelPage = new WizardPage((Component)((Object)this.m_finalPanel), this.ns.getString("nnaFinalPanel"));
        this.m_namesWizard.addPage(this.m_finalPanelPage);
        this.m_finalPanelPage.addWizardValidateListener((WizardValidateListener)this);
        NamesGeneric.debugTracing("Wizard page creation complete");
    }

    private void initialPanelSetup() {
        NamesGeneric.debugTracing("Initial setup");
        this.m_firstPage.setEnabled(true);
        this.m_firstPage.setVisible(true);
        this.m_wizardInfoPage.setEnabled(true);
        this.m_wizardInfoPage.setVisible(true);
        this.m_serverNamePage.setEnabled(true);
        this.m_serverNamePage.setVisible(true);
        this.m_serverAddressPage.setEnabled(true);
        this.m_serverAddressPage.setVisible(true);
        this.m_regionInfoPage.setEnabled(true);
        this.m_regionInfoPage.setVisible(true);
        this.m_regionDBDecisionPage.setEnabled(true);
        this.m_regionDBDecisionPage.setVisible(true);
        this.m_regionDBInfoPage.setEnabled(false);
        this.m_regionDBInfoPage.setVisible(false);
        this.m_dbAddressPage.setEnabled(false);
        this.m_dbAddressPage.setVisible(false);
        this.m_SIDPage.setEnabled(false);
        this.m_SIDPage.setVisible(false);
        this.m_userPage.setEnabled(false);
        this.m_userPage.setVisible(false);
        this.m_dbPasswordPage.setEnabled(false);
        this.m_dbPasswordPage.setVisible(false);
        this.m_rootDecisionPage.setEnabled(false);
        this.m_rootDecisionPage.setVisible(false);
        this.m_firstNSDecisionPage.setEnabled(false);
        this.m_firstNSDecisionPage.setVisible(false);
        this.m_discoverNSPage.setEnabled(false);
        this.m_discoverNSPage.setVisible(false);
        this.m_wknsAddressPage.setEnabled(false);
        this.m_wknsAddressPage.setVisible(false);
        this.m_domainNamePage.setEnabled(false);
        this.m_domainNamePage.setVisible(false);
        this.m_minttlPage.setEnabled(false);
        this.m_minttlPage.setVisible(false);
        this.m_domainListPage.setEnabled(false);
        this.m_domainListPage.setVisible(false);
        this.m_domainHintPage.setEnabled(false);
        this.m_domainHintPage.setVisible(false);
        this.m_finalPanelPage.setEnabled(true);
        this.m_finalPanelPage.setVisible(true);
        NamesGeneric.debugTracing("Initial setup end");
    }

    private NamesWizardInterface getWizardPage(WizardPage wizardPage) {
        if (wizardPage == this.m_firstPage) {
            return this.m_firstPanel;
        }
        if (wizardPage == this.m_wizardInfoPage) {
            return this.m_wizardInfoPanel;
        }
        if (wizardPage == this.m_serverNamePage) {
            return this.m_serverNamePanel;
        }
        if (wizardPage == this.m_serverAddressPage) {
            return this.m_serverAddress;
        }
        if (wizardPage == this.m_regionInfoPage) {
            return this.m_regionInfoPanel;
        }
        if (wizardPage == this.m_regionDBDecisionPage) {
            return this.m_regionDBDecision;
        }
        if (wizardPage == this.m_SIDPage) {
            return this.m_SIDPanel;
        }
        if (wizardPage == this.m_userPage) {
            return this.m_userPanel;
        }
        if (wizardPage == this.m_dbPasswordPage) {
            return this.m_dbPassword;
        }
        if (wizardPage == this.m_rootDecisionPage) {
            return this.m_rootDecision;
        }
        if (wizardPage == this.m_firstNSDecisionPage) {
            return this.m_firstNSDecision;
        }
        if (wizardPage == this.m_domainListPage) {
            return this.m_domainList;
        }
        if (wizardPage == this.m_domainNamePage) {
            return this.m_domainName;
        }
        if (wizardPage == this.m_minttlPage) {
            return this.m_minttlPanel;
        }
        if (wizardPage == this.m_domainHintPage) {
            return this.m_domainHint;
        }
        if (wizardPage == this.m_regionDBInfoPage) {
            return this.m_regionDBInfo;
        }
        if (wizardPage == this.m_dbAddressPage) {
            return this.m_dbAddressPanel;
        }
        if (wizardPage == this.m_wknsAddressPage) {
            return this.m_wknsAddress;
        }
        if (wizardPage == this.m_discoverNSPage) {
            return this.m_discoverNS;
        }
        if (wizardPage == this.m_finalPanelPage) {
            return this.m_finalPanel;
        }
        return null;
    }

    private void useRegionDBPages(boolean bl) {
        NamesGeneric.debugTracing("Setting for regionDBPages: " + bl);
        this.m_regionDBInfoPage.setEnabled(bl);
        this.m_regionDBInfoPage.setVisible(bl);
        this.m_dbAddressPage.setEnabled(bl);
        this.m_dbAddressPage.setVisible(bl);
        this.m_SIDPage.setEnabled(bl);
        this.m_SIDPage.setVisible(bl);
        this.m_userPage.setEnabled(bl);
        this.m_userPage.setVisible(bl);
        this.m_dbPasswordPage.setEnabled(bl);
        this.m_dbPasswordPage.setVisible(bl);
        this.m_rootDecisionPage.setEnabled(bl);
        this.m_rootDecisionPage.setVisible(bl);
        this.m_firstNSDecisionPage.setEnabled(!bl);
        this.m_firstNSDecisionPage.setVisible(!bl);
        this.m_domainNamePage.setEnabled(false);
        this.m_domainNamePage.setVisible(false);
        this.m_minttlPage.setEnabled(false);
        this.m_minttlPage.setVisible(false);
        this.m_domainListPage.setEnabled(false);
        this.m_domainListPage.setVisible(false);
        this.m_domainHintPage.setEnabled(false);
        this.m_domainHintPage.setVisible(false);
        this.m_discoverNSPage.setEnabled(false);
        this.m_discoverNSPage.setVisible(false);
        this.m_wknsAddressPage.setEnabled(false);
        this.m_wknsAddressPage.setVisible(false);
    }

    private void nsInRootRegion(boolean bl) {
        NamesGeneric.debugTracing("Setting for nsInRootRegion: " + bl);
        this.m_discoverNSPage.setEnabled(false);
        this.m_discoverNSPage.setVisible(false);
        this.m_wknsAddressPage.setEnabled(false);
        this.m_wknsAddressPage.setVisible(false);
        this.m_domainNamePage.setEnabled(!bl);
        this.m_domainNamePage.setVisible(!bl);
        this.m_minttlPage.setEnabled(!bl);
        this.m_minttlPage.setVisible(!bl);
        this.m_domainListPage.setEnabled(!bl);
        this.m_domainListPage.setVisible(!bl);
        this.m_domainHintPage.setEnabled(!bl);
        this.m_domainHintPage.setVisible(!bl);
    }

    private void firstNSInRegion(boolean bl) {
        NamesGeneric.debugTracing("Setting for firstNSInRegion: " + bl);
        this.m_rootDecisionPage.setEnabled(true);
        this.m_rootDecisionPage.setVisible(true);
        this.m_discoverNSPage.setEnabled(!bl);
        this.m_discoverNSPage.setVisible(!bl);
        this.m_wknsAddressPage.setEnabled(false);
        this.m_wknsAddressPage.setVisible(false);
        this.m_domainNamePage.setEnabled(false);
        this.m_domainNamePage.setVisible(false);
        this.m_minttlPage.setEnabled(false);
        this.m_minttlPage.setVisible(false);
        this.m_domainListPage.setEnabled(false);
        this.m_domainListPage.setVisible(false);
        this.m_domainHintPage.setEnabled(false);
        this.m_domainHintPage.setVisible(false);
    }

    private void serverIsWK(boolean bl) {
        NamesGeneric.debugTracing("Setting for serverIsWK: " + bl);
        if (this.discoveredNS) {
            this.m_discoverNSPage.setEnabled(false);
            this.m_discoverNSPage.setVisible(false);
        } else {
            this.m_discoverNSPage.setEnabled(!bl);
            this.m_discoverNSPage.setVisible(!bl);
        }
        this.m_rootDecisionPage.setEnabled(!bl);
        this.m_rootDecisionPage.setVisible(!bl);
        this.m_wknsAddressPage.setEnabled(false);
        this.m_wknsAddressPage.setVisible(false);
        this.m_domainNamePage.setEnabled(false);
        this.m_domainNamePage.setVisible(false);
        this.m_minttlPage.setEnabled(false);
        this.m_minttlPage.setVisible(false);
        this.m_domainListPage.setEnabled(false);
        this.m_domainListPage.setVisible(false);
        this.m_domainHintPage.setEnabled(false);
        this.m_domainHintPage.setVisible(false);
    }

    public static void setDomains(Vector vector) {
        domainVector = vector;
    }

    private String getFirstDomainName() {
        if (domainVector == null || domainVector.size() == 0) {
            return null;
        }
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = nVNavigator.findNVPairRecurse((NVPair)domainVector.elementAt(0), "Name");
        return nVPair.getAtom();
    }

    private String getFirstDomainTTL() {
        if (domainVector == null || domainVector.size() == 0) {
            return "86400";
        }
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = nVNavigator.findNVPairRecurse((NVPair)domainVector.elementAt(0), "MIN_TTL");
        return nVPair.getAtom();
    }

    private boolean getBooleanValue(String string) {
        return Boolean.valueOf(string);
    }

    public boolean getWizardFinishState() {
        return this.wizardFinishState;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }
}

