/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.nameswizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import oracle.ewt.EwtContainer;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.nameswizard.BasicWizardPanel;
import oracle.net.asst.nameswizard.NamesWizardInterface;
import oracle.net.asst.profile.NetAddr;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class ServerAddress
extends BasicWizardPanel
implements NamesWizardInterface {
    private EwtContainer contentPanel;
    private NetAddr addrPanel;
    private GridBagLayout gb;
    private GridBagConstraints gbc;
    private MultiLineLabel multiLabel;
    private TextWrapper Textwrap = WordWrapper.getTextWrapper();
    private NetStrings ns = new NetStrings();
    private NVFactory nvf = new NVFactory();
    private NVPair address;

    public ServerAddress() {
        NamesGeneric.debugTracing("Entering init:ServerAddress");
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.insets.left = 5;
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.contentPanel = new EwtContainer();
        this.contentPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.contentPanel, this.gbc);
        try {
            this.multiLabel = new MultiLineLabel(this.Textwrap, this.ns.getString("nnaServerAddrMsg1"));
            this.multiLabel.setAlignment(1);
            this.multiLabel.setWrapWidth(350);
        }
        catch (NullPointerException nullPointerException) {}
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weighty = 0.5;
        this.gbc.weightx = 0.25;
        this.gbc.gridwidth = 2;
        this.gb.setConstraints((Component)this.multiLabel, this.gbc);
        this.contentPanel.add((Component)this.multiLabel);
        try {
            this.multiLabel = new MultiLineLabel(this.Textwrap, this.ns.getString("nnaServerAddrMsg2"));
            this.multiLabel.setAlignment(1);
            this.multiLabel.setWrapWidth(350);
        }
        catch (NullPointerException nullPointerException) {}
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.weighty = 1.0;
        this.gbc.weightx = 0.25;
        this.gbc.gridwidth = 2;
        this.gb.setConstraints((Component)this.multiLabel, this.gbc);
        this.contentPanel.add((Component)this.multiLabel);
        String string = NamesGeneric.getLocalHost();
        this.address = this.nvf.createNVPair("(Address=(protocol=tcp)(host=" + string + "))");
        this.addrPanel = new NetAddr(this.address);
        this.addrPanel.setAppEnv(NetUtils.getApplication());
        this.gbc.gridwidth = 1;
        ++this.gbc.gridy;
        this.gbc.weighty = 0.5;
        this.gb.setConstraints((Component)((Object)this.addrPanel), this.gbc);
        this.contentPanel.add((Component)((Object)this.addrPanel));
        this.setImage("images/NamesWiz.gif");
        this.setInteractiveArea((Component)this.contentPanel);
        NamesGeneric.debugTracing("Exiting init:ServerAddress");
    }

    public String getPageData() {
        this.address = this.addrPanel.getAddr();
        return this.address.toString();
    }

    public boolean isPageValid() {
        if (!this.addrPanel.areDataValid()) {
            this.addrPanel.setFocus();
            return false;
        }
        this.address = this.addrPanel.getAddr();
        if (this.address == null) {
            String string = this.ns.getString("nnaError");
            String string2 = this.ns.getString("nnaAddressNull");
            NamesDialog.popUp(string, string2, 2);
            return false;
        }
        return true;
    }
}

