/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.nsnMigrationWizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.meter.BusyBar;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.asst.container.NetStrings;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.FileDataStore;
import oracle.net.common.dataStore.LDAPDataStore;
import oracle.net.common.dataStore.NetServiceHandler;
import oracle.net.common.netObject.NetObject;

public class MigrateUpdatePanel
extends EwtContainer {
    private String m_messageBase;
    private String m_statusBase;
    private String m_completeMessage;
    private MultiLineLabel m_message;
    private BusyBar m_status;
    private LWTextArea m_resultText;
    private String m_context;
    private String[] m_services;
    private int m_authType;
    private String[] m_credentials;
    private boolean m_updateOnNextDisplay;
    private FileDataStore m_fds;
    private NetStrings m_netStrings;

    public MigrateUpdatePanel(FileDataStore fileDataStore) {
        this.m_fds = fileDataStore;
        if (fileDataStore == null) {
            throw new NullPointerException("null data store in <init>");
        }
        this.m_netStrings = new NetStrings();
        this.m_messageBase = this.m_netStrings.getString("MGWupdateWritingToServer");
        this.m_message = new MultiLineLabel(WordWrapper.getTextWrapper(), this.m_messageBase);
        this.m_message.setPreferredAspectRatio(7.0f);
        this.m_resultText = new LWTextArea();
        this.m_resultText.setEditable(false);
        this.m_statusBase = this.m_netStrings.getString("MGWupdateWritingElement");
        this.m_completeMessage = this.m_netStrings.getString("MGWupdateComplete");
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        ((Container)((Object)this)).add((Component)this.m_message, gridBagConstraints);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.top = 15;
        ((Container)((Object)this)).add((Component)new ScrollBox((Component)this.m_resultText), gridBagConstraints);
    }

    public void update(String[] stringArray, String string, int n, String[] stringArray2) {
        this.m_services = stringArray;
        this.m_context = string;
        this.m_authType = n;
        this.m_credentials = stringArray2;
        this.m_updateOnNextDisplay = true;
    }

    private void _update() {
        this.m_message.setText(String.valueOf(this.m_messageBase) + this.m_context);
        NetServiceHandler netServiceHandler = null;
        NetServiceHandler netServiceHandler2 = null;
        try {
            netServiceHandler = this.m_fds.getNetServiceHandler();
            LDAPDataStore lDAPDataStore = new LDAPDataStore(this.m_context);
            lDAPDataStore.setAuthInfo(this.m_authType, this.m_credentials);
            netServiceHandler2 = lDAPDataStore.getNetServiceHandler();
        }
        catch (DataStoreException dataStoreException) {
            this.m_resultText.append(this.m_netStrings.getString("MGWupdateErrorDataStore"));
            this.m_resultText.append(dataStoreException.getMessage());
            return;
        }
        int n = 0;
        while (n < this.m_services.length) {
            this.m_resultText.append("\n" + this.m_statusBase + this.m_services[n]);
            int n2 = this.m_services[n].indexOf(46);
            if (n2 == -1) {
                n2 = this.m_services[n].length();
            }
            String string = this.m_services[n].substring(0, n2);
            try {
                NetObject netObject = netServiceHandler.getElement(this.m_services[n]);
                netObject.setName(string);
                netServiceHandler2.addElement(netObject);
                this.m_resultText.append(String.valueOf(this.m_netStrings.getString("MGWupdateDone")) + "\n");
            }
            catch (DataStoreException dataStoreException) {
                Object[] objectArray = new Object[]{this.m_services[n], this.m_context};
                this.m_resultText.append(String.valueOf(this.m_netStrings.getString("MGWupdateErrorWriting", objectArray)) + "\n");
                this.m_resultText.append(String.valueOf(this.m_netStrings.getString("MGWupdateDetails")) + "\n");
                this.m_resultText.append(dataStoreException.getMessage());
            }
            ++n;
        }
        this.m_resultText.append("\n" + this.m_netStrings.getString("MGWupdateComplete"));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_updateOnNextDisplay) {
            this.m_updateOnNextDisplay = false;
            this._update();
        }
    }
}

