/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.nsnMigrationWizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import oracle.ewt.alert.Alert;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.wizard.BaseWizard;
import oracle.ewt.wizard.ImageWizardPage;
import oracle.ewt.wizard.Wizard;
import oracle.ewt.wizard.WizardDialog;
import oracle.ewt.wizard.WizardEvent;
import oracle.ewt.wizard.WizardListener;
import oracle.ewt.wizard.WizardPage;
import oracle.ewt.wizard.WizardValidateListener;
import oracle.net.asst.container.ExceptionMessage;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.nsnMigrationWizard.MigrateContextPanel;
import oracle.net.asst.nsnMigrationWizard.MigrateDomainPanel;
import oracle.net.asst.nsnMigrationWizard.MigrateIntroPanel;
import oracle.net.asst.nsnMigrationWizard.MigrateServicePanel;
import oracle.net.asst.nsnMigrationWizard.MigrateUpdatePanel;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.FileDataStore;
import oracle.net.common.dataStore.NetServiceHandler;

public final class NSNMigrationWizard
implements WizardListener,
WizardValidateListener {
    private NetStrings m_netStrings;
    private BufferedFrame m_frame;
    private Wizard m_wizard;
    private WizardDialog m_dialog;
    private MigrateIntroPanel m_introPanel;
    private MigrateDomainPanel m_domainPanel;
    private MigrateServicePanel m_servicePanel;
    private MigrateContextPanel m_contextPanel;
    private MigrateUpdatePanel m_updatePanel;
    private WizardPage m_introPage;
    private WizardPage m_domainPage;
    private WizardPage m_servicePage;
    private WizardPage m_contextPage;
    private WizardPage m_updatePage;
    private FileDataStore m_fileDataStore;
    private NetServiceHandler m_fileNSHandler;
    private boolean m_initFailed;
    private boolean m_wizardCancelled;
    private boolean m_multipleDomains;
    private String m_titleBase;
    private int m_authType;
    private String[] m_credentials;
    private String m_selectedDomain;
    private String[] m_selectedServices;
    private String m_selectedContext;

    public NSNMigrationWizard(BufferedFrame bufferedFrame, FileDataStore fileDataStore, int n, String[] stringArray) {
        if (bufferedFrame == null || fileDataStore == null) {
            throw new NullPointerException("Null param to NSNMigrationWizard");
        }
        this.m_frame = bufferedFrame;
        this.m_fileDataStore = fileDataStore;
        this.m_authType = n;
        this.m_credentials = stringArray;
        this.m_netStrings = new NetStrings();
        this.m_titleBase = this.m_netStrings.getString("MGWtitleBase");
        try {
            this.m_fileNSHandler = this.m_fileDataStore.getNetServiceHandler();
            if (!this.m_fileNSHandler.enum().hasMoreElements()) {
                ExceptionMessage.display((Component)bufferedFrame, "No local net service names found.", null);
                this.m_initFailed = true;
                return;
            }
        }
        catch (Exception exception) {
            ExceptionMessage.display((Component)bufferedFrame, "Error accessing local data storage.", exception);
            exception.printStackTrace();
            this.m_initFailed = true;
            return;
        }
        this.m_wizard = new Wizard();
        this.m_dialog = new WizardDialog((BaseWizard)this.m_wizard, (Frame)this.m_frame);
        this.m_wizard.setMustFinish(true);
        this.m_wizard.setHelpAvailable(false);
        this.m_wizard.setCanApply(false);
        this.m_initFailed = !this._initWizardPanels();
        this.m_wizard.addWizardListener((WizardListener)this);
        this.m_dialog.setPreferredSize(600, 360);
        this.m_dialog.setSize(600, 360);
        this.m_dialog.setResizable(false);
        NetUtils.centerDialog((Dialog)this.m_dialog, (Component)this.m_frame);
    }

    public boolean go() {
        if (this.m_initFailed) {
            return false;
        }
        this.m_dialog.runDialog();
        return !this.m_wizardCancelled;
    }

    public String getLastDestinationContext() {
        if (!this.m_wizardCancelled) {
            return this.m_selectedContext;
        }
        return null;
    }

    public void wizardValidatePage(WizardEvent wizardEvent) {
        ImageWizardPage imageWizardPage = (ImageWizardPage)wizardEvent.getPage();
        Component component = imageWizardPage.getInteractiveArea();
        if (component == this.m_introPanel && !this.m_multipleDomains) {
            try {
                this.m_servicePanel.setServices(this.m_fileNSHandler.enum(this.m_selectedDomain));
                return;
            }
            catch (DataStoreException dataStoreException) {
                ExceptionMessage.display((Component)this.m_dialog, "Error accessing local data storage.", dataStoreException);
                dataStoreException.printStackTrace();
                return;
            }
        }
        if (component == this.m_domainPanel) {
            this.m_selectedDomain = ((MigrateDomainPanel)((Object)component)).getDomain();
            try {
                this.m_servicePanel.setServices(this.m_fileNSHandler.enum(this.m_selectedDomain));
                return;
            }
            catch (DataStoreException dataStoreException) {
                ExceptionMessage.display((Component)this.m_dialog, "Error accessing local data storage.", dataStoreException);
                dataStoreException.printStackTrace();
                return;
            }
        }
        if (component == this.m_servicePanel) {
            this.m_selectedServices = ((MigrateServicePanel)((Object)component)).getServices();
            if (this.m_selectedServices == null || this.m_selectedServices.length == 0) {
                Alert alert = new Alert((Frame)this.m_frame, this.m_netStrings.getString("MGWserviceSelectError"), 0, 1);
                alert.runAlert();
                ((Cancelable)wizardEvent).cancel();
            }
            return;
        }
        if (component == this.m_contextPanel) {
            this.m_selectedContext = ((MigrateContextPanel)((Object)component)).getContext();
            if (this.m_selectedContext == null) {
                Alert alert = new Alert((Frame)this.m_frame, this.m_netStrings.getString("MGWcontextSelectError"), 0, 1);
                alert.runAlert();
                ((Cancelable)wizardEvent).cancel();
            }
        }
    }

    public void wizardSelectionChanged(WizardEvent wizardEvent) {
        ImageWizardPage imageWizardPage = (ImageWizardPage)wizardEvent.getPage();
        Component component = imageWizardPage.getInteractiveArea();
        if (this.m_dialog != null) {
            this.m_dialog.setTitle(String.valueOf(this.m_titleBase) + this.m_netStrings.getString(imageWizardPage.getLabel()));
        }
        if (component == this.m_updatePanel) {
            this.m_updatePanel.update(this.m_selectedServices, this.m_selectedContext, this.m_authType, this.m_credentials);
        }
    }

    public void wizardApplyState(WizardEvent wizardEvent) {
    }

    public void wizardCanceled(WizardEvent wizardEvent) {
        this.m_wizardCancelled = true;
    }

    public void wizardFinished(WizardEvent wizardEvent) {
    }

    private boolean _initWizardPanels() {
        String[] stringArray;
        FixedBorderPainter fixedBorderPainter = new FixedBorderPainter(0, 10, 0, 10);
        this.m_introPanel = new MigrateIntroPanel();
        this.m_introPanel.setBorderPainter((BorderPainter)fixedBorderPainter);
        Image image = Toolkit.getDefaultToolkit().getImage(String.valueOf(NetUtils.getImageDirectory()) + "migrateIntro.gif");
        this.m_introPage = new ImageWizardPage((Component)((Object)this.m_introPanel), image, "MGWintroTitle");
        this.m_wizard.addPage(this.m_introPage);
        this.m_introPage.addWizardValidateListener((WizardValidateListener)this);
        try {
            stringArray = this.m_fileNSHandler.enumDomains();
            this.m_selectedDomain = stringArray[0];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ExceptionMessage.display((Component)this.m_dialog, "No local net service names found.", arrayIndexOutOfBoundsException);
            arrayIndexOutOfBoundsException.printStackTrace();
            return false;
        }
        catch (DataStoreException dataStoreException) {
            ExceptionMessage.display((Component)this.m_dialog, "Error accessing local data storage.", dataStoreException);
            dataStoreException.printStackTrace();
            return false;
        }
        if (stringArray.length > 1) {
            this.m_multipleDomains = true;
            this.m_domainPanel = new MigrateDomainPanel(stringArray);
            this.m_domainPanel.setBorderPainter((BorderPainter)fixedBorderPainter);
            image = Toolkit.getDefaultToolkit().getImage(String.valueOf(NetUtils.getImageDirectory()) + "migrateDomain.gif");
            this.m_domainPage = new ImageWizardPage((Component)((Object)this.m_domainPanel), image, "MGWdomainTitle");
            this.m_wizard.addPage(this.m_domainPage);
            this.m_domainPage.addWizardValidateListener((WizardValidateListener)this);
        }
        this.m_servicePanel = new MigrateServicePanel();
        this.m_servicePanel.setBorderPainter((BorderPainter)fixedBorderPainter);
        image = Toolkit.getDefaultToolkit().getImage(String.valueOf(NetUtils.getImageDirectory()) + "migrateService.gif");
        this.m_servicePage = new ImageWizardPage((Component)((Object)this.m_servicePanel), image, "MGWserviceTitle");
        this.m_wizard.addPage(this.m_servicePage);
        this.m_servicePage.addWizardValidateListener((WizardValidateListener)this);
        this.m_contextPanel = new MigrateContextPanel(this.m_authType, this.m_credentials);
        this.m_contextPanel.setBorderPainter((BorderPainter)fixedBorderPainter);
        image = Toolkit.getDefaultToolkit().getImage(String.valueOf(NetUtils.getImageDirectory()) + "migrateContext.gif");
        this.m_contextPage = new ImageWizardPage((Component)((Object)this.m_contextPanel), image, "MGWcontextTitle");
        this.m_wizard.addPage(this.m_contextPage);
        this.m_contextPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_updatePanel = new MigrateUpdatePanel(this.m_fileDataStore);
        this.m_updatePanel.setBorderPainter((BorderPainter)fixedBorderPainter);
        image = Toolkit.getDefaultToolkit().getImage(String.valueOf(NetUtils.getImageDirectory()) + "migrateUpdate.gif");
        this.m_updatePage = new ImageWizardPage((Component)((Object)this.m_updatePanel), image, "MGWupdateTitle");
        this.m_wizard.addPage(this.m_updatePage);
        this.m_servicePage.addWizardValidateListener((WizardValidateListener)this);
        return true;
    }
}

