/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import oracle.net.asst.profile.NetProtocolAddr;
import oracle.net.nl.NVPair;

public class NetIPCAddr
extends NetProtocolAddr {
    public static final String IPC_PROTOCOL = "IPC";
    public static final String IPC_ADDR_FORMAT = "(ADDRESS=(PROTOCOL=IPC))";
    private static final String[] IPC_ADDR_PARAM = new String[]{"KEY"};
    private static final String[] IPC_ADDR_PARAM_LABEL = new String[]{"PFCaddrKeyLabel"};

    public NetIPCAddr() {
        super(IPC_PROTOCOL, IPC_ADDR_FORMAT, IPC_ADDR_PARAM, IPC_ADDR_PARAM_LABEL);
    }

    public NetIPCAddr(NVPair nVPair) {
        this();
        this.setAddr(nVPair);
    }

    public String getProtocol() {
        return IPC_PROTOCOL;
    }

    public boolean areDataValid() {
        String string = this.addrParamText[0].getText();
        if (string == null || string.equals("") || string.indexOf(32) != -1) {
            this.invalidField = 0;
            return false;
        }
        return true;
    }

    public boolean sameEndpoint(NetProtocolAddr netProtocolAddr) {
        if (netProtocolAddr == null) {
            return false;
        }
        if (!(netProtocolAddr instanceof NetIPCAddr)) {
            return false;
        }
        String string = this.addrParamText[0].getText().toUpperCase();
        String string2 = ((NetIPCAddr)netProtocolAddr).addrParamText[0].getText().toUpperCase();
        return string.equalsIgnoreCase(string2);
    }
}

