/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.Painter;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NetLog
extends NetLayout
implements ProfileCache,
NetButtonListener {
    private static final String[] USER_TYPE = new String[]{"client", "server"};
    private static final String[] USER_LABEL = new String[]{"PFCclientLabel", "PFCserverLabel"};
    private static final String[] LOG_PARAM = new String[]{"log_directory", "log_file"};
    private static final String[] LOG_PARAM_LABEL = new String[]{"PFClogDirectory", "PFClogFile"};
    private static final String[] NET_LOG_BUTTONS = new String[]{"PFChelp"};
    private final NetStrings netStrings = new NetStrings();
    private final String NET_LOG_HELP_TOPIC = "TOPICprofGeneralLogging";
    private LWTextField[] logParam;
    private EwtContainer[] fieldPanel;
    private NLParamParser nlpa;
    private String[] netLogButton = new String[NET_LOG_BUTTONS.length];

    public NetLog() {
        int n = 0;
        while (n < NET_LOG_BUTTONS.length) {
            this.netLogButton[n] = this.netStrings.getString(NET_LOG_BUTTONS[n]);
            ++n;
        }
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(25, 25, 25, 25));
        this.fieldPanel = new EwtContainer[USER_TYPE.length];
        this.logParam = new LWTextField[LOG_PARAM.length * USER_TYPE.length];
        int n2 = 0;
        while (n2 < USER_TYPE.length) {
            this.fieldPanel[n2] = new EwtContainer();
            this.fieldPanel[n2].setLayout(new GridBagLayout());
            this.fieldPanel[n2].setBorderPainter(UIManager.createGroupBoxPainter((Painter)new FixedBorderPainter(10, 0, 5, 0), (String)this.netStrings.getString(USER_LABEL[n2])));
            this.constrain((Container)((Object)this), (Component)this.fieldPanel[n2], 0, n2, 1, 1, 2, 11, 1.0, 0.0, 0, 0, 15, 0);
            int n3 = n2 * USER_TYPE.length;
            n = 0;
            while (n < LOG_PARAM.length) {
                if (n2 <= 0 || n <= 0) {
                    this.constrain((Container)this.fieldPanel[n2], (Component)new LWLabel(this.netStrings.getString(LOG_PARAM_LABEL[n]), 1), 0, n + 1, 1, 1, 0, 17, 0.0, 0.0, 0, 10, 5, 0);
                    this.logParam[n3 + n] = new LWTextField(20);
                    this.constrain((Container)this.fieldPanel[n2], (Component)this.logParam[n3 + n], 1, n + 1, 1, 1, 2, 17, 1.0, 0.0, 0, 10, 5, 10);
                }
                ++n;
            }
            ++n2;
        }
        this.constrain((Container)((Object)this), (Component)new LWLabel(""), 0, n, 1, 1, 3, 10, 1.0, 1.0, 0, 0, 0, 0);
    }

    public NetLog(NLParamParser nLParamParser) {
        this();
        this.setNLP(nLParamParser);
    }

    public void setNLP(NLParamParser nLParamParser) {
        this.devTrc("NetLog: setNLP():");
        this.nlpa = nLParamParser;
    }

    public void cacheIt() {
        this.devTrc("NetLog: cacheIt():");
        int n = 0;
        while (n < USER_TYPE.length) {
            int n2 = n * USER_TYPE.length;
            int n3 = 0;
            while (n3 < LOG_PARAM.length) {
                if (n <= 0 || n3 <= 0) {
                    String string = new String(String.valueOf(LOG_PARAM[n3]) + "_" + USER_TYPE[n]);
                    String string2 = this.logParam[n2 + n3].getText();
                    if (string2.length() > 0) {
                        try {
                            this.nlpa.addNLPListElement(String.valueOf(string) + "=" + string2);
                        }
                        catch (NLException nLException) {}
                    } else {
                        this.nlpa.removeNLPListElement(string);
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    public void refresh() {
        this.devTrc("NetLog: refresh():");
        int n = 0;
        while (n < USER_TYPE.length) {
            int n2 = n * USER_TYPE.length;
            int n3 = 0;
            while (n3 < LOG_PARAM.length) {
                if (n <= 0 || n3 <= 0) {
                    String string;
                    NVPair nVPair = this.nlpa.getNLPListElement(String.valueOf(LOG_PARAM[n3]) + "_" + USER_TYPE[n]);
                    if (nVPair != null && (string = nVPair.getAtom()) != null) {
                        this.logParam[n2 + n3].setText(string);
                    } else {
                        this.logParam[n2 + n3].setText("");
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    public boolean hasChanged() {
        this.devTrc("NetLog: hasChanged():");
        int n = 0;
        int n2 = 0;
        while (n2 < USER_TYPE.length) {
            int n3 = n2 * USER_TYPE.length;
            n = 0;
            while (n < LOG_PARAM.length) {
                NVPair nVPair;
                if ((n2 <= 0 || n <= 0) && ((nVPair = this.nlpa.getNLPListElement(String.valueOf(LOG_PARAM[n]) + "_" + USER_TYPE[n2])) != null ? !this.logParam[n3 + n].getText().equalsIgnoreCase(nVPair.getAtom()) : this.logParam[n3 + n].getText().length() > 0)) {
                    return true;
                }
                ++n;
            }
            ++n2;
        }
        return false;
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }

    public NetButton createNetButton() {
        this.devTrc("NetLog: createNetButton()");
        NetButton netButton = new NetButton(this.netLogButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String string) {
        this.devTrc("NetLog: buttonPushed()");
        if (string.equalsIgnoreCase(this.netLogButton[0])) {
            this.devTrc("NetLog: buttonPushed(): do help.");
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.showTopic("TOPICprofGeneralLogging");
        }
    }
}

