/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import oracle.net.asst.profile.NetProtocolAddr;
import oracle.net.nl.NVPair;

public class NetNMPAddr
extends NetProtocolAddr {
    public static final String NMP_PROTOCOL_PREFIX = "NMP";
    public static final String NMP_ADDR_FORMAT = "(ADDRESS=(PROTOCOL=NMP))";
    private static final String[] NMP_ADDR_PARAM = new String[]{"SERVER", "PIPE"};
    private static final String[] NMP_ADDR_PARAM_LABEL = new String[]{"SNCMachine", "SNCPipe"};
    private int inValidField;

    public NetNMPAddr() {
        super(NMP_PROTOCOL_PREFIX, NMP_ADDR_FORMAT, NMP_ADDR_PARAM, NMP_ADDR_PARAM_LABEL);
    }

    public NetNMPAddr(NVPair nVPair) {
        this();
        this.setAddr(nVPair);
    }

    public boolean areDataValid() {
        this.devTrc("NetNMPAddr: areDataValid():");
        if (!this.netValidate.validateHostName(this.addrParamText[0])) {
            this.inValidField = 0;
            return false;
        }
        if (this.addrParamText[0].getText().length() > 0 && !this.netValidate.validateName(this.addrParamText[1])) {
            this.inValidField = 1;
            return false;
        }
        if (this.addrParamText[0].getText().length() == 0 && this.addrParamText[1].getText().length() > 0) {
            this.inValidField = 0;
            return false;
        }
        if (this.addrParamText[0].getText().length() > 0 && this.addrParamText[1].getText().length() == 0) {
            this.inValidField = 1;
            return false;
        }
        this.devTrc("NetNMPAddr: areDataValid(): true ");
        return true;
    }

    public void setFocus() {
        this.devTrc("NetNMPAddr: setFocus():");
        switch (this.inValidField) {
            case 0: {
                this.netValidate.showDialog(NMP_ADDR_PARAM[this.inValidField]);
                break;
            }
            case 1: {
                this.netValidate.showDialog(NMP_ADDR_PARAM[this.inValidField]);
            }
        }
        this.addrParamText[this.inValidField].selectAll();
        this.addrParamText[this.inValidField].requestFocus();
    }

    public String getProtocol() {
        return NMP_PROTOCOL_PREFIX;
    }

    public boolean sameEndpoint(NetProtocolAddr netProtocolAddr) {
        if (netProtocolAddr == null) {
            return false;
        }
        if (!(netProtocolAddr instanceof NetNMPAddr)) {
            return false;
        }
        String string = this.addrParamText[0].getText().toUpperCase();
        String string2 = ((NetNMPAddr)netProtocolAddr).addrParamText[0].getText().toUpperCase();
        String string3 = this.addrParamText[1].getText().toUpperCase();
        String string4 = ((NetNMPAddr)netProtocolAddr).addrParamText[1].getText().toUpperCase();
        return string.equalsIgnoreCase(string2) && string3.equalsIgnoreCase(string4);
    }
}

