/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import oracle.net.asst.profile.NetProtocolAddr;
import oracle.net.nl.NVPair;

public class NetSPXAddr
extends NetProtocolAddr {
    public static final String SPX_PROTOCOL_PREFIX = "SPX";
    public static final String SPX_ADDR_FORMAT = "(ADDRESS=(PROTOCOL=SPX))";
    private static final String[] SPX_ADDR_PARAM = new String[]{"SERVICE"};
    private static final String[] SPX_ADDR_PARAM_LABEL = new String[]{"PFCaddrServiceLabel"};

    public NetSPXAddr() {
        super(SPX_PROTOCOL_PREFIX, SPX_ADDR_FORMAT, SPX_ADDR_PARAM, SPX_ADDR_PARAM_LABEL);
    }

    public NetSPXAddr(NVPair nVPair) {
        this();
        this.setAddr(nVPair);
    }

    public String getProtocol() {
        return SPX_PROTOCOL_PREFIX;
    }

    public boolean areDataValid() {
        String string = this.addrParamText[0].getText();
        if (string == null || string.equals("") || string.indexOf(32) != -1) {
            this.invalidField = 0;
            return false;
        }
        return true;
    }

    public void setFocus() {
        this.netValidate.showDialog(SPX_ADDR_PARAM[0]);
        this.addrParamText[0].requestFocus();
    }

    public boolean sameEndpoint(NetProtocolAddr netProtocolAddr) {
        if (netProtocolAddr == null) {
            return false;
        }
        if (!(netProtocolAddr instanceof NetSPXAddr)) {
            return false;
        }
        String string = this.addrParamText[0].getText().toUpperCase();
        String string2 = ((NetSPXAddr)netProtocolAddr).addrParamText[0].getText().toUpperCase();
        return string.equalsIgnoreCase(string2);
    }
}

